/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.RadioButton;
import android.widget.TextView;
import com.ghostsq.commander.utils.ForwardCompat;
import com.ghostsq.commander.utils.Replacer;
import com.ghostsq.commander.utils.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultRename
extends Activity
implements View.OnClickListener,
TextWatcher {
    private static final String TAG = "MultRename";
    private ArrayList<String> names;
    private AutoCompleteTextView pattern;
    private AutoCompleteTextView replace;
    private TextView preview;
    private RadioButton preview_b;

    public void onCreate(Bundle savedInstanceState) {
        try {
            SharedPreferences shared_pref = PreferenceManager.getDefaultSharedPreferences((Context)this);
            Utils.setDialogTheme((Context)this, shared_pref.getString("color_themes", "d"));
            super.onCreate(savedInstanceState);
            this.setContentView(2130903050);
            Intent intent = this.getIntent();
            this.names = intent.getStringArrayListExtra(this.getPackageName() + ".TO_RENAME_LIST");
            this.pattern = (AutoCompleteTextView)this.findViewById(2131230818);
            this.replace = (AutoCompleteTextView)this.findViewById(2131230819);
            ArrayAdapter pattern_history_adapter = new ArrayAdapter((Context)this, 17367043);
            this.pattern.setAdapter((ListAdapter)pattern_history_adapter);
            ArrayAdapter replace_history_adapter = new ArrayAdapter((Context)this, 17367043);
            this.replace.setAdapter((ListAdapter)replace_history_adapter);
            this.preview = (TextView)this.findViewById(2131230822);
            this.preview_b = (RadioButton)this.findViewById(2131230820);
            this.pattern.addTextChangedListener((TextWatcher)this);
            this.replace.addTextChangedListener((TextWatcher)this);
            Button connect_button = (Button)this.findViewById(2131230833);
            connect_button.setOnClickListener((View.OnClickListener)this);
            Button cancel_button = (Button)this.findViewById(2131230834);
            cancel_button.setOnClickListener((View.OnClickListener)this);
            SharedPreferences prefs = this.getPreferences(0);
            this.pattern.setText((CharSequence)prefs.getString("PATTERN", "(.+)"));
            this.replace.setText((CharSequence)prefs.getString("REPLACE", "$1"));
            Set<String> hist_set = this.getHistory(prefs, "PATTERN_HIST");
            for (String s : hist_set) {
                pattern_history_adapter.add((Object)s);
            }
            hist_set = this.getHistory(prefs, "REPLACE_HIST");
            for (String s : hist_set) {
                replace_history_adapter.add((Object)s);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"onCreate() Exception: ", (Throwable)e);
        }
    }

    private Set<String> getHistory(SharedPreferences prefs, String key) {
        Set<String> hist_set = ForwardCompat.getStringSet(prefs, key);
        if (hist_set == null) {
            hist_set = new HashSet<String>();
            if ("PATTERN_HIST".equals(key)) {
                hist_set.add("(.+)");
                hist_set.add(".+");
                hist_set.add("[^.]+");
            } else if ("REPLACE_HIST".equals(key)) {
                hist_set.add("$1");
                hist_set.add("$2");
                hist_set.add("$3");
            }
        }
        hist_set.add(this.pattern.getText().toString());
        return hist_set;
    }

    private void saveStrings() {
        try {
            SharedPreferences prefs = this.getPreferences(0);
            SharedPreferences.Editor editor = prefs.edit();
            Set<String> hist_set = ForwardCompat.getStringSet(prefs, "PATTERN_HIST");
            if (hist_set == null) {
                hist_set = new HashSet<String>();
            }
            String pattern_s = this.pattern.getText().toString();
            hist_set.add(pattern_s);
            editor.putString("PATTERN", pattern_s);
            ForwardCompat.putStringSet(editor, "PATTERN_HIST", hist_set);
            hist_set = ForwardCompat.getStringSet(prefs, "REPLACE_HIST");
            if (hist_set == null) {
                hist_set = new HashSet<String>();
            }
            String replace_s = this.replace.getText().toString();
            hist_set.add(replace_s);
            editor.putString("REPLACE", replace_s);
            ForwardCompat.putStringSet(editor, "REPLACE_HIST", hist_set);
            editor.commit();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"onPause() Exception: ", (Throwable)e);
        }
    }

    protected void onStart() {
        try {
            super.onStart();
            this.setPreview();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"onStart() Exception: ", (Throwable)e);
        }
    }

    protected void onPause() {
        try {
            super.onPause();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"onPause() Exception: ", (Throwable)e);
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        try {
            super.onSaveInstanceState(outState);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"onSaveInstanceState() Exception: ", (Throwable)e);
        }
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        try {
            super.onRestoreInstanceState(savedInstanceState);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"onRestoreInstanceState() Exception: ", (Throwable)e);
        }
    }

    private void setHelp() {
        if (this.preview_b.isChecked()) {
            return;
        }
        this.preview.setText((CharSequence)this.getString(2131361974));
    }

    private void setPreview() {
        if (!this.preview_b.isChecked()) {
            return;
        }
        if (this.names == null) {
            return;
        }
        this.preview.setText((CharSequence)this.getPreview(this.pattern.getText().toString(), this.replace.getText().toString()));
    }

    private String getPreview(String pattern_str, String replace_to) {
        final StringBuilder sb = new StringBuilder();
        Replacer r = new Replacer(){

            protected int getNumberOfOriginalStrings() {
                return MultRename.this.names.size();
            }

            protected String getOriginalString(int i) {
                String name = (String)MultRename.this.names.get(i);
                sb.append(name);
                sb.append("\t->\t");
                return name;
            }

            protected void setReplacedString(int i, String replaced) {
                sb.append(replaced);
                sb.append("\n");
            }
        };
        r.replace(pattern_str, replace_to);
        return sb.toString();
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        this.setPreview();
    }

    public void onClick(View v) {
        try {
            if (v.getId() == 2131230833) {
                Intent in = new Intent("com.ghostsq.commander.RENAME");
                in.putExtra("PATTERN", this.pattern.getText().toString());
                in.putExtra("REPLACE", this.replace.getText().toString());
                this.setResult(-1, in);
                this.saveStrings();
            } else {
                this.setResult(0);
            }
            this.finish();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"onClick() Exception: ", (Throwable)e);
        }
    }

    public void onRadioButtonClicked(View v) {
        if (v.getId() == 2131230820) {
            this.setPreview();
        } else {
            this.setHelp();
        }
    }
}

