/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.IBinder;
import android.util.Log;
import com.ghostsq.commander.adapters.CA;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.Date;

public class StreamServer
extends Service {
    private static final String TAG = "StreamServer";
    private static final String CRLF = "\r\n";
    private static final String SALT = "GCSS";
    public static final int server_port = 5322;
    public static final boolean verbose_log = false;
    private Context ctx;
    public ListenThread thread = null;
    public WifiManager.WifiLock wifiLock = null;
    public String last_host = null;
    public CommanderAdapter ca = null;

    public void onCreate() {
        super.onCreate();
        this.ctx = this;
        WifiManager manager = (WifiManager)this.getSystemService("wifi");
        this.wifiLock = manager.createWifiLock(TAG);
        this.wifiLock.setReferenceCounted(false);
    }

    public void onStart(Intent intent, int start_id) {
        super.onStart(intent, start_id);
        Log.d((String)TAG, (String)"onStart");
        if (this.thread == null) {
            Log.d((String)TAG, (String)"Starting the server thread");
            this.thread = new ListenThread();
            this.thread.start();
            this.getBaseContext();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        Log.d((String)TAG, (String)"onDestroy");
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.close();
            this.thread.interrupt();
            try {
                this.thread.join(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.thread.isAlive()) {
                Log.e((String)TAG, (String)"Listen tread has ignored the interruption");
            }
        }
    }

    public static String getEncKey(Context ctx) {
        String seed = null;
        SharedPreferences ssp = ctx.getSharedPreferences(StreamServer.class.getSimpleName(), 0);
        if (ssp != null) {
            String pk = "enc_key";
            seed = ssp.getString("enc_key", null);
            if (seed == null) {
                SecureRandom rnd = new SecureRandom();
                seed = "" + Math.abs(rnd.nextLong());
                seed = seed.substring(0, 16);
                SharedPreferences.Editor edt = ssp.edit();
                edt.putString("enc_key", seed);
                edt.commit();
            }
        }
        return seed + SALT;
    }

    public static void storeCredentials(Context ctx, Credentials crd, Uri uri) {
        crd.storeCredentials(ctx, StreamServer.class.getSimpleName(), uri);
    }

    public static Credentials restoreCredentials(Context ctx, Uri uri) {
        return Credentials.restoreCredentials(ctx, StreamServer.class.getSimpleName(), uri);
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    class ReaderThread
    extends Thread {
        private static final String TAG = "GCSS.RT";
        private InputStream is;
        private long roller = 0L;
        private final int MAX = 163840;
        private int chunk = 4340;
        private byte[][] bufs = null;
        private byte[] out_buf = null;
        private int data_size = 0;
        private int num_id;
        private boolean stop = false;
        private boolean l = false;

        public ReaderThread(InputStream is_, int num_id_) {
            this.is = is_;
            this.setName(TAG);
            this.num_id = num_id_;
            this.bufs = new byte[][]{new byte[163840], new byte[163840]};
            Log.d((String)TAG, (String)"Buffers size: 163840");
        }

        private final void Log(String s) {
            if (this.l) {
                Log.d((String)TAG, (String)("" + this.num_id + ": " + s));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                this.setPriority(10);
                int count = 0;
                while (!this.stop) {
                    byte[] inp_buf = this.bufs[(int)(this.roller++ % 2L)];
                    if (this.l) {
                        this.Log("R...");
                    }
                    int has_read = 0;
                    has_read = this.is.read(inp_buf, 0, this.chunk);
                    if (!this.stop && has_read >= 0) {
                        if (has_read == this.chunk && this.chunk < 163840) {
                            this.chunk <<= 1;
                            Log.d((String)TAG, (String)("chunk size: " + this.chunk));
                        }
                        if (this.chunk > 163840) {
                            this.chunk = 163840;
                        }
                        if (this.l) {
                            this.Log("...R " + has_read + "/" + (count += has_read));
                        }
                        ReaderThread readerThread = this;
                        synchronized (readerThread) {
                            int wcount = 0;
                            if (this.l) {
                                this.Log("?..");
                            }
                            while (this.out_buf != null) {
                                this.wait(10L);
                                wcount += 10;
                            }
                            if (this.l) {
                                this.Log("...! (" + wcount + "ms)");
                            }
                            this.out_buf = inp_buf;
                            this.data_size = has_read;
                            if (this.l) {
                                this.Log("O=I ->");
                            }
                            this.notify();
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("" + this.num_id + ": "), (Throwable)e);
            }
            if (this.l) {
                this.Log("The read thread is done!");
            }
        }

        public synchronized byte[] getOutputBuffer() throws InterruptedException {
            int wcount = 0;
            if (this.l) {
                this.Log("       ?..");
            }
            while (this.out_buf == null && this.isAlive()) {
                this.wait(10L);
                wcount += 10;
            }
            if (this.out_buf != null) {
                if (this.l) {
                    this.Log("      ..! (" + wcount + "ms)");
                }
            } else if (this.l) {
                this.Log("X");
            }
            return this.out_buf;
        }

        public int GetDataSize() {
            int ds = this.data_size;
            this.data_size = 0;
            return ds;
        }

        public synchronized void doneOutput(boolean stop_) {
            this.stop = stop_;
            this.out_buf = null;
            if (this.l) {
                this.Log("    <- O done" + (this.stop ? ". stop" : ""));
            }
            this.notify();
        }
    }

    private class StreamingThread
    extends Thread {
        private static final String TAG = "GCSS.WT";
        private Socket data_socket;
        private int num_id;
        private boolean l = false;

        public StreamingThread(Socket data_socket_, int num_id_) {
            this.data_socket = data_socket_;
            this.num_id = num_id_;
        }

        private final void Log(String s) {
            if (this.l) {
                Log.d((String)TAG, (String)("" + this.num_id + ": " + s));
            }
        }

        private final void SendStatus(OutputStreamWriter osw, int code) throws IOException {
            String descr;
            String http = "HTTP/1.0 ";
            switch (code) {
                case 200: {
                    descr = "OK";
                    break;
                }
                case 206: {
                    descr = "Partial Content";
                    break;
                }
                case 400: {
                    descr = "Invalid";
                    break;
                }
                case 404: {
                    descr = "Not found";
                    break;
                }
                case 416: {
                    descr = "Bad Requested Range";
                    break;
                }
                case 500: {
                    descr = "Server error";
                    break;
                }
                default: {
                    descr = "";
                }
            }
            String resp = "HTTP/1.0 " + code + " " + descr;
            osw.write(resp + StreamServer.CRLF);
            if (this.l) {
                this.Log(resp);
            }
            Date date = new Date();
            osw.write("Date: " + date + StreamServer.CRLF);
            if (this.l) {
                this.Log("Date: " + date + StreamServer.CRLF);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            InputStream is = null;
            OutputStream os = null;
            try {
                String fn;
                Credentials credentials;
                String hl;
                if (this.l) {
                    this.Log("Thread started");
                }
                this.setName(TAG);
                if (this.data_socket == null || !this.data_socket.isConnected()) {
                    Log.e((String)TAG, (String)"Invalid data socked");
                    return;
                }
                os = this.data_socket.getOutputStream();
                if (os == null) {
                    Log.e((String)TAG, (String)"Can't get the output stream");
                    return;
                }
                OutputStreamWriter osw = new OutputStreamWriter(os);
                StreamingThread.yield();
                is = this.data_socket.getInputStream();
                if (is == null) {
                    Log.e((String)TAG, (String)"Can't get the input stream");
                    this.SendStatus(osw, 500);
                    return;
                }
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(isr);
                String cmd = br.readLine();
                if (!Utils.str(cmd)) {
                    Log.e((String)TAG, (String)"Invalid HTTP input");
                    this.SendStatus(osw, 400);
                    return;
                }
                String[] parts = cmd.split(" ");
                if (this.l) {
                    this.Log(cmd);
                }
                if (parts.length <= 1) {
                    Log.e((String)TAG, (String)"Invalid HTTP input");
                    this.SendStatus(osw, 400);
                    return;
                }
                String passed_uri_s = parts[1].substring(1);
                if (!Utils.str(passed_uri_s)) {
                    Log.w((String)TAG, (String)"No URI passed in the request");
                    this.SendStatus(osw, 404);
                    return;
                }
                Uri uri = Uri.parse((String)Uri.decode((String)passed_uri_s));
                if (uri == null || !Utils.str(uri.getPath())) {
                    Log.w((String)TAG, (String)"Wrong URI passed in the request");
                    this.SendStatus(osw, 404);
                    return;
                }
                if (this.l) {
                    this.Log("Requested URI: " + uri);
                }
                long offset = 0L;
                while (br.ready() && Utils.str(hl = br.readLine())) {
                    if (this.l) {
                        this.Log(hl);
                    }
                    if (!hl.startsWith("Range: bytes=")) continue;
                    int end = hl.indexOf(45, 13);
                    String range_s = hl.substring(13, end);
                    try {
                        offset = Long.parseLong(range_s);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                String scheme = uri.getScheme();
                if (scheme == null) {
                    scheme = "";
                }
                String host = uri.getHost();
                if (StreamServer.this.ca != null) {
                    if (!scheme.equals(StreamServer.this.ca.getScheme())) {
                        StreamServer.this.ca = null;
                    } else {
                        Uri prev_uri = StreamServer.this.ca.getUri();
                        if (host != null && !host.equals(prev_uri.getHost())) {
                            StreamServer.this.ca = null;
                        }
                    }
                }
                if (StreamServer.this.ca == null) {
                    StreamServer.this.ca = CA.CreateAdapterInstance(uri, StreamServer.this.ctx);
                    if (StreamServer.this.ca == null) {
                        Log.e((String)TAG, (String)("Can't create the adapter for: " + scheme));
                        this.SendStatus(osw, 500);
                        return;
                    }
                    StreamServer.this.ca.Init(null);
                    if (this.l) {
                        this.Log("Adapter is created");
                    }
                }
                StreamServer.this.last_host = host;
                String ui = uri.getUserInfo();
                if (ui != null && (credentials = StreamServer.restoreCredentials((Context)StreamServer.this, uri)) != null) {
                    StreamServer.this.ca.setCredentials(credentials);
                    uri = Utils.updateUserInfo(uri, null);
                }
                StreamServer.this.ca.setUri(uri);
                CommanderAdapter.Item item = StreamServer.this.ca.getItem(uri);
                if (item == null) {
                    Log.e((String)TAG, (String)("Can't get the item for " + uri));
                    this.SendStatus(osw, 404);
                    return;
                }
                InputStream cs = StreamServer.this.ca.getContent(uri, offset);
                if (cs == null) {
                    Log.e((String)TAG, (String)("Can't get the content for " + uri));
                    this.SendStatus(osw, 500);
                    return;
                }
                if (offset > 0L && item != null) {
                    this.SendStatus(osw, 206);
                } else {
                    this.SendStatus(osw, 200);
                }
                String string2 = fn = "zip".equals(scheme) ? uri.getFragment() : uri.getLastPathSegment();
                if (fn != null) {
                    String ext = Utils.getFileExt(fn);
                    String mime = Utils.getMimeByExt(ext);
                    if (this.l) {
                        this.Log("Content-Type: " + mime);
                    }
                    osw.write("Content-Type: " + mime + StreamServer.CRLF);
                } else {
                    osw.write("Content-Type: application/octet-stream\r\n");
                }
                String content_range = "Content-Range: bytes ";
                String content_length = "Content-Length: ";
                if (offset == 0L) {
                    content_length = content_length + item.size;
                    content_range = content_range + "0-" + (item.size - 1L) + "/" + item.size;
                } else {
                    content_length = content_length + (item.size - offset);
                    content_range = content_range + offset + "-" + (item.size - 1L) + "/" + item.size;
                }
                osw.write(content_length + StreamServer.CRLF);
                osw.write(content_range + StreamServer.CRLF);
                if (this.l) {
                    this.Log(content_length);
                }
                if (this.l) {
                    this.Log(content_range);
                }
                osw.write(StreamServer.CRLF);
                osw.flush();
                ReaderThread rt = new ReaderThread(cs, this.num_id);
                rt.start();
                this.setPriority(10);
                int count = 0;
                while (rt.isAlive()) {
                    try {
                        int n;
                        char[] isb;
                        if (isr.ready() && isr.read(isb = new char[32]) > 0) {
                            Log.d((String)TAG, (String)("" + isb.toString()));
                            if (this.l) {
                                this.Log("Some additional HTTP line has arrived!!! ");
                            }
                        }
                        StreamServer.this.thread.touch();
                        byte[] out_buf = rt.getOutputBuffer();
                        if (out_buf == null || (n = rt.GetDataSize()) < 0) break;
                        if (this.l) {
                            this.Log("      W...");
                        }
                        os.write(out_buf, 0, n);
                        if (this.l) {
                            this.Log("      ...W " + n + "/" + (count += n));
                        }
                        rt.doneOutput(false);
                    }
                    catch (Exception e) {
                        if (this.l) {
                            this.Log("write exception: " + e.getMessage());
                        }
                        rt.doneOutput(true);
                        break;
                    }
                }
                if (StreamServer.this.ca != null) {
                    StreamServer.this.ca.closeStream(cs);
                }
                if (this.l) {
                    this.Log("----------- done -------------");
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Exception", (Throwable)e);
            }
            finally {
                if (this.l) {
                    this.Log("Thread exits");
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Exception on Closing", (Throwable)e);
                }
            }
        }
    }

    private class ListenThread
    extends Thread {
        private static final String TAG = "GCSS.ListenThread";
        private Thread stream_thread;
        public ServerSocket ss = null;
        public long lastUsed = System.currentTimeMillis();

        private ListenThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Log.d((String)TAG, (String)"started");
                this.setName(TAG);
                this.setPriority(1);
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        block4: while (true) {
                            try {
                                while (true) {
                                    ListenThread listenThread = ListenThread.this;
                                    synchronized (listenThread) {
                                        int max_idle = 100000;
                                        ListenThread.this.wait(100000L);
                                        Log.d((String)ListenThread.TAG, (String)("Checking the idle time... last used: " + (System.currentTimeMillis() - ListenThread.this.lastUsed) + "ms ago "));
                                        if (System.currentTimeMillis() - 100000L > ListenThread.this.lastUsed) {
                                            Log.d((String)ListenThread.TAG, (String)"Time to closer the listen thread");
                                            ListenThread.this.close();
                                            break block4;
                                        }
                                    }
                                }
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                                continue;
                            }
                            break;
                        }
                        Log.d((String)ListenThread.TAG, (String)"Closer thread stopped");
                    }
                }, "Closer").start();
                StreamServer.this.wifiLock.acquire();
                Log.d((String)TAG, (String)"WiFi lock");
                ListenThread listenThread = this;
                synchronized (listenThread) {
                    this.ss = new ServerSocket(5322);
                }
                int count = 0;
                while (!this.isInterrupted()) {
                    Log.d((String)TAG, (String)"Listening for a new connection...");
                    Socket data_socket = this.ss.accept();
                    Log.d((String)TAG, (String)"Connection accepted");
                    if (data_socket != null && data_socket.isConnected()) {
                        int tn = count++;
                        this.stream_thread = new StreamingThread(data_socket, tn);
                        this.stream_thread.start();
                    }
                    this.touch();
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"Exception", (Throwable)e);
            }
            finally {
                StreamServer.this.wifiLock.release();
                Log.d((String)TAG, (String)"WiFi lock release");
                this.close();
            }
            StreamServer.this.stopSelf();
        }

        public synchronized void touch() {
            this.lastUsed = System.currentTimeMillis();
        }

        public synchronized void close() {
            try {
                if (this.ss != null) {
                    this.ss.close();
                    this.ss = null;
                }
                if (this.stream_thread != null && this.stream_thread.isAlive()) {
                    this.stream_thread.interrupt();
                    this.stream_thread = null;
                }
                if (StreamServer.this.ca != null) {
                    StreamServer.this.ca.prepareToDestroy();
                    StreamServer.this.ca = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

