/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.ContextMenu;
import android.widget.AdapterView;
import com.ghostsq.commander.Commander;
import com.ghostsq.commander.FilterProps;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.CommanderAdapterBase;
import com.ghostsq.commander.adapters.EditFTPPermissions;
import com.ghostsq.commander.adapters.Engine;
import com.ghostsq.commander.adapters.Engines;
import com.ghostsq.commander.adapters.FSAdapter;
import com.ghostsq.commander.adapters.FTPEngines;
import com.ghostsq.commander.favorites.Favorite;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.FTP;
import com.ghostsq.commander.utils.LsItem;
import com.ghostsq.commander.utils.Utils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class FTPAdapter
extends CommanderAdapterBase
implements Engines.IReciever {
    private static final String TAG = "FTPAdapter";
    private FTP ftp = new FTP();
    private Uri uri = null;
    private LsItem[] items = null;
    private Timer heartBeat;
    private boolean noHeartBeats = false;
    private FTPCredentials theUserPass = null;
    private static final int CHMOD_CMD = 36793;

    public FTPAdapter(Context ctx_) {
        super(ctx_);
    }

    public void Init(Commander c) {
        super.Init(c);
    }

    public String getScheme() {
        return "ftp";
    }

    public boolean hasFeature(CommanderAdapter.Feature feature) {
        switch (feature) {
            case REAL: 
            case MULT_RENAME: 
            case FILTER: {
                return true;
            }
        }
        return super.hasFeature(feature);
    }

    protected int getPredictedAttributesLength() {
        return 25;
    }

    public void setCredentials(Credentials crd) {
        this.theUserPass = crd != null ? new FTPCredentials(crd) : null;
    }

    public Credentials getCredentials() {
        if (this.theUserPass == null || this.theUserPass.isNotSet()) {
            return null;
        }
        return this.theUserPass;
    }

    public void setFilter(FilterProps filter) {
        this.filter = new LsItem.FilterProps(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readSource(Uri tmp_uri, String pass_back_on_done) {
        try {
            boolean need_reconnect = false;
            if (tmp_uri != null) {
                String new_user_info = tmp_uri.getUserInfo();
                if (this.uri == null) {
                    need_reconnect = true;
                } else if (!tmp_uri.getHost().equalsIgnoreCase(this.uri.getHost())) {
                    need_reconnect = true;
                    if (this.theUserPass != null && !this.theUserPass.dirty) {
                        this.theUserPass = null;
                    }
                } else if (new_user_info != null) {
                    if (this.theUserPass == null) {
                        need_reconnect = true;
                    } else if (this.theUserPass != null && !this.theUserPass.equals(new FTPCredentials(new_user_info))) {
                        need_reconnect = true;
                    }
                } else if (this.theUserPass != null) {
                    need_reconnect = this.theUserPass.dirty;
                }
                if (this.uri != null) {
                    Uri uri = this.uri;
                    synchronized (uri) {
                        this.setUri(tmp_uri);
                    }
                } else {
                    this.setUri(tmp_uri);
                }
            } else if (this.uri == null) {
                return false;
            }
            if (this.reader != null) {
                Log.w((String)TAG, (String)"reader's existed!");
                if (this.reader.isAlive()) {
                    Log.e((String)TAG, (String)"reader's busy!");
                    return false;
                }
            }
            if (this.items == null) {
                this.numItems = 1;
            }
            this.notify(-1);
            Log.v((String)TAG, (String)"Creating and starting the reader...");
            this.reader = new FTPEngines.ListEngine(this, this.readerHandler, this.ftp, need_reconnect, pass_back_on_done);
            this.reader.start();
            if (this.heartBeat == null) {
                this.heartBeat = new Timer("FTP Heartbeat", true);
                this.heartBeat.schedule((TimerTask)new Noop(), 120000L, 40000L);
            }
            return true;
        }
        catch (Exception e) {
            this.commander.showError(e.getLocalizedMessage());
            e.printStackTrace();
            this.notify(this.ftp.getLog(), -2);
            return false;
        }
    }

    protected void onReadComplete() {
        Log.v((String)TAG, (String)("UI thread finishes the items obtaining. reader=" + this.reader));
        if (this.reader instanceof FTPEngines.ListEngine) {
            boolean hide;
            FTPEngines.ListEngine list_engine = (FTPEngines.ListEngine)this.reader;
            this.items = null;
            this.parentLink = !Utils.str(list_engine.path) || list_engine.path.equals(SLS) ? SLS : "..";
            boolean bl = hide = (this.mode & 8) == 8;
            if (hide || this.filter != null) {
                LsItem[] tmp_items = list_engine.getItems();
                if (tmp_items != null) {
                    ArrayList<LsItem> al = new ArrayList<LsItem>(tmp_items.length);
                    for (int i = 0; i < tmp_items.length; ++i) {
                        LsItem lsi = tmp_items[i];
                        if (hide && lsi.getName().charAt(0) == '.' || this.filter != null && !((LsItem.FilterProps)this.filter).isMatched(lsi)) continue;
                        al.add(lsi);
                    }
                    this.items = new LsItem[al.size()];
                    al.toArray(this.items);
                }
            } else {
                this.items = list_engine.getItems();
            }
            this.numItems = this.items != null ? this.items.length + 1 : 1;
            this.notifyDataSetChanged();
            if (this.theUserPass != null) {
                this.theUserPass.dirty = false;
            }
        }
    }

    public String toString() {
        if (this.uri == null) {
            return "";
        }
        String ui = this.uri.getUserInfo();
        if (ui != null && this.theUserPass == null) {
            return Favorite.screenPwd(this.uri);
        }
        if (this.theUserPass == null || this.theUserPass.isNotSet()) {
            return this.uri.toString();
        }
        return Favorite.screenPwd(Utils.getUriWithAuth(this.uri, this.theUserPass));
    }

    public Uri getUri() {
        return Utils.updateUserInfo(this.uri, null);
    }

    private final void setFTPMode(Uri uri_) {
        String active_s = uri_.getQueryParameter("a");
        boolean a_set = Utils.str(active_s);
        if ((this.mode & 0x20000) == 0 || a_set) {
            this.ftp.setActiveMode(a_set && ("1".equals(active_s) || "true".equals(active_s) || "yes".equals(active_s)));
        }
        String charset_s = uri_.getQueryParameter("e");
        boolean e_set = Utils.str(charset_s);
        if ((this.mode & 0x20000) == 0 || e_set) {
            Charset charset = null;
            try {
                charset = Charset.forName(charset_s);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ftp.setCharset(charset);
        }
    }

    public void setUri(Uri uri_) {
        this.uri = uri_;
        try {
            this.setFTPMode(this.uri);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Uri: " + uri_), (Throwable)e);
        }
    }

    public void populateContextMenu(ContextMenu menu2, AdapterView.AdapterContextMenuInfo acmi, int num) {
        try {
            super.populateContextMenu(menu2, acmi, num);
            if (acmi.position > 0) {
                menu2.add(0, 36793, 0, 2131362236);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, null, (Throwable)e);
        }
    }

    public void doIt(int command_id, SparseBooleanArray cis) {
        try {
            if (36793 == command_id) {
                boolean selected_one;
                LsItem[] items_todo = this.bitsToItems(cis);
                boolean bl = selected_one = items_todo != null && items_todo.length > 0 && items_todo[0] != null;
                if (selected_one) {
                    Intent i = new Intent(this.ctx, EditFTPPermissions.class);
                    i.putExtra("perm", items_todo[0].getAttr());
                    i.putExtra("path", Utils.mbAddSl(this.uri.getPath()) + items_todo[0].getName());
                    i.putExtra("uri", (Parcelable)Utils.getUriWithAuth(this.uri, this.theUserPass));
                    this.commander.issue(i, 695);
                } else {
                    this.commander.showError(this.commander.getContext().getString(2131362058));
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Can't do the command " + command_id), (Throwable)e);
        }
    }

    public void reqItemsSize(SparseBooleanArray cis) {
        try {
            LsItem[] subItems = this.bitsToItems(cis);
            this.notify(-1);
            FTPEngines.CalcSizesEngine cse = new FTPEngines.CalcSizesEngine(this.commander, this.theUserPass, this.uri, subItems, this.ftp.getActiveMode(), this.ftp.getCharset());
            this.commander.startEngine(cse);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean copyItems(SparseBooleanArray cis, CommanderAdapter to, boolean move) {
        String err_msg = null;
        try {
            Uri to_uri;
            LsItem[] subItems = this.bitsToItems(cis);
            if (subItems == null) {
                this.notify(this.s(2131361975), -2);
                return false;
            }
            if (!this.checkReadyness()) {
                return false;
            }
            Engines.IReciever recipient = null;
            File dest = null;
            if (move && to instanceof FTPAdapter && (to_uri = to.getUri()).getHost().equalsIgnoreCase(this.uri.getHost())) {
                this.notify(-1);
                String new_name = Utils.mbAddSl(to_uri.getPath());
                FTPEngines.RenEngine re = new FTPEngines.RenEngine(this.ctx, this.theUserPass, this.uri, subItems, new_name, this.ftp.getActiveMode(), this.ftp.getCharset());
                this.commander.startEngine(re);
                return true;
            }
            if (to instanceof FSAdapter) {
                dest = new File(to.toString());
                if (!dest.exists()) {
                    dest.mkdirs();
                }
                if (!dest.isDirectory()) {
                    throw new RuntimeException(this.s(2131361979));
                }
            } else {
                dest = new File(this.createTempDir());
                recipient = to.getReceiver();
            }
            this.notify(-1);
            FTPEngines.CopyFromEngine cfe = new FTPEngines.CopyFromEngine(this.commander, this.theUserPass, this.uri, subItems, dest, move, recipient, this.ftp.getActiveMode(), this.ftp.getCharset());
            this.commander.startEngine(cfe);
            return true;
        }
        catch (Exception e) {
            err_msg = e.getLocalizedMessage();
            this.notify(err_msg, -2);
            return false;
        }
    }

    public boolean createFile(String name) {
        FTPEngines.CreateFileEngine e = new FTPEngines.CreateFileEngine(name, this.ctx, this.theUserPass, this.uri, this.ftp);
        return this.commander.startEngine(e);
    }

    public void createFolder(String name) {
        this.notify(-1);
        this.commander.startEngine(new MkDirEngine(name));
    }

    public boolean deleteItems(SparseBooleanArray cis) {
        try {
            if (!this.checkReadyness()) {
                return false;
            }
            LsItem[] subItems = this.bitsToItems(cis);
            if (subItems != null) {
                this.notify(-1);
                this.commander.startEngine(new FTPEngines.DelEngine(this.ctx, this.theUserPass, this.uri, subItems, this.ftp.getActiveMode(), this.ftp.getCharset()));
                return true;
            }
        }
        catch (Exception e) {
            this.commander.showError(e.getLocalizedMessage());
        }
        return false;
    }

    public Uri getItemUri(int position) {
        Uri u = this.getUri();
        if (u == null) {
            return null;
        }
        return u.buildUpon().appendEncodedPath(this.getItemName(position, false)).build();
    }

    public String getItemName(int position, boolean full) {
        if (this.items != null && position > 0 && position <= this.items.length) {
            String path;
            if (full && (path = this.toString()) != null && path.length() > 0) {
                if (path.charAt(path.length() - 1) != SLC) {
                    path = path + SLS;
                }
                return path + this.items[position - 1].getName();
            }
            return this.items[position - 1].getName();
        }
        return null;
    }

    public void openItem(int position) {
        if (position == 0) {
            String path;
            int len_;
            if (this.uri != null && this.parentLink != SLS && (len_ = (path = this.uri.getPath()).length() - 1) > 0) {
                if (path.charAt(len_) == SLC) {
                    path = path.substring(0, len_);
                }
                if ((path = path.substring(0, path.lastIndexOf(SLC))).length() == 0) {
                    path = SLS;
                }
                this.commander.Navigate(this.uri.buildUpon().path(path).build(), null, this.uri.getLastPathSegment());
            }
            return;
        }
        if (this.items == null || position < 0 || position > this.items.length) {
            return;
        }
        LsItem item = this.items[position - 1];
        if (item.isDirectory()) {
            String cur = this.uri.getPath();
            if (cur == null || cur.length() == 0) {
                cur = SLS;
            } else if (cur.charAt(cur.length() - 1) != SLC) {
                cur = cur + SLS;
            }
            Uri item_uri = this.uri.buildUpon().appendEncodedPath(item.getName()).build();
            this.commander.Navigate(item_uri, null, null);
        } else {
            Uri auth_item_uri = this.getUri().buildUpon().appendEncodedPath(item.getName()).build();
            this.commander.Open(auth_item_uri, this.theUserPass);
        }
    }

    public boolean receiveItems(String[] uris, int move_mode) {
        try {
            if (uris == null || uris.length == 0) {
                this.notify(this.s(2131361975), -2);
                return false;
            }
            File[] list = Utils.getListOfFiles(uris);
            if (list == null) {
                this.notify("Something wrong with the files", -2);
                return false;
            }
            this.notify(-1);
            boolean move = (move_mode & 1) != 0;
            boolean del_src_dir = (move_mode & 2) != 0;
            FTPEngines.CopyToEngine cte = new FTPEngines.CopyToEngine(this.ctx, this.theUserPass, this.uri, list, move, del_src_dir, this.ftp.getActiveMode(), this.ftp.getCharset());
            this.commander.startEngine(cte);
            return true;
        }
        catch (Exception e) {
            this.notify(e.getLocalizedMessage(), -2);
            return false;
        }
    }

    public boolean renameItem(int position, String new_name, boolean copy) {
        try {
            if (copy) {
                this.notify(this.s(2131362057), -2);
            }
            if (this.items == null || position <= 0 || position > this.items.length) {
                return false;
            }
            String old_name = this.getItemName(position, false);
            if (old_name != null) {
                this.notify(-1);
                LsItem[] list = new LsItem[]{this.items[position - 1]};
                FTPEngines.RenEngine re = new FTPEngines.RenEngine(this.ctx, this.theUserPass, this.uri, list, new_name, this.ftp.getActiveMode(), this.ftp.getCharset());
                this.commander.startEngine(re);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Can't rename to " + new_name), (Throwable)e);
        }
        return false;
    }

    public boolean renameItems(SparseBooleanArray cis, String pattern_str, String replace_to) {
        LsItem[] list = this.bitsToItems(cis);
        try {
            FTPEngines.RenEngine re = new FTPEngines.RenEngine(this.ctx, this.theUserPass, this.uri, list, pattern_str, replace_to, this.ftp.getActiveMode(), this.ftp.getCharset());
            this.commander.startEngine(re);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Can't rename to " + replace_to + " with pattern " + pattern_str), (Throwable)e);
        }
        return false;
    }

    public void prepareToDestroy() {
        if (this.heartBeat != null) {
            this.heartBeat.cancel();
            this.heartBeat.purge();
            this.heartBeat = null;
        }
        super.prepareToDestroy();
        new Thread(new Runnable(){

            public void run() {
                FTPAdapter.this.ftp.disconnect(false);
            }
        }, "FTP disconnect").start();
        this.items = null;
    }

    public Object getItem(int position) {
        CommanderAdapter.Item item = new CommanderAdapter.Item();
        item.name = "???";
        if (position == 0) {
            item.name = this.parentLink;
        } else if (this.items != null && position > 0 && position <= this.items.length) {
            LsItem ls_item = this.items[position - 1];
            item.dir = ls_item.isDirectory();
            item.name = item.dir ? SLS + ls_item.getName() : ls_item.getName();
            String lnk = ls_item.getLinkTarget();
            if (lnk != null) {
                item.name = item.name + " -> " + lnk;
                if (!item.dir) {
                    item.icon_id = 2130837530;
                }
            }
            item.size = !item.dir || ls_item.length() > 0L ? ls_item.length() : -1L;
            item.date = ls_item.getDate();
            item.attr = ls_item.getAttr();
        }
        return item;
    }

    private final LsItem[] bitsToItems(SparseBooleanArray cis) {
        try {
            int counter = 0;
            for (int i = 0; i < cis.size(); ++i) {
                if (!cis.valueAt(i)) continue;
                ++counter;
            }
            LsItem[] subItems = new LsItem[counter];
            int j = 0;
            for (int i = 0; i < cis.size(); ++i) {
                if (!cis.valueAt(i)) continue;
                subItems[j++] = this.items[cis.keyAt(i) - 1];
            }
            return subItems;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
            return null;
        }
    }

    private final boolean checkReadyness() {
        if (!this.ftp.isLoggedIn()) {
            this.notify(this.s(2131362083), -2);
            return false;
        }
        return true;
    }

    protected void reSort() {
        if (this.items == null || this.items.length < 1) {
            return;
        }
        LsItem lsItem = this.items[0];
        lsItem.getClass();
        LsItem.LsItemPropComparator comp = new LsItem.LsItemPropComparator(lsItem, this.mode & 0x30, (this.mode & 0x80) != 0, this.ascending);
        Arrays.sort(this.items, comp);
    }

    public CommanderAdapter.Item getItem(Uri u) {
        try {
            this.setFTPMode(u);
            if (this.theUserPass == null || this.theUserPass.isNotSet()) {
                this.theUserPass = new FTPCredentials(u.getUserInfo());
            }
            if (this.ftp.connectAndLogin(u, this.theUserPass.getUserName(), this.theUserPass.getPassword(), false) > 0) {
                List segs = u.getPathSegments();
                if (segs.size() == 0) {
                    CommanderAdapter.Item item = new CommanderAdapter.Item("/");
                    item.dir = true;
                    return item;
                }
                String prt_path = "";
                for (int i = 0; i < segs.size() - 1; ++i) {
                    prt_path = prt_path + "/" + (String)segs.get(i);
                }
                LsItem[] subItems = this.ftp.getDirList(prt_path, true);
                if (subItems == null) {
                    Log.e((String)TAG, (String)("No items in the directory " + prt_path));
                } else {
                    String fn = (String)segs.get(segs.size() - 1);
                    for (int i = 0; i < subItems.length; ++i) {
                        LsItem ls_item = subItems[i];
                        String ifn = ls_item.getName();
                        if (!fn.equals(ifn)) continue;
                        CommanderAdapter.Item item = new CommanderAdapter.Item(ifn);
                        item.size = ls_item.length();
                        item.date = ls_item.getDate();
                        item.dir = ls_item.isDirectory();
                        return item;
                    }
                    Log.e((String)TAG, (String)("File " + fn + " was not found in the directory " + prt_path));
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public InputStream getContent(Uri u, long skip) {
        try {
            if (this.uri != null && !this.uri.getHost().equals(u.getHost())) {
                return null;
            }
            if (!this.ftp.isLoggedIn()) {
                Log.d((String)TAG, (String)"Connecting...");
                if (this.theUserPass == null || this.theUserPass.isNotSet()) {
                    this.theUserPass = new FTPCredentials(u.getUserInfo());
                }
                this.setFTPMode(u);
                if (this.ftp.connectAndLogin(u, this.theUserPass.getUserName(), this.theUserPass.getPassword(), false) < 0) {
                    Log.e((String)TAG, (String)("Cannot connect to " + u.toString()));
                    return null;
                }
                this.noHeartBeats = true;
            }
            if (this.ftp.isLoggedIn()) {
                return this.ftp.prepRetr(u.getPath(), skip);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)u.getPath(), (Throwable)e);
        }
        return null;
    }

    public OutputStream saveContent(Uri u) {
        try {
            if (this.uri != null && !this.uri.getHost().equals(u.getHost())) {
                return null;
            }
            if (this.theUserPass == null || this.theUserPass.isNotSet()) {
                this.theUserPass = new FTPCredentials(u.getUserInfo());
            }
            this.setFTPMode(u);
            if (this.ftp.connectAndLogin(u, this.theUserPass.getUserName(), this.theUserPass.getPassword(), false) > 0) {
                this.noHeartBeats = true;
                return this.ftp.prepStore(u.getPath());
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)u.getPath(), (Throwable)e);
        }
        return null;
    }

    public void closeStream(Closeable s) {
        try {
            this.noHeartBeats = false;
            if (s != null) {
                s.close();
            }
            this.ftp.doneWithData(s.hashCode());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Engines.IReciever getReceiver() {
        return this;
    }

    public static class FTPCredentials
    extends Credentials {
        public boolean dirty = true;

        public FTPCredentials(String userName, String password) {
            super(userName, password);
        }

        public FTPCredentials(String newUserInfo) {
            super(newUserInfo == null ? ":" : newUserInfo);
        }

        public FTPCredentials(Credentials c) {
            super(c);
        }

        public String getUserName() {
            String u = super.getUserName();
            return u == null || u.length() == 0 ? "anonymous" : u;
        }

        public String getPassword() {
            String u = super.getUserName();
            String p = u == null || u.length() == 0 ? "user@host.com" : super.getPassword();
            return p != null ? p : "";
        }

        public final boolean isNotSet() {
            String u = super.getUserName();
            if (u == null || u.length() == 0) {
                return true;
            }
            String p = super.getPassword();
            return p == null;
        }
    }

    class MkDirEngine
    extends Engine {
        private String name;

        MkDirEngine(String name_) {
            this.name = name_;
        }

        public void run() {
            FTPAdapter.this.ftp.clearLog();
            try {
                FTPAdapter.this.ftp.makeDir(this.name);
                this.sendResult("");
                return;
            }
            catch (Exception exception) {
                this.error(FTPAdapter.this.ctx.getString(2131362082, new Object[]{this.name, FTPAdapter.this.ftp.getLog()}));
                if (!this.noErrors()) {
                    this.sendResult("");
                } else {
                    this.sendRefrReq(this.name);
                }
                return;
            }
        }
    }

    class Noop
    extends TimerTask {
        Noop() {
        }

        public void run() {
            if (!FTPAdapter.this.noHeartBeats && FTPAdapter.this.reader == null && FTPAdapter.this.ftp.isLoggedIn()) {
                try {
                    FTPAdapter.this.ftp.heartBeat();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

