/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.content.Context;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Handler;
import android.text.format.Formatter;
import android.util.Log;
import com.ghostsq.commander.Commander;
import com.ghostsq.commander.adapters.Engine;
import com.ghostsq.commander.adapters.Engines;
import com.ghostsq.commander.adapters.FTPAdapter;
import com.ghostsq.commander.utils.FTP;
import com.ghostsq.commander.utils.LsItem;
import com.ghostsq.commander.utils.Replacer;
import com.ghostsq.commander.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;

public final class FTPEngines {

    public static class CreateFileEngine
    extends FTPEngine {
        String newFileName;

        CreateFileEngine(String name, Context ctx_, FTPAdapter.FTPCredentials crd_, Uri uri_, FTP ftp_) {
            super(ctx_, crd_, uri_, ftp_);
            this.newFileName = name;
        }

        public void run() {
            try {
                if (this.ftp.connectAndLogin(this.uri, this.crd.getUserName(), this.crd.getPassword(), true) < 0) {
                    this.error(this.ctx.getString(2131362083));
                    return;
                }
                byte[] bb = new byte[]{};
                ByteArrayInputStream in = new ByteArrayInputStream(bb);
                this.ftp.store(this.newFileName, in, null);
            }
            catch (Exception e) {
                this.error(e.getLocalizedMessage());
            }
            if (!this.noErrors()) {
                this.sendResult("");
            } else {
                this.sendRefrReq(this.newFileName);
            }
        }
    }

    public static class CalcSizesEngine
    extends FTPEngine {
        private int num = 0;
        private int dirs = 0;
        private int depth = 0;
        private LsItem[] list;

        CalcSizesEngine(Commander c, FTPAdapter.FTPCredentials crd_, Uri uri_, LsItem[] list_, boolean active, Charset cs) {
            super(c.getContext(), crd_, uri_, active, cs);
            this.list = list_;
        }

        public void run() {
            try {
                LsItem f;
                if (this.crd == null || this.crd.isNotSet()) {
                    this.crd = new FTPAdapter.FTPCredentials(this.uri.getUserInfo());
                }
                if (this.ftp.connectAndLogin(this.uri, this.crd.getUserName(), this.crd.getPassword(), true) < 0) {
                    this.error(this.ctx.getString(2131362083));
                    this.sendResult("");
                    return;
                }
                this.sendProgress();
                long total = this.getSizes(this.list, "");
                StringBuffer result = new StringBuffer();
                if (this.list.length == 1) {
                    f = this.list[0];
                    if (f.isDirectory()) {
                        result.append(this.ctx.getString(Utils.RR.sz_folder.r(), new Object[]{f.getName(), this.num}));
                        if (this.dirs > 0) {
                            result.append(this.ctx.getString(Utils.RR.sz_dirnum.r(), new Object[]{this.dirs, this.dirs > 1 ? this.ctx.getString(Utils.RR.sz_dirsfx_p.r()) : this.ctx.getString(Utils.RR.sz_dirsfx_s.r())}));
                        }
                    } else {
                        result.append(this.ctx.getString(Utils.RR.sz_file.r(), new Object[]{f.getName()}));
                    }
                } else {
                    result.append(this.ctx.getString(Utils.RR.sz_files.r(), new Object[]{this.num}));
                    if (this.dirs > 0) {
                        result.append(this.ctx.getString(Utils.RR.sz_dirnum.r(), new Object[]{this.dirs, this.dirs > 1 ? this.ctx.getString(Utils.RR.sz_dirsfx_p.r()) : this.ctx.getString(Utils.RR.sz_dirsfx_s.r())}));
                    }
                }
                if (total > 0L) {
                    result.append(this.ctx.getString(Utils.RR.sz_Nbytes.r(), new Object[]{Formatter.formatFileSize((Context)this.ctx, (long)total).trim()}));
                }
                if (total > 1024L) {
                    result.append(this.ctx.getString(Utils.RR.sz_bytes.r(), new Object[]{total}));
                }
                if (this.list.length == 1) {
                    f = this.list[0];
                    result.append(this.ctx.getString(Utils.RR.sz_lastmod.r()));
                    result.append(" ");
                    result.append("<small>");
                    result.append(Utils.formatDate(f.getDate(), this.ctx));
                    result.append("</small>");
                }
                this.sendReport(result.toString());
                super.run();
            }
            catch (InterruptedException e) {
                this.sendResult(this.ctx.getString(2131362010));
            }
            catch (Exception e) {
                this.error(this.ctx.getString(2131361918) + e.getLocalizedMessage());
                e.printStackTrace();
            }
            super.run();
        }

        protected final long getSizes(LsItem[] list, String path) throws Exception {
            long total = 0L;
            try {
                for (int i = 0; i < list.length; ++i) {
                    if (this.stop || this.isInterrupted()) {
                        this.error(this.ctx.getString(2131361992));
                        break;
                    }
                    LsItem f = list[i];
                    if (f == null) continue;
                    String pathName = path + f.getName();
                    if (f.isDirectory()) {
                        ++this.dirs;
                        if (this.depth++ > 20) {
                            throw new Exception(this.ctx.getString(2131361994));
                        }
                        LsItem[] subItems = this.ftp.getDirList(pathName, true);
                        --this.depth;
                        if (subItems == null) {
                            this.error("Failed to get the file list of the subfolder '" + pathName + "'.\n FTP log:\n\n" + this.ftp.getLog());
                        } else {
                            total += this.getSizes(subItems, pathName + File.separator);
                            if (this.errMsg == null) continue;
                        }
                        break;
                    }
                    total += f.length();
                    ++this.num;
                }
            }
            catch (RuntimeException e) {
                this.error("Runtime Exception: " + e.getMessage());
                Log.e((String)this.TAG, (String)"", (Throwable)e);
            }
            return total;
        }
    }

    static class ChmodEngine
    extends FTPEngine {
        private String chmod;

        ChmodEngine(Context ctx_, Uri uri_, String chmod_, Charset cs) {
            super(ctx_, null, uri_, false, cs);
            this.chmod = chmod_;
        }

        public void run() {
            try {
                if (this.ftp.connectAndLogin(this.uri, this.crd.getUserName(), this.crd.getPassword(), true) < 0) {
                    this.error(this.ctx.getString(2131362083));
                    this.sendResult("");
                    return;
                }
                if (!this.ftp.site(this.chmod)) {
                    this.error(this.ctx.getString(2131361918) + this.ftp.getLog());
                }
                this.sendResult("");
                super.run();
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)"", (Throwable)e);
            }
        }
    }

    static class RenEngine
    extends FTPEngine {
        private LsItem[] origList;
        private String newName;
        private String pattern_str;

        RenEngine(Context ctx_, FTPAdapter.FTPCredentials crd_, Uri uri_, LsItem[] list, String new_name_or_path, boolean active, Charset cs) {
            super(ctx_, crd_, uri_, active, cs);
            this.origList = list;
            this.newName = new_name_or_path;
        }

        RenEngine(Context ctx_, FTPAdapter.FTPCredentials crd_, Uri uri_, LsItem[] list, String pattern_str, String replace_to, boolean active, Charset cs) {
            this(ctx_, crd_, uri_, list, replace_to, active, cs);
            this.pattern_str = pattern_str;
        }

        public void run() {
            try {
                if (this.ftp.connectAndLogin(this.uri, this.crd.getUserName(), this.crd.getPassword(), true) < 0) {
                    this.error(this.ctx.getString(2131362083));
                    this.sendResult("");
                    return;
                }
                String base_path = Utils.mbAddSl(this.uri.getPath());
                if (this.pattern_str == null) {
                    boolean dest_is_dir = this.newName.indexOf(47) >= 0;
                    for (int i = 0; i < this.origList.length; ++i) {
                        String old_name = this.origList[i].getName();
                        String old_path = base_path + old_name;
                        if (this.ftp.rename(old_path, dest_is_dir ? this.newName + old_name : this.newName)) continue;
                        this.error(this.ctx.getString(2131361918) + this.ftp.getLog());
                    }
                } else {
                    FTPReplacer r = new FTPReplacer(this.origList, base_path);
                    r.replace(this.pattern_str, this.newName);
                }
                this.sendResult("");
                super.run();
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)"", (Throwable)e);
            }
        }

        class FTPReplacer
        extends Replacer {
            public String last_file_name = null;
            private LsItem[] origList;
            private String base_path;

            FTPReplacer(LsItem[] origList, String base_path) {
                this.origList = origList;
                this.base_path = base_path;
            }

            protected int getNumberOfOriginalStrings() {
                return this.origList.length;
            }

            protected String getOriginalString(int i) {
                return this.origList[i].getName();
            }

            protected void setReplacedString(int i, String replaced) {
                String name = this.getOriginalString(i);
                String old_path = this.base_path + name;
                try {
                    if (!RenEngine.this.ftp.rename(old_path, replaced)) {
                        RenEngine.this.error(RenEngine.this.ctx.getString(2131361918) + RenEngine.this.ftp.getLog());
                    }
                }
                catch (InterruptedException e) {
                    Log.e((String)RenEngine.this.TAG, (String)("Can't rename " + old_path + " to " + replaced));
                }
            }
        }
    }

    static class DelEngine
    extends FTPEngine {
        LsItem[] mList;

        DelEngine(Context ctx_, FTPAdapter.FTPCredentials crd_, Uri uri_, LsItem[] list, boolean active, Charset cs) {
            super(ctx_, crd_, uri_, active, cs);
            this.mList = list;
        }

        public void run() {
            try {
                if (this.ftp.connectAndLogin(this.uri, this.crd.getUserName(), this.crd.getPassword(), true) < 0) {
                    this.error(this.ctx.getString(2131362083));
                    this.sendResult("");
                    return;
                }
                int total = this.delFiles(this.mList, "");
                this.sendResult(Utils.getOpReport(this.ctx, total, 2131362026));
                super.run();
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)"", (Throwable)e);
            }
        }

        private final int delFiles(LsItem[] list, String path) {
            int counter = 0;
            try {
                for (int i = 0; i < list.length; ++i) {
                    if (this.stop || this.isInterrupted()) {
                        this.error(this.ctx.getString(2131361992));
                        break;
                    }
                    LsItem f = list[i];
                    if (f == null) continue;
                    String pathName = path + f.getName();
                    if (f.isDirectory()) {
                        LsItem[] subItems = this.ftp.getDirList(pathName, true);
                        counter += this.delFiles(subItems, pathName + File.separator);
                        if (this.errMsg != null) break;
                        this.ftp.clearLog();
                        if (!this.ftp.rmDir(pathName)) {
                            this.error("Failed to remove folder '" + pathName + "'.\n FTP log:\n\n" + this.ftp.getLog());
                            break;
                        }
                    } else {
                        this.sendProgress(this.ctx.getString(2131361999, new Object[]{pathName}), i * 100 / list.length);
                        this.ftp.clearLog();
                        if (!this.ftp.delete(pathName)) {
                            this.error("Failed to delete file '" + pathName + "'.\n FTP log:\n\n" + this.ftp.getLog());
                            break;
                        }
                    }
                    ++counter;
                }
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)"delFiles()", (Throwable)e);
                this.error(e.getLocalizedMessage());
            }
            return counter;
        }
    }

    public static class CopyToEngine
    extends CopyEngine {
        private File[] mList;
        private int basePathLen;
        private boolean move = false;
        private boolean del_src_dir = false;

        CopyToEngine(Context ctx_, FTPAdapter.FTPCredentials crd_, Uri uri_, File[] list, boolean move_, boolean del_src_dir_, boolean active, Charset cs) {
            super(ctx_, crd_, uri_, active, cs);
            this.mList = list;
            this.basePathLen = list[0].getParent().length();
            if (this.basePathLen > 1) {
                ++this.basePathLen;
            }
            this.move = move_;
            this.del_src_dir = del_src_dir_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block11: {
                block10: {
                    block8: {
                        block9: {
                            try {
                                try {
                                    if (this.ftp.connectAndLogin(this.uri, this.crd.getUserName(), this.crd.getPassword(), true) < 0) {
                                        this.error(this.ctx.getString(2131362083));
                                        this.sendResult("");
                                        Object var3_1 = null;
                                        if (!this.del_src_dir) break block8;
                                        break block9;
                                    }
                                    this.wifiLock.acquire();
                                    int total = this.copyFiles(this.mList);
                                    this.wifiLock.release();
                                    this.sendResult(Utils.getOpReport(this.ctx, total, 2131362028));
                                    break block10;
                                }
                                catch (Exception e) {
                                    this.error(e.getLocalizedMessage());
                                    Object var3_3 = null;
                                    if (this.del_src_dir) {
                                        this.deleteDir(this.mList[0].getParentFile());
                                    }
                                    super.run();
                                    break block11;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var3_4 = null;
                                if (this.del_src_dir) {
                                    this.deleteDir(this.mList[0].getParentFile());
                                }
                                super.run();
                                throw throwable;
                            }
                        }
                        this.deleteDir(this.mList[0].getParentFile());
                    }
                    super.run();
                    return;
                }
                Object var3_2 = null;
                if (this.del_src_dir) {
                    this.deleteDir(this.mList[0].getParentFile());
                }
                super.run();
                return;
            }
            this.sendResult("");
        }

        private final int copyFiles(File[] list) throws InterruptedException {
            if (list == null) {
                return 0;
            }
            int counter = 0;
            try {
                for (int i = 0; i < list.length; ++i) {
                    if (this.stop || this.isInterrupted()) {
                        this.error(this.ctx.getString(2131361992));
                        break;
                    }
                    File f = list[i];
                    if (f == null || !f.exists()) continue;
                    if (f.isFile()) {
                        String pathName = f.getAbsolutePath();
                        int pnl = pathName.length();
                        this.progressMessage = this.ctx.getString(2131362006, new Object[]{pnl > 36 ? "\u2026" + pathName.substring(pnl - 36) : pathName});
                        this.sendProgress(this.progressMessage, 0);
                        String fn = f.getAbsolutePath().substring(this.basePathLen);
                        FileInputStream in = new FileInputStream(f);
                        this.setCurFileLength(f.length());
                        this.ftp.clearLog();
                        if (!this.ftp.store(fn, in, this)) {
                            this.error(this.ctx.getString(2131362081, new Object[]{f.getName(), this.ftp.getLog()}));
                            break;
                        }
                        this.progressMessage = "";
                    } else if (f.isDirectory()) {
                        this.ftp.clearLog();
                        String toCreate = f.getAbsolutePath().substring(this.basePathLen);
                        if (!this.ftp.makeDir(toCreate)) {
                            Log.w((String)this.TAG, (String)this.ctx.getString(2131362082, new Object[]{toCreate, this.ftp.getLog()}));
                        }
                        counter += this.copyFiles(f.listFiles());
                        if (this.errMsg != null) break;
                    }
                    ++counter;
                    if (!this.move || f.delete()) continue;
                    this.error(this.ctx.getString(2131362022, new Object[]{f.getCanonicalPath()}));
                    break;
                }
            }
            catch (IOException e) {
                this.error("IOException: " + e.getMessage());
                Log.e((String)this.TAG, (String)"", (Throwable)e);
            }
            return counter;
        }
    }

    public static class CopyFromEngine
    extends CopyEngine {
        private LsItem[] mList;
        private File dest_folder;
        private boolean move;
        private Commander commander;

        CopyFromEngine(Commander c, FTPAdapter.FTPCredentials crd_, Uri uri_, LsItem[] list, File dest, boolean move_, Engines.IReciever recipient_, boolean active, Charset cs) {
            super(c.getContext(), crd_, uri_, active, cs);
            this.commander = c;
            this.mList = list;
            this.dest_folder = dest;
            this.move = move_;
            this.recipient = recipient_;
        }

        public void run() {
            try {
                if (this.crd == null || this.crd.isNotSet()) {
                    this.crd = new FTPAdapter.FTPCredentials(this.uri.getUserInfo());
                }
                if (this.ftp.connectAndLogin(this.uri, this.crd.getUserName(), this.crd.getPassword(), true) < 0) {
                    this.error(this.ctx.getString(2131362083));
                    this.sendResult("");
                    return;
                }
                this.wifiLock.acquire();
                int total = this.copyFiles(this.mList, "");
                this.wifiLock.release();
                if (this.recipient != null) {
                    this.sendReceiveReq(this.dest_folder, this.move);
                    return;
                }
                this.sendResult(Utils.getOpReport(this.ctx, total, 2131362027));
            }
            catch (InterruptedException e) {
                this.sendResult(this.ctx.getString(2131362010));
            }
            catch (Exception e) {
                this.error(this.ctx.getString(2131361918) + e.getLocalizedMessage());
                e.printStackTrace();
            }
            super.run();
        }

        private final int copyFiles(LsItem[] list, String path) throws InterruptedException {
            int counter = 0;
            try {
                for (int i = 0; i < list.length; ++i) {
                    Date ftp_file_date;
                    if (this.stop || this.isInterrupted()) {
                        this.error(this.ctx.getString(2131361992));
                        break;
                    }
                    LsItem f = list[i];
                    if (f == null) continue;
                    String pathName = path + f.getName();
                    File dest = new File(this.dest_folder, pathName);
                    if (f.isDirectory()) {
                        if (!(dest.mkdir() || dest.exists() && dest.isDirectory())) {
                            this.errMsg = "Can't create folder \"" + dest.getCanonicalPath() + "\"";
                            break;
                        }
                        LsItem[] subItems = this.ftp.getDirList(pathName, true);
                        if (subItems == null) {
                            this.errMsg = "Failed to get the file list of the subfolder '" + pathName + "'.\n FTP log:\n\n" + this.ftp.getLog();
                            break;
                        }
                        counter += this.copyFiles(subItems, pathName + File.separator);
                        if (this.errMsg != null) break;
                        if (this.move && !this.ftp.rmDir(pathName)) {
                            this.errMsg = "Failed to remove folder '" + pathName + "'.\n FTP log:\n\n" + this.ftp.getLog();
                            break;
                        }
                    } else {
                        if (dest.exists()) {
                            int res = this.askOnFileExist(this.ctx.getString(2131362015, new Object[]{dest.getAbsolutePath()}), this.commander);
                            if (res == 1) break;
                            if (res == 4) continue;
                            if (res == 2 && !dest.delete()) {
                                this.error(this.ctx.getString(2131362022, new Object[]{dest.getAbsoluteFile()}));
                                break;
                            }
                        }
                        int pnl = pathName.length();
                        this.progressMessage = this.ctx.getString(2131362005, new Object[]{pnl > 36 ? "\u2026" + pathName.substring(pnl - 36) : pathName});
                        this.sendProgress(this.progressMessage, 0);
                        this.setCurFileLength(f.length());
                        FileOutputStream out = new FileOutputStream(dest);
                        this.ftp.clearLog();
                        if (!this.ftp.retrieve(pathName, out, this)) {
                            this.error("Can't download file '" + pathName + "'.\n FTP log:\n\n" + this.ftp.getLog());
                            dest.delete();
                            break;
                        }
                        if (this.move && !this.ftp.delete(pathName)) {
                            this.error("Can't delete file '" + pathName + "'.\n FTP log:\n\n" + this.ftp.getLog());
                            break;
                        }
                        this.progressMessage = "";
                    }
                    if ((ftp_file_date = f.getDate()) != null) {
                        dest.setLastModified(ftp_file_date.getTime());
                    }
                    dest.setWritable(true, false);
                    dest.setReadable(true, false);
                    ++counter;
                }
            }
            catch (RuntimeException e) {
                this.error("Runtime Exception: " + e.getMessage());
                Log.e((String)this.TAG, (String)"", (Throwable)e);
            }
            catch (IOException e) {
                this.error("Input-Output Exception: " + e.getMessage());
                Log.e((String)this.TAG, (String)"", (Throwable)e);
            }
            return counter;
        }
    }

    private static abstract class CopyEngine
    extends FTPEngine
    implements FTP.ProgressSink {
        private long startTime = System.currentTimeMillis();
        private long curFileLen = 0L;
        private long curFileDone = 0L;
        private long secDone = 0L;
        protected WifiManager.WifiLock wifiLock;
        protected String progressMessage = null;

        CopyEngine(Context ctx_, FTPAdapter.FTPCredentials crd_, Uri uri_, boolean active, Charset cs) {
            super(ctx_, crd_, uri_, active, cs);
            WifiManager manager = (WifiManager)this.ctx.getSystemService("wifi");
            this.wifiLock = manager.createWifiLock(Build.VERSION.SDK_INT >= 12 ? 3 : 1, this.TAG);
            this.wifiLock.setReferenceCounted(false);
        }

        protected void setCurFileLength(long len) {
            this.curFileDone = 0L;
            this.curFileLen = len;
        }

        public boolean completed(long size, boolean done) throws InterruptedException {
            if (this.curFileLen > 0L) {
                this.curFileDone += size;
                this.secDone += size;
                long cur_time = System.currentTimeMillis();
                long time_delta = cur_time - this.startTime;
                if (done || time_delta > 1000L) {
                    int speed = (int)(1000L * this.secDone / time_delta);
                    this.sendProgress(this.progressMessage, (int)(this.curFileDone * 100L / this.curFileLen), -1, speed);
                    this.startTime = cur_time;
                    this.secDone = 0L;
                }
            }
            if (this.isStopReq()) {
                this.error(this.ctx.getString(2131362010));
                return false;
            }
            Thread.sleep(1L);
            return true;
        }
    }

    public static class ListEngine
    extends FTPEngine {
        private int mode = 0;
        private boolean ascending;
        private boolean needReconnect;
        private LsItem[] items_tmp;
        public String pass_back_on_done;
        public String path;

        ListEngine(FTPAdapter a, Handler h, FTP ftp_, boolean need_reconnect_, String pass_back_on_done_) {
            super(a.ctx, (FTPAdapter.FTPCredentials)a.getCredentials(), a.getUri(), ftp_);
            this.setHandler(h);
            this.needReconnect = need_reconnect_;
            this.pass_back_on_done = pass_back_on_done_;
            this.mode = a.getMode();
            this.ascending = (this.mode & 0x40) == 0;
        }

        public LsItem[] getItems() {
            return this.items_tmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            block23: {
                block22: {
                    Uri uri;
                    boolean need_restore_wd;
                    block20: {
                        int n;
                        block21: {
                            try {
                                try {
                                    int cl_res;
                                    if (this.uri == null) {
                                        this.sendProgress("Wrong URI", -2);
                                        Object var11_1 = null;
                                        super.run();
                                        return;
                                    }
                                    Log.i((String)this.TAG, (String)"ListEngine started");
                                    this.threadStartedAt = System.currentTimeMillis();
                                    this.ftp.clearLog();
                                    if (this.needReconnect && this.ftp.isLoggedIn()) {
                                        this.ftp.disconnect(false);
                                    }
                                    if (this.crd == null || this.crd.isNotSet()) {
                                        this.crd = new FTPAdapter.FTPCredentials(this.uri.getUserInfo());
                                    }
                                    if ((cl_res = this.ftp.connectAndLogin(this.uri, this.crd.getUserName(), this.crd.getPassword(), true)) < 0) {
                                        if (cl_res == -2) {
                                            this.sendLoginReq(this.uri.toString(), this.crd, this.pass_back_on_done);
                                        }
                                        Object var11_2 = null;
                                        super.run();
                                        return;
                                    }
                                    if (cl_res == 2) {
                                        this.sendProgress(this.ctx.getString(2131362080, new Object[]{this.uri.getHost(), this.crd.getUserName()}), -1);
                                    }
                                    if (this.ftp.isLoggedIn()) {
                                        this.items_tmp = this.ftp.getDirList(null, (this.mode & 8) == 0);
                                        this.path = this.ftp.getCurrentDir();
                                        need_restore_wd = false;
                                        if (this.path == null) break block20;
                                        uri = this.items_tmp;
                                        n = ((LsItem[])uri).length;
                                        break block21;
                                    }
                                    Log.e((String)this.TAG, (String)"Did not log in.");
                                }
                                catch (UnknownHostException e) {
                                    this.ftp.debugPrint("Unknown host:\n" + e.getLocalizedMessage());
                                    Object var11_5 = null;
                                    super.run();
                                    break block23;
                                }
                                catch (IOException e) {
                                    this.ftp.debugPrint("IO exception:\n" + e.getLocalizedMessage());
                                    Log.e((String)this.TAG, (String)"", (Throwable)e);
                                    Object var11_6 = null;
                                    super.run();
                                    break block23;
                                }
                                catch (Exception e) {
                                    this.ftp.debugPrint(e.getLocalizedMessage());
                                    Log.e((String)this.TAG, (String)"", (Throwable)e);
                                    Object var11_7 = null;
                                    super.run();
                                    break block23;
                                }
                                break block22;
                            }
                            catch (Throwable throwable) {
                                Object var11_8 = null;
                                super.run();
                                throw throwable;
                            }
                        }
                        for (int i = 0; i < n; ++i) {
                            String lt;
                            Uri lsi = uri[i];
                            String name = lsi.getName();
                            if (name == null || !Utils.str(lt = lsi.getLinkTarget())) continue;
                            if (lt.charAt(0) != '/') {
                                lt = Utils.mbAddSl(this.path) + lt;
                            }
                            need_restore_wd = true;
                            if (!this.ftp.setCurrentDir(lt)) continue;
                            lsi.setDirectory();
                        }
                    }
                    if (need_restore_wd) {
                        this.ftp.setCurrentDir(this.path);
                    }
                    uri = this.uri;
                    // MONITORENTER : uri
                    this.uri = this.uri.buildUpon().encodedPath(this.path).build();
                    // MONITOREXIT : uri
                    if (this.items_tmp != null) {
                        if (this.items_tmp.length > 0) {
                            LsItem lsItem = this.items_tmp[0];
                            lsItem.getClass();
                            LsItem.LsItemPropComparator comp = new LsItem.LsItemPropComparator(lsItem, this.mode & 0x30, (this.mode & 0x80) != 0, this.ascending);
                            Arrays.sort(this.items_tmp, comp);
                        }
                        this.sendProgress(this.tooLong(8) ? this.ftp.getLog() : null, -3, this.pass_back_on_done);
                        Object var11_3 = null;
                        super.run();
                        return;
                    }
                    Log.e((String)this.TAG, (String)"Can't get the items list");
                }
                Object var11_4 = null;
                super.run();
            }
            this.ftp.disconnect(true);
            this.sendProgress(this.ftp.getLog(), -2, this.pass_back_on_done);
        }
    }

    private static abstract class FTPEngine
    extends Engine {
        protected Context ctx;
        protected FTPAdapter.FTPCredentials crd;
        protected FTP ftp;
        protected Uri uri;

        FTPEngine(Context ctx_, FTPAdapter.FTPCredentials crd_, Uri uri_, FTP ftp_) {
            if (crd_ == null) {
                crd_ = new FTPAdapter.FTPCredentials(uri_.getUserInfo());
            }
            this.ctx = ctx_;
            this.crd = crd_;
            this.uri = uri_;
            this.ftp = ftp_;
        }

        FTPEngine(Context ctx_, FTPAdapter.FTPCredentials crd_, Uri uri_, boolean active, Charset cs) {
            this(ctx_, crd_, uri_, new FTP());
            this.ftp.setActiveMode(active);
            this.ftp.setCharset(cs);
        }
    }
}

