/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.preference.PreferenceManager;
import android.provider.DocumentsContract;
import android.system.Os;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.ContextMenu;
import android.widget.AdapterView;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.CommanderAdapterBase;
import com.ghostsq.commander.adapters.Engine;
import com.ghostsq.commander.adapters.Engines;
import com.ghostsq.commander.adapters.FSAdapter;
import com.ghostsq.commander.adapters.FSEngines;
import com.ghostsq.commander.adapters.ItemComparator;
import com.ghostsq.commander.adapters.ThumbnailsThread;
import com.ghostsq.commander.utils.Replacer;
import com.ghostsq.commander.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressLint(value={"NewApi"})
public class SAFAdapter
extends CommanderAdapterBase
implements Engines.IReciever {
    private static final String TAG = "SAFAdapter";
    public static final String ORG_SCHEME = "saf";
    public static final int OPEN_SAF = 9036;
    private boolean primary = false;
    private Uri uri;
    protected SAFItem[] items;
    ThumbnailsThread tht = null;
    private static final String PATH_TREE = "tree";

    public SAFAdapter(Context ctx_) {
        super(ctx_);
    }

    @Override
    public String getScheme() {
        return "content";
    }

    @Override
    public boolean hasFeature(CommanderAdapter.Feature feature) {
        switch (feature) {
            case FS: 
            case LOCAL: 
            case REAL: 
            case SF4: 
            case SEND: 
            case MULT_RENAME: 
            case FILTER: {
                return true;
            }
        }
        return super.hasFeature(feature);
    }

    public String toString() {
        return "saf:" + this.getPath(this.uri, true);
    }

    private static boolean isTreeUri(Uri uri) {
        List paths = uri.getPathSegments();
        return paths.size() == 2 && PATH_TREE.equals(paths.get(0));
    }

    private static boolean isRootDoc(Uri uri) {
        List paths = uri.getPathSegments();
        if (paths.size() < 4) {
            return true;
        }
        String last = (String)paths.get(paths.size() - 1);
        return last.lastIndexOf(58) == last.length() - 1;
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    private static boolean isPrimary(Uri u) {
        List paths = u.getPathSegments();
        if (paths.size() < 4) {
            return false;
        }
        String path_part = (String)paths.get(3);
        int col_pos = path_part.lastIndexOf(58);
        String volume = (String)paths.get(1);
        return volume != null && volume.startsWith("primary");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getMime(Context ctx, Uri u) {
        Cursor c;
        block6: {
            String string2;
            c = null;
            try {
                try {
                    String[] projection = new String[]{"mime_type"};
                    c = ctx.getContentResolver().query(u, projection, null, null, null);
                    if (c.getCount() <= 0) break block6;
                    c.moveToFirst();
                    string2 = c.getString(0);
                    Object var6_6 = null;
                    if (c == null) return string2;
                }
                catch (Exception exception) {
                    Object var6_8 = null;
                    if (c == null) return null;
                    c.close();
                    return null;
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                if (c == null) throw throwable;
                c.close();
                throw throwable;
            }
            c.close();
            return string2;
        }
        Object var6_7 = null;
        if (c == null) return null;
        c.close();
        return null;
    }

    public static String getFdPath(ParcelFileDescriptor fd) {
        String resolved;
        try {
            File procfsFdFile = new File("/proc/self/fd/" + fd.getFd());
            resolved = Build.VERSION.SDK_INT >= 21 ? Os.readlink((String)procfsFdFile.getAbsolutePath()) : procfsFdFile.getCanonicalPath();
            if (!Utils.str(resolved) || resolved.charAt(0) != '/' || resolved.startsWith("/proc/") || resolved.startsWith("/fd/")) {
                return null;
            }
        }
        catch (IOException ioe) {
            return "";
        }
        catch (Exception errnoe) {
            return null;
        }
        return resolved;
    }

    public final String getPath(Uri u, boolean dir) {
        return SAFAdapter.getPath(this.ctx, u, dir);
    }

    public static final String getPath(Context ctx, Uri u, boolean dir) {
        try {
            List paths;
            String fd_path = null;
            ContentResolver cr = ctx.getContentResolver();
            ParcelFileDescriptor pfd = cr.openFileDescriptor(u, "r");
            if (pfd != null) {
                fd_path = SAFAdapter.getFdPath(pfd);
                Log.d((String)TAG, (String)("Got path: " + fd_path));
                if (Utils.str(fd_path) && fd_path.indexOf("media_rw") < 0) {
                    return fd_path;
                }
            }
            if ((paths = u.getPathSegments()).size() < 4) {
                return null;
            }
            String path_part = (String)paths.get(3);
            int col_pos = path_part.lastIndexOf(58);
            String path_root = null;
            String volume = (String)paths.get(1);
            String sub_path = path_part.substring(col_pos + 1);
            if (volume.startsWith("primary")) {
                return Environment.getExternalStorageDirectory().getAbsolutePath() + "/" + sub_path;
            }
            try {
                volume = volume.substring(0, volume.length() - 1);
                if (Build.VERSION.SDK_INT >= 23) {
                    String full_path = "/storage/" + volume + "/" + sub_path;
                    File probe = new File(full_path);
                    if (dir ? probe.isDirectory() : probe.isFile()) {
                        return full_path;
                    }
                    full_path = "/mnt/media_rw/" + volume + "/" + sub_path;
                    probe = new File(full_path);
                    if (dir ? probe.isDirectory() : probe.isFile()) {
                        return full_path;
                    }
                } else {
                    path_root = Utils.getSecondaryStorage();
                    if (path_root != null) {
                        String full_path = Utils.mbAddSl(path_root) + sub_path;
                        File probe = new File(full_path);
                        if (dir ? probe.isDirectory() : probe.isFile()) {
                            return full_path;
                        }
                    }
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)("Can't resolve uri to a path: " + u));
            }
            if (Utils.str(fd_path)) {
                return fd_path;
            }
            if (path_root == null) {
                path_root = volume;
            }
            return path_root + "/" + sub_path;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Can't get the real location of " + u), (Throwable)e);
            return null;
        }
    }

    public static Uri getParent(Uri u) {
        if (u == null) {
            return null;
        }
        List paths = u.getPathSegments();
        int n = paths.size();
        if (n < 4) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n - 1; ++i) {
            sb.append("/");
            sb.append((String)paths.get(i));
        }
        if (n == 4) {
            String last = (String)paths.get(n - 1);
            int col_pos = last.lastIndexOf(58);
            if (col_pos > 0 && col_pos != last.length() - 1) {
                sb.append("/");
                sb.append(last.substring(0, col_pos + 1));
                String subpath = last.substring(col_pos + 1);
                int sl_pos = subpath.lastIndexOf(SLC);
                if (sl_pos > 0) {
                    subpath = subpath.substring(0, sl_pos);
                    sb.append(Uri.encode((String)subpath));
                }
            }
            return u.buildUpon().encodedPath(sb.toString()).build();
        }
        return null;
    }

    @Override
    public Uri getUri() {
        return this.uri;
    }

    @Override
    public void setUri(Uri uri_) {
        if (this.uri == null && SAFAdapter.isTreeUri(uri_)) {
            try {
                this.ctx.getContentResolver().takePersistableUriPermission(uri_, 3);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)uri_.toString());
            }
            this.uri = DocumentsContract.buildDocumentUriUsingTree((Uri)uri_, (String)DocumentsContract.getTreeDocumentId((Uri)uri_));
        } else {
            this.uri = uri_;
            this.primary = SAFAdapter.isPrimary(uri_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final ArrayList<SAFItem> getChildren(Uri u) {
        Cursor c;
        block11: {
            ArrayList<SAFItem> arrayList;
            block13: {
                Object children_uri;
                block12: {
                    c = null;
                    try {
                        try {
                            try {
                                ContentResolver cr = this.ctx.getContentResolver();
                                String document_id = DocumentsContract.getDocumentId((Uri)u);
                                children_uri = DocumentsContract.buildChildDocumentsUriUsingTree((Uri)u, (String)document_id);
                                String[] projection = this.colIds();
                                c = cr.query(children_uri, projection, null, null, null);
                            }
                            catch (SecurityException e) {
                                Log.w((String)TAG, (String)("Security error on " + u.toString()), (Throwable)e);
                                ArrayList<SAFItem> document_id = null;
                                Object var9_12 = null;
                                if (c == null) return document_id;
                                c.close();
                                return document_id;
                            }
                            catch (Exception e) {
                                Log.e((String)TAG, (String)u.toString(), (Throwable)e);
                            }
                            if (c == null) break block11;
                            boolean hide = (this.mode & 8) == 8;
                            ArrayList<SAFItem> tmp_list = new ArrayList<SAFItem>();
                            if (c.getCount() == 0) {
                                children_uri = tmp_list;
                                Object var9_13 = null;
                                if (c == null) return children_uri;
                                break block12;
                            }
                            int[] ii = this.colInds(c);
                            c.moveToFirst();
                            do {
                                String fc;
                                SAFItem item = this.rowToItem(c, u, ii);
                                if (hide && (".".equals(fc = item.name.substring(0, 1)) || "/".equals(fc) && ".".equals(item.name.substring(1, 2))) || this.filter != null && !this.filter.isMatched(item)) continue;
                                tmp_list.add(item);
                            } while (c.moveToNext());
                            arrayList = tmp_list;
                            break block13;
                        }
                        catch (Exception e) {
                            Log.e((String)TAG, (String)("Failed cursor processing for " + u.toString()), (Throwable)e);
                            Object var9_16 = null;
                            if (c == null) return null;
                            c.close();
                            return null;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_17 = null;
                        if (c == null) throw throwable;
                        c.close();
                        throw throwable;
                    }
                }
                c.close();
                return children_uri;
            }
            Object var9_14 = null;
            if (c == null) return arrayList;
            c.close();
            return arrayList;
        }
        Object var9_15 = null;
        if (c == null) return null;
        c.close();
        return null;
    }

    private final String[] colIds() {
        String[] projection = new String[]{"document_id", "_display_name", "last_modified", "mime_type", "_size"};
        return projection;
    }

    private final int[] colInds(Cursor c) {
        int[] ii = new int[]{c.getColumnIndex("document_id"), c.getColumnIndex("_display_name"), c.getColumnIndex("_size"), c.getColumnIndex("mime_type"), c.getColumnIndex("last_modified")};
        return ii;
    }

    private final SAFItem rowToItem(Cursor c, Uri u, int[] ii) {
        int ici = ii[0];
        int nci = ii[1];
        int sci = ii[2];
        int mci = ii[3];
        int dci = ii[4];
        SAFItem item = new SAFItem();
        String id2 = c.getString(ici);
        item.origin = DocumentsContract.buildDocumentUriUsingTree((Uri)u, (String)id2);
        item.attr = item.mime = c.getString(mci);
        item.dir = "vnd.android.document/directory".equals(item.attr);
        item.name = (item.dir ? "/" : "") + c.getString(nci);
        item.size = c.getLong(sci);
        item.date = new Date(c.getLong(dci));
        if (item.dir) {
            item.size = -1L;
        }
        return item;
    }

    @Override
    public boolean readSource(Uri tmp_uri, String pass_back_on_done) {
        try {
            if (tmp_uri != null) {
                this.setUri(tmp_uri);
            }
            if (this.uri == null) {
                Log.e((String)TAG, (String)"No URI");
                return false;
            }
            ArrayList<SAFItem> tmp_list = this.getChildren(this.uri);
            if (tmp_list == null) {
                SAFAdapter.saveURI(this.ctx, null);
                this.commander.showError(this.s(2131362196));
                this.commander.Navigate(Uri.parse((String)"home:"), null, null);
                return false;
            }
            this.items = new SAFItem[tmp_list.size()];
            tmp_list.toArray(this.items);
            this.reSort(this.items);
            super.setCount(this.items.length);
            this.parentLink = SAFAdapter.isRootDoc(this.uri) ? SLS : "..";
            this.startThumbnailCreation();
            this.notifyDataSetChanged();
            this.notify(pass_back_on_done);
            return true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"readSource() exception", (Throwable)e);
        }
        catch (OutOfMemoryError err) {
            Log.e((String)TAG, (String)"Out Of Memory", (Throwable)err);
            this.notify(this.s(2131362011), -2);
        }
        return false;
    }

    protected void startThumbnailCreation() {
        if (this.thumbnail_size_perc <= 0) {
            return;
        }
        String path = this.getPath(this.uri, true);
        if (path == null || path.charAt(0) != '/') {
            return;
        }
        if (this.tht != null) {
            this.tht.interrupt();
        }
        Handler h = new Handler(){

            public void handleMessage(Message msg) {
                SAFAdapter.this.notifyDataSetChanged();
            }
        };
        this.tht = new ThumbnailsThread(this, h, Utils.mbAddSl(path), this.items);
        this.tht.start();
    }

    @Override
    public void populateContextMenu(ContextMenu menu2, AdapterView.AdapterContextMenuInfo acmi, int num) {
        try {
            if (acmi.position != 0) {
                CommanderAdapter.Item item = (CommanderAdapter.Item)this.getItem(acmi.position);
                if (!item.dir && ".zip".equals(Utils.getFileExt(item.name))) {
                    menu2.add(0, 2131230757, 0, 2131361908);
                }
                if (item.dir && num == 1 && Build.VERSION.SDK_INT >= 8) {
                    menu2.add(0, 2131230761, 0, 2131361841);
                }
            }
            super.populateContextMenu(menu2, acmi, num);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
        }
    }

    @Override
    public void doIt(int command_id, SparseBooleanArray cis) {
    }

    @Override
    public void openItem(int position) {
        if (position == 0) {
            Uri uri_to_go = null;
            if (this.parentLink == SLS) {
                uri_to_go = Uri.parse((String)"home:");
            } else {
                uri_to_go = SAFAdapter.getParent(this.uri);
                if (uri_to_go == null) {
                    uri_to_go = Uri.parse((String)"home:");
                }
            }
            String pos_to = null;
            String cur_path = this.getPath(this.uri, true);
            if (cur_path != null) {
                pos_to = cur_path.substring(cur_path.lastIndexOf(47));
            }
            this.commander.Navigate(uri_to_go, null, pos_to);
        } else {
            SAFItem item = this.items[position - 1];
            if (item.dir) {
                this.commander.Navigate((Uri)item.origin, null, null);
            } else {
                SharedPreferences shared_pref = PreferenceManager.getDefaultSharedPreferences((Context)this.ctx);
                boolean try_as_file = !shared_pref.getBoolean("open_content", Build.VERSION.SDK_INT > 23);
                for (int att = 0; att < 2; ++att) {
                    Uri to_open = this.getItemOpenableUri(position, try_as_file);
                    if (to_open == null) {
                        Log.w((String)TAG, (String)("No URI to open item " + item));
                        return;
                    }
                    if ("content".equals(to_open.getScheme())) {
                        try {
                            Intent in = new Intent("android.intent.action.VIEW");
                            in.setDataAndType(to_open, item.mime);
                            in.addFlags(3);
                            this.ctx.startActivity(in);
                            return;
                        }
                        catch (Exception e) {
                            Log.w((String)TAG, (String)("Failed to open " + to_open), (Throwable)e);
                        }
                    } else {
                        Log.v((String)TAG, (String)("Uri:" + to_open.toString()));
                        this.commander.Open(to_open, null);
                        return;
                    }
                    try_as_file = !try_as_file;
                }
                this.commander.showError(this.s(2131362218));
            }
        }
    }

    public final Uri getItemOpenableUri(int position, boolean try_as_file) {
        try {
            String full_name;
            SAFItem item = this.items[position - 1];
            if (try_as_file && (full_name = this.getItemName(position, true)) != null && full_name.charAt(0) == '/' && full_name.indexOf("media_rw") < 0) {
                Uri.Builder ub = new Uri.Builder();
                ub.scheme("file").encodedPath(full_name);
                return ub.build();
            }
            Uri u = (Uri)item.origin;
            if (u == null) {
                return null;
            }
            return u;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("pos:" + position), (Throwable)e);
            return null;
        }
    }

    @Override
    public Uri getItemUri(int position) {
        try {
            return (Uri)this.items[position - 1].origin;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("No item in the position " + position));
            return null;
        }
    }

    @Override
    public String getItemName(int position, boolean full) {
        if (position == 0) {
            return this.parentLink;
        }
        if (position < 0 || this.items == null || position > this.items.length) {
            return null;
        }
        SAFItem item = this.items[position - 1];
        if (full) {
            Uri item_uri = (Uri)item.origin;
            return this.getPath(item_uri, item.dir);
        }
        return item.name != null ? item.name.replace("/", "") : null;
    }

    @Override
    public void reqItemsSize(SparseBooleanArray cis) {
        try {
            FSEngines.IFileItem[] list = this.bitsToItems(cis);
            if (list != null) {
                this.notify(-1);
                this.commander.startEngine(new FSEngines.CalcSizesEngine(this, list));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final boolean renameItem(CommanderAdapter.Item item, ContentResolver cr, String new_name) {
        try {
            Uri new_uri = DocumentsContract.renameDocument((ContentResolver)cr, (Uri)((Uri)item.origin), (String)new_name);
            if (new_uri == null) {
                return false;
            }
            item.origin = new_uri;
            return true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Item: " + item.name), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean renameItem(int position, String new_name, boolean copy) {
        if (!this.renameItem(this.items[position - 1], this.ctx.getContentResolver(), new_name)) {
            return false;
        }
        this.notifyRefr(new_name);
        return true;
    }

    @Override
    public boolean renameItems(SparseBooleanArray cis, String pattern_str, String replace_to) {
        SAFReplacer r = new SAFReplacer(this.bitsToItems(cis), this.ctx.getContentResolver());
        r.replace(pattern_str, replace_to);
        this.notifyRefr(r.last_file_name);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommanderAdapter.Item getItem(Uri u) {
        SAFItem sAFItem;
        Cursor c;
        block5: {
            c = null;
            String[] projection = this.colIds();
            ContentResolver cr = this.ctx.getContentResolver();
            c = cr.query(u, projection, null, null, null);
            if (c.getCount() != 0) break block5;
            Log.e((String)TAG, (String)("Can't query uri " + u));
            CommanderAdapter.Item item = null;
            Object var9_8 = null;
            if (c == null) return item;
            c.close();
            return item;
        }
        try {
            SAFItem item;
            c.moveToFirst();
            int[] ii = this.colInds(c);
            sAFItem = item = this.rowToItem(c, u, ii);
            Object var9_9 = null;
            if (c == null) return sAFItem;
        }
        catch (Exception exception) {
            try {
                Object var9_10 = null;
                if (c == null) return null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (c == null) throw throwable;
                c.close();
                throw throwable;
            }
            c.close();
            return null;
        }
        c.close();
        return sAFItem;
    }

    public CommanderAdapter.Item getItem_(Uri u) {
        try {
            File f = new File(u.getPath());
            if (f.exists()) {
                CommanderAdapter.Item item = new CommanderAdapter.Item(f.getName());
                item.size = f.length();
                item.date = new Date(f.lastModified());
                item.dir = f.isDirectory();
                return item;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public InputStream getContent(Uri u, long skip) {
        try {
            ContentResolver cr = this.ctx.getContentResolver();
            InputStream is = cr.openInputStream(u);
            if (is == null) {
                return null;
            }
            if (skip > 0L) {
                is.skip(skip);
            }
            return is;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public OutputStream saveContent(Uri u) {
        if (u != null) {
            try {
                ContentResolver cr = this.ctx.getContentResolver();
                return cr.openOutputStream(u);
            }
            catch (FileNotFoundException e) {
                Log.e((String)TAG, (String)u.getPath(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public boolean createFile(String new_name) {
        try {
            Uri new_doc_uri = DocumentsContract.createDocument((ContentResolver)this.ctx.getContentResolver(), (Uri)this.uri, (String)"text/plain", (String)new_name);
            return new_doc_uri != null;
        }
        catch (Exception e) {
            this.commander.showError(this.ctx.getString(2131362021, new Object[]{new_name, e.getMessage()}));
            return false;
        }
    }

    @Override
    public void createFolder(String new_name) {
        try {
            Uri new_uri = DocumentsContract.createDocument((ContentResolver)this.ctx.getContentResolver(), (Uri)this.uri, (String)"vnd.android.document/directory", (String)new_name);
            if (new_uri != null) {
                this.notifyRefr(new_name);
                return;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"createFolder", (Throwable)e);
        }
        this.notify(this.ctx.getString(2131362013, new Object[]{new_name}), -2);
    }

    @Override
    public boolean deleteItems(SparseBooleanArray cis) {
        try {
            CommanderAdapter.Item[] list = this.bitsToItems(cis);
            if (list != null) {
                this.notify(-1);
                this.commander.startEngine(new DeleteEngine(list));
            }
        }
        catch (Exception e) {
            this.notify(e.getMessage(), -2);
        }
        return false;
    }

    @Override
    public boolean copyItems(SparseBooleanArray cis, CommanderAdapter to, boolean move) {
        if (to instanceof SAFAdapter) {
            this.notify(-1);
            SAFItem[] to_copy = this.bitsToItems(cis);
            if (to_copy == null) {
                return false;
            }
            CopyBetweenEngine cbe = new CopyBetweenEngine(to_copy, to.getUri(), move);
            this.commander.startEngine(cbe);
            return true;
        }
        if (this.primary && !move) {
            boolean ok = to.receiveItems(this.bitsToNames(cis), move ? 1 : 0);
            if (!ok) {
                this.notify(-2);
            }
            return ok;
        }
        String err_msg = null;
        try {
            SAFItem[] to_copy = this.bitsToItems(cis);
            if (to_copy == null) {
                return false;
            }
            File dest = null;
            Engines.IReciever recipient = null;
            if (to instanceof FSAdapter) {
                String dest_fn = to.toString();
                dest = new File(dest_fn);
                if (!dest.exists()) {
                    dest.mkdirs();
                }
                if (!dest.isDirectory()) {
                    throw new RuntimeException(this.ctx.getString(Utils.RR.file_exist.r(), new Object[]{dest_fn}));
                }
            } else {
                dest = new File(this.createTempDir());
                recipient = to.getReceiver();
            }
            this.notify(-1);
            CopyFromEngine mfe = new CopyFromEngine(to_copy, move, dest, recipient);
            this.commander.startEngine(mfe);
            return true;
        }
        catch (Exception e) {
            err_msg = "Exception: " + e.getMessage();
            this.notify(err_msg, -2);
            return false;
        }
    }

    @Override
    public boolean receiveItems(String[] uris, int move_mode) {
        try {
            if (uris == null || uris.length == 0) {
                return false;
            }
            File[] list = Utils.getListOfFiles(uris);
            if (list != null) {
                this.notify(-1);
                this.commander.startEngine(new CopyToEngine(list, move_mode));
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public void prepareToDestroy() {
        super.prepareToDestroy();
        if (this.tht != null) {
            this.tht.interrupt();
        }
    }

    @Override
    protected int getPredictedAttributesLength() {
        return 24;
    }

    @Override
    public int getCount() {
        if (this.items == null) {
            return 1;
        }
        return this.items.length + 1;
    }

    public Object getItem(int position) {
        CommanderAdapter.Item item = null;
        if (position == 0) {
            item = new CommanderAdapter.Item();
            item.name = this.parentLink;
            item.dir = true;
        } else {
            if (this.items != null && position <= this.items.length) {
                return this.items[position - 1];
            }
            item = new CommanderAdapter.Item();
            item.name = "???";
        }
        return item;
    }

    public final SAFItem[] bitsToItems(SparseBooleanArray cis) {
        try {
            int counter = 0;
            for (int i = 0; i < cis.size(); ++i) {
                if (!cis.valueAt(i) || cis.keyAt(i) <= 0) continue;
                ++counter;
            }
            SAFItem[] res = new SAFItem[counter];
            int j = 0;
            for (int i = 0; i < cis.size(); ++i) {
                int k;
                if (!cis.valueAt(i) || (k = cis.keyAt(i)) <= 0) continue;
                res[j++] = this.items[k - 1];
            }
            return res;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"bitsToFiles()", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reSort() {
        if (this.items == null) {
            return;
        }
        SAFItem[] sAFItemArray = this.items;
        synchronized (this.items) {
            this.reSort(this.items);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void reSort(CommanderAdapter.Item[] items_) {
        if (items_ == null) {
            return;
        }
        ItemComparator comp = new ItemComparator(this.mode & 0x30, (this.mode & 0x80) != 0, this.ascending);
        Arrays.sort(items_, comp);
    }

    @Override
    public Engines.IReciever getReceiver() {
        return this;
    }

    public static void saveURI(Context ctx, Uri uri) {
        SharedPreferences saf_sp = ctx.getSharedPreferences(ORG_SCHEME, 0);
        SharedPreferences.Editor editor = saf_sp.edit();
        editor.putString("tree_root_uri", uri != null ? uri.toString() : null);
        editor.commit();
    }

    class CopyToEngine
    extends Engine {
        private Uri mDest;
        private ContentResolver cr;
        private int counter;
        private int delerr_counter;
        private int depth;
        private long totalBytes;
        private double conv;
        private File[] fList;
        private boolean move;
        private boolean del_src_dir;
        private boolean report_copy;
        private byte[] buf;
        private static final int BUFSZ = 524288;
        private PowerManager.WakeLock wakeLock;

        CopyToEngine(File[] list, int move_mode) {
            super((Engines.IReciever)null);
            this.counter = 0;
            this.delerr_counter = 0;
            this.depth = 0;
            this.totalBytes = 0L;
            this.fList = null;
            this.setName(".CopyToEngine");
            this.fList = list;
            this.mDest = SAFAdapter.this.getUri();
            this.cr = SAFAdapter.this.ctx.getContentResolver();
            this.move = (move_mode & 1) != 0;
            this.del_src_dir = (move_mode & 2) != 0;
            this.report_copy = (move_mode & 4) == 0;
            this.buf = new byte[524288];
            PowerManager pm = (PowerManager)SAFAdapter.this.ctx.getSystemService("power");
            this.wakeLock = pm.newWakeLock(1, this.TAG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            this.sendProgress(SAFAdapter.this.ctx.getString(2131361996), 0, 0);
            try {
                try {
                    int l = this.fList.length;
                    this.wakeLock.acquire();
                    int num = this.copyFiles(this.fList, this.mDest);
                    this.wakeLock.release();
                    if (this.delerr_counter == this.counter) {
                        this.move = false;
                    }
                    String report = Utils.getOpReport(SAFAdapter.this.ctx, num, this.move && !this.report_copy ? 2131362025 : 2131362024);
                    this.sendResult(report);
                }
                catch (Exception e) {
                    this.sendProgress(e.getMessage(), -7);
                    Object var5_6 = null;
                    if (!this.del_src_dir) return;
                    this.deleteDir(this.fList[0].getParentFile());
                    return;
                }
                Object var5_5 = null;
                if (!this.del_src_dir) return;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (!this.del_src_dir) throw throwable;
                this.deleteDir(this.fList[0].getParentFile());
                throw throwable;
            }
            this.deleteDir(this.fList[0].getParentFile());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final int copyFiles(File[] list, Uri dest) throws InterruptedException {
            file = null;
            i = 0;
            while (i < list.length) {
                block41: {
                    is = null;
                    os = null;
                    file = list[i];
                    if (file == null) {
                        this.error(SAFAdapter.this.ctx.getString(2131362012));
                        return this.counter;
                    }
                    dest_uri = null;
                    try {
                        block48: {
                            block54: {
                                block52: {
                                    block49: {
                                        block53: {
                                            block51: {
                                                block50: {
                                                    block43: {
                                                        block47: {
                                                            block46: {
                                                                block45: {
                                                                    block44: {
                                                                        block42: {
                                                                            if (!this.isStopReq()) break block42;
                                                                            this.error(SAFAdapter.this.ctx.getString(2131362010));
                                                                            var29_27 = null;
                                                                            ** GOTO lbl-1000
                                                                        }
                                                                        fn = file.getName();
                                                                        escaped_name = Utils.escapePath(fn);
                                                                        dest_uri = dest.buildUpon().encodedPath(dest.getEncodedPath() + "%2f" + escaped_name).build();
                                                                        mime = SAFAdapter.getMime(SAFAdapter.this.ctx, dest_uri);
                                                                        if (!file.isDirectory()) break block43;
                                                                        if (this.depth++ <= 40) break block44;
                                                                        this.error(SAFAdapter.this.ctx.getString(2131361994));
                                                                        ** GOTO lbl171
                                                                    }
                                                                    if (mime == null) break block45;
                                                                    if ("vnd.android.document/directory".equals(mime)) break block46;
                                                                    this.error(SAFAdapter.this.ctx.getString(2131362013));
                                                                    ** GOTO lbl181
                                                                }
                                                                DocumentsContract.createDocument((ContentResolver)this.cr, (Uri)dest, (String)"vnd.android.document/directory", (String)escaped_name);
                                                            }
                                                            this.copyFiles(file.listFiles(), dest_uri);
                                                            if (this.errMsg == null) break block47;
                                                            ** GOTO lbl191
                                                        }
                                                        --this.depth;
                                                        ++this.counter;
                                                        break block48;
                                                    }
                                                    if (mime == null) break block49;
                                                    res = this.askOnFileExist(SAFAdapter.this.ctx.getString(2131362015, new Object[]{fn}), SAFAdapter.this.commander);
                                                    if (res != 4) break block50;
                                                    ** GOTO lbl201
                                                }
                                                if (res != 1) break block51;
                                                ** GOTO lbl212
                                            }
                                            if (res != 2) break block52;
                                            dest_file = new File(SAFAdapter.this.getPath(dest_uri, false));
                                            if (!dest_file.equals(file)) break block53;
                                            Log.w((String)this.TAG, (String)"Not going to copy file to itself");
                                            ** GOTO lbl222
                                        }
                                        Log.v((String)this.TAG, (String)("Overwritting file " + fn));
                                        DocumentsContract.deleteDocument((ContentResolver)this.cr, (Uri)dest_uri);
                                        break block52;
                                    }
                                    mime = Utils.getMimeByExt(Utils.getFileExt(fn));
                                }
                                dest_uri = DocumentsContract.createDocument((ContentResolver)this.cr, (Uri)dest, (String)mime, (String)escaped_name);
                                if (dest_uri != null) break block54;
                                this.error(SAFAdapter.this.ctx.getString(2131362021, new Object[]{fn, ""}));
                                ** GOTO lbl233
                            }
                            dest_path = dest_uri.getPath();
                            if (dest_path.indexOf(fn) < 0) {
                                dest_uri = DocumentsContract.renameDocument((ContentResolver)this.cr, (Uri)dest_uri, (String)fn);
                            }
                            is = new FileInputStream(file);
                            os = this.cr.openOutputStream(dest_uri);
                            copied = 0L;
                            size = file.length();
                            start_time = 0L;
                            speed = 0;
                            so_far = (int)((double)this.totalBytes * this.conv);
                            sz_s = Utils.getHumanSize(size);
                            fnl = fn.length();
                            rep_s = SAFAdapter.this.ctx.getString(2131361997, new Object[]{fnl > 36 ? "\u2026" + fn.substring(fnl - 36) : fn});
                            n = 0;
                            nn = 0L;
                            while (true) {
                                block55: {
                                    if (nn == 0L) {
                                        start_time = System.currentTimeMillis();
                                        this.sendProgress(rep_s + this.sizeOfsize(copied, sz_s), so_far, (int)((double)this.totalBytes * this.conv), speed);
                                    }
                                    if ((n = is.read(this.buf)) < 0) {
                                        time_delta = System.currentTimeMillis() - start_time;
                                        if (time_delta <= 0L) break;
                                        speed = (int)(1000L * nn / time_delta);
                                        this.sendProgress(rep_s + this.sizeOfsize(copied, sz_s), so_far, (int)((double)this.totalBytes * this.conv), speed);
                                        break;
                                    }
                                    os.write(this.buf, 0, n);
                                    nn += (long)n;
                                    copied += (long)n;
                                    this.totalBytes += (long)n;
                                    if (!this.isStopReq()) break block55;
                                    Log.d((String)this.TAG, (String)"Interrupted!");
                                    this.error(SAFAdapter.this.ctx.getString(2131362010));
                                    time_delta = this.counter;
                                    ** GOTO lbl243
                                }
                                time_delta = System.currentTimeMillis() - start_time;
                                if (time_delta <= 1000L) continue;
                                speed = (int)(1000L * nn / time_delta);
                                nn = 0L;
                            }
                            is.close();
                            os.close();
                            is = null;
                            os = null;
                            if (i >= list.length - 1) {
                                this.sendProgress(SAFAdapter.this.ctx.getString(2131361998, new Object[]{fn}) + this.sizeOfsize(copied, sz_s), (int)((double)this.totalBytes * this.conv));
                            }
                            ++this.counter;
                        }
                        if (this.move && !file.delete()) {
                            this.sendProgress(SAFAdapter.this.ctx.getString(2131362022, new Object[]{fn}), -1);
                            ++this.delerr_counter;
                        }
                        ** GOTO lbl253
                    }
                    catch (Exception e) {
                        Log.e((String)this.TAG, (String)"", (Throwable)e);
                        this.error(SAFAdapter.this.ctx.getString(2131362019, new Object[]{file.getAbsolutePath(), e.getMessage()}));
                        var29_27 = null;
                        try {
                            if (is != null) {
                                is.close();
                            }
                            if (os != null) {
                                os.close();
                            }
                        }
                        catch (IOException e) {
                            this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{file.getAbsolutePath(), e.getMessage()}));
                        }
                        break block41;
                    }
                    {
                        catch (Throwable var28_29) {
                            var29_27 = null;
                            ** try [egrp 2[TRYBLOCK] [22 : 1149->1172)] { 
lbl154:
                            // 1 sources

                            if (is != null) {
                                is.close();
                            }
                            if (os == null) throw var28_29;
                            os.close();
                            throw var28_29;
lbl159:
                            // 1 sources

                            catch (IOException e) {
                                this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{file.getAbsolutePath(), e.getMessage()}));
                            }
                            throw var28_29;
                        }
lbl-1000:
                        // 1 sources

                        try {}
                        catch (IOException e) {
                            this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{file.getAbsolutePath(), e.getMessage()}));
                            return this.counter;
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (os == null) return this.counter;
                        os.close();
                        return this.counter;
lbl171:
                        // 1 sources

                        var29_27 = null;
                        try {}
                        catch (IOException e) {
                            this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{file.getAbsolutePath(), e.getMessage()}));
                            return this.counter;
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (os == null) return this.counter;
                        os.close();
                        return this.counter;
lbl181:
                        // 1 sources

                        var29_27 = null;
                        try {}
                        catch (IOException e) {
                            this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{file.getAbsolutePath(), e.getMessage()}));
                            return this.counter;
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (os == null) return this.counter;
                        os.close();
                        return this.counter;
lbl191:
                        // 1 sources

                        var29_27 = null;
                        try {}
                        catch (IOException e) {
                            this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{file.getAbsolutePath(), e.getMessage()}));
                            return this.counter;
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (os == null) return this.counter;
                        os.close();
                        return this.counter;
lbl201:
                        // 1 sources

                        var29_27 = null;
                        ** try [egrp 2[TRYBLOCK] [22 : 1149->1172)] { 
lbl203:
                        // 1 sources

                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
lbl209:
                        // 1 sources

                        catch (IOException e) {
                            this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{file.getAbsolutePath(), e.getMessage()}));
                        }
lbl212:
                        // 1 sources

                        var29_27 = null;
                        try {}
                        catch (IOException e) {
                            this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{file.getAbsolutePath(), e.getMessage()}));
                            return this.counter;
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (os == null) return this.counter;
                        os.close();
                        return this.counter;
lbl222:
                        // 1 sources

                        var29_27 = null;
                        ** try [egrp 2[TRYBLOCK] [22 : 1149->1172)] { 
lbl224:
                        // 1 sources

                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
lbl230:
                        // 1 sources

                        catch (IOException e) {
                            this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{file.getAbsolutePath(), e.getMessage()}));
                        }
lbl233:
                        // 1 sources

                        var29_27 = null;
                        try {}
                        catch (IOException e) {
                            this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{file.getAbsolutePath(), e.getMessage()}));
                            return this.counter;
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (os == null) return this.counter;
                        os.close();
                        return this.counter;
lbl243:
                        // 1 sources

                        var29_27 = null;
                        ** try [egrp 2[TRYBLOCK] [22 : 1149->1172)] { 
lbl245:
                        // 1 sources

                        if (is != null) {
                            is.close();
                        }
                        if (os == null) return time_delta;
                        os.close();
                        return time_delta;
lbl250:
                        // 1 sources

                        catch (IOException e) {
                            this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{file.getAbsolutePath(), e.getMessage()}));
                        }
                        return time_delta;
lbl253:
                        // 1 sources

                        var29_27 = null;
                        ** try [egrp 2[TRYBLOCK] [22 : 1149->1172)] { 
lbl255:
                        // 1 sources

                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
lbl261:
                        // 1 sources

                        catch (IOException e) {}
                        this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{file.getAbsolutePath(), e.getMessage()}));
                    }
                }
                ++i;
            }
            return this.counter;
        }
    }

    class CopyFromEngine
    extends Engine {
        private SAFItem[] mList;
        private SAFAdapter owner;
        private ContentResolver cr;
        private File destFolder;
        private byte[] buf;
        private boolean move;

        CopyFromEngine(SAFItem[] list, boolean move, File dest, Engines.IReciever recipient_) {
            super(recipient_);
            this.buf = new byte[65536];
            this.setName(".CopyFromEngine");
            this.owner = SAFAdapter.this;
            this.mList = list;
            this.destFolder = dest;
            this.move = move;
        }

        public void run() {
            try {
                SAFAdapter.this.Init(null);
                this.cr = SAFAdapter.this.ctx.getContentResolver();
                int cnt = this.copyFiles(this.mList, this.destFolder);
                if (this.recipient != null) {
                    this.sendReceiveReq(this.destFolder, this.move);
                    return;
                }
                this.sendResult(Utils.getOpReport(this.owner.ctx, cnt, this.move ? 2131362025 : 2131362024));
            }
            catch (Exception e) {
                this.sendProgress(e.getMessage(), -7);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private final int copyFiles(CommanderAdapter.Item[] l, File dest) throws Exception {
            if (l == null) {
                return 0;
            }
            int cnt = 0;
            int num = l.length;
            for (int i = 0; i < num; ++i) {
                boolean ok;
                Uri u;
                block21: {
                    File dest_file;
                    CommanderAdapter.Item item;
                    block22: {
                        Object var26_24;
                        InputStream is;
                        FileOutputStream os;
                        block19: {
                            String fn;
                            block20: {
                                CopyFromEngine.sleep(1L);
                                if (this.isStopReq()) {
                                    throw new Exception(SAFAdapter.this.s(2131362010));
                                }
                                item = l[i];
                                fn = item.name;
                                this.sendProgress(SAFAdapter.this.ctx.getString(2131361997, new Object[]{fn}), 0);
                                dest_file = new File(dest, fn);
                                u = (Uri)item.origin;
                                ok = false;
                                if (!item.dir) break block20;
                                if (!dest_file.exists()) {
                                    dest_file.mkdir();
                                }
                                ArrayList<SAFItem> tmp_list = SAFAdapter.this.getChildren(u);
                                CommanderAdapter.Item[] sub_items = new SAFItem[tmp_list.size()];
                                tmp_list.toArray(sub_items);
                                cnt += this.copyFiles(sub_items, dest_file);
                                if (this.errMsg != null) break;
                                ok = true;
                                break block21;
                            }
                            if (dest_file.exists()) {
                                int res = this.askOnFileExist(this.owner.ctx.getString(2131362015, new Object[]{dest_file.getAbsolutePath()}), this.owner.commander);
                                if (res == 1) {
                                    this.error(this.owner.ctx.getString(2131361992));
                                    break;
                                }
                                if (res == 4) continue;
                                if (res == 2 && !dest_file.delete()) {
                                    this.error(this.owner.ctx.getString(2131362022, new Object[]{dest_file.getAbsoluteFile()}));
                                    break;
                                }
                            }
                            int fnl = fn.length();
                            String rep_s = this.owner.ctx.getString(2131361997, new Object[]{fnl > 36 ? "\u2026" + fn.substring(fnl - 36) : fn});
                            long copied = 0L;
                            long size = item.size;
                            String sz_s = Utils.getHumanSize(size, false);
                            double conv = 100.0 / (double)size;
                            os = null;
                            is = null;
                            try {
                                int n;
                                os = new FileOutputStream(dest_file);
                                is = this.cr.openInputStream(u);
                                while ((n = is.read(this.buf)) != -1) {
                                    ((OutputStream)os).write(this.buf, 0, n);
                                    this.sendProgress(rep_s + this.sizeOfsize(copied += (long)n, sz_s), (int)((double)copied * conv));
                                    Thread.sleep(1L);
                                }
                                ok = true;
                                var26_24 = null;
                                if (is == null) break block19;
                            }
                            catch (Throwable throwable) {
                                var26_24 = null;
                                if (is != null) {
                                    is.close();
                                }
                                if (os != null) {
                                    ((OutputStream)os).close();
                                }
                                throw throwable;
                            }
                            is.close();
                        }
                        if (os != null) {
                            ((OutputStream)os).close();
                        }
                        break block22;
                        {
                            catch (Exception e) {
                                Log.e((String)this.TAG, (String)("Can't copy to file: " + dest_file.getAbsolutePath()), (Throwable)e);
                                String msg = e.getMessage();
                                this.error(this.owner.ctx.getString(2131362018, new Object[]{dest_file.getAbsolutePath(), ""}));
                                var26_24 = null;
                                if (is != null) {
                                    is.close();
                                }
                                if (os == null) break;
                                ((OutputStream)os).close();
                                break;
                            }
                        }
                    }
                    try {
                        dest_file.setLastModified(item.date.getTime());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.move && ok) {
                    DocumentsContract.deleteDocument((ContentResolver)this.cr, (Uri)u);
                }
                ++cnt;
            }
            return cnt;
        }
    }

    class CopyBetweenEngine
    extends Engine {
        private Uri mDest;
        private ContentResolver cr;
        private int counter = 0;
        private int delerr_counter = 0;
        private int depth = 0;
        private long totalBytes = 0L;
        private double conv;
        private SAFItem[] iList = null;
        private boolean move;
        private byte[] buf;
        private static final int BUFSZ = 524288;
        private PowerManager.WakeLock wakeLock;

        CopyBetweenEngine(SAFItem[] to_copy, Uri dest, boolean move) {
            this.setName(".CopyBetweenEngine");
            this.iList = to_copy;
            this.mDest = dest;
            this.cr = SAFAdapter.this.ctx.getContentResolver();
            this.move = move;
            this.buf = new byte[524288];
            PowerManager pm = (PowerManager)SAFAdapter.this.ctx.getSystemService("power");
            this.wakeLock = pm.newWakeLock(1, this.TAG);
        }

        public void run() {
            this.sendProgress(SAFAdapter.this.ctx.getString(2131361996), 0, 0);
            try {
                int l = this.iList.length;
                this.wakeLock.acquire();
                int num = this.copyFiles(this.iList, this.mDest);
                this.wakeLock.release();
                String report = Utils.getOpReport(SAFAdapter.this.ctx, num, this.move ? 2131362025 : 2131362024);
                this.sendResult(report);
            }
            catch (Exception e) {
                this.sendProgress(e.getMessage(), -7);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final int copyFiles(SAFItem[] list, Uri dest) throws InterruptedException {
            item = null;
            i = 0;
            while (i < list.length) {
                block43: {
                    is = null;
                    os = null;
                    item = list[i];
                    if (item == null) {
                        this.error(SAFAdapter.this.ctx.getString(2131362012));
                        return this.counter;
                    }
                    dest_uri = null;
                    try {
                        block51: {
                            block55: {
                                block52: {
                                    block56: {
                                        block54: {
                                            block53: {
                                                block46: {
                                                    block50: {
                                                        block49: {
                                                            block48: {
                                                                block47: {
                                                                    block45: {
                                                                        block44: {
                                                                            if (!this.isStopReq()) break block44;
                                                                            this.error(SAFAdapter.this.ctx.getString(2131362010));
                                                                            var30_28 = null;
                                                                            ** GOTO lbl-1000
                                                                        }
                                                                        fn = item.name;
                                                                        if (Utils.str(fn)) break block45;
                                                                        ** GOTO lbl176
                                                                    }
                                                                    if (fn.charAt(0) == '/') {
                                                                        fn = fn.substring(1);
                                                                    }
                                                                    to_append = "%2f" + Utils.escapePath(fn);
                                                                    dest_uri = dest.buildUpon().encodedPath(dest.getEncodedPath() + to_append).build();
                                                                    mime = SAFAdapter.getMime(SAFAdapter.this.ctx, dest_uri);
                                                                    item_uri = (Uri)item.origin;
                                                                    if (!item.dir) break block46;
                                                                    if (this.depth++ <= 40) break block47;
                                                                    this.error(SAFAdapter.this.ctx.getString(2131361994));
                                                                    ** GOTO lbl187
                                                                }
                                                                if (mime == null) break block48;
                                                                if ("vnd.android.document/directory".equals(mime)) break block49;
                                                                this.error(SAFAdapter.this.ctx.getString(2131362013));
                                                                ** GOTO lbl197
                                                            }
                                                            DocumentsContract.createDocument((ContentResolver)this.cr, (Uri)dest, (String)"vnd.android.document/directory", (String)fn);
                                                        }
                                                        tmp_list = SAFAdapter.this.getChildren(item_uri);
                                                        sub_items = new SAFItem[tmp_list.size()];
                                                        tmp_list.toArray(sub_items);
                                                        this.copyFiles(sub_items, dest_uri);
                                                        if (this.errMsg == null) break block50;
                                                        ** GOTO lbl207
                                                    }
                                                    --this.depth;
                                                    ++this.counter;
                                                    break block51;
                                                }
                                                if (mime == null) break block52;
                                                res = this.askOnFileExist(SAFAdapter.this.ctx.getString(2131362015, new Object[]{fn}), SAFAdapter.this.commander);
                                                if (res != 4) break block53;
                                                ** GOTO lbl217
                                            }
                                            if (res != 1) break block54;
                                            ** GOTO lbl228
                                        }
                                        if (res != 2) break block55;
                                        if (!item_uri.equals((Object)dest_uri)) break block56;
                                        Log.w((String)this.TAG, (String)"Not going to copy file to itself");
                                        ** GOTO lbl238
                                    }
                                    Log.v((String)this.TAG, (String)("Overwritting file " + fn));
                                    DocumentsContract.deleteDocument((ContentResolver)this.cr, (Uri)dest_uri);
                                    break block55;
                                }
                                mime = Utils.getMimeByExt(Utils.getFileExt(fn));
                            }
                            dest_uri = DocumentsContract.createDocument((ContentResolver)this.cr, (Uri)dest, (String)mime, (String)fn);
                            dest_path = dest_uri.getPath();
                            if (dest_path.indexOf(fn, dest_path.length() - fn.length() - 1) < 0) {
                                dest_uri = DocumentsContract.renameDocument((ContentResolver)this.cr, (Uri)dest_uri, (String)fn);
                            }
                            is = this.cr.openInputStream(item_uri);
                            os = this.cr.openOutputStream(dest_uri);
                            copied = 0L;
                            size = item.size;
                            start_time = 0L;
                            speed = 0;
                            so_far = (int)((double)this.totalBytes * this.conv);
                            sz_s = Utils.getHumanSize(size);
                            fnl = fn.length();
                            rep_s = SAFAdapter.this.ctx.getString(2131361997, new Object[]{fnl > 36 ? "\u2026" + fn.substring(fnl - 36) : fn});
                            n = 0;
                            nn = 0L;
                            while (true) {
                                block57: {
                                    if (nn == 0L) {
                                        start_time = System.currentTimeMillis();
                                        this.sendProgress(rep_s + this.sizeOfsize(copied, sz_s), so_far, (int)((double)this.totalBytes * this.conv), speed);
                                    }
                                    if ((n = is.read(this.buf)) < 0) {
                                        time_delta = System.currentTimeMillis() - start_time;
                                        if (time_delta <= 0L) break;
                                        speed = (int)(1000L * nn / time_delta);
                                        this.sendProgress(rep_s + this.sizeOfsize(copied, sz_s), so_far, (int)((double)this.totalBytes * this.conv), speed);
                                        break;
                                    }
                                    os.write(this.buf, 0, n);
                                    nn += (long)n;
                                    copied += (long)n;
                                    this.totalBytes += (long)n;
                                    if (!this.isStopReq()) break block57;
                                    Log.d((String)this.TAG, (String)"Interrupted!");
                                    this.error(SAFAdapter.this.ctx.getString(2131362010));
                                    time_delta = this.counter;
                                    ** GOTO lbl249
                                }
                                time_delta = System.currentTimeMillis() - start_time;
                                if (time_delta <= 1000L) continue;
                                speed = (int)(1000L * nn / time_delta);
                                nn = 0L;
                            }
                            is.close();
                            os.close();
                            is = null;
                            os = null;
                            if (i >= list.length - 1) {
                                this.sendProgress(SAFAdapter.this.ctx.getString(2131361998, new Object[]{fn}) + this.sizeOfsize(copied, sz_s), (int)((double)this.totalBytes * this.conv));
                            }
                            ++this.counter;
                        }
                        if (this.move && !DocumentsContract.deleteDocument((ContentResolver)this.cr, (Uri)item_uri)) {
                            this.sendProgress(SAFAdapter.this.ctx.getString(2131362022, new Object[]{fn}), -1);
                            ++this.delerr_counter;
                        }
                        ** GOTO lbl259
                    }
                    catch (Exception e) {
                        Log.e((String)this.TAG, (String)"", (Throwable)e);
                        this.error(SAFAdapter.this.ctx.getString(2131362019, new Object[]{item.name, e.getMessage()}));
                        var30_28 = null;
                        try {
                            if (is != null) {
                                is.close();
                            }
                            if (os != null) {
                                os.close();
                            }
                        }
                        catch (IOException e) {
                            this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{item.name, e.getMessage()}));
                        }
                        break block43;
                    }
                    {
                        catch (Throwable var29_30) {
                            var30_28 = null;
                            ** try [egrp 2[TRYBLOCK] [22 : 1191->1214)] { 
lbl159:
                            // 1 sources

                            if (is != null) {
                                is.close();
                            }
                            if (os == null) throw var29_30;
                            os.close();
                            throw var29_30;
lbl164:
                            // 1 sources

                            catch (IOException e) {
                                this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{item.name, e.getMessage()}));
                            }
                            throw var29_30;
                        }
lbl-1000:
                        // 1 sources

                        try {}
                        catch (IOException e) {
                            this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{item.name, e.getMessage()}));
                            return this.counter;
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (os == null) return this.counter;
                        os.close();
                        return this.counter;
lbl176:
                        // 1 sources

                        var30_28 = null;
                        ** try [egrp 2[TRYBLOCK] [22 : 1191->1214)] { 
lbl178:
                        // 1 sources

                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
lbl184:
                        // 1 sources

                        catch (IOException e) {
                            this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{item.name, e.getMessage()}));
                        }
lbl187:
                        // 1 sources

                        var30_28 = null;
                        try {}
                        catch (IOException e) {
                            this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{item.name, e.getMessage()}));
                            return this.counter;
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (os == null) return this.counter;
                        os.close();
                        return this.counter;
lbl197:
                        // 1 sources

                        var30_28 = null;
                        try {}
                        catch (IOException e) {
                            this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{item.name, e.getMessage()}));
                            return this.counter;
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (os == null) return this.counter;
                        os.close();
                        return this.counter;
lbl207:
                        // 1 sources

                        var30_28 = null;
                        try {}
                        catch (IOException e) {
                            this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{item.name, e.getMessage()}));
                            return this.counter;
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (os == null) return this.counter;
                        os.close();
                        return this.counter;
lbl217:
                        // 1 sources

                        var30_28 = null;
                        ** try [egrp 2[TRYBLOCK] [22 : 1191->1214)] { 
lbl219:
                        // 1 sources

                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
lbl225:
                        // 1 sources

                        catch (IOException e) {
                            this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{item.name, e.getMessage()}));
                        }
lbl228:
                        // 1 sources

                        var30_28 = null;
                        try {}
                        catch (IOException e) {
                            this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{item.name, e.getMessage()}));
                            return this.counter;
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (os == null) return this.counter;
                        os.close();
                        return this.counter;
lbl238:
                        // 1 sources

                        var30_28 = null;
                        ** try [egrp 2[TRYBLOCK] [22 : 1191->1214)] { 
lbl240:
                        // 1 sources

                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
lbl246:
                        // 1 sources

                        catch (IOException e) {
                            this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{item.name, e.getMessage()}));
                        }
lbl249:
                        // 1 sources

                        var30_28 = null;
                        ** try [egrp 2[TRYBLOCK] [22 : 1191->1214)] { 
lbl251:
                        // 1 sources

                        if (is != null) {
                            is.close();
                        }
                        if (os == null) return time_delta;
                        os.close();
                        return time_delta;
lbl256:
                        // 1 sources

                        catch (IOException e) {
                            this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{item.name, e.getMessage()}));
                        }
                        return time_delta;
lbl259:
                        // 1 sources

                        var30_28 = null;
                        ** try [egrp 2[TRYBLOCK] [22 : 1191->1214)] { 
lbl261:
                        // 1 sources

                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
lbl267:
                        // 1 sources

                        catch (IOException e) {}
                        this.error(SAFAdapter.this.ctx.getString(2131362018, new Object[]{item.name, e.getMessage()}));
                    }
                }
                ++i;
            }
            return this.counter;
        }
    }

    class DeleteEngine
    extends Engine {
        private CommanderAdapter.Item[] mList;
        private Uri dirUri;
        private ContentResolver cr;

        DeleteEngine(CommanderAdapter.Item[] list) {
            this.setName(".DeleteEngine");
            this.mList = list;
            this.dirUri = SAFAdapter.this.getUri();
        }

        public void run() {
            try {
                SAFAdapter.this.Init(null);
                this.cr = SAFAdapter.this.ctx.getContentResolver();
                int cnt = this.deleteFiles(this.dirUri, this.mList);
                this.sendResult(Utils.getOpReport(SAFAdapter.this.ctx, cnt, 2131362026));
            }
            catch (Exception e) {
                this.sendProgress(e.getMessage(), -7);
            }
        }

        private final int deleteFiles(Uri dir_uri, CommanderAdapter.Item[] l) throws Exception {
            if (l == null) {
                return 0;
            }
            int cnt = 0;
            int num = l.length;
            double conv = 100.0 / (double)num;
            for (int i = 0; i < num; ++i) {
                DeleteEngine.sleep(1L);
                if (this.isStopReq()) {
                    throw new Exception(SAFAdapter.this.s(2131362010));
                }
                CommanderAdapter.Item item = l[i];
                this.sendProgress(SAFAdapter.this.ctx.getString(2131361999, new Object[]{item.name}), (int)((double)cnt * conv));
                DocumentsContract.deleteDocument((ContentResolver)this.cr, (Uri)((Uri)item.origin));
                ++cnt;
            }
            return cnt;
        }
    }

    class SAFReplacer
    extends Replacer {
        public String last_file_name = null;
        private CommanderAdapter.Item[] list;
        private ContentResolver cr;

        SAFReplacer(CommanderAdapter.Item[] list, ContentResolver cr) {
            this.list = list;
            this.cr = cr;
        }

        protected int getNumberOfOriginalStrings() {
            return this.list.length;
        }

        protected String getOriginalString(int i) {
            return this.list[i].name;
        }

        protected void setReplacedString(int i, String replaced) {
            CommanderAdapter.Item item = this.list[i];
            SAFAdapter.this.renameItem(item, this.cr, replaced);
            this.last_file_name = replaced;
        }
    }

    class SAFItem
    extends CommanderAdapter.Item
    implements FSEngines.IFileItem {
        SAFItem() {
        }

        public File f() {
            Uri u = (Uri)this.origin;
            String path = SAFAdapter.this.getPath(u, this.dir);
            return new File(path);
        }
    }
}

