/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.favorites;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.Utils;
import java.util.regex.Pattern;

public class Favorite {
    private static final String TAG = "Favorite";
    private static String sep = ",";
    private static Pattern sep_re = Pattern.compile(sep);
    private String id;
    private Uri uri;
    private String comment;
    private Credentials credentials;

    public Favorite(Uri u) {
        this(u, null, null);
    }

    public Favorite(Uri u, Credentials c) {
        this(u, c, null);
    }

    public Favorite(String uri_str, String comment_) {
        this(Uri.parse((String)uri_str), null, comment_);
    }

    public Favorite(Uri u, Credentials c, String comment_) {
        if (u == null) {
            u = new Uri.Builder().build();
        }
        if (c == null) {
            this.extractCredentialsFromUri(u);
        } else {
            this.uri = Utils.updateUserInfo(u, null);
            this.credentials = c;
        }
        this.comment = comment_;
        this.setID(Integer.toHexString(u.hashCode()));
    }

    public final void extractCredentialsFromUri(Uri u) {
        try {
            this.uri = u;
            String user_info = this.uri.getUserInfo();
            if (user_info != null && user_info.length() > 0) {
                this.credentials = new Credentials(user_info);
                String pw = this.credentials.getPassword();
                if (Credentials.pwScreen.equals(pw)) {
                    this.credentials = new Credentials(this.credentials.getUserName(), this.credentials.getPassword());
                }
                this.uri = Utils.updateUserInfo(this.uri, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final String getID() {
        return this.id;
    }

    private final void setID(String id2) {
        this.id = id2;
    }

    public static Favorite fromString(String raw2, Context ctx) {
        if (raw2 == null) {
            return null;
        }
        try {
            String[] flds = sep_re.split(raw2);
            if (flds == null) {
                return null;
            }
            Uri uri = null;
            String comment = null;
            Credentials credentials = null;
            for (int i = 0; i < flds.length; ++i) {
                String s = flds[i];
                if (s == null || s.length() == 0) continue;
                String sv = Favorite.unescape(s.substring(4));
                if (s.startsWith("URI=")) {
                    uri = Uri.parse((String)sv);
                    continue;
                }
                if (s.startsWith("CMT=")) {
                    comment = sv;
                    continue;
                }
                if (s.startsWith("CRD=")) {
                    credentials = Credentials.fromOldEncriptedString(sv);
                    continue;
                }
                if (!s.startsWith("CRS=")) continue;
                credentials = Credentials.fromEncriptedString(sv, ctx);
            }
            return new Favorite(uri, credentials, comment);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("can't restore " + raw2), (Throwable)e);
            return null;
        }
    }

    public final void store(Context ctx, SharedPreferences.Editor ed) {
        ed.putString("URI_" + this.id, this.uri.toString());
        if (this.comment != null) {
            ed.putString("CMT_" + this.id, this.comment);
        }
        if (this.credentials != null) {
            if (Build.VERSION.SDK_INT >= 18) {
                ed.putString("CRS_" + this.id, this.credentials.toEncriptedString(ctx));
            } else {
                ed.putString("CRD_" + this.id, this.credentials.toOldEncriptedString());
            }
        }
    }

    public static final void erasePrefs(String id2, SharedPreferences.Editor ed) {
        ed.remove("URI_" + id2);
        ed.remove("CMT_" + id2);
        ed.remove("CRS_" + id2);
        ed.remove("CRD_" + id2);
    }

    public static final Favorite restore(Context ctx, String id2, SharedPreferences sp) {
        String sv = sp.getString("URI_" + id2, null);
        if (sv == null) {
            return null;
        }
        Uri uri = null;
        String comment = null;
        Credentials credentials = null;
        uri = Uri.parse((String)sv);
        comment = sp.getString("CMT_" + id2, null);
        String crs = null;
        if (Build.VERSION.SDK_INT >= 18) {
            crs = sp.getString("CRS_" + id2, null);
        }
        if (crs != null) {
            credentials = Credentials.fromEncriptedString(crs, ctx);
        } else {
            crs = sp.getString("CRD_" + id2, null);
            if (crs != null) {
                credentials = Credentials.fromOldEncriptedString(crs);
            }
        }
        Favorite f = new Favorite(uri, credentials, comment);
        f.setID(id2);
        return f;
    }

    public final String getComment() {
        return this.comment;
    }

    public final void setComment(String s) {
        this.comment = s;
    }

    public final void setUri(Uri u) {
        this.uri = u;
    }

    public final Uri getUri() {
        return this.uri;
    }

    public final Uri getUriWithAuth() {
        if (this.credentials == null) {
            return this.uri;
        }
        return Utils.getUriWithAuth(this.uri, this.credentials.getUserName(), this.credentials.getPassword());
    }

    public final String getUriString(boolean screen_pw) {
        try {
            if (this.uri == null) {
                return null;
            }
            if (this.credentials == null) {
                return this.uri.toString();
            }
            if (screen_pw) {
                return Utils.getUriWithAuth(this.uri, this.credentials.getUserName(), Credentials.pwScreen).toString();
            }
            return this.getUriWithAuth().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public final boolean equals(String test) {
        String item = this.getUriString(false);
        if (item != null) {
            String strip_item = item.trim();
            if (strip_item.length() == 0 || strip_item.charAt(strip_item.length() - 1) != '/') {
                strip_item = strip_item + "/";
            }
            if (strip_item.compareTo(test) == 0) {
                return true;
            }
        }
        return false;
    }

    public final String getUserName() {
        return this.credentials == null ? null : this.credentials.getUserName();
    }

    public final String getPassword() {
        return this.credentials == null ? "" : this.credentials.getPassword();
    }

    public final void setCredentials(String un, String pw) {
        if (un == null || un.length() == 0) {
            this.credentials = null;
            return;
        }
        this.credentials = new Credentials(un, pw);
    }

    private static String unescape(String s) {
        return s.replace("%2C", sep);
    }

    private static String escape(String s) {
        return s.replace(sep, "%2C");
    }

    public static final String screenPwd(String uri_str) {
        if (uri_str == null) {
            return null;
        }
        return Favorite.screenPwd(Uri.parse((String)uri_str));
    }

    public static final String screenPwd(Uri u) {
        if (u == null) {
            return null;
        }
        String ui = u.getUserInfo();
        if (ui == null || ui.length() == 0) {
            return u.toString();
        }
        int pw_pos = ui.indexOf(58);
        if (pw_pos < 0) {
            return u.toString();
        }
        ui = Uri.encode((String)ui.substring(0, pw_pos)) + ":" + Credentials.pwScreen;
        return Utils.updateUserInfo(u, ui).toString();
    }

    public static final boolean isPwdScreened(Uri u) {
        Credentials crd;
        String user_info = u.getUserInfo();
        return user_info != null && user_info.length() > 0 && Credentials.pwScreen.equals((crd = new Credentials(user_info)).getPassword());
    }

    public final Credentials borrowPassword(Uri stranger_uri) {
        Credentials stranger_crd;
        String stranger_username;
        if (this.credentials == null) {
            return null;
        }
        String stranger_user_info = stranger_uri.getUserInfo();
        String username = this.credentials.getUserName();
        String password = this.credentials.getPassword();
        if (username != null && password != null && stranger_user_info != null && stranger_user_info.length() > 0 && username.equalsIgnoreCase(stranger_username = (stranger_crd = new Credentials(stranger_user_info)).getUserName())) {
            return new Credentials(stranger_username, password);
        }
        return null;
    }

    public static Uri borrowPassword(Uri us, Uri fu) {
        String host;
        String schm = us.getScheme();
        if (schm != null && schm.equals(fu.getScheme()) && (host = us.getHost()) != null && host.equalsIgnoreCase(fu.getHost())) {
            String uis = us.getUserInfo();
            String fui = fu.getUserInfo();
            if (fui != null && fui.length() > 0) {
                Credentials crds = new Credentials(uis);
                Credentials fcrd = new Credentials(fui);
                String un = crds.getUserName();
                if (un != null && un.equals(fcrd.getUserName())) {
                    return Utils.getUriWithAuth(us, un, fcrd.getPassword());
                }
            }
        }
        return null;
    }
}

