/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.utils;

import android.util.Log;
import com.ghostsq.commander.utils.Utils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LsItem {
    private static final String TAG = "LsItem";
    private static Pattern unix = Pattern.compile("^([\\-bcdlprwxsStT]{9,10}\\s+\\d+\\s+[^\\s]+\\s+[^\\s]+)\\s+(\\d+)\\s+((?:Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\\s+\\d{1,2}\\s+(?:\\d{4}|\\d{1,2}:\\d{2}))\\s(.+)");
    private static Pattern inet = Pattern.compile("^([\\-bcdlprwxsStT]{9,10}\\s+.+)\\s+(\\d*)\\s+(\\d{4}-\\d{2}-\\d{2}\\s\\d{1,2}:\\d{2})\\s(.+)");
    private static Pattern msdos = Pattern.compile("^(\\d{2,4}-\\d{2}-\\d{2,4}\\s+\\d{1,2}:\\d{2}[AP]M)\\s+(\\d+|<DIR>)\\s+(.+)");
    private static SimpleDateFormat format_date_time = new SimpleDateFormat("MMM d HH:mm", Locale.ENGLISH);
    private static SimpleDateFormat format_date_year = new SimpleDateFormat("MMM d yyyy", Locale.ENGLISH);
    private static SimpleDateFormat format_full_date = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.ENGLISH);
    private static SimpleDateFormat format_msdos_date = new SimpleDateFormat("MM-dd-yy  HH:mmaa", Locale.ENGLISH);
    private String name;
    private String link_target_name = null;
    private String attr = null;
    private boolean directory = false;
    private boolean link = false;
    private long size = 0L;
    private Date date;
    public static final String LINK_PTR = " -> ";

    public LsItem(String ls_string) {
        Matcher m = unix.matcher(ls_string);
        if (m.matches()) {
            try {
                this.name = m.group(4);
                if (ls_string.charAt(0) == 'd') {
                    this.directory = true;
                }
                if (ls_string.charAt(0) == 'l') {
                    this.link = true;
                    int arr_pos = this.name.indexOf(LINK_PTR);
                    if (arr_pos > 0) {
                        this.link_target_name = this.name.substring(arr_pos + 4);
                        this.name = this.name.substring(0, arr_pos);
                    }
                }
                this.size = Long.parseLong(m.group(2));
                String date_s = m.group(3);
                boolean in_year = date_s.indexOf(58) > 0;
                SimpleDateFormat df = in_year ? format_date_time : format_date_year;
                this.date = df.parse(date_s);
                if (in_year) {
                    Calendar cal = Calendar.getInstance();
                    int cur_year = cal.get(1) - 1900;
                    int cur_month = cal.get(2);
                    int f_month = this.date.getMonth();
                    if (f_month > cur_month) {
                        --cur_year;
                    }
                    this.date.setYear(cur_year);
                }
                this.attr = m.group(1);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return;
        }
        m = inet.matcher(ls_string);
        if (m.matches()) {
            try {
                String sz_str;
                if (ls_string.charAt(0) == 'd') {
                    this.directory = true;
                }
                this.name = m.group(4);
                if (ls_string.charAt(0) == 'l') {
                    this.link = true;
                    int arr_pos = this.name.indexOf(LINK_PTR);
                    if (arr_pos > 0) {
                        this.link_target_name = this.name.substring(arr_pos + 4);
                        this.name = this.name.substring(0, arr_pos);
                    }
                }
                this.size = (sz_str = m.group(2)) != null && sz_str.length() > 0 ? Long.parseLong(sz_str) : -1L;
                String date_s = m.group(3);
                SimpleDateFormat df = format_full_date;
                this.date = df.parse(date_s);
                this.attr = m.group(1);
                if (this.attr != null) {
                    this.attr = this.attr.trim();
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return;
        }
        m = msdos.matcher(ls_string);
        if (m.matches()) {
            try {
                this.name = m.group(3);
                if (m.group(2).equals("<DIR>")) {
                    this.directory = true;
                } else {
                    this.size = Long.parseLong(m.group(2));
                }
                String date_s = m.group(1);
                SimpleDateFormat df = format_msdos_date;
                this.date = df.parse(date_s);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return;
        }
        Log.e((String)TAG, (String)("\nUnmatched string: " + ls_string + "\n"));
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.name);
        if (this.link_target_name != null) {
            s.append("  ->  " + this.link_target_name);
        }
        if (this.attr != null) {
            s.append(" (" + this.attr + ")");
        }
        if (this.directory) {
            s.append(" DIR");
        }
        if (this.link) {
            s.append(" LINK");
        }
        s.append(" " + this.size);
        s.append(" " + this.date);
        return s.toString();
    }

    public final String getName() {
        return this.name;
    }

    public final Date getDate() {
        return this.date;
    }

    public final long length() {
        return this.size;
    }

    public final boolean isValid() {
        return this.name != null;
    }

    public final boolean isDirectory() {
        return this.directory;
    }

    public final void setDirectory() {
        this.directory = true;
    }

    public final String getLinkTarget() {
        return this.link ? this.link_target_name : null;
    }

    public final String getAttr() {
        return this.attr;
    }

    public final int compareTo(LsItem o) {
        return this.getName().compareTo(o.getName());
    }

    public static LsItem[] createArray(int n) {
        return new LsItem[n];
    }

    public static class FilterProps
    extends com.ghostsq.commander.FilterProps {
        public FilterProps(com.ghostsq.commander.FilterProps from) {
            this.file_mask = from.file_mask;
            this.dirs = from.dirs;
            this.files = from.files;
            this.include_matched = from.include_matched;
            this.larger_than = from.larger_than;
            this.smaller_than = from.smaller_than;
            this.mod_after = from.mod_after;
            this.mod_before = from.mod_before;
        }

        private boolean isItMatched(LsItem item) {
            String item_name = item.name;
            if (item.directory) {
                if (!this.dirs) {
                    return false;
                }
                item_name = item.name.replace("/", "");
            } else {
                if (!this.files) {
                    return false;
                }
                if (item.size < this.larger_than || item.size > this.smaller_than) {
                    return false;
                }
            }
            if (Utils.str(this.file_mask)) {
                if (this.cards == null) {
                    this.cards = Utils.prepareWildcard(this.file_mask);
                }
                if (!Utils.match(item_name, this.cards)) {
                    return false;
                }
            }
            long modified = item.date.getTime();
            if (this.mod_after != null && modified < this.mod_after.getTime()) {
                return false;
            }
            return this.mod_before == null || modified <= this.mod_before.getTime();
        }

        public boolean isMatched(LsItem item) {
            return !(this.isItMatched(item) ^ this.include_matched);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LsItemPropComparator
    implements Comparator<LsItem> {
        int type;
        boolean case_ignore;
        boolean ascending;

        public LsItemPropComparator(int type_, boolean case_ignore_, boolean ascending_) {
            this.type = type_;
            this.case_ignore = case_ignore_ && (type_ == 48 || type_ == 0);
            this.ascending = ascending_;
        }

        @Override
        public int compare(LsItem f1, LsItem f2) {
            boolean f2IsDir;
            boolean f1IsDir = f1.isDirectory();
            if (f1IsDir != (f2IsDir = f2.isDirectory())) {
                return f1IsDir ? -1 : 1;
            }
            int ext_cmp = 0;
            switch (this.type) {
                case 48: {
                    ext_cmp = this.case_ignore ? Utils.getFileExt(f1.getName()).compareToIgnoreCase(Utils.getFileExt(f2.getName())) : Utils.getFileExt(f1.getName()).compareTo(Utils.getFileExt(f2.getName()));
                    break;
                }
                case 16: {
                    ext_cmp = f1.length() - f2.length() < 0L ? -1 : 1;
                    break;
                }
                case 32: {
                    ext_cmp = f1.getDate().compareTo(f2.getDate());
                }
            }
            if (ext_cmp == 0) {
                ext_cmp = this.case_ignore ? f1.getName().compareToIgnoreCase(f2.getName()) : f1.compareTo(f2);
            }
            return this.ascending ? ext_cmp : -ext_cmp;
        }
    }
}

