/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.net.UrlQuerySanitizer;
import android.os.Build;
import android.os.Environment;
import android.preference.PreferenceManager;
import android.text.format.DateFormat;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.webkit.MimeTypeMap;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.ForwardCompat;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public final class Utils {
    public static final String C_AUDIO = "a";
    public static final String C_VIDEO = "v";
    public static final String C_TEXT = "t";
    public static final String C_ZIP = "z";
    public static final String C_OFFICE = "o";
    public static final String C_DROID = "d";
    public static final String C_BOOK = "b";
    public static final String C_IMAGE = "i";
    public static final String C_MARKUP = "m";
    public static final String C_APP = "x";
    public static final String C_PDF = "p";
    public static final String C_UNKNOWN = "u";
    private static final String[][] mimes = new String[][]{{".3gpp", "audio/3gpp", "a"}, {".7z", "application/x-7z-compressed", "z"}, {".aif", "audio/x-aiff", "a"}, {".apk", "application/vnd.android.package-archive", "d"}, {".arj", "application/x-arj", "z"}, {".au", "audio/basic", "a"}, {".avi", "video/x-msvideo", "v"}, {".b1", "application/x-b1", "x"}, {".bmp", "image/bmp", "i"}, {".bz", "application/x-bzip2", "z"}, {".bz2", "application/x-bzip2", "z"}, {".cab", "application/x-compressed", "z"}, {".chm", "application/vnd.ms-htmlhelp", "o"}, {".conf", "application/x-conf", "x"}, {".csv", "text/csv", "t"}, {".db", "application/x-sqlite3", "x"}, {".dex", "application/octet-stream", "d"}, {".djvu", "image/vnd.djvu", "i"}, {".doc", "application/msword", "o"}, {".docx", "application/msword", "o"}, {".epub", "application/epub+zip", "b"}, {".fb2", "application/fb2", "b"}, {".flac", "audio/flac", "a"}, {".flv", "video/x-flv", "v"}, {".gif", "image/gif", "i"}, {".gpx", "application/gpx+xml", "m"}, {".gtar", "application/x-gtar", "z"}, {".gz", "application/x-gzip", "z"}, {".htm", "text/html", "m"}, {".html", "text/html", "m"}, {".img", "application/x-compressed", "z"}, {".jar", "application/java-archive", "z"}, {".java", "text/java", "t"}, {".jpeg", "image/jpeg", "i"}, {".jpg", "image/jpeg", "i"}, {".js", "text/javascript", "t"}, {".kml", "application/vnd.google-earth.kml+xml", "m"}, {".kmz", "application/vnd.google-earth.kmz", "m"}, {".log", "text/plain", "t"}, {".lst", "text/plain", "t"}, {".lzh", "application/x-lzh", "z"}, {".m3u", "application/x-mpegurl", "a"}, {".md5", "application/x-md5", "x"}, {".mid", "audio/midi", "a"}, {".midi", "audio/midi", "a"}, {".mkv", "video/x-matroska", "v"}, {".mobi", "application/x-mobipocket", "b"}, {".mov", "video/quicktime", "v"}, {".mp2", "video/mpeg", "v"}, {".mp3", "audio/mp3", "a"}, {".mp4", "video/mp4", "v"}, {".mpeg", "video/mpeg", "v"}, {".mpg", "video/mpeg", "v"}, {".odex", "application/octet-stream", "d"}, {".ods", "application/vnd.oasis.opendocument.spreadsheet", "o"}, {".odt", "application/vnd.oasis.opendocument.text", "o"}, {".oga", "audio/ogg", "a"}, {".ogg", "audio/ogg", "a"}, {".ogv", "video/ogg", "v"}, {".opml", "text/xml", "m"}, {".pdf", "application/pdf", "p"}, {".php", "text/php", "m"}, {".pmd", "application/x-pmd", "o"}, {".png", "image/png", "i"}, {".ppt", "application/vnd.ms-powerpoint", "o"}, {".pptx", "application/vnd.ms-powerpoint", "o"}, {".prd", "application/x-prd", "o"}, {".ra", "audio/x-pn-realaudio", "a"}, {".ram", "audio/x-pn-realaudio", "a"}, {".rar", "application/x-rar-compressed", "z"}, {".rtf", "application/rtf", "o"}, {".sh", "application/x-sh", "x"}, {".so", "application/octet-stream", "x"}, {".sqlite", "application/x-sqlite3", "x"}, {".svg", "image/svg+xml", "i"}, {".swf", "application/x-shockwave-flash", "v"}, {".sxw", "application/vnd.sun.xml.writer", "o"}, {".tar", "application/x-tar", "z"}, {".tcl", "application/x-tcl", "x"}, {".tgz", "application/x-gzip", "z"}, {".tif", "image/tiff", "i"}, {".tiff", "image/tiff", "i"}, {".tmd", "application/x-tmd", "o"}, {".txt", "text/plain", "t"}, {".vcf", "text/x-vcard", "o"}, {".wav", "audio/wav", "a"}, {".wma", "audio/x-ms-wma", "a"}, {".wmv", "video/x-ms-wmv", "v"}, {".xls", "application/vnd.ms-excel", "o"}, {".xlsx", "application/vnd.ms-excel", "o"}, {".xml", "text/xml", "m"}, {".xsl", "text/xml", "m"}, {".zip", "application/zip", "z"}};
    static final char[] spaces = new char[]{'\u00a0', '\u00a0', '\u00a0', '\u00a0', '\u00a0', '\u00a0', '\u00a0', '\u00a0'};
    public static final int ENC_DESC_MODE_NUMB = 0;
    public static final int ENC_DESC_MODE_BRIEF = 1;
    public static final int ENC_DESC_MODE_FULL = 2;
    private static final String HEX = "0123456789abcdef";

    public static final String getMimeByExt(String ext) {
        if (Utils.str(ext)) {
            String mime;
            String[] descr = Utils.getTypeDescrByExt(ext);
            if (descr != null) {
                return descr[1];
            }
            MimeTypeMap mime_map = MimeTypeMap.getSingleton();
            if (mime_map != null && Utils.str(mime = mime_map.getMimeTypeFromExtension(ext.substring(1)))) {
                return mime;
            }
        }
        return "*/*";
    }

    public static final String getCategoryByExt(String ext) {
        if (!Utils.str(ext)) {
            return C_UNKNOWN;
        }
        String[] descr = Utils.getTypeDescrByExt(ext);
        if (descr != null) {
            return descr[2];
        }
        MimeTypeMap mime_map = MimeTypeMap.getSingleton();
        if (mime_map == null) {
            return C_UNKNOWN;
        }
        String mime = mime_map.getMimeTypeFromExtension(ext.substring(1));
        if (!Utils.str(mime)) {
            return C_UNKNOWN;
        }
        int sl_pos = mime.indexOf(47);
        if (sl_pos <= 0) {
            return C_UNKNOWN;
        }
        String type = mime.substring(0, sl_pos);
        if (type.compareTo("text") == 0) {
            return C_TEXT;
        }
        if (type.compareTo("image") == 0) {
            return C_IMAGE;
        }
        if (type.compareTo("audio") == 0) {
            return C_AUDIO;
        }
        if (type.compareTo("video") == 0) {
            return C_VIDEO;
        }
        if (type.compareTo("application") == 0) {
            return C_APP;
        }
        return C_UNKNOWN;
    }

    public static final String[] getExtsByCategory(String c) {
        if (c == null) {
            return null;
        }
        ArrayList<String> exts = new ArrayList<String>();
        for (int l = 0; l < mimes.length; ++l) {
            if (!c.equals(mimes[l][2])) continue;
            exts.add(mimes[l][0]);
        }
        String[] ret = new String[exts.size()];
        return exts.toArray(ret);
    }

    public static final String[] getTypeDescrByExt(String ext) {
        ext = ext.toLowerCase();
        int from = 0;
        int to = mimes.length;
        block0: for (int l = 0; l < mimes.length; ++l) {
            int idx = (to - from) / 2 + from;
            String tmp = mimes[idx][0];
            if (tmp.compareTo(ext) == 0) {
                return mimes[idx];
            }
            int cp = 1;
            while (true) {
                char ct;
                if (cp >= ext.length()) {
                    to = idx;
                    continue block0;
                }
                if (cp >= tmp.length()) {
                    from = idx;
                    continue block0;
                }
                char c0 = ext.charAt(cp);
                if (c0 < (ct = tmp.charAt(cp))) {
                    to = idx;
                    continue block0;
                }
                if (c0 > ct) {
                    from = idx;
                    continue block0;
                }
                ++cp;
            }
        }
        return null;
    }

    public static final String getFileExt(String file_name) {
        if (file_name == null) {
            return "";
        }
        int dot = file_name.lastIndexOf(".");
        return dot >= 0 ? file_name.substring(dot) : "";
    }

    public static final String[] prepareWildcard(String wc) {
        if (!Utils.str(wc)) {
            wc = "*";
        }
        return ("\u0002" + wc.toLowerCase() + "\u0003").split("\\*");
    }

    public static final boolean match(String text, String[] cards) {
        int pos = 0;
        String lc_text = "\u0002" + text.toLowerCase() + "\u0003";
        for (String card : cards) {
            int idx = lc_text.indexOf(card, pos);
            if (idx < 0) {
                return false;
            }
            pos = idx + card.length();
        }
        return true;
    }

    public static final int deleteDirContent(File d) {
        int cnt = 0;
        File[] fl = d.listFiles();
        if (fl != null) {
            for (File f : fl) {
                if (f.isDirectory()) {
                    cnt += Utils.deleteDirContent(f);
                }
                if (!f.delete()) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    public static final File[] getListOfFiles(String[] uris) {
        File[] list = new File[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            if (uris[i] == null) {
                return null;
            }
            list[i] = new File(uris[i]);
        }
        return list;
    }

    public static final String getSecondaryStorage() {
        try {
            Map<String, String> env = System.getenv();
            String sec_storage = env.get("SECONDARY_STORAGE");
            if (!Utils.str(sec_storage)) {
                return null;
            }
            String[] ss = sec_storage.split(":");
            for (int i = 0; i < ss.length; ++i) {
                if (ss[i].toLowerCase().indexOf("sd") <= 0) continue;
                return ss[i];
            }
            return "";
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getPath(PubPathType ppt) {
        String pps = null;
        switch (ppt) {
            case DOWNLOADS: {
                pps = Environment.DIRECTORY_DOWNLOADS;
                break;
            }
            case DCIM: {
                pps = Environment.DIRECTORY_DCIM;
                break;
            }
            case PICTURES: {
                pps = Environment.DIRECTORY_PICTURES;
                break;
            }
            case MUSIC: {
                pps = Environment.DIRECTORY_MUSIC;
                break;
            }
            case MOVIES: {
                pps = Environment.DIRECTORY_MOVIES;
            }
        }
        return Environment.getExternalStoragePublicDirectory((String)pps).getAbsolutePath();
    }

    public static void setFullPermissions(File file) {
        file.setWritable(true, false);
        file.setReadable(true, false);
    }

    public static final String getOpReport_(Context ctx, int total, int verb_id) {
        String items = null;
        if (total > 1) {
            if (total < 5) {
                items = ctx.getString(2131362036);
            }
            if (items == null || items.length() == 0) {
                items = ctx.getString(2131362035);
            }
            if (items == null || items.length() == 0) {
                items = ctx.getString(2131362034);
            }
        }
        String verb = ctx.getString(verb_id);
        String report = (total > 0 ? "" + total + " " + (total > 1 ? items : ctx.getString(2131362034)) : ctx.getString(2131362039)) + " " + (total > 1 ? ctx.getString(2131362037) : ctx.getString(2131362038)) + " " + verb + (total > 1 ? ctx.getString(2131362033) : "") + ".";
        return report;
    }

    public static final String getOpReport(Context ctx, int total, int verb_id) {
        String verb = " " + ctx.getString(verb_id);
        if (total == 0) {
            return ctx.getString(2131362040) + verb;
        }
        if (total == 1) {
            return ctx.getString(2131362041) + verb;
        }
        if (total > 1) {
            String rep24;
            verb = verb + ctx.getString(2131362033);
            if (total < 5 && Utils.str(rep24 = ctx.getString(2131362042, new Object[]{total})) && !"\u00a0".equals(rep24)) {
                return rep24 + verb;
            }
            return ctx.getString(2131362043, new Object[]{total}) + verb;
        }
        return null;
    }

    public static final String getHumanSize(long sz) {
        return Utils.getHumanSize(sz, true);
    }

    public static final String getHumanSize(long sz, boolean prepend_nbsp) {
        try {
            String s = sz > 0x40000000L ? (double)Math.round((double)(sz * 10L) / 1.073741824E9) / 10.0 + "G" : (sz > 0x100000L ? (double)Math.round((double)(sz * 10L) / 1048576.0) / 10.0 + "M" : (sz > 1024L ? (double)Math.round((double)(sz * 10L) / 1024.0) / 10.0 + "K" : "" + sz + " "));
            if (prepend_nbsp) {
                return new String(spaces, 0, 8 - s.length()) + s;
            }
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "" + sz + " ";
        }
    }

    public static final long parseHumanSize(String s) {
        if (s == null) {
            return 0L;
        }
        char[] sxs = new char[]{'K', 'M', 'G', 'T'};
        long m = 1024L;
        s = s.toUpperCase();
        try {
            int s_pos;
            for (int i = 0; i < 4; ++i) {
                s_pos = s.indexOf(sxs[i]);
                if (s_pos > 0) {
                    float v = Float.parseFloat(s.substring(0, s_pos));
                    return (long)(v * (float)m);
                }
                m *= 1024L;
            }
            s_pos = s.indexOf(66);
            return Long.parseLong(s_pos > 0 ? s.substring(0, s_pos) : s);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static final String encodeToAuthority(String serv) {
        String auth = null;
        int cp = serv.lastIndexOf(58);
        if (cp > 0) {
            String ps = serv.substring(cp + 1);
            try {
                int port = Integer.parseInt(ps);
                if (port > 0) {
                    auth = Uri.encode((String)serv.substring(0, cp)) + ":" + port;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (auth == null) {
            auth = Uri.encode((String)serv);
        }
        return auth;
    }

    public static Uri getUriWithAuth(Uri u, Credentials crd) {
        return crd != null ? Utils.getUriWithAuth(u, crd.getUserName(), crd.getPassword()) : u;
    }

    public static Uri getUriWithAuth(Uri u, String un, String pw) {
        if (un == null) {
            return u;
        }
        String ui = Utils.escapeName(un);
        if (pw != null) {
            ui = ui + ":" + Utils.escapeName(pw);
        }
        return Utils.updateUserInfo(u, ui);
    }

    public static final Uri updateUserInfo(Uri u, String encoded_ui) {
        if (u == null) {
            return null;
        }
        String ea = u.getEncodedAuthority();
        if (ea == null) {
            return u;
        }
        int at_pos = ea.lastIndexOf(64);
        if (encoded_ui == null) {
            if (at_pos < 0) {
                return u;
            }
            ea = ea.substring(at_pos + 1);
        } else {
            ea = encoded_ui + (at_pos < 0 ? "@" + ea : ea.substring(at_pos));
        }
        return u.buildUpon().encodedAuthority(ea).build();
    }

    public static final String mbAddSl(String path) {
        if (!Utils.str(path)) {
            return "/";
        }
        return path.charAt(path.length() - 1) == '/' ? path : path + "/";
    }

    public static final Uri addTrailngSlash(Uri u) {
        String alt_path;
        String path = u.getEncodedPath();
        if (path == null) {
            alt_path = "/";
        } else {
            alt_path = Utils.mbAddSl(path);
            if (alt_path == null || path.equals(alt_path)) {
                return u;
            }
        }
        return u.buildUpon().encodedPath(alt_path).build();
    }

    public static final boolean str(String s) {
        return s != null && s.length() > 0;
    }

    public static final boolean equals(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    public static final String join(String[] a, String sep) {
        if (a == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(256);
        boolean first = true;
        for (int i = 0; i < a.length; ++i) {
            if (first) {
                first = false;
            } else if (sep != null) {
                buf.append(sep);
            }
            buf.append(a[i]);
        }
        return buf.toString();
    }

    public static final void changeLanguage(Context c) {
        Utils.changeLanguage(c, c.getResources());
    }

    public static final void changeLanguage(Context c, Resources r) {
        try {
            Locale locale;
            SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)c);
            String lang = sharedPref.getString("language", "");
            if (lang == null || lang.length() == 0) {
                locale = Locale.getDefault();
            } else {
                String country = lang.length() > 3 ? lang.substring(3) : null;
                locale = country != null ? new Locale(lang.substring(0, 2), country) : new Locale(lang);
            }
            Locale.setDefault(locale);
            Configuration config = new Configuration();
            config.locale = locale;
            r.updateConfiguration(config, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"InlinedApi"})
    public static void setTheme(Context ctx, String code) {
        int t_id = 0;
        t_id = "l".equals(code) ? 2131427330 : 2131427331;
        ctx.setTheme(t_id);
    }

    public static void setDialogTheme(Context ctx, String code) {
        int t_id = 0;
        t_id = "l".equals(code) ? 2131427329 : 2131427328;
        ctx.setTheme(t_id);
    }

    public static final CharSequence readStreamToBuffer(InputStream is, String encoding) {
        if (is != null) {
            try {
                boolean available_supported;
                int bytes = is.available();
                if (bytes < 1024 || bytes > 0x100000) {
                    bytes = 10240;
                }
                char[] chars = new char[bytes];
                InputStreamReader isr = null;
                if (Utils.str(encoding)) {
                    try {
                        isr = new InputStreamReader(is, encoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        Log.w((String)"GC", (String)encoding, (Throwable)e);
                        isr = new InputStreamReader(is);
                    }
                } else {
                    isr = new InputStreamReader(is);
                }
                StringBuffer sb = new StringBuffer(bytes);
                int n = -1;
                boolean bl = available_supported = is.available() > 0;
                while ((n = isr.read(chars, 0, bytes)) >= 0) {
                    int i;
                    for (i = 0; i < n; ++i) {
                        if (chars[i] != '\r') continue;
                        chars[i] = 32;
                    }
                    sb.append(chars, 0, n);
                    if (!available_supported) continue;
                    for (i = 0; i < 10 && is.available() <= 0; ++i) {
                        Thread.sleep(20L);
                    }
                    if (is.available() != 0) continue;
                }
                return sb;
            }
            catch (Throwable e) {
                Log.e((String)"Utils.readStreamToBuffer()", (String)"Error on reading a stream", (Throwable)e);
            }
        }
        return null;
    }

    public static final boolean copyBytes(InputStream is, OutputStream os) {
        try {
            int n;
            byte[] buf = new byte[65536];
            while ((n = is.read(buf)) != -1) {
                os.write(buf, 0, n);
                Thread.sleep(1L);
            }
            return true;
        }
        catch (Exception e) {
            Log.e((String)"Utils.copyBytes", (String)("Exception: " + e));
            return false;
        }
    }

    public static final File getTempDir(Context ctx) {
        File parent_dir = ctx.getExternalFilesDir(null);
        if (parent_dir == null) {
            parent_dir = new File(Environment.getExternalStorageDirectory().getAbsolutePath());
        }
        File temp_dir = new File(parent_dir, "/temp/");
        temp_dir.mkdirs();
        return temp_dir;
    }

    public static final File createTempDir(Context ctx) {
        Date d = new Date();
        File parent_dir = null;
        parent_dir = ctx.getExternalFilesDir(null);
        if (parent_dir == null) {
            parent_dir = new File(Environment.getExternalStorageDirectory().getAbsolutePath());
        }
        File temp_dir = new File(parent_dir, "/temp/gc_" + d.getHours() + d.getMinutes() + d.getSeconds() + "/");
        temp_dir.mkdirs();
        return temp_dir;
    }

    public static final String getEncodingDescr(Context ctx, String enc_name, int mode) {
        Resources res;
        if (enc_name == null) {
            enc_name = "";
        }
        if ((res = ctx.getResources()) == null) {
            return null;
        }
        String[] enc_dsc_arr = res.getStringArray(2131296263);
        String[] enc_nms_arr = res.getStringArray(2131296264);
        try {
            for (int i = 0; i < enc_nms_arr.length; ++i) {
                if (!enc_name.equals(enc_nms_arr[i])) continue;
                if (mode == 0) {
                    return String.valueOf(i);
                }
                String enc_desc = enc_dsc_arr[i];
                if (mode == 2) {
                    return enc_desc;
                }
                int nlp = enc_desc.indexOf(10);
                if (nlp < 0) {
                    return enc_desc;
                }
                return enc_desc.substring(0, nlp);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static final String escapeRest(String s) {
        if (!Utils.str(s)) {
            return s;
        }
        return s.replaceAll("%", "%25").replaceAll("#", "%23").replaceAll("\\?", "%3F").replaceAll(":", "%3A");
    }

    public static final String escapePath(String s) {
        if (!Utils.str(s)) {
            return s;
        }
        return Utils.escapeRest(s).replaceAll("@", "%40");
    }

    public static final String escapeName(String s) {
        if (!Utils.str(s)) {
            return s;
        }
        return Utils.escapePath(s).replaceAll("/", "%2F");
    }

    public static final String unEscape(String s) {
        UrlQuerySanitizer urlqs = new UrlQuerySanitizer();
        return urlqs.unescape(s.replaceAll("\\+", "`2B`")).replaceAll("`2B`", "+");
    }

    public static final boolean isHTML(String s) {
        return s.indexOf("</", 3) > 0 || s.indexOf("/>", 3) > 0 || s.indexOf("&#x") >= 0;
    }

    public static byte[] hexStringToBytes(String hexString) {
        int len = hexString.length() / 2;
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            result[i] = Integer.valueOf(hexString.substring(2 * i, 2 * i + 2), 16).byteValue();
        }
        return result;
    }

    public static final String toHexString(byte[] buf, String delim) {
        if (buf == null) {
            return "";
        }
        StringBuffer result = new StringBuffer(2 * buf.length);
        for (int i = 0; i < buf.length; ++i) {
            if (i > 0 && Utils.str(delim)) {
                result.append(delim);
            }
            result.append(HEX.charAt(buf[i] >> 4 & 0xF)).append(HEX.charAt(buf[i] & 0xF));
        }
        return result.toString();
    }

    public static final String getHash(File f, String algorithm) {
        String[] hashes = Utils.getHash(f, new String[]{algorithm});
        return hashes != null ? hashes[0] : null;
    }

    public static final String[] getHash(File f, String[] algorithms) {
        try {
            int byteCount;
            FileInputStream in = new FileInputStream(f);
            MessageDigest[] digesters = new MessageDigest[algorithms.length];
            for (int i = 0; i < algorithms.length; ++i) {
                digesters[i] = MessageDigest.getInstance(algorithms[i]);
            }
            byte[] bytes = new byte[8192];
            while ((byteCount = in.read(bytes)) > 0) {
                for (int i = 0; i < digesters.length; ++i) {
                    digesters[i].update(bytes, 0, byteCount);
                }
            }
            in.close();
            String[] hashes = new String[digesters.length];
            for (int i = 0; i < digesters.length; ++i) {
                byte[] digest = digesters[i].digest();
                hashes[i] = Utils.toHexString(digest, null);
            }
            return hashes;
        }
        catch (Exception e) {
            Log.e((String)"getHash", (String)"", (Throwable)e);
            return null;
        }
    }

    public static final float getBrightness(int color2) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color2, (float[])hsv);
        return hsv[2];
    }

    public static final int setBrightness(int color2, float br) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color2, (float[])hsv);
        hsv[2] = br;
        return Color.HSVToColor((float[])hsv);
    }

    public static final int shiftBrightness(int color2, float drop) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color2, (float[])hsv);
        hsv[2] = hsv[2] * drop;
        return Color.HSVToColor((float[])hsv);
    }

    public static final GradientDrawable getShadingEx(int color2, float drop) {
        try {
            int[] cc = new int[]{color2, Utils.shiftBrightness(color2, drop)};
            return new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, cc);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final int getCount(SparseBooleanArray cis) {
        int counter = 0;
        for (int i = 0; i < cis.size(); ++i) {
            if (!cis.valueAt(i)) continue;
            ++counter;
        }
        return counter;
    }

    public static final int getPosition(SparseBooleanArray cis, int of_item) {
        int counter = 0;
        for (int i = 0; i < cis.size(); ++i) {
            if (!cis.valueAt(i) || counter++ != of_item) continue;
            return cis.keyAt(i);
        }
        return -1;
    }

    public static final String getCause(Throwable e) {
        Throwable c = e.getCause();
        if (c != null) {
            String s = c.getLocalizedMessage();
            String cs = Utils.getCause(c);
            if (cs != null) {
                return s + "\n" + cs;
            }
            return s;
        }
        return null;
    }

    public static final String formatDate(Date date, Context ctx) {
        boolean no_time;
        boolean bl = no_time = date.getHours() == 0 && date.getMinutes() == 0 && date.getSeconds() == 0;
        if (Locale.getDefault().getLanguage().compareTo("en") != 0) {
            java.text.DateFormat locale_date_format = DateFormat.getDateFormat((Context)ctx);
            String ret = locale_date_format.format(date);
            if (!no_time) {
                java.text.DateFormat locale_time_format = DateFormat.getTimeFormat((Context)ctx);
                ret = ret + " " + locale_time_format.format(date);
            }
            return ret;
        }
        String fmt = "MMM dd yyyy";
        if (!no_time) {
            fmt = fmt + " hh:mm:ss";
        }
        return (String)DateFormat.format((CharSequence)fmt, (Date)date);
    }

    public static final boolean needActionBar(Activity a) {
        boolean ab = false;
        try {
            if (Build.VERSION.SDK_INT < 11) {
                return false;
            }
            int size_class = a.getResources().getConfiguration().screenLayout & 0xF;
            SharedPreferences shared_pref = PreferenceManager.getDefaultSharedPreferences((Context)a);
            String show_actionbar = shared_pref.getString("show_actionbar", C_AUDIO);
            if (C_AUDIO.equals(show_actionbar)) {
                if (size_class >= 3 || Build.VERSION.SDK_INT >= 14 && !ForwardCompat.hasPermanentMenuKey((Context)a)) {
                    ab = true;
                }
            } else {
                ab = "y".equals(show_actionbar);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ab;
    }

    public static final boolean setActionBar(Activity a) {
        boolean ab = false;
        try {
            ab = Utils.needActionBar(a);
            if (ab) {
                ab = a.getWindow().requestFeature(8);
                ForwardCompat.setupActionBar(a);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ab;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RR {
        busy(2131362054),
        copy_err(2131361975),
        copied(2131362024),
        moved(2131362025),
        interrupted(2131361992),
        uploading(2131362006),
        fail_del(2131362001),
        cant_del(2131362022),
        retrieving(2131362005),
        deleting(2131361999),
        not_supported(2131362057),
        file_exist(2131362015),
        cant_md(2131362013),
        rename_err(2131361976),
        sz_folder(2131362044),
        sz_dirnum(2131362045),
        sz_dirsfx_p(2131362047),
        sz_dirsfx_s(2131362046),
        sz_file(2131362048),
        sz_files(2131362049),
        sz_Nbytes(2131362050),
        sz_bytes(2131362051),
        sz_lastmod(2131362052),
        sz_total(2131362053),
        too_deep_hierarchy(2131361994),
        failed(2131361918),
        ftp_connected(2131362080),
        rtexcept(2131362019);

        private int r;

        private RR(int r_) {
            this.r = r_;
        }

        public int r() {
            return this.r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PubPathType {
        DOWNLOADS,
        DCIM,
        PICTURES,
        MUSIC,
        MOVIES;

    }
}

