/*
 * Copyright (c) 2006-2011 Christian Plattner. All rights reserved.
 * Please refer to the LICENSE.txt for licensing details.
 */
package ch.ethz.ssh2.crypto.digest;

import java.security.DigestException;

/**
 * Digest.
 *
 * @author Christian Plattner
 * @version 2.50, 03/15/10
 */
public interface Digest {
    public int getDigestLength();

    public void update(byte b);

    public void update(byte[] b);

    public void update(byte b[], int off, int len);

    public void reset();

    public void digest(byte[] out) throws DigestException;

    public void digest(byte[] out, int off) throws DigestException;
}
