package com.ghstudios.android.features.armor.list;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.*;

import com.ghstudios.android.data.classes.Rank;
import com.ghstudios.android.mhgendatabase.R;
import com.ghstudios.android.features.armor.list.ArmorExpandableListFragment;

public class ArmorFilterDialogFragment extends DialogFragment {

    public static final String EXTRA_RANK = "com.daviancorp.android.ui.detail.Rank";
    public static final String EXTRA_SLOTS = "com.daviancorp.android.ui.detail.Slots";
    public static final String EXTRA_SLOTS_SPEC = "com.daviancorp.android.ui.detail.SlotsSpec";

    private void sendResult(int resultCode, Rank rank, int slots, FilterSpecification slotsSpec) {
        if (getTargetFragment() == null)
            return;

        Intent i = new Intent();
        i.putExtra(EXTRA_RANK, rank);
        i.putExtra(EXTRA_SLOTS, slots);
        i.putExtra(EXTRA_SLOTS_SPEC, slotsSpec);

        getTargetFragment().onActivityResult(getTargetRequestCode(), resultCode, i);
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        LayoutInflater inflater = getActivity().getLayoutInflater();
        View addView = inflater.inflate(R.layout.dialog_armor_filter, null);

        ////// INITIALIZING RANK ///////

        Rank rank = (Rank) getArguments().getSerializable(ArmorExpandableListFragment.KEY_FILTER_RANK);

        final Spinner rankSpinner = (Spinner) addView.findViewById(R.id.filter_spinner_rank);
        rankSpinner.setAdapter(ArrayAdapter.createFromResource(getActivity().getApplicationContext(), R.array.rank, R.layout.view_spinner_item));
        ((ArrayAdapter) rankSpinner.getAdapter()).setDropDownViewResource(R.layout.view_spinner_dropdown_item);

        final CheckBox rankCheckBox = (CheckBox) addView.findViewById(R.id.filter_checkbox_rank);

        rankCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {
                    rankSpinner.setEnabled(true);
                    rankSpinner.getBackground().setColorFilter(null);
                } else {
                    rankSpinner.setEnabled(false);
                    rankSpinner.getBackground().setColorFilter(Color.GRAY, PorterDuff.Mode.MULTIPLY);
                }
            }
        });

        if (rank == null) {
            rankSpinner.setEnabled(false);
            rankCheckBox.setChecked(false);
        }
        else {
            rankSpinner.setEnabled(true);
            rankSpinner.setSelection(rank.ordinal());
            rankCheckBox.setChecked(true);
        }

        ////// INITIALIZING SLOTS //////

        int slots = getArguments().getInt(ArmorExpandableListFragment.KEY_FILTER_SLOTS, -1);
        FilterSpecification slotsSpecification = (FilterSpecification) getArguments().getSerializable(ArmorExpandableListFragment.KEY_FILTER_SLOTS_SPECIFICATION);

        final Spinner slotsSpinner = (Spinner) addView.findViewById(R.id.filter_spinner_slots);
        slotsSpinner.setAdapter(ArrayAdapter.createFromResource(getActivity().getApplicationContext(), R.array.slot_values, R.layout.view_spinner_item));
        ((ArrayAdapter) slotsSpinner.getAdapter()).setDropDownViewResource(R.layout.view_spinner_dropdown_item);

        final Spinner slotsSpecSpinner = (Spinner) addView.findViewById(R.id.filter_spinner_slots_spec);
        slotsSpecSpinner.setAdapter(ArrayAdapter.createFromResource(getActivity().getApplicationContext(), R.array.filter_restriction, R.layout.view_spinner_item));
        ((ArrayAdapter) slotsSpecSpinner.getAdapter()).setDropDownViewResource(R.layout.view_spinner_dropdown_item);

        final CheckBox slotsCheckBox = (CheckBox) addView.findViewById(R.id.filter_checkbox_slots);

        slotsCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {
                    slotsSpinner.setEnabled(true);
                    slotsSpecSpinner.setEnabled(true);
                } else {
                    slotsSpinner.setEnabled(false);
                    slotsSpecSpinner.setEnabled(false);
                }
            }
        });

        if (slots == -1) {
            slotsSpinner.setEnabled(false);
            slotsCheckBox.setChecked(false);
            slotsSpecSpinner.setEnabled(false);
        }
        else {
            slotsSpinner.setEnabled(true);
            slotsSpinner.setSelection(slots);
            slotsCheckBox.setChecked(true);
        }

        if (slotsSpecification != null) {
            slotsSpecSpinner.setSelection(slotsSpecification.ordinal());
        }

        ////// CREATING THE DIALOG //////

        return new AlertDialog.Builder(getActivity())
                .setTitle(R.string.dialog_armor_filter_title)
                .setView(addView)
                .setNegativeButton(android.R.string.cancel, null)
                .setPositiveButton(android.R.string.ok, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int id) {
                        Rank sendRank = rankCheckBox.isChecked() ? (Rank) Rank.values()[rankSpinner.getSelectedItemPosition()] : null;
                        int sendSlots = slotsCheckBox.isChecked() ? slotsSpinner.getSelectedItemPosition() : -1;
                        FilterSpecification sendSlotsSpec = slotsCheckBox.isChecked() ? FilterSpecification.values()[slotsSpecSpinner.getSelectedItemPosition()] : null;

                        sendResult(Activity.RESULT_OK, sendRank, sendSlots, sendSlotsSpec);
                    }
                })
                .create();
    }

    /**
     * Methods that are capable of filtering integer values.
     */
    public static enum FilterSpecification {
        MINIMUM {
            @Override
            public boolean qualifies(int value, int test) {
                return value >= test;
            }
        },

        EXACTLY {
            @Override
            public boolean qualifies(int value, int test) {
                return value == test;
            }
        },

        MAXIMUM {
            @Override
            public boolean qualifies(int value, int test) {
                return value <= test;
            }
        };

        /**
         * Evaluates whether or not the value meets the filter's specification.
         * @param value The input value, typically an armor's stat.
         * @param test The value against which to test the input, typically a fixed value.
         * @return True if the input value passes the {@code FilterSpecification}'s test, otherwise false.
         */
        public abstract boolean qualifies(int value, int test);
    }
}
