/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.speech.tts;

import android.support.v4.speech.tts.RequestConfig;
import android.support.v4.speech.tts.TextToSpeechClient;
import android.support.v4.speech.tts.VoiceInfo;
import java.util.Locale;

public final class RequestConfigHelper {
    private RequestConfigHelper() {
    }

    private static VoiceInfo getHighestQualityVoice(TextToSpeechClient.EngineStatus engineStatus, VoiceScorer voiceScorer, boolean hasToBeEmbedded) {
        VoiceInfo bestVoice = null;
        int bestScoreMatch = 1;
        int bestVoiceQuality = 0;
        for (VoiceInfo voice : engineStatus.getVoices()) {
            int score = voiceScorer.scoreVoice(voice);
            if (score <= 0 || hasToBeEmbedded && voice.getRequiresNetworkConnection() || voice.getQuality() < bestVoiceQuality || bestVoice != null && voice.getQuality() <= bestVoiceQuality && score <= bestScoreMatch) continue;
            bestVoice = voice;
            bestScoreMatch = score;
            bestVoiceQuality = voice.getQuality();
        }
        return bestVoice;
    }

    public static RequestConfig highestQuality(TextToSpeechClient.EngineStatus engineStatus, boolean hasToBeEmbedded, VoiceScorer voiceScorer) {
        VoiceInfo voice = RequestConfigHelper.getHighestQualityVoice(engineStatus, voiceScorer, hasToBeEmbedded);
        if (voice == null) {
            return null;
        }
        return RequestConfig.Builder.newBuilder().setVoice(voice).build();
    }

    public static RequestConfig highestQuality(TextToSpeechClient.EngineStatus engineStatus, boolean hasToBeEmbedded) {
        return RequestConfigHelper.highestQuality(engineStatus, hasToBeEmbedded, new LanguageMatcher(Locale.getDefault()));
    }

    public static final class LanguageMatcher
    implements VoiceScorer {
        private final Locale mLocale;

        public LanguageMatcher(Locale locale) {
            this.mLocale = locale == null ? Locale.getDefault() : locale;
        }

        @Override
        public int scoreVoice(VoiceInfo voiceInfo) {
            Locale voiceLocale = voiceInfo.getLocale();
            if (this.mLocale.equals(voiceLocale)) {
                return 3;
            }
            if (this.mLocale.getLanguage().equals(voiceLocale.getLanguage())) {
                if (this.mLocale.getCountry().equals(voiceLocale.getCountry())) {
                    return 2;
                }
                return 1;
            }
            return 0;
        }
    }

    public static final class ExactLocaleMatcher
    implements VoiceScorer {
        private final Locale mLocale;

        public ExactLocaleMatcher(Locale locale) {
            this.mLocale = locale == null ? Locale.getDefault() : locale;
        }

        @Override
        public int scoreVoice(VoiceInfo voiceInfo) {
            return this.mLocale.equals(voiceInfo.getLocale()) ? 1 : 0;
        }
    }

    public static interface VoiceScorer {
        public int scoreVoice(VoiceInfo var1);
    }
}

