/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.speech.tts;

import android.content.Context;
import android.net.Uri;
import android.support.v4.speech.tts.ITextToSpeechClient;
import android.support.v4.speech.tts.RequestConfig;
import android.support.v4.speech.tts.VoiceInfo;
import android.util.Log;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class TextToSpeechClient {
    private static final String TAG = "TextToSpeechClient";
    private final ITextToSpeechClient mImplementation;

    TextToSpeechClient(ITextToSpeechClient implementation, Context context, String engine, boolean fallbackToDefaultEngine, RequestCallbacks defaultRequestCallbacks, ConnectionCallbacks connectionCallbacks) {
        this.mImplementation = implementation;
        this.mImplementation.setup(context, engine, fallbackToDefaultEngine, defaultRequestCallbacks, connectionCallbacks);
    }

    public void connect() {
        this.mImplementation.connect();
    }

    public boolean isConnected() {
        return this.mImplementation.isConnected();
    }

    public void disconnect() {
        this.mImplementation.disconnect();
    }

    public EngineStatus getEngineStatus() {
        return this.mImplementation.getEngineStatus();
    }

    public void stop() {
        if (this.mImplementation.isConnected()) {
            this.mImplementation.stop();
        } else {
            Log.e((String)TAG, (String)"TTS Client is not connected");
        }
    }

    public void queueSpeak(String utterance, UtteranceId utteranceId, RequestConfig config, RequestCallbacks callbacks) {
        if (utterance == null) {
            throw new IllegalArgumentException("utterance can't be null");
        }
        if (utteranceId == null) {
            throw new IllegalArgumentException("utteranceId can't be null");
        }
        if (config == null) {
            throw new IllegalArgumentException("config can't be null");
        }
        if (this.mImplementation.isConnected()) {
            this.mImplementation.queueSpeak(utterance, utteranceId, config, callbacks);
        } else {
            Log.e((String)TAG, (String)"TTS Client is not connected");
        }
    }

    public void queueSynthesizeToFile(String utterance, UtteranceId utteranceId, File outputFile, RequestConfig config, RequestCallbacks callbacks) {
        if (utterance == null) {
            throw new IllegalArgumentException("utterance can't be null");
        }
        if (utteranceId == null) {
            throw new IllegalArgumentException("utteranceId can't be null");
        }
        if (outputFile == null) {
            throw new IllegalArgumentException("outputFile can't be null");
        }
        if (config == null) {
            throw new IllegalArgumentException("config can't be null");
        }
        if (this.mImplementation.isConnected()) {
            this.mImplementation.queueSynthesizeToFile(utterance, utteranceId, outputFile, config, callbacks);
        } else {
            Log.e((String)TAG, (String)"TTS Client is not connected");
        }
    }

    public void queueSilence(long durationInMs, UtteranceId utteranceId, RequestCallbacks callbacks) {
        if (utteranceId == null) {
            throw new IllegalArgumentException("utteranceId can't be null");
        }
        if (this.mImplementation.isConnected()) {
            this.mImplementation.queueSilence(durationInMs, utteranceId, callbacks);
        } else {
            Log.e((String)TAG, (String)"TTS Client is not connected");
        }
    }

    public void queueAudio(Uri audioUrl, UtteranceId utteranceId, RequestConfig config, RequestCallbacks callbacks) {
        if (audioUrl == null) {
            throw new IllegalArgumentException("audioUrl can't be null");
        }
        if (utteranceId == null) {
            throw new IllegalArgumentException("utteranceId can't be null");
        }
        if (config == null) {
            throw new IllegalArgumentException("config can't be null");
        }
        if (this.mImplementation.isConnected()) {
            this.mImplementation.queueAudio(audioUrl, utteranceId, config, callbacks);
        } else {
            Log.e((String)TAG, (String)"TTS Client is not connected");
        }
    }

    public static class UtteranceId {
        private final int id = ID_GENERATOR.getAndIncrement();
        private static final AtomicInteger ID_GENERATOR = new AtomicInteger();

        public final String toUniqueString() {
            return "UID" + this.id;
        }
    }

    public static final class EngineStatus {
        private final List<VoiceInfo> mVoices;
        private final String mPackageName;

        EngineStatus(String packageName, List<VoiceInfo> voices) {
            this.mVoices = Collections.unmodifiableList(voices);
            this.mPackageName = packageName;
        }

        public List<VoiceInfo> getVoices() {
            return this.mVoices;
        }

        public String getEnginePackage() {
            return this.mPackageName;
        }
    }

    public static interface ConnectionCallbacks {
        public void onConnectionSuccess();

        public void onConnectionFailure();

        public void onServiceDisconnected();

        public void onEngineStatusChange(EngineStatus var1);
    }

    public static abstract class RequestCallbacks {
        public void onSynthesisStart(UtteranceId utteranceId) {
        }

        public void onSynthesisSuccess(UtteranceId utteranceId) {
        }

        public void onSynthesisStop(UtteranceId utteranceId) {
        }

        public void onSynthesisFallback(UtteranceId utteranceId) {
        }

        public void onSynthesisFailure(UtteranceId utteranceId, int errorCode) {
        }

        public void onSynthesisProgress(UtteranceId utteranceId, int charIndex, int msFromStart) {
        }
    }

    public static final class Status {
        public static final int SUCCESS = 0;
        public static final int STOPPED = 100;
        public static final int ERROR_UNKNOWN = -1;
        public static final int ERROR_SYNTHESIS = 10;
        public static final int ERROR_SERVICE = 11;
        public static final int ERROR_OUTPUT = 12;
        public static final int ERROR_NETWORK = 13;
        public static final int ERROR_NETWORK_TIMEOUT = 14;
        public static final int ERROR_INVALID_REQUEST = 15;
        public static final int ERROR_NON_UNIQUE_UTTERANCE_ID = 16;
        public static final int ERROR_DOWNLOADING_ADDITIONAL_DATA = 17;

        private Status() {
        }
    }

    public static final class Params {
        public static final String NETWORK_TIMEOUT_MS = "networkTimeoutMs";
        public static final String NETWORK_RETRIES_COUNT = "networkRetriesCount";
        public static final String TRACK_SUBUTTERANCE_PROGRESS = "trackSubutteranceProgress";
        public static final String FALLBACK_VOICE_NAME = "fallbackVoiceName";
        public static final String SPEECH_SPEED = "speechSpeed";
        public static final String SPEECH_PITCH = "speechPitch";
        public static final String AUDIO_PARAM_VOLUME = "volume";
        public static final String AUDIO_PARAM_PAN = "pan";
        public static final String AUDIO_PARAM_STREAM = "streamType";

        private Params() {
        }
    }
}

