/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.speech.tts;

import android.os.Bundle;
import java.util.Locale;

public class VoiceInfo {
    public static final int QUALITY_VERY_LOW = 100;
    public static final int QUALITY_LOW = 200;
    public static final int QUALITY_NORMAL = 300;
    public static final int QUALITY_HIGH = 400;
    public static final int QUALITY_VERY_HIGH = 500;
    public static final int LATENCY_VERY_LOW = 100;
    public static final int LATENCY_LOW = 200;
    public static final int LATENCY_NORMAL = 300;
    public static final int LATENCY_HIGH = 400;
    public static final int LATENCY_VERY_HIGH = 500;
    public static final String FEATURE_SPEAKER_GENDER = "speakerGender";
    public static final String FEATURE_WORDS_PER_MINUTE = "wordsPerMinute";
    public static final String FEATURE_MAY_AUTOINSTALL = "mayAutoInstall";
    private final String mName;
    private final Locale mLocale;
    private final int mQuality;
    private final int mLatency;
    private final boolean mRequiresNetworkConnection;
    private final Bundle mParams;
    private final Bundle mAdditionalFeatures;
    private final Object mPrivateData;

    VoiceInfo(String name, Locale locale, int quality, int latency, boolean requiresNetworkConnection, Bundle params, Bundle additionalFeatures, Object privateData) {
        this.mName = name;
        this.mLocale = locale;
        this.mQuality = quality;
        this.mLatency = latency;
        this.mRequiresNetworkConnection = requiresNetworkConnection;
        this.mParams = params;
        this.mAdditionalFeatures = additionalFeatures;
        this.mPrivateData = privateData;
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    public int getQuality() {
        return this.mQuality;
    }

    public int getLatency() {
        return this.mLatency;
    }

    public boolean getRequiresNetworkConnection() {
        return this.mRequiresNetworkConnection;
    }

    public Bundle getParamsWithDefaults() {
        return this.mParams;
    }

    public String getName() {
        return this.mName;
    }

    public Bundle getAdditionalFeatures() {
        return this.mAdditionalFeatures;
    }

    Object getPrivateData() {
        return this.mPrivateData;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(64);
        return builder.append("VoiceInfo[Name: ").append(this.mName).append(", locale: ").append(this.mLocale).append(", quality: ").append(this.mQuality).append(", latency: ").append(this.mLatency).append(", requiresNetwork: ").append(this.mRequiresNetworkConnection).append(", paramsWithDefaults: ").append(this.mParams.toString()).append(", additionalFeatures: ").append(this.mAdditionalFeatures.toString()).append("]").toString();
    }

    static final class Builder {
        private String name;
        private Locale locale;
        private int quality = 300;
        private int latency = 300;
        private boolean requiresNetworkConnection;
        private Bundle params;
        private Bundle additionalFeatures;
        private Object privateData;

        public Builder() {
        }

        public Builder(VoiceInfo voiceInfo) {
            this.name = voiceInfo.mName;
            this.locale = voiceInfo.mLocale;
            this.quality = voiceInfo.mQuality;
            this.latency = voiceInfo.mLatency;
            this.requiresNetworkConnection = voiceInfo.mRequiresNetworkConnection;
            this.params = (Bundle)voiceInfo.mParams.clone();
            this.additionalFeatures = (Bundle)voiceInfo.mAdditionalFeatures.clone();
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder setParamsWithDefaults(Bundle params) {
            this.params = params;
            return this;
        }

        public Builder setAdditionalFeatures(Bundle additionalFeatures) {
            this.additionalFeatures = additionalFeatures;
            return this;
        }

        public Builder setQuality(int quality) {
            this.quality = quality;
            return this;
        }

        public Builder setLatency(int latency) {
            this.latency = latency;
            return this;
        }

        public Builder setRequiresNetworkConnection(boolean requiresNetworkConnection) {
            this.requiresNetworkConnection = requiresNetworkConnection;
            return this;
        }

        public void setPrivateData(Object privateData) {
            this.privateData = privateData;
        }

        public VoiceInfo build() {
            if (this.name == null || this.name.length() == 0) {
                throw new IllegalStateException("Name can't be null or empty");
            }
            if (this.locale == null) {
                throw new IllegalStateException("Locale can't be null");
            }
            return new VoiceInfo(this.name, this.locale, this.quality, this.latency, this.requiresNetworkConnection, this.params == null ? new Bundle() : (Bundle)this.params.clone(), this.additionalFeatures == null ? new Bundle() : (Bundle)this.additionalFeatures.clone(), this.privateData);
        }
    }
}

