/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.graphics;

import android.graphics.Bitmap;
import android.os.Build;
import android.support.v4.graphics.BitmapCompatJellybeanMR2;

public class BitmapCompat {
    static final BitmapImpl IMPL;

    public static boolean hasMipMap(Bitmap bitmap) {
        return IMPL.hasMipMap(bitmap);
    }

    public static void setHasMipMap(Bitmap bitmap, boolean hasMipMap) {
        IMPL.setHasMipMap(bitmap, hasMipMap);
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 18 ? new JbMr2BitmapCompatImpl() : new BaseBitmapImpl();
    }

    static class JbMr2BitmapCompatImpl
    extends BaseBitmapImpl {
        JbMr2BitmapCompatImpl() {
        }

        @Override
        public boolean hasMipMap(Bitmap bitmap) {
            return BitmapCompatJellybeanMR2.hasMipMap((Bitmap)bitmap);
        }

        @Override
        public void setHasMipMap(Bitmap bitmap, boolean hasMipMap) {
            BitmapCompatJellybeanMR2.setHasMipMap((Bitmap)bitmap, (boolean)hasMipMap);
        }
    }

    static class BaseBitmapImpl
    implements BitmapImpl {
        BaseBitmapImpl() {
        }

        @Override
        public boolean hasMipMap(Bitmap bitmap) {
            return false;
        }

        @Override
        public void setHasMipMap(Bitmap bitmap, boolean hasMipMap) {
        }
    }

    static interface BitmapImpl {
        public boolean hasMipMap(Bitmap var1);

        public void setHasMipMap(Bitmap var1, boolean var2);
    }
}

