/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.speech.tts;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.provider.Settings;
import android.speech.tts.TextToSpeech;
import android.support.v4.speech.tts.ITextToSpeechClient;
import android.support.v4.speech.tts.RequestConfig;
import android.support.v4.speech.tts.TextToSpeechClient;
import android.support.v4.speech.tts.TextToSpeechICS;
import android.support.v4.speech.tts.TextToSpeechICSMR1;
import android.support.v4.speech.tts.VoiceInfo;
import android.util.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;

class TTSImplementationV1
implements ITextToSpeechClient {
    private static final String TAG = "android.support.v4.speech.tts";
    private TextToSpeech mOldClient;
    private Context mContext;
    private String mEngine;
    private TextToSpeechClient.RequestCallbacks mDefaultRequestCallbacks;
    private TextToSpeechClient.ConnectionCallbacks mConnectionCallbacks;
    private TextToSpeechClient.EngineStatus mEngineStatus;
    private Object mLock = new Object();
    private volatile boolean mConnected = false;
    TextToSpeech.OnInitListener mOnInitListener = new TextToSpeech.OnInitListener(){

        public void onInit(int status) {
            TTSImplementationV1.this.mConnected = true;
            if (status == 0) {
                TTSImplementationV1.this.onInit();
                TTSImplementationV1.this.mConnectionCallbacks.onConnectionSuccess();
            } else {
                TTSImplementationV1.this.mConnectionCallbacks.onConnectionFailure();
            }
        }
    };
    private HashMap<String, RequestInternal> mUtteranceIdToRequest = new HashMap();

    public TTSImplementationV1() {
    }

    TTSImplementationV1(TextToSpeech client) {
        this.mOldClient = client;
    }

    public void setup(Context context, String engine, boolean fallbackToDefaultEngine, TextToSpeechClient.RequestCallbacks defaultRequestCallbacks, TextToSpeechClient.ConnectionCallbacks connectionCallbacks) {
        this.mContext = context;
        this.mEngine = engine;
        this.mDefaultRequestCallbacks = defaultRequestCallbacks;
        this.mConnectionCallbacks = connectionCallbacks;
    }

    public TextToSpeechClient.EngineStatus getEngineStatus() {
        return this.mEngineStatus;
    }

    private void onInit() {
        this.mEngineStatus = this.generateEngineStatus();
        TextToSpeechICSMR1.setUtteranceProgressListener((TextToSpeech)this.mOldClient, (TextToSpeechICSMR1.UtteranceProgressListenerICSMR1)new TextToSpeechICSMR1.UtteranceProgressListenerICSMR1(){

            public void onStart(String utteranceId) {
                RequestInternal requestInternal = TTSImplementationV1.this.getCallback(utteranceId);
                if (requestInternal == null) {
                    return;
                }
                requestInternal.requestCallbacks.onSynthesisStart(requestInternal.utteranceId);
            }

            public void onError(String utteranceId) {
                RequestInternal requestInternal = TTSImplementationV1.this.removeCallback(utteranceId);
                if (requestInternal == null) {
                    return;
                }
                requestInternal.requestCallbacks.onSynthesisFailure(requestInternal.utteranceId, -1);
            }

            public void onDone(String utteranceId) {
                RequestInternal requestInternal = TTSImplementationV1.this.removeCallback(utteranceId);
                if (requestInternal == null) {
                    return;
                }
                requestInternal.requestCallbacks.onSynthesisSuccess(requestInternal.utteranceId);
            }
        });
    }

    public void connect() {
        if (this.mOldClient != null) {
            Log.w((String)TAG, (String)"Already connected");
            return;
        }
        this.mOldClient = TextToSpeechICS.construct((Context)this.mContext, (TextToSpeech.OnInitListener)this.mOnInitListener, (String)this.mEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addCallback(TextToSpeechClient.UtteranceId utteranceId, TextToSpeechClient.RequestCallbacks callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (utteranceId == null || callback == null) {
                return 15;
            }
            if (this.mUtteranceIdToRequest.put(utteranceId.toUniqueString(), new RequestInternal(utteranceId, callback)) != null) {
                return 16;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestInternal removeCallback(String utteranceIdStr) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUtteranceIdToRequest.remove(utteranceIdStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestInternal getCallback(String utteranceIdStr) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUtteranceIdToRequest.get(utteranceIdStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCallbackAndErr(String utteranceIdStr, int errorCode) {
        Object object = this.mLock;
        synchronized (object) {
            RequestInternal c = this.mUtteranceIdToRequest.remove(utteranceIdStr);
            c.requestCallbacks.onSynthesisFailure(c.utteranceId, errorCode);
        }
    }

    private TextToSpeechClient.EngineStatus generateEngineStatus() {
        Bundle defaultParams = new Bundle();
        defaultParams.putFloat("speechPitch", 1.0f);
        defaultParams.putFloat("speechSpeed", 0.0f);
        ArrayList<VoiceInfo> voicesInfo = new ArrayList<VoiceInfo>();
        for (Locale locale : Locale.getAvailableLocales()) {
            int expectedStatus = 2;
            if (locale.getVariant().length() == 0) {
                expectedStatus = locale.getCountry().length() == 0 ? 0 : 1;
            }
            try {
                locale.getISO3Language();
                if (locale.getCountry() != null && locale.getCountry().length() > 0) {
                    locale.getISO3Country();
                }
                if (this.mOldClient.isLanguageAvailable(locale) != expectedStatus) {
                }
            }
            catch (MissingResourceException e) {}
            continue;
            Set features = TextToSpeechICSMR1.getFeatures((TextToSpeech)this.mOldClient, (Locale)locale);
            VoiceInfo.Builder builder = new VoiceInfo.Builder();
            builder.setLatency(300);
            builder.setQuality(300);
            builder.setLocale(locale);
            builder.setParamsWithDefaults(defaultParams);
            boolean isUnknown = true;
            if (features != null && features.contains("embeddedTts")) {
                isUnknown = false;
                builder.setName(locale.toString() + "-embedded");
                builder.setRequiresNetworkConnection(false);
                builder.setPrivateData((Object)new VoiceInfoPrivate(1));
                voicesInfo.add(builder.build());
            }
            if (features != null && features.contains("networkTts")) {
                isUnknown = false;
                builder.setName(locale.toString() + "-network");
                builder.setRequiresNetworkConnection(true);
                builder.setPrivateData((Object)new VoiceInfoPrivate(2));
                voicesInfo.add(builder.build());
            }
            if (!isUnknown) continue;
            builder.setName(locale.toString());
            builder.setRequiresNetworkConnection(false);
            builder.setPrivateData((Object)new VoiceInfoPrivate(3));
            voicesInfo.add(builder.build());
        }
        return new TextToSpeechClient.EngineStatus(this.mEngine, voicesInfo);
    }

    public boolean isConnected() {
        return this.mOldClient != null && this.mConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (this.mOldClient == null) {
            Log.w((String)TAG, (String)"Already disconnected");
            return;
        }
        TextToSpeech textToSpeech = this.mOldClient;
        synchronized (textToSpeech) {
            this.mOldClient.shutdown();
            this.mOldClient = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.mOldClient == null) {
            Log.e((String)TAG, (String)"Client is not connected");
            return;
        }
        TextToSpeech textToSpeech = this.mOldClient;
        synchronized (textToSpeech) {
            this.mOldClient.stop();
        }
    }

    private HashMap<String, String> createParameters(RequestConfig config, TextToSpeechClient.UtteranceId utteranceId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("utteranceId", utteranceId.toUniqueString());
        int voiceType = VoiceInfoPrivate.getVoiceType(config.getVoice());
        if (voiceType == 2) {
            parameters.put("networkTts", "true");
        } else if (voiceType == 1) {
            parameters.put("embeddedTts", "true");
        }
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueSpeak(String utterance, TextToSpeechClient.UtteranceId utteranceId, RequestConfig config, TextToSpeechClient.RequestCallbacks callbacks) {
        if (this.mOldClient == null || !this.mConnected) {
            Log.e((String)TAG, (String)"Client is not connected");
            return;
        }
        TextToSpeech textToSpeech = this.mOldClient;
        synchronized (textToSpeech) {
            if (callbacks != null) {
                this.addCallback(utteranceId, callbacks);
            } else {
                this.addCallback(utteranceId, this.mDefaultRequestCallbacks);
            }
            this.mOldClient.setLanguage(config.getVoice().getLocale());
            float speed = config.getVoiceParams().getFloat("speechSpeed");
            this.mOldClient.setSpeechRate(speed > 0.0f ? speed : this.getDefaultSpeechRate());
            this.mOldClient.setPitch(config.getVoiceParams().getFloat("speechPitch"));
            if (this.mOldClient.speak(utterance, 1, this.createParameters(config, utteranceId)) != 0) {
                this.removeCallbackAndErr(utteranceId.toUniqueString(), -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueSynthesizeToFile(String utterance, TextToSpeechClient.UtteranceId utteranceId, File outputFile, RequestConfig config, TextToSpeechClient.RequestCallbacks callbacks) {
        if (this.mOldClient == null || !this.mConnected) {
            Log.e((String)TAG, (String)"Client is not connected");
            return;
        }
        TextToSpeech textToSpeech = this.mOldClient;
        synchronized (textToSpeech) {
            if (callbacks != null) {
                this.addCallback(utteranceId, callbacks);
            } else {
                this.addCallback(utteranceId, this.mDefaultRequestCallbacks);
            }
            this.mOldClient.setLanguage(config.getVoice().getLocale());
            float speed = config.getVoiceParams().getFloat("speechSpeed");
            this.mOldClient.setSpeechRate(speed > 0.0f ? speed : this.getDefaultSpeechRate());
            this.mOldClient.setPitch(config.getVoiceParams().getFloat("speechPitch"));
            if (this.mOldClient.synthesizeToFile(utterance, this.createParameters(config, utteranceId), outputFile.getAbsolutePath()) != 0) {
                this.removeCallbackAndErr(utteranceId.toUniqueString(), -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueSilence(long durationInMs, TextToSpeechClient.UtteranceId utteranceId, TextToSpeechClient.RequestCallbacks callbacks) {
        if (this.mOldClient == null || !this.mConnected) {
            Log.e((String)TAG, (String)"Client is not connected");
            return;
        }
        TextToSpeech textToSpeech = this.mOldClient;
        synchronized (textToSpeech) {
            if (callbacks != null) {
                this.addCallback(utteranceId, callbacks);
            } else {
                this.addCallback(utteranceId, this.mDefaultRequestCallbacks);
            }
            if (this.mOldClient.playSilence(durationInMs, 1, this.createParameters(null, utteranceId)) != 0) {
                this.removeCallbackAndErr(utteranceId.toUniqueString(), -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueAudio(Uri audioUri, TextToSpeechClient.UtteranceId utteranceId, RequestConfig config, TextToSpeechClient.RequestCallbacks callbacks) {
        if (this.mOldClient == null || !this.mConnected) {
            Log.e((String)TAG, (String)"Client is not connected");
            return;
        }
        TextToSpeech textToSpeech = this.mOldClient;
        synchronized (textToSpeech) {
            if (callbacks != null) {
                this.addCallback(utteranceId, callbacks);
            } else {
                this.addCallback(utteranceId, this.mDefaultRequestCallbacks);
            }
            String earconName = audioUri.toString();
            this.mOldClient.setLanguage(config.getVoice().getLocale());
            this.mOldClient.addEarcon(earconName, earconName);
            if (this.mOldClient.playEarcon(earconName, 1, this.createParameters(config, utteranceId)) != 0) {
                this.removeCallbackAndErr(utteranceId.toUniqueString(), -1);
            }
        }
    }

    float getDefaultSpeechRate() {
        return (float)this.getSecureSettingInt("tts_default_rate", 100) / 100.0f;
    }

    int getSecureSettingInt(String name, int defaultValue) {
        return Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)name, (int)defaultValue);
    }

    private static class VoiceInfoPrivate {
        static final int VOICE_TYPE_EMBEDDED = 1;
        static final int VOICE_TYPE_NETWORK = 2;
        static final int VOICE_TYPE_UNKNOWN = 3;
        int mVoiceType;

        public VoiceInfoPrivate(int voiceType) {
            this.mVoiceType = voiceType;
        }

        static int getVoiceType(VoiceInfo voiceInfo) {
            return ((VoiceInfoPrivate)voiceInfo.getPrivateData()).mVoiceType;
        }
    }

    private static class RequestInternal {
        TextToSpeechClient.UtteranceId utteranceId;
        TextToSpeechClient.RequestCallbacks requestCallbacks;

        public RequestInternal(TextToSpeechClient.UtteranceId utteranceId, TextToSpeechClient.RequestCallbacks requestCallbacks) {
            this.utteranceId = utteranceId;
            this.requestCallbacks = requestCallbacks;
        }
    }
}

