/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import org.apache.cordova.Config;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.api.CordovaInterface;
import org.apache.cordova.api.LOG;
import org.json.JSONArray;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CordovaChromeClient
extends WebChromeClient {
    public static final int FILECHOOSER_RESULTCODE = 5173;
    private static final String LOG_TAG = "CordovaChromeClient";
    private String TAG = "CordovaLog";
    private long MAX_QUOTA = 0x6400000L;
    private CordovaInterface cordova;
    private CordovaWebView appView;
    private View mVideoProgressView;
    public ValueCallback<Uri> mUploadMessage;

    public CordovaChromeClient(CordovaInterface cordova) {
        this.cordova = cordova;
    }

    public CordovaChromeClient(CordovaInterface ctx, CordovaWebView app) {
        this.cordova = ctx;
        this.appView = app;
    }

    public void setWebView(CordovaWebView view) {
        this.appView = view;
    }

    public boolean onJsAlert(WebView view, String url, String message, final JsResult result) {
        AlertDialog.Builder dlg = new AlertDialog.Builder((Context)this.cordova.getActivity());
        dlg.setMessage((CharSequence)message);
        dlg.setTitle((CharSequence)"Alert");
        dlg.setCancelable(true);
        dlg.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                result.confirm();
            }
        });
        dlg.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                result.cancel();
            }
        });
        dlg.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                if (keyCode == 4) {
                    result.confirm();
                    return false;
                }
                return true;
            }
        });
        dlg.create();
        dlg.show();
        return true;
    }

    public boolean onJsConfirm(WebView view, String url, String message, final JsResult result) {
        AlertDialog.Builder dlg = new AlertDialog.Builder((Context)this.cordova.getActivity());
        dlg.setMessage((CharSequence)message);
        dlg.setTitle((CharSequence)"Confirm");
        dlg.setCancelable(true);
        dlg.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                result.confirm();
            }
        });
        dlg.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                result.cancel();
            }
        });
        dlg.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                result.cancel();
            }
        });
        dlg.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                if (keyCode == 4) {
                    result.cancel();
                    return false;
                }
                return true;
            }
        });
        dlg.create();
        dlg.show();
        return true;
    }

    public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
        boolean reqOk = false;
        if (url.startsWith("file://") || url.indexOf(this.appView.baseUrl) == 0 || Config.isUrlWhiteListed(url)) {
            reqOk = true;
        }
        if (reqOk && defaultValue != null && defaultValue.length() > 3 && defaultValue.substring(0, 4).equals("gap:")) {
            try {
                JSONArray array = new JSONArray(defaultValue.substring(4));
                String service = array.getString(0);
                String action = array.getString(1);
                String callbackId = array.getString(2);
                String r = this.appView.exposedJsApi.exec(service, action, callbackId, message);
                result.confirm(r == null ? "" : r);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else if (reqOk && defaultValue != null && defaultValue.equals("gap_bridge_mode:")) {
            this.appView.exposedJsApi.setNativeToJsBridgeMode(Integer.parseInt(message));
            result.confirm("");
        } else if (reqOk && defaultValue != null && defaultValue.equals("gap_poll:")) {
            String r = this.appView.exposedJsApi.retrieveJsMessages();
            result.confirm(r == null ? "" : r);
        } else if (defaultValue != null && defaultValue.equals("gap_init:")) {
            result.confirm("OK");
        } else {
            final JsPromptResult res = result;
            AlertDialog.Builder dlg = new AlertDialog.Builder((Context)this.cordova.getActivity());
            dlg.setMessage((CharSequence)message);
            final EditText input = new EditText((Context)this.cordova.getActivity());
            if (defaultValue != null) {
                input.setText((CharSequence)defaultValue);
            }
            dlg.setView((View)input);
            dlg.setCancelable(false);
            dlg.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    String usertext = input.getText().toString();
                    res.confirm(usertext);
                }
            });
            dlg.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    res.cancel();
                }
            });
            dlg.create();
            dlg.show();
        }
        return true;
    }

    public void onExceededDatabaseQuota(String url, String databaseIdentifier, long currentQuota, long estimatedSize, long totalUsedQuota, WebStorage.QuotaUpdater quotaUpdater) {
        LOG.d(this.TAG, "DroidGap:  onExceededDatabaseQuota estimatedSize: %d  currentQuota: %d  totalUsedQuota: %d", estimatedSize, currentQuota, totalUsedQuota);
        if (estimatedSize < this.MAX_QUOTA) {
            long newQuota = estimatedSize;
            LOG.d(this.TAG, "calling quotaUpdater.updateQuota newQuota: %d", newQuota);
            quotaUpdater.updateQuota(newQuota);
        } else {
            quotaUpdater.updateQuota(currentQuota);
        }
    }

    public void onConsoleMessage(String message, int lineNumber, String sourceID) {
        if (Build.VERSION.SDK_INT == 7) {
            LOG.d(this.TAG, "%s: Line %d : %s", sourceID, lineNumber, message);
            super.onConsoleMessage(message, lineNumber, sourceID);
        }
    }

    @TargetApi(value=8)
    public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        if (consoleMessage.message() != null) {
            LOG.d(this.TAG, consoleMessage.message());
        }
        return super.onConsoleMessage(consoleMessage);
    }

    public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
        super.onGeolocationPermissionsShowPrompt(origin, callback);
        callback.invoke(origin, true, false);
    }

    public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
        this.appView.showCustomView(view, callback);
    }

    public void onHideCustomView() {
        this.appView.hideCustomView();
    }

    public View getVideoLoadingProgressView() {
        if (this.mVideoProgressView == null) {
            LinearLayout layout = new LinearLayout(this.appView.getContext());
            layout.setOrientation(1);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.addRule(13);
            layout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            ProgressBar bar = new ProgressBar(this.appView.getContext());
            LinearLayout.LayoutParams barLayoutParams = new LinearLayout.LayoutParams(-2, -2);
            barLayoutParams.gravity = 17;
            bar.setLayoutParams((ViewGroup.LayoutParams)barLayoutParams);
            layout.addView((View)bar);
            this.mVideoProgressView = layout;
        }
        return this.mVideoProgressView;
    }

    public void openFileChooser(ValueCallback<Uri> uploadMsg) {
        this.openFileChooser(uploadMsg, "*/*");
    }

    public void openFileChooser(ValueCallback<Uri> uploadMsg, String acceptType) {
        this.openFileChooser(uploadMsg, acceptType, null);
    }

    public void openFileChooser(ValueCallback<Uri> uploadMsg, String acceptType, String capture) {
        this.mUploadMessage = uploadMsg;
        Intent i = new Intent("android.intent.action.GET_CONTENT");
        i.addCategory("android.intent.category.OPENABLE");
        i.setType("*/*");
        this.cordova.getActivity().startActivityForResult(Intent.createChooser((Intent)i, (CharSequence)"File Browser"), 5173);
    }

    public ValueCallback<Uri> getValueCallback() {
        return this.mUploadMessage;
    }
}

