/*
 * temperature-android
 * Copyright (C) 2018  jiwopene
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * jiwopene@gmail.com
 * https://gitlab.com/jiwopene/temperature-android
 */

package com.gmail.jiwopene.temperature;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.View;

public class AboutActivity extends AppCompatActivity implements View.OnClickListener {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_about);

        setTitle(R.string.about_app);

        findViewById(R.id.show_gitlab).setOnClickListener(this);
        findViewById(R.id.submit_issue).setOnClickListener(this);
        findViewById(R.id.open_material_icons).setOnClickListener(this);
    }

    @Override
    public void onClick(View view) {
        switch (view.getId()) {
            case R.id.show_gitlab:
                startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("https://gitlab.com/jiwopene/temperature-android")));
                break;
            case R.id.submit_issue:
                startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("https://gitlab.com/jiwopene/temperature-android/issues/new")));
                break;
            case R.id.open_material_icons:
                startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("https://material.io/tools/icons/")));
                break;
        }
    }
}
