/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.analytics;

import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import com.google.android.apps.analytics.Dispatcher;
import com.google.android.apps.analytics.Event;
import com.google.android.apps.analytics.GoogleAnalyticsTracker;
import com.google.android.apps.analytics.NetworkRequestUtil;
import com.google.android.apps.analytics.PipelinedRequester;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Locale;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.ParseException;
import org.apache.http.message.BasicHttpRequest;

class NetworkDispatcher
implements Dispatcher {
    private static final HttpHost GOOGLE_ANALYTICS_HOST = new HttpHost("www.google-analytics.com", 80);
    private static final String USER_AGENT_TEMPLATE = "%s/%s (Linux; U; Android %s; %s-%s; %s Build/%s)";
    private final String userAgent;
    private static final int MAX_EVENTS_PER_PIPELINE = 30;
    private static final int MAX_SEQUENTIAL_REQUESTS = 5;
    private static final long MIN_RETRY_INTERVAL = 2L;
    private DispatcherThread dispatcherThread;
    private boolean dryRun = false;

    public NetworkDispatcher() {
        this("GoogleAnalytics", "1.2");
    }

    public NetworkDispatcher(String string, String string2) {
        Locale locale = Locale.getDefault();
        this.userAgent = String.format(USER_AGENT_TEMPLATE, string, string2, Build.VERSION.RELEASE, locale.getLanguage() != null ? locale.getLanguage().toLowerCase() : "en", locale.getCountry() != null ? locale.getCountry().toLowerCase() : "", Build.MODEL, Build.ID);
    }

    public void init(Dispatcher.Callbacks callbacks, String string) {
        this.stop();
        this.dispatcherThread = new DispatcherThread(callbacks, string, this.userAgent, this);
        this.dispatcherThread.start();
    }

    public void init(Dispatcher.Callbacks callbacks, PipelinedRequester pipelinedRequester, String string) {
        this.stop();
        this.dispatcherThread = new DispatcherThread(callbacks, pipelinedRequester, string, this.userAgent, this);
        this.dispatcherThread.start();
    }

    public void dispatchEvents(Event[] eventArray) {
        if (this.dispatcherThread != null) {
            this.dispatcherThread.dispatchEvents(eventArray);
        }
    }

    public void setDryRun(boolean bl) {
        this.dryRun = bl;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void waitForThreadLooper() {
        this.dispatcherThread.getLooper();
    }

    public void stop() {
        if (this.dispatcherThread != null && this.dispatcherThread.getLooper() != null) {
            this.dispatcherThread.getLooper().quit();
            this.dispatcherThread = null;
        }
    }

    String getUserAgent() {
        return this.userAgent;
    }

    private static class DispatcherThread
    extends HandlerThread {
        private Handler handlerExecuteOnDispatcherThread;
        private final PipelinedRequester pipelinedRequester;
        private final String referrer;
        private final String userAgent;
        private int lastStatusCode;
        private int maxEventsPerRequest = 30;
        private long retryInterval;
        private AsyncDispatchTask currentTask = null;
        private final Dispatcher.Callbacks callbacks;
        private final RequesterCallbacks requesterCallBacks;
        private final NetworkDispatcher parent;

        private DispatcherThread(Dispatcher.Callbacks callbacks, String string, String string2, NetworkDispatcher networkDispatcher) {
            this(callbacks, new PipelinedRequester(GOOGLE_ANALYTICS_HOST), string, string2, networkDispatcher);
        }

        private DispatcherThread(Dispatcher.Callbacks callbacks, PipelinedRequester pipelinedRequester, String string, String string2, NetworkDispatcher networkDispatcher) {
            super("DispatcherThread");
            this.callbacks = callbacks;
            this.referrer = string;
            this.userAgent = string2;
            this.pipelinedRequester = pipelinedRequester;
            this.requesterCallBacks = new RequesterCallbacks();
            this.pipelinedRequester.installCallbacks(this.requesterCallBacks);
            this.parent = networkDispatcher;
        }

        protected void onLooperPrepared() {
            this.handlerExecuteOnDispatcherThread = new Handler();
        }

        public void dispatchEvents(Event[] eventArray) {
            if (this.handlerExecuteOnDispatcherThread != null) {
                this.handlerExecuteOnDispatcherThread.post((Runnable)new AsyncDispatchTask(eventArray));
            }
        }

        private class RequesterCallbacks
        implements PipelinedRequester.Callbacks {
            private RequesterCallbacks() {
            }

            public void pipelineModeChanged(boolean bl) {
                if (bl) {
                    DispatcherThread.this.maxEventsPerRequest = 30;
                } else {
                    DispatcherThread.this.maxEventsPerRequest = 1;
                }
            }

            public void requestSent() {
                if (DispatcherThread.this.currentTask == null) {
                    return;
                }
                Event event = DispatcherThread.this.currentTask.removeNextEvent();
                if (event != null) {
                    DispatcherThread.this.callbacks.eventDispatched(event.eventId);
                }
            }

            public void serverError(int n) {
                DispatcherThread.this.lastStatusCode = n;
            }
        }

        private class AsyncDispatchTask
        implements Runnable {
            private final LinkedList<Event> events = new LinkedList();

            public AsyncDispatchTask(Event[] eventArray) {
                Collections.addAll(this.events, eventArray);
            }

            public void run() {
                DispatcherThread.this.currentTask = this;
                for (int i = 0; i < 5 && this.events.size() > 0; ++i) {
                    try {
                        long l = 0L;
                        if (DispatcherThread.this.lastStatusCode == 500 || DispatcherThread.this.lastStatusCode == 503) {
                            l = (long)(Math.random() * (double)DispatcherThread.this.retryInterval);
                            if (DispatcherThread.this.retryInterval < 256L) {
                                DispatcherThread.this.retryInterval *= 2L;
                            }
                        } else {
                            DispatcherThread.this.retryInterval = 2L;
                        }
                        Thread.sleep(l * 1000L);
                        this.dispatchSomePendingEvents(DispatcherThread.this.parent.isDryRun());
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        Log.w((String)"GoogleAnalyticsTracker", (String)"Couldn't sleep.", (Throwable)interruptedException);
                        break;
                    }
                    catch (IOException iOException) {
                        Log.w((String)"GoogleAnalyticsTracker", (String)"Problem with socket or streams.", (Throwable)iOException);
                        break;
                    }
                    catch (HttpException httpException) {
                        Log.w((String)"GoogleAnalyticsTracker", (String)"Problem with http streams.", (Throwable)httpException);
                        break;
                    }
                }
                DispatcherThread.this.pipelinedRequester.finishedCurrentRequests();
                DispatcherThread.this.callbacks.dispatchFinished();
                DispatcherThread.this.currentTask = null;
            }

            private void dispatchSomePendingEvents(boolean bl) throws IOException, ParseException, HttpException {
                if (GoogleAnalyticsTracker.getInstance().getDebug() && bl) {
                    Log.v((String)"GoogleAnalyticsTracker", (String)"dispatching events in dry run mode");
                }
                for (int i = 0; i < this.events.size() && i < DispatcherThread.this.maxEventsPerRequest; ++i) {
                    Event event = this.events.get(i);
                    String string = "__##GOOGLEPAGEVIEW##__".equals(event.category) ? NetworkRequestUtil.constructPageviewRequestPath(event, DispatcherThread.this.referrer) : ("__##GOOGLETRANSACTION##__".equals(event.category) ? NetworkRequestUtil.constructTransactionRequestPath(event, DispatcherThread.this.referrer) : ("__##GOOGLEITEM##__".equals(event.category) ? NetworkRequestUtil.constructItemRequestPath(event, DispatcherThread.this.referrer) : NetworkRequestUtil.constructEventRequestPath(event, DispatcherThread.this.referrer)));
                    BasicHttpRequest basicHttpRequest = new BasicHttpRequest("GET", string);
                    basicHttpRequest.addHeader("Host", GOOGLE_ANALYTICS_HOST.getHostName());
                    basicHttpRequest.addHeader("User-Agent", DispatcherThread.this.userAgent);
                    if (GoogleAnalyticsTracker.getInstance().getDebug()) {
                        Log.i((String)"GoogleAnalyticsTracker", (String)basicHttpRequest.getRequestLine().toString());
                    }
                    if (bl) {
                        DispatcherThread.this.requesterCallBacks.requestSent();
                        continue;
                    }
                    DispatcherThread.this.pipelinedRequester.addRequest((HttpRequest)basicHttpRequest);
                }
                if (!bl) {
                    DispatcherThread.this.pipelinedRequester.sendRequests();
                }
            }

            public Event removeNextEvent() {
                return this.events.poll();
            }
        }
    }
}

