/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.googlelogindist;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import com.google.android.googleapps.GoogleLoginCredentialsResult;
import com.google.android.googlelogindist.GoogleLoginServiceBlockingHelper;
import com.google.android.googlelogindist.GoogleLoginServiceNotFoundException;

public class GoogleLoginServiceHelper {
    private static final String SERVICE = "service";
    private static final String REQUEST_CODE = "requestCode";
    private static final String OPTIONAL_MESSAGE = "optional_message";
    private static final String TAG = "GoogleLoginServiceHelper";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private static String REQUIRE_GOOGLE_FALSE = new String("false");
    private static String REQUIRE_GOOGLE_TRUE = new String("true");

    private GoogleLoginServiceHelper() {
    }

    public static void getAccount(final Activity activity, final int requestCode, final boolean requireGoogle) {
        final Handler handler = new Handler();
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Bundle b = new Bundle();
                int resultCode = -1;
                GoogleLoginServiceBlockingHelper helper = null;
                try {
                    helper = new GoogleLoginServiceBlockingHelper((Context)activity.getApplication());
                    String[] accounts = new String[]{helper.getAccount(requireGoogle)};
                    b.putStringArray("accounts", accounts);
                }
                catch (GoogleLoginServiceNotFoundException e) {
                    resultCode = 0;
                    b.putInt("errorCode", e.getErrorCode());
                }
                finally {
                    if (helper != null) {
                        helper.close();
                    }
                }
                GoogleLoginServiceHelper.postActivityResult(handler, activity, resultCode, requestCode, b);
            }
        };
        t.start();
    }

    public static void getCredentials(Activity activity, int requestCode, Bundle requestExtras, boolean requireGoogle, String service, boolean promptUser) {
        GoogleLoginServiceHelper.getCredentials(activity, requestCode, requestExtras, requireGoogle ? REQUIRE_GOOGLE_TRUE : REQUIRE_GOOGLE_FALSE, service, promptUser);
    }

    public static void getCredentials(final Activity activity, final int requestCode, final Bundle requestExtras, final String accountName, final String service, final boolean promptUser) {
        final Handler handler = new Handler();
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                GoogleLoginServiceBlockingHelper helper = null;
                Bundle b = new Bundle();
                try {
                    helper = new GoogleLoginServiceBlockingHelper((Context)activity.getApplication());
                    String account = accountName == REQUIRE_GOOGLE_FALSE ? helper.getAccount(false) : (accountName == REQUIRE_GOOGLE_TRUE ? helper.getAccount(true) : accountName);
                    final GoogleLoginCredentialsResult credentialsResult = helper.getCredentials(account, service, !promptUser);
                    b.putBundle("callerExtras", requestExtras);
                    if (credentialsResult.getCredentialsString() != null) {
                        b.putString("authtoken", credentialsResult.getCredentialsString());
                        b.putString("authAccount", credentialsResult.getAccount());
                        if ("youtube".equals(service)) {
                            b.putString("YouTubeUser", helper.peekCredentials(credentialsResult.getAccount(), "YouTubeUser"));
                        }
                        GoogleLoginServiceHelper.postActivityResult(handler, activity, -1, requestCode, b);
                        return;
                    }
                    if (credentialsResult.getCredentialsIntent() != null) {
                        if (promptUser) {
                            handler.post(new Runnable(){

                                public void run() {
                                    Intent credentialsIntent = credentialsResult.getCredentialsIntent();
                                    if (requestExtras != null) {
                                        CharSequence msg = requestExtras.getCharSequence(GoogleLoginServiceHelper.OPTIONAL_MESSAGE);
                                        credentialsIntent.putExtra(GoogleLoginServiceHelper.OPTIONAL_MESSAGE, msg);
                                    }
                                    credentialsIntent.putExtra("callerExtras", requestExtras);
                                    credentialsIntent.putExtra(GoogleLoginServiceHelper.REQUEST_CODE, requestCode);
                                    credentialsIntent.putExtra(GoogleLoginServiceHelper.SERVICE, service);
                                    activity.startActivityForResult(credentialsIntent, requestCode);
                                }
                            });
                            return;
                        }
                        GoogleLoginServiceHelper.postActivityResult(handler, activity, -1, requestCode, b);
                        return;
                    }
                    try {
                        throw new RuntimeException("Malformed credentialsResult from helper.getCredentials()");
                    }
                    catch (GoogleLoginServiceNotFoundException e) {
                        b.putInt("errorCode", e.getErrorCode());
                        GoogleLoginServiceHelper.postActivityResult(handler, activity, 0, requestCode, b);
                        return;
                    }
                }
                finally {
                    if (helper != null) {
                        helper.close();
                    }
                }
            }
        };
        t.start();
    }

    public static void invalidateAuthToken(final Activity activity, final int requestCode, final String authToken) {
        final Handler handler = new Handler();
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                GoogleLoginServiceBlockingHelper helper = null;
                try {
                    helper = new GoogleLoginServiceBlockingHelper((Context)activity.getApplication());
                    helper.invalidateAuthToken(authToken);
                }
                catch (GoogleLoginServiceNotFoundException e) {
                    Bundle b = new Bundle();
                    b.putInt("errorCode", e.getErrorCode());
                    GoogleLoginServiceHelper.postActivityResult(handler, activity, 0, requestCode, b);
                    return;
                }
                finally {
                    if (helper != null) {
                        helper.close();
                    }
                }
                GoogleLoginServiceHelper.postActivityResult(handler, activity, -1, requestCode, null);
            }
        };
        t.start();
    }

    private static void sendActivityResult(Activity activity, int resultCode, int requestCode, Bundle bundle) {
        PendingIntent apr = activity.createPendingResult(requestCode, null, 0);
        if (apr != null) {
            try {
                Intent intent = new Intent();
                if (bundle != null) {
                    intent.putExtras(bundle);
                }
                apr.send((Context)activity, resultCode, intent);
            }
            catch (PendingIntent.CanceledException e) {
                // empty catch block
            }
        }
    }

    private static void postActivityResult(Handler handler, final Activity activity, final int resultCode, final int requestCode, final Bundle bundle) {
        handler.post(new Runnable(){

            public void run() {
                GoogleLoginServiceHelper.sendActivityResult(activity, resultCode, requestCode, bundle);
            }
        });
    }
}

