/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.testing.mocking;

import com.google.android.testing.mocking.MockObject;
import java.lang.constant.Constable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.easymock.IExpectationSetters;
import org.easymock.LogicalOperator;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AndroidMock {
    private AndroidMock() {
    }

    public static <T> T createStrictMock(Class<T> toMock, Object ... args) {
        return AndroidMock.createStrictMock(null, toMock, args);
    }

    public static <T> T createStrictMock(String name, Class<T> toMock, Object ... args) {
        if (toMock.isInterface()) {
            return EasyMock.createStrictMock(name, toMock);
        }
        T mockedInterface = EasyMock.createStrictMock(name, AndroidMock.getInterfaceFor(toMock));
        return AndroidMock.getSubclassFor(toMock, AndroidMock.getInterfaceFor(toMock), mockedInterface, args);
    }

    public static <T> T createMock(Class<T> toMock, Object ... args) {
        return AndroidMock.createMock(null, toMock, args);
    }

    public static <T> T createMock(String name, Class<T> toMock, Object ... args) {
        if (toMock.isInterface()) {
            return EasyMock.createMock(name, toMock);
        }
        T mockedInterface = EasyMock.createMock(name, AndroidMock.getInterfaceFor(toMock));
        return AndroidMock.getSubclassFor(toMock, AndroidMock.getInterfaceFor(toMock), mockedInterface, args);
    }

    public static <T> T createNiceMock(Class<T> toMock, Object ... args) {
        return AndroidMock.createNiceMock(null, toMock, args);
    }

    public static <T> T createNiceMock(String name, Class<T> toMock, Object ... args) {
        if (toMock.isInterface()) {
            return EasyMock.createNiceMock(name, toMock);
        }
        T mockedInterface = EasyMock.createNiceMock(name, AndroidMock.getInterfaceFor(toMock));
        return AndroidMock.getSubclassFor(toMock, AndroidMock.getInterfaceFor(toMock), mockedInterface, args);
    }

    public static <T> IExpectationSetters<T> expect(T expectedValue) {
        return EasyMock.expect(expectedValue);
    }

    public static <T> IExpectationSetters<T> expectLastCall() {
        return EasyMock.expectLastCall();
    }

    public static boolean anyBoolean() {
        return EasyMock.anyBoolean();
    }

    public static byte anyByte() {
        return EasyMock.anyByte();
    }

    public static char anyChar() {
        return EasyMock.anyChar();
    }

    public static int anyInt() {
        return EasyMock.anyInt();
    }

    public static long anyLong() {
        return EasyMock.anyLong();
    }

    public static float anyFloat() {
        return EasyMock.anyFloat();
    }

    public static double anyDouble() {
        return EasyMock.anyDouble();
    }

    public static short anyShort() {
        return EasyMock.anyShort();
    }

    public static <T> T anyObject() {
        return EasyMock.anyObject();
    }

    public static <T extends Comparable<T>> T geq(Comparable<T> expectedValue) {
        return EasyMock.geq(expectedValue);
    }

    public static byte geq(byte expectedValue) {
        return EasyMock.geq(expectedValue);
    }

    public static double geq(double expectedValue) {
        return EasyMock.geq(expectedValue);
    }

    public static float geq(float expectedValue) {
        return EasyMock.geq(expectedValue);
    }

    public static int geq(int expectedValue) {
        return EasyMock.geq(expectedValue);
    }

    public static long geq(long expectedValue) {
        return EasyMock.geq(expectedValue);
    }

    public static short geq(short expectedValue) {
        return EasyMock.geq(expectedValue);
    }

    public static <T extends Comparable<T>> T leq(Comparable<T> expectedValue) {
        return EasyMock.leq(expectedValue);
    }

    public static byte leq(byte expectedValue) {
        return EasyMock.leq(expectedValue);
    }

    public static double leq(double expectedValue) {
        return EasyMock.leq(expectedValue);
    }

    public static float leq(float expectedValue) {
        return EasyMock.leq(expectedValue);
    }

    public static int leq(int expectedValue) {
        return EasyMock.leq(expectedValue);
    }

    public static long leq(long expectedValue) {
        return EasyMock.leq(expectedValue);
    }

    public static short leq(short expectedValue) {
        return EasyMock.leq(expectedValue);
    }

    public static <T extends Comparable<T>> T gt(Comparable<T> expectedValue) {
        return EasyMock.gt(expectedValue);
    }

    public static byte gt(byte expectedValue) {
        return EasyMock.gt(expectedValue);
    }

    public static double gt(double expectedValue) {
        return EasyMock.gt(expectedValue);
    }

    public static float gt(float expectedValue) {
        return EasyMock.gt(expectedValue);
    }

    public static int gt(int expectedValue) {
        return EasyMock.gt(expectedValue);
    }

    public static long gt(long expectedValue) {
        return EasyMock.gt(expectedValue);
    }

    public static short gt(short expectedValue) {
        return EasyMock.gt(expectedValue);
    }

    public static <T extends Comparable<T>> T lt(Comparable<T> expectedValue) {
        return EasyMock.lt(expectedValue);
    }

    public static byte lt(byte expectedValue) {
        return EasyMock.lt(expectedValue);
    }

    public static double lt(double expectedValue) {
        return EasyMock.lt(expectedValue);
    }

    public static float lt(float expectedValue) {
        return EasyMock.lt(expectedValue);
    }

    public static int lt(int expectedValue) {
        return EasyMock.lt(expectedValue);
    }

    public static long lt(long expectedValue) {
        return EasyMock.lt(expectedValue);
    }

    public static short lt(short expectedValue) {
        return EasyMock.lt(expectedValue);
    }

    public static <T> T isA(Class<T> clazz) {
        return EasyMock.isA(clazz);
    }

    public static String contains(String substring) {
        return EasyMock.contains(substring);
    }

    public static boolean and(boolean first, boolean second) {
        return EasyMock.and(first, second);
    }

    public static byte and(byte first, byte second) {
        return EasyMock.and(first, second);
    }

    public static char and(char first, char second) {
        return EasyMock.and(first, second);
    }

    public static double and(double first, double second) {
        return EasyMock.and(first, second);
    }

    public static float and(float first, float second) {
        return EasyMock.and(first, second);
    }

    public static int and(int first, int second) {
        return EasyMock.and(first, second);
    }

    public static long and(long first, long second) {
        return EasyMock.and(first, second);
    }

    public static short and(short first, short second) {
        return EasyMock.and(first, second);
    }

    public static <T> T and(T first, T second) {
        return EasyMock.and(first, second);
    }

    public static boolean or(boolean first, boolean second) {
        return EasyMock.or(first, second);
    }

    public static byte or(byte first, byte second) {
        return EasyMock.or(first, second);
    }

    public static char or(char first, char second) {
        return EasyMock.or(first, second);
    }

    public static double or(double first, double second) {
        return EasyMock.or(first, second);
    }

    public static float or(float first, float second) {
        return EasyMock.or(first, second);
    }

    public static int or(int first, int second) {
        return EasyMock.or(first, second);
    }

    public static long or(long first, long second) {
        return EasyMock.or(first, second);
    }

    public static short or(short first, short second) {
        return EasyMock.or(first, second);
    }

    public static <T> T or(T first, T second) {
        return EasyMock.or(first, second);
    }

    public static boolean not(boolean expectation) {
        return EasyMock.not(expectation);
    }

    public static byte not(byte expectation) {
        return EasyMock.not(expectation);
    }

    public static char not(char expectation) {
        return EasyMock.not(expectation);
    }

    public static double not(double expectation) {
        return EasyMock.not(expectation);
    }

    public static float not(float expectation) {
        return EasyMock.not(expectation);
    }

    public static int not(int expectation) {
        return EasyMock.not(expectation);
    }

    public static long not(long expectation) {
        return EasyMock.not(expectation);
    }

    public static short not(short expectation) {
        return EasyMock.not(expectation);
    }

    public static <T> T not(T expectation) {
        return EasyMock.not(expectation);
    }

    public static boolean eq(boolean expectedValue) {
        return EasyMock.eq(expectedValue);
    }

    public static byte eq(byte expectedValue) {
        return EasyMock.eq(expectedValue);
    }

    public static char eq(char expectedValue) {
        return EasyMock.eq(expectedValue);
    }

    public static double eq(double expectedValue) {
        return EasyMock.eq(expectedValue);
    }

    public static float eq(float expectedValue) {
        return EasyMock.eq(expectedValue);
    }

    public static int eq(int expectedValue) {
        return EasyMock.eq(expectedValue);
    }

    public static long eq(long expectedValue) {
        return EasyMock.eq(expectedValue);
    }

    public static short eq(short expectedValue) {
        return EasyMock.eq(expectedValue);
    }

    public static <T> T eq(T expectedValue) {
        return EasyMock.eq(expectedValue);
    }

    public static boolean[] aryEq(boolean[] expectedValue) {
        return EasyMock.aryEq(expectedValue);
    }

    public static byte[] aryEq(byte[] expectedValue) {
        return EasyMock.aryEq(expectedValue);
    }

    public static char[] aryEq(char[] expectedValue) {
        return EasyMock.aryEq(expectedValue);
    }

    public static double[] aryEq(double[] expectedValue) {
        return EasyMock.aryEq(expectedValue);
    }

    public static float[] aryEq(float[] expectedValue) {
        return EasyMock.aryEq(expectedValue);
    }

    public static int[] aryEq(int[] expectedValue) {
        return EasyMock.aryEq(expectedValue);
    }

    public static long[] aryEq(long[] expectedValue) {
        return EasyMock.aryEq(expectedValue);
    }

    public static short[] aryEq(short[] expectedValue) {
        return EasyMock.aryEq(expectedValue);
    }

    public static <T> T[] aryEq(T[] expectedValue) {
        return EasyMock.aryEq(expectedValue);
    }

    public static <T> T isNull() {
        return EasyMock.isNull();
    }

    public static <T> T notNull() {
        return EasyMock.notNull();
    }

    public static String find(String regex) {
        return EasyMock.find(regex);
    }

    public static String matches(String regex) {
        return EasyMock.matches(regex);
    }

    public static String startsWith(String prefix) {
        return EasyMock.startsWith(prefix);
    }

    public static String endsWith(String suffix) {
        return EasyMock.endsWith(suffix);
    }

    public static double eq(double expectedValue, double delta) {
        return EasyMock.eq(expectedValue, delta);
    }

    public static float eq(float expectedValue, float delta) {
        return EasyMock.eq(expectedValue, delta);
    }

    public static <T> T same(T expectedValue) {
        return EasyMock.same(expectedValue);
    }

    public static <T extends Comparable<T>> T cmpEq(Comparable<T> expectedValue) {
        return EasyMock.cmpEq(expectedValue);
    }

    public static <T> T cmp(T expectedValue, Comparator<? super T> comparator, LogicalOperator operator) {
        return EasyMock.cmp(expectedValue, comparator, operator);
    }

    public static <T> T capture(Capture<T> captured) {
        return EasyMock.capture(captured);
    }

    public static int capture(Capture<Integer> captured) {
        return EasyMock.capture(captured);
    }

    public static long capture(Capture<Long> captured) {
        return EasyMock.capture(captured);
    }

    public static float capture(Capture<Float> captured) {
        return EasyMock.capture(captured);
    }

    public static double capture(Capture<Double> captured) {
        return EasyMock.capture(captured);
    }

    public static byte capture(Capture<Byte> captured) {
        return EasyMock.capture(captured);
    }

    public static char capture(Capture<Character> captured) {
        return EasyMock.capture(captured);
    }

    public static void replay(Object ... mocks) {
        for (Object mockObject : mocks) {
            if (mockObject instanceof MockObject) {
                EasyMock.replay(((MockObject)mockObject).getDelegate___AndroidMock());
                continue;
            }
            EasyMock.replay(mockObject);
        }
    }

    public static void reset(Object ... mocks) {
        for (Object mockObject : mocks) {
            if (mockObject instanceof MockObject) {
                EasyMock.reset(((MockObject)mockObject).getDelegate___AndroidMock());
                continue;
            }
            EasyMock.reset(mockObject);
        }
    }

    public static void resetToNice(Object ... mocks) {
        for (Object mockObject : mocks) {
            if (mockObject instanceof MockObject) {
                EasyMock.resetToNice(((MockObject)mockObject).getDelegate___AndroidMock());
                continue;
            }
            EasyMock.resetToNice(mockObject);
        }
    }

    public static void resetToDefault(Object ... mocks) {
        for (Object mockObject : mocks) {
            if (mockObject instanceof MockObject) {
                EasyMock.resetToDefault(((MockObject)mockObject).getDelegate___AndroidMock());
                continue;
            }
            EasyMock.resetToDefault(mockObject);
        }
    }

    public static void resetToStrict(Object ... mocks) {
        for (Object mockObject : mocks) {
            if (mockObject instanceof MockObject) {
                EasyMock.resetToStrict(((MockObject)mockObject).getDelegate___AndroidMock());
                continue;
            }
            EasyMock.resetToStrict(mockObject);
        }
    }

    public static void verify(Object ... mocks) {
        for (Object mockObject : mocks) {
            if (mockObject instanceof MockObject) {
                EasyMock.verify(((MockObject)mockObject).getDelegate___AndroidMock());
                continue;
            }
            EasyMock.verify(mockObject);
        }
    }

    public static void checkOrder(Object mock, boolean orderCheckingOn) {
        if (mock instanceof MockObject) {
            EasyMock.checkOrder(((MockObject)mock).getDelegate___AndroidMock(), orderCheckingOn);
        } else {
            EasyMock.checkOrder(mock, orderCheckingOn);
        }
    }

    public static void reportMatcher(IArgumentMatcher matcher) {
        EasyMock.reportMatcher(matcher);
    }

    public static Object[] getCurrentArguments() {
        return EasyMock.getCurrentArguments();
    }

    public static void makeThreadSafe(Object mock, boolean threadSafe) {
        if (mock instanceof MockObject) {
            EasyMock.makeThreadSafe(((MockObject)mock).getDelegate___AndroidMock(), threadSafe);
        } else {
            EasyMock.makeThreadSafe(mock, threadSafe);
        }
    }

    static String getInterfaceNameFor(Class<?> clazz) {
        return "genmocks." + clazz.getName() + "DelegateInterface";
    }

    private static <T, S> T getSubclassFor(Class<? super T> clazz, Class<S> delegateInterface, Object realMock, Object ... args) {
        Method setMethod;
        Object newObject;
        Class<?> subclass;
        try {
            subclass = Class.forName(AndroidMock.getSubclassNameFor(clazz));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find class for " + AndroidMock.getSubclassNameFor(clazz) + " which likely means that the mock-instrumented jar has not been created or else" + " is not being used in the current runtime environment. Try running MockGeneratorMain" + " in MockGenerator_deploy.jar or using the output of that execution as the input to" + " the dex/apk generation.", e);
        }
        Constructor<?> constructor = AndroidMock.getConstructorFor(subclass, args);
        try {
            newObject = constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Internal error instantiating new mock subclass" + subclass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Internal error - the new mock subclass' constructor was inaccessible", e);
        }
        catch (InvocationTargetException e) {
            throw new ExceptionInInitializerError(e);
        }
        Method[] methods = subclass.getMethods();
        try {
            setMethod = subclass.getMethod("setDelegate___AndroidMock", delegateInterface);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Internal error - No setDelegate method found for class " + subclass.getName() + " and param " + delegateInterface.getName(), e);
        }
        try {
            setMethod.invoke(newObject, realMock);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Internal error setting the delegate, expected " + newObject.getClass() + " to be subclass of " + clazz.getName());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Severe internal error, setDelegate threw an exception", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Internal error, setDelegate method was inaccessible", e);
        }
        return (T)newObject;
    }

    static boolean isUnboxableToPrimitive(Class<?> clazz, Object arg, boolean exactMatch) {
        if (!clazz.isPrimitive()) {
            throw new IllegalArgumentException("Internal Error - The class to test against is not a primitive");
        }
        Class<Constable> unboxedType = null;
        if (arg.getClass().equals(Integer.class)) {
            unboxedType = Integer.TYPE;
        } else if (arg.getClass().equals(Long.class)) {
            unboxedType = Long.TYPE;
        } else if (arg.getClass().equals(Byte.class)) {
            unboxedType = Byte.TYPE;
        } else if (arg.getClass().equals(Short.class)) {
            unboxedType = Short.TYPE;
        } else if (arg.getClass().equals(Character.class)) {
            unboxedType = Character.TYPE;
        } else if (arg.getClass().equals(Float.class)) {
            unboxedType = Float.TYPE;
        } else if (arg.getClass().equals(Double.class)) {
            unboxedType = Double.TYPE;
        } else if (arg.getClass().equals(Boolean.class)) {
            unboxedType = Boolean.TYPE;
        } else {
            return false;
        }
        if (exactMatch) {
            return clazz == unboxedType;
        }
        return AndroidMock.isAssignable(clazz, unboxedType);
    }

    private static boolean isAssignable(Class<?> to, Class<?> from) {
        if (to == Byte.TYPE) {
            return from == Byte.TYPE;
        }
        if (to == Short.TYPE) {
            return from == Byte.TYPE || from == Short.TYPE || from == Character.TYPE;
        }
        if (to == Integer.TYPE || to == Character.TYPE) {
            return from == Byte.TYPE || from == Short.TYPE || from == Integer.TYPE || from == Character.TYPE;
        }
        if (to == Long.TYPE) {
            return from == Byte.TYPE || from == Short.TYPE || from == Integer.TYPE || from == Long.TYPE || from == Character.TYPE;
        }
        if (to == Float.TYPE) {
            return from == Byte.TYPE || from == Short.TYPE || from == Integer.TYPE || from == Character.TYPE || from == Float.TYPE;
        }
        if (to == Double.TYPE) {
            return from == Byte.TYPE || from == Short.TYPE || from == Integer.TYPE || from == Long.TYPE || from == Character.TYPE || from == Float.TYPE || from == Double.TYPE;
        }
        if (to == Boolean.TYPE) {
            return from == Boolean.TYPE;
        }
        return to.isAssignableFrom(from);
    }

    static <T> Constructor<T> getConstructorFor(Class<T> clazz, Object ... args) throws SecurityException {
        Constructor<?>[] constructors = clazz.getConstructors();
        Constructor<?> compatibleConstructor = null;
        for (Constructor<?> constructor : constructors) {
            Class<?>[] params = constructor.getParameterTypes();
            if (params.length != args.length) continue;
            boolean exactMatch = true;
            boolean compatibleMatch = true;
            for (int i = 0; i < params.length; ++i) {
                Class<Void> arg = args[i];
                if (arg == null) {
                    arg = Void.TYPE;
                }
                if (params[i].isAssignableFrom(arg.getClass())) continue;
                if (params[i].isPrimitive()) {
                    exactMatch &= AndroidMock.isUnboxableToPrimitive(params[i], arg, true);
                    compatibleMatch &= AndroidMock.isUnboxableToPrimitive(params[i], arg, false);
                    continue;
                }
                exactMatch = false;
                compatibleMatch = false;
            }
            if (exactMatch) {
                return constructor;
            }
            if (!compatibleMatch) continue;
            compatibleConstructor = constructor;
        }
        if (compatibleConstructor != null) {
            return compatibleConstructor;
        }
        ArrayList<String> argTypes = new ArrayList<String>(args.length);
        for (Object arg : args) {
            argTypes.add(arg == null ? "<null>" : arg.getClass().toString());
        }
        throw new IllegalArgumentException("Could not find the specified Constructor: " + clazz.getName() + "(" + argTypes + ")");
    }

    static String getSubclassNameFor(Class<?> clazz) {
        return "genmocks." + clazz.getName() + "DelegateSubclass";
    }

    private static <T> Class<T> getInterfaceFor(Class<T> clazz) {
        try {
            return Class.forName(AndroidMock.getInterfaceNameFor(clazz));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find mock for " + clazz.getName() + "  -- Make sure to run the MockGenerator.jar on your test jar, and to " + "build the Android test APK using the modified jar created by MockGenerator", e);
        }
    }
}

