/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Csv {
    public static final String COMMA = ",";
    public static final String NEWLINE = "\n";

    public static void writeValue(String value, Appendable output) throws IOException {
        int len = value.length();
        if (len == 0) {
            return;
        }
        char first = value.charAt(0);
        char last = value.charAt(len - 1);
        if (first != ' ' && first != '\t' && last != ' ' && last != '\t' && value.indexOf(34) < 0 && value.indexOf(44) < 0 && value.indexOf(13) < 0 && value.indexOf(10) < 0) {
            output.append(value);
            return;
        }
        output.append('\"').append(value.replace("\"", "\"\"")).append('\"');
    }

    public static boolean parseLine(BufferedReader reader, List<String> out) throws IOException {
        int comma;
        String text = reader.readLine();
        if (text == null) {
            return false;
        }
        int pos = 0;
        do {
            StringBuilder buf = new StringBuilder();
            while (true) {
                comma = text.indexOf(44, pos);
                int quote = text.indexOf(34, pos);
                if (quote == -1 || comma != -1 && comma < quote) break;
                if (pos > 0 && text.charAt(pos - 1) == '\"') {
                    buf.append('\"');
                }
                buf.append(text, pos, quote);
                while ((quote = text.indexOf(34, pos = quote + 1)) == -1) {
                    buf.append(text, pos, text.length()).append('\n');
                    text = reader.readLine();
                    if (text == null) {
                        out.add(buf.toString());
                        return true;
                    }
                    quote = -1;
                }
                buf.append(text, pos, quote);
                pos = quote + 1;
            }
            buf.append(text, pos, comma == -1 ? text.length() : comma);
            out.add(buf.toString());
        } while ((pos = comma + 1) > 0);
        return true;
    }

    private Csv() {
    }
}

