/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.common;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Scroller;
import java.util.ArrayList;
import java.util.HashMap;

public class SwipeySwitcher
extends ViewGroup {
    float mLastTouchX;
    private static final float MOVE_THRESHOLD = 0.2f;
    private static final int VIEW_CACHE_SIZE = 3;
    private IViewHolder[] mViews = new IViewHolder[3];
    private Adapter mAdapter;
    private int mSelection;
    private Context mContext;
    private int mNextSelection;
    private boolean mCenterOnLayout = true;
    private Handler mHandler = new Handler();
    private GestureDetector mGestureDetector;
    private Scroller mScroller;
    private ObserverCallbacks mObserver;
    private boolean mAnimatingScroll;
    private boolean mClearAnimatingScroll;
    private int mDownX;
    private int mDownY;
    private int mLockDirection;
    private static final int NO_DIRECTION = 0;
    private static final int LEFT_RIGHT_DIRECTION = 1;
    private static final int UP_DOWN_DIRECTION = 2;
    private SimpleViewCache mFakes = new SimpleViewCache(new IMakeView(){

        public View makeView() {
            return new View(SwipeySwitcher.this.mContext);
        }
    });
    private SimpleViewCache mPlaceholders = new SimpleViewCache(new IMakeView(){

        public View makeView() {
            View v = new View(SwipeySwitcher.this.mContext);
            return v;
        }
    });
    Runnable mRefreshRunnable = new Runnable(){

        public void run() {
            if (SwipeySwitcher.this.mAdapter == null) {
                return;
            }
            for (int viewslot = 0; viewslot < SwipeySwitcher.this.mViews.length; ++viewslot) {
                Intent intent;
                IViewHolder ivh = SwipeySwitcher.this.mViews[viewslot];
                if (!SwipeySwitcher.this.mPlaceholders.memberOf(ivh) || (intent = ivh.getIntent()) == null) continue;
                int viewPosition = SwipeySwitcher.this.mSelection + viewslot - 1;
                IViewHolder newVh = SwipeySwitcher.this.mAdapter.getView(SwipeySwitcher.this.wrap(viewPosition), SwipeySwitcher.this);
                if (newVh == null) continue;
                if (SwipeySwitcher.this.getChildCount() > viewslot) {
                    SwipeySwitcher.this.mViews[viewslot].stop();
                    SwipeySwitcher.this.removeViewAt(viewslot);
                }
                SwipeySwitcher.this.installView(newVh, viewslot);
            }
            if (SwipeySwitcher.this.mViews[1] != null) {
                SwipeySwitcher.this.mViews[1].focus();
            }
        }
    };
    static final int[] sOrderLeft = new int[]{1, 2, 0};
    static final int[] sOrderRight = new int[]{1, 0, 2};
    final HashMap<String, IViewHolder> mReuseCache = new HashMap();
    ScrollRunnable mAnimateScrollRunnable = new ScrollRunnable();

    public void clear() {
        for (int i = 0; i < this.mViews.length; ++i) {
            IViewHolder ivh = this.mViews[i];
            if (ivh == null) continue;
            ivh.stop();
            this.mViews[i] = null;
        }
    }

    private void recenter() {
        this.scrollTo(this.getWidth(), 0);
    }

    private int wrap(int x) {
        if (this.mAdapter == null) {
            return x;
        }
        int count = this.mAdapter.getCount();
        if (count == 0) {
            return x;
        }
        if (x < 0) {
            x = count - -x % count;
        }
        return x %= count;
    }

    private int nextSelection(boolean forward) {
        return forward ? this.mSelection + 1 : this.mSelection - 1;
    }

    private void recenterAndSelect(boolean forward, Runnable onDoneRunnable, int duration) {
        int nextSelection;
        this.mNextSelection = nextSelection = this.nextSelection(forward);
        this.mAnimateScrollRunnable.mOnDoneRunnable = onDoneRunnable;
        if (!forward) {
            this.mScroller.startScroll(this.getScrollX(), 0, -this.getScrollX(), 0, duration);
            this.mHandler.post((Runnable)this.mAnimateScrollRunnable);
        } else {
            this.mScroller.startScroll(this.getScrollX(), 0, 2 * this.getWidth() - this.getScrollX(), 0, duration);
            this.mHandler.post((Runnable)this.mAnimateScrollRunnable);
        }
    }

    private void recenterAndSelect(boolean forward) {
        this.recenterAndSelect(forward, null, 400);
    }

    public void selectNext(boolean forward, Runnable onDone, int duration) {
        this.recenterAndSelect(forward, onDone, duration);
    }

    private void swapLeftRight() {
        IViewHolder temp = this.mViews[0];
        this.mViews[0] = this.mViews[2];
        this.mViews[2] = temp;
        this.requestLayout();
    }

    private void ensureLeft() {
        if (this.mAdapter != null && this.mAdapter.getCount() == 2 && this.mFakes.memberOf(this.mViews[0])) {
            this.swapLeftRight();
        }
    }

    private void ensureRight() {
        if (this.mAdapter != null && this.mAdapter.getCount() == 2 && this.mFakes.memberOf(this.mViews[2])) {
            this.swapLeftRight();
        }
    }

    private GestureDetector makeGestureDetector() {
        GestureDetector.OnGestureListener listener = new GestureDetector.OnGestureListener(){

            public boolean onDown(MotionEvent e) {
                SwipeySwitcher.this.createScrollingCaches();
                return true;
            }

            private boolean canGoLeft() {
                int count = SwipeySwitcher.this.mAdapter.getCount();
                return count > 1;
            }

            private boolean canGoRight() {
                int count = SwipeySwitcher.this.mAdapter.getCount();
                return count > 1;
            }

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                boolean forward;
                if (velocityX == 0.0f) {
                    return false;
                }
                if (velocityX > 0.0f && !this.canGoLeft()) {
                    return false;
                }
                if (velocityX < 0.0f && !this.canGoRight()) {
                    return false;
                }
                boolean bl = forward = velocityX < 0.0f;
                if (forward) {
                    SwipeySwitcher.this.ensureRight();
                } else {
                    SwipeySwitcher.this.ensureLeft();
                }
                SwipeySwitcher.this.recenterAndSelect(forward);
                return true;
            }

            public void onLongPress(MotionEvent e) {
            }

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                int target = SwipeySwitcher.this.getScrollX() + (int)distanceX;
                if (target < SwipeySwitcher.this.getWidth() && !this.canGoLeft()) {
                    target = SwipeySwitcher.this.getWidth();
                } else if (target > SwipeySwitcher.this.getWidth() && !this.canGoRight()) {
                    target = SwipeySwitcher.this.getWidth();
                }
                SwipeySwitcher.this.scrollTo(target, 0);
                if (SwipeySwitcher.this.mAdapter != null && SwipeySwitcher.this.mAdapter.getCount() == 2) {
                    boolean swap = false;
                    int width = SwipeySwitcher.this.getWidth();
                    if (target < width && SwipeySwitcher.this.mViews[0] instanceof ViewHolder) {
                        swap = true;
                    } else if (target > width && SwipeySwitcher.this.mViews[2] instanceof ViewHolder) {
                        swap = true;
                    }
                    if (swap) {
                        SwipeySwitcher.this.swapLeftRight();
                    }
                }
                return true;
            }

            public void onShowPress(MotionEvent e) {
            }

            public boolean onSingleTapUp(MotionEvent e) {
                return false;
            }
        };
        return new GestureDetector(this.mContext, listener);
    }

    public SwipeySwitcher(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mGestureDetector = this.makeGestureDetector();
        this.mScroller = new Scroller(this.getContext());
        this.mContext = context;
    }

    public SwipeySwitcher(Context context) {
        super(context);
        this.mGestureDetector = this.makeGestureDetector();
        this.mScroller = new Scroller(this.getContext());
        this.mContext = context;
    }

    public void setOnTouchCallback(ObserverCallbacks cb) {
        this.mObserver = cb;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthSpecSize, (int)0x40000000);
            int childheightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)heightSpecSize, (int)0x40000000);
            child.measure(childWidthMeasureSpec, childheightMeasureSpec);
        }
        this.setMeasuredDimension(widthSpecSize, heightSpecSize);
    }

    private void installView(IViewHolder vh, int slot) {
        int mywidth = this.getWidth();
        int myheight = this.getHeight();
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
        View v = vh.get();
        this.addViewInLayout(v, slot, lp, true);
        v.layout(mywidth * slot, 0, mywidth * slot + mywidth, myheight);
        this.mViews[slot] = vh;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int mywidth = this.getWidth();
        int count = this.mAdapter != null ? this.mAdapter.getCount() : 0;
        this.removeAllViews();
        if (this.mAdapter == null) {
            return;
        }
        this.mSelection = this.mNextSelection;
        HashMap<String, IViewHolder> cache = this.mReuseCache;
        cache.clear();
        for (int i = 0; i < 3; ++i) {
            Intent key;
            IViewHolder ivh = this.mViews[i];
            this.mViews[i] = null;
            if (ivh == null || (key = ivh.getIntent()) == null) continue;
            cache.put(key.getDataString(), ivh);
        }
        int[] order = this.getScrollX() > this.getWidth() ? sOrderLeft : sOrderRight;
        for (int i = 0; i < order.length; ++i) {
            String key;
            IViewHolder ivh;
            int viewslot = order[i];
            int viewPosition = this.mSelection + viewslot - 1;
            Intent intent = this.mAdapter.getIntent(this.wrap(viewPosition));
            if (intent == null || (ivh = cache.get(key = intent.getDataString())) == null) continue;
            cache.remove(key);
            this.mViews[viewslot] = ivh;
            if (viewslot == 1) continue;
            this.mViews[viewslot].unfocus();
        }
        if (cache.size() > 0) {
            for (String key : cache.keySet()) {
                IViewHolder ivh = cache.get(key);
                ivh.stop();
            }
        }
        for (int i = -1; i <= 1; ++i) {
            int slot = i + 1;
            IViewHolder vh = this.mViews[slot];
            if (vh == null) {
                boolean useFake = false;
                switch (count) {
                    case 1: {
                        useFake = i != 0;
                        break;
                    }
                    case 2: {
                        if (i == -1) {
                            useFake = this.mViews[2] != null && !this.mFakes.memberOf(this.mViews[2]);
                            break;
                        }
                        if (i != 1) break;
                        useFake = this.mViews[0] != null && !this.mFakes.memberOf(this.mViews[0]);
                        break;
                    }
                    default: {
                        useFake = false;
                    }
                }
                if (useFake) {
                    vh = this.mFakes.get(null);
                } else {
                    int viewPosition = this.wrap(this.mSelection + i);
                    if (i == 0 && count > 0) {
                        vh = this.mAdapter.getView(viewPosition, this);
                    }
                    if (vh == null) {
                        vh = this.mPlaceholders.get(this.mAdapter.getIntent(viewPosition));
                    }
                }
                this.mViews[i + 1] = vh;
            }
            this.installView(vh, slot);
        }
        if (this.mCenterOnLayout) {
            this.scrollTo(mywidth, 0);
        }
        if (this.mViews[1] != null) {
            this.mViews[1].focus();
        }
        this.mHandler.post(this.mRefreshRunnable);
        if (this.mClearAnimatingScroll) {
            this.mAnimatingScroll = false;
            this.mClearAnimatingScroll = false;
        }
    }

    public void foreachView(ViewRunnable vr) {
        for (int i = 0; i < 3 && (this.mViews[i] == null || this.mViews[i].run(vr)); ++i) {
        }
    }

    public int getCount() {
        return this.getAdapter().getCount();
    }

    public View getSelectedViewAdjacent(boolean forward) {
        IViewHolder ivh = this.mViews[forward ? 2 : 0];
        if (ivh != null) {
            return ivh.get();
        }
        return null;
    }

    public View getSelectedView() {
        if (this.mViews[1] != null) {
            return this.mViews[1].get();
        }
        return null;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        View focus = this.getSelectedView();
        if (focus != null) {
            return focus.dispatchKeyEvent(event);
        }
        return super.dispatchKeyEvent(event);
    }

    private void createScrollingCaches() {
        for (IViewHolder ivh : this.mViews) {
            if (ivh == null) continue;
            ivh.createScrollingCache();
        }
    }

    private void clearScrollingCaches() {
        for (IViewHolder ivh : this.mViews) {
            if (ivh == null) continue;
            ivh.clearScrollingCache();
        }
    }

    private float moveFactor() {
        int width = this.getWidth();
        int scrollX = this.getScrollX() - width;
        float moveFactor = (float)scrollX / (float)width;
        return moveFactor;
    }

    public boolean dispatchTouchEvent(MotionEvent m) {
        if (this.mAnimatingScroll) {
            return true;
        }
        switch (m.getAction()) {
            case 0: {
                this.mCenterOnLayout = false;
                this.mGestureDetector.onTouchEvent(m);
                this.mDownX = (int)m.getX();
                this.mDownY = (int)m.getY();
                this.mLockDirection = 0;
                if (this.mObserver == null) break;
                this.mObserver.onStartReveal();
                break;
            }
            case 2: {
                int newaction = m.getAction();
                if (this.mLockDirection == 0) {
                    int deltaX = Math.abs((int)m.getX() - this.mDownX);
                    int deltaY = Math.abs((int)m.getY() - this.mDownY);
                    int minimumLatchMotion = 25;
                    if (deltaX > 25 && deltaY < deltaX) {
                        this.mLockDirection = 1;
                        newaction = 3;
                    } else if (deltaY > 25 && deltaX < deltaY) {
                        this.mLockDirection = 2;
                        this.scrollTo(this.getWidth(), 0);
                    }
                }
                if (this.mLockDirection != 2) {
                    this.mGestureDetector.onTouchEvent(m);
                }
                if (this.mObserver != null) {
                    float moveFactor = this.moveFactor();
                    boolean commit = false;
                    if (moveFactor > 0.2f || moveFactor < -0.2f) {
                        commit = true;
                    }
                    this.mObserver.onRevealChange((float)this.getScrollX() / (float)this.getWidth() - 1.0f, commit);
                }
                m.setAction(newaction);
                break;
            }
            case 1: {
                this.mCenterOnLayout = true;
                boolean consumed = this.mGestureDetector.onTouchEvent(m);
                this.clearScrollingCaches();
                if (!consumed) {
                    float moveFactor = this.moveFactor();
                    if (moveFactor > 0.2f) {
                        this.recenterAndSelect(true);
                    } else if (moveFactor < -0.2f) {
                        this.recenterAndSelect(false);
                    } else {
                        this.recenter();
                    }
                }
                if (this.mObserver == null) break;
                this.mObserver.onStopReveal();
                break;
            }
            case 3: {
                if (this.mObserver == null) break;
                this.mObserver.onStopReveal();
            }
        }
        if (this.mLockDirection != 1) {
            return super.dispatchTouchEvent(m);
        }
        return true;
    }

    public Adapter getAdapter() {
        return this.mAdapter;
    }

    public void setAdapter(Adapter a) {
        this.mAdapter = a;
        if (a == null) {
            for (int i = 0; i < 3; ++i) {
                if (this.mViews[i] == null) continue;
                this.mViews[i].stop();
                this.mViews[i] = null;
            }
        }
        this.mNextSelection = 0;
        this.mSelection = 0;
        this.requestLayout();
        this.mHandler.removeCallbacks((Runnable)this.mAnimateScrollRunnable);
    }

    public int getSelectedItemPosition() {
        return this.wrap(this.mNextSelection);
    }

    public void setSelection(int position) {
        if (this.mAdapter == null) {
            return;
        }
        this.mNextSelection = position;
        this.mCenterOnLayout = true;
        this.requestLayout();
        if (this.mObserver != null) {
            this.mObserver.onSelection(this.mAdapter.getIntent(this.wrap(position)));
        }
    }

    class ScrollRunnable
    implements Runnable {
        Runnable mOnDoneRunnable;

        ScrollRunnable() {
        }

        public void run() {
            if (SwipeySwitcher.this.mScroller.computeScrollOffset()) {
                SwipeySwitcher.this.mAnimatingScroll = true;
                SwipeySwitcher.this.scrollTo(SwipeySwitcher.this.mScroller.getCurrX(), 0);
                SwipeySwitcher.this.postInvalidate();
                SwipeySwitcher.this.mHandler.post((Runnable)this);
            } else {
                SwipeySwitcher.this.scrollTo(SwipeySwitcher.this.mScroller.getCurrX(), 0);
                SwipeySwitcher.this.setSelection(SwipeySwitcher.this.mNextSelection);
                SwipeySwitcher.this.mClearAnimatingScroll = true;
                if (this.mOnDoneRunnable != null) {
                    this.mOnDoneRunnable.run();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewHolder
    implements IViewHolder {
        private View mView;
        private Intent mIntent;
        ArrayList<IViewHolder> mAvailable;
        ArrayList<IViewHolder> mInUse;

        public ViewHolder(View v, ArrayList<IViewHolder> available, ArrayList<IViewHolder> inUse) {
            this.mView = v;
            this.mAvailable = available;
            this.mInUse = inUse;
        }

        public ViewHolder(View v) {
            this.mView = v;
        }

        @Override
        public void focus() {
        }

        @Override
        public View get() {
            return this.mView;
        }

        @Override
        public void stop() {
            if (this.mInUse != null) {
                this.mInUse.remove(this);
            }
            if (this.mAvailable != null) {
                this.mAvailable.add(this);
            }
        }

        @Override
        public void unfocus() {
        }

        public String getTitle() {
            return "";
        }

        @Override
        public void createScrollingCache() {
        }

        @Override
        public void clearScrollingCache() {
        }

        @Override
        public boolean run(ViewRunnable vr) {
            return true;
        }

        @Override
        public Intent getIntent() {
            return this.mIntent;
        }
    }

    public static interface ObserverCallbacks {
        public void onRevealChange(float var1, boolean var2);

        public void onStartReveal();

        public void onStopReveal();

        public void onSelection(Intent var1);
    }

    public static interface Adapter {
        public IViewHolder getView(int var1, ViewGroup var2);

        public Intent getIntent(int var1);

        public int getCount();
    }

    public static interface IViewHolder {
        public void stop();

        public void focus();

        public void unfocus();

        public View get();

        public void createScrollingCache();

        public void clearScrollingCache();

        public boolean run(ViewRunnable var1);

        public Intent getIntent();
    }

    public static interface ViewRunnable {
        public boolean run(View var1);
    }

    class SimpleViewCache {
        private ArrayList<IViewHolder> mAvailable = new ArrayList();
        private ArrayList<IViewHolder> mInUse = new ArrayList();
        private IMakeView mMaker;

        SimpleViewCache(IMakeView maker) {
            this.mMaker = maker;
        }

        IViewHolder get(Intent intent) {
            if (this.mAvailable.size() == 0) {
                this.mAvailable.add(new ViewHolder(this.mMaker.makeView(), this.mAvailable, this.mInUse));
            }
            IViewHolder retval = this.mAvailable.remove(this.mAvailable.size() - 1);
            this.mInUse.add(retval);
            ((ViewHolder)retval).mIntent = intent;
            return retval;
        }

        boolean memberOf(IViewHolder v) {
            return this.mInUse.contains(v) || this.mAvailable.contains(v);
        }
    }

    static interface IMakeView {
        public View makeView();
    }
}

