/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.common.http;

import android.content.ContentResolver;
import android.content.Context;
import android.net.TrafficStats;
import android.net.http.AndroidHttpClient;
import android.os.Build;
import android.os.Process;
import android.os.SystemClock;
import android.util.EventLog;
import android.util.Log;
import com.google.android.common.http.NetworkStatsEntity;
import com.google.android.common.http.UrlRules;
import com.google.android.gsf.Gservices;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.LayeredSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.impl.client.EntityEnclosingRequestWrapper;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleHttpClient
implements HttpClient {
    private static final String TAG = "GoogleHttpClient";
    private static final boolean LOCAL_LOGV = false;
    private final AndroidHttpClient mClient;
    private final ContentResolver mResolver;
    private final String mAppName;
    private final String mUserAgent;
    private final ThreadLocal<Boolean> mConnectionAllocated = new ThreadLocal();

    public GoogleHttpClient(Context context, String appAndVersion, boolean gzipCapable) {
        String userAgent = appAndVersion + " (" + Build.DEVICE + " " + Build.ID + ")";
        if (gzipCapable) {
            userAgent = userAgent + "; gzip";
        }
        this.mClient = AndroidHttpClient.newInstance((String)userAgent, (Context)context);
        this.mResolver = context.getContentResolver();
        this.mAppName = appAndVersion;
        this.mUserAgent = userAgent;
        SchemeRegistry registry = this.getConnectionManager().getSchemeRegistry();
        for (String name : registry.getSchemeNames()) {
            Scheme scheme = registry.unregister(name);
            SocketFactory sf = scheme.getSocketFactory();
            sf = sf instanceof LayeredSocketFactory ? new WrappedLayeredSocketFactory((LayeredSocketFactory)sf) : new WrappedSocketFactory(sf);
            registry.register(new Scheme(name, sf, scheme.getDefaultPort()));
        }
    }

    public void close() {
        this.mClient.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse executeWithoutRewriting(HttpUriRequest request, HttpContext context) throws IOException {
        HttpResponse httpResponse;
        int code = -1;
        long start = SystemClock.elapsedRealtime();
        try {
            HttpResponse response;
            this.mConnectionAllocated.set(null);
            if (Gservices.getBoolean(this.mResolver, "http_stats", false)) {
                HttpEntity origEntity;
                int uid = Process.myUid();
                long startTx = TrafficStats.getUidTxBytes((int)uid);
                long startRx = TrafficStats.getUidRxBytes((int)uid);
                response = this.mClient.execute(request, context);
                HttpEntity httpEntity = origEntity = response == null ? null : response.getEntity();
                if (origEntity != null) {
                    long now = SystemClock.elapsedRealtime();
                    long elapsed = now - start;
                    NetworkStatsEntity entity = new NetworkStatsEntity(origEntity, this.mAppName, uid, startTx, startRx, elapsed, now);
                    response.setEntity((HttpEntity)entity);
                }
            } else {
                response = this.mClient.execute(request, context);
            }
            code = response.getStatusLine().getStatusCode();
            httpResponse = response;
        }
        catch (Throwable throwable) {
            try {
                long elapsed = SystemClock.elapsedRealtime() - start;
                int reused = this.mConnectionAllocated.get() == null && code >= 0 ? 1 : 0;
                EventLog.writeEvent((int)203002, (Object[])new Object[]{elapsed, code, this.mAppName, reused});
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Error recording stats", (Throwable)e);
            }
            throw throwable;
        }
        try {
            long elapsed = SystemClock.elapsedRealtime() - start;
            int reused = this.mConnectionAllocated.get() == null && code >= 0 ? 1 : 0;
            EventLog.writeEvent((int)203002, (Object[])new Object[]{elapsed, code, this.mAppName, reused});
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error recording stats", (Throwable)e);
        }
        return httpResponse;
    }

    public String rewriteURI(String original) {
        UrlRules rules = UrlRules.getRules(this.mResolver);
        UrlRules.Rule rule = rules.matchRule(original);
        return rule.apply(original);
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException {
        URI uri = request.getURI();
        String original = uri.toString();
        UrlRules rules = UrlRules.getRules(this.mResolver);
        UrlRules.Rule rule = rules.matchRule(original);
        String rewritten = rule.apply(original);
        if (rewritten == null) {
            Log.w((String)TAG, (String)("Blocked by " + rule.mName + ": " + original));
            throw new BlockedRequestException(rule);
        }
        if (rewritten == original) {
            return this.executeWithoutRewriting(request, context);
        }
        try {
            uri = new URI(rewritten);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Bad URL from rule: " + rule.mName, e);
        }
        RequestWrapper wrapper = GoogleHttpClient.wrapRequest(request);
        wrapper.setURI(uri);
        request = wrapper;
        return this.executeWithoutRewriting(request, context);
    }

    private static RequestWrapper wrapRequest(HttpUriRequest request) throws IOException {
        try {
            Object wrapped = request instanceof HttpEntityEnclosingRequest ? new EntityEnclosingRequestWrapper((HttpEntityEnclosingRequest)request) : new RequestWrapper((HttpRequest)request);
            wrapped.resetHeaders();
            return wrapped;
        }
        catch (ProtocolException e) {
            throw new ClientProtocolException((Throwable)e);
        }
    }

    public static String getGzipCapableUserAgent(String originalUserAgent) {
        return originalUserAgent + "; gzip";
    }

    public HttpParams getParams() {
        return this.mClient.getParams();
    }

    public ClientConnectionManager getConnectionManager() {
        return this.mClient.getConnectionManager();
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException {
        return this.execute(request, (HttpContext)null);
    }

    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException {
        return this.mClient.execute(target, request);
    }

    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        return this.mClient.execute(target, request, context);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)this.mClient.execute(request, responseHandler);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        return (T)this.mClient.execute(request, responseHandler, context);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)this.mClient.execute(target, request, responseHandler);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        return (T)this.mClient.execute(target, request, responseHandler, context);
    }

    public void enableCurlLogging(String name, int level) {
        this.mClient.enableCurlLogging(name, level);
    }

    public void disableCurlLogging() {
        this.mClient.disableCurlLogging();
    }

    private class WrappedLayeredSocketFactory
    extends WrappedSocketFactory
    implements LayeredSocketFactory {
        private LayeredSocketFactory mDelegate;

        private WrappedLayeredSocketFactory(LayeredSocketFactory sf) {
            super((SocketFactory)sf);
            this.mDelegate = sf;
        }

        public final Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            return this.mDelegate.createSocket(s, host, port, autoClose);
        }
    }

    private class WrappedSocketFactory
    implements SocketFactory {
        private SocketFactory mDelegate;

        private WrappedSocketFactory(SocketFactory delegate) {
            this.mDelegate = delegate;
        }

        public final Socket createSocket() throws IOException {
            return this.mDelegate.createSocket();
        }

        public final boolean isSecure(Socket s) {
            return this.mDelegate.isSecure(s);
        }

        public final Socket connectSocket(Socket s, String h, int p, InetAddress la, int lp, HttpParams params) throws IOException {
            GoogleHttpClient.this.mConnectionAllocated.set(Boolean.TRUE);
            return this.mDelegate.connectSocket(s, h, p, la, lp, params);
        }
    }

    public static class BlockedRequestException
    extends IOException {
        private final UrlRules.Rule mRule;

        BlockedRequestException(UrlRules.Rule rule) {
            super("Blocked by rule: " + rule.mName);
            this.mRule = rule;
        }
    }
}

