/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.common.http;

import java.io.IOException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;

public class TestHttpClient {
    private final HttpParams params = new BasicHttpParams();
    private final BasicHttpProcessor httpproc;
    private final HttpRequestExecutor httpexecutor;
    private final ConnectionReuseStrategy connStrategy;
    private final HttpContext context;

    public TestHttpClient() {
        this.params.setIntParameter("http.socket.timeout", 5000).setBooleanParameter("http.connection.stalecheck", false).setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1).setParameter("http.useragent", (Object)"TEST-CLIENT/1.1");
        this.httpproc = new BasicHttpProcessor();
        this.httpproc.addInterceptor((HttpRequestInterceptor)new RequestContent());
        this.httpproc.addInterceptor((HttpRequestInterceptor)new RequestTargetHost());
        this.httpproc.addInterceptor((HttpRequestInterceptor)new RequestConnControl());
        this.httpproc.addInterceptor((HttpRequestInterceptor)new RequestUserAgent());
        this.httpproc.addInterceptor((HttpRequestInterceptor)new RequestExpectContinue());
        this.httpexecutor = new HttpRequestExecutor();
        this.connStrategy = new DefaultConnectionReuseStrategy();
        this.context = new BasicHttpContext(null);
    }

    public HttpParams getParams() {
        return this.params;
    }

    public HttpResponse execute(HttpRequest request, HttpHost targetHost, HttpClientConnection conn) throws HttpException, IOException {
        this.context.setAttribute("http.request", (Object)request);
        this.context.setAttribute("http.target_host", (Object)targetHost);
        this.context.setAttribute("http.connection", (Object)conn);
        request.setParams((HttpParams)new DefaultedHttpParams(request.getParams(), this.params));
        this.httpexecutor.preProcess(request, (HttpProcessor)this.httpproc, this.context);
        HttpResponse response = this.httpexecutor.execute(request, conn, this.context);
        response.setParams((HttpParams)new DefaultedHttpParams(response.getParams(), this.params));
        this.httpexecutor.postProcess(response, (HttpProcessor)this.httpproc, this.context);
        return response;
    }

    public boolean keepAlive(HttpResponse response) {
        return this.connStrategy.keepAlive(response, this.context);
    }
}

