/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.common.http;

import android.content.ContentResolver;
import android.util.Log;
import com.google.android.gsf.Gservices;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlRules {
    public static final String TAG = "UrlRules";
    private static final Pattern PATTERN_SPACE_PLUS = Pattern.compile(" +");
    private static final Pattern RULE_PATTERN = Pattern.compile("\\W");
    private static UrlRules sCachedRules = new UrlRules(new Rule[0]);
    private static Object sCachedVersionToken;
    private final Rule[] mRules;
    private final Pattern mPattern;

    public UrlRules(Rule[] rules) {
        Arrays.sort(rules);
        StringBuilder pattern = new StringBuilder("(");
        for (int i = 0; i < rules.length; ++i) {
            if (i > 0) {
                pattern.append(")|(");
            }
            pattern.append(RULE_PATTERN.matcher(rules[i].mPrefix).replaceAll("\\\\$0"));
        }
        this.mPattern = Pattern.compile(pattern.append(")").toString());
        this.mRules = rules;
    }

    public Rule matchRule(String url) {
        Matcher matcher = this.mPattern.matcher(url);
        if (matcher.lookingAt()) {
            for (int i = 0; i < this.mRules.length; ++i) {
                if (matcher.group(i + 1) == null) continue;
                return this.mRules[i];
            }
        }
        return Rule.DEFAULT;
    }

    public static synchronized UrlRules getRules(ContentResolver resolver) {
        Object versionToken = Gservices.getVersionToken(resolver);
        if (versionToken == sCachedVersionToken) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("Using cached rules, versionToken: " + versionToken));
            }
            return sCachedRules;
        }
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)"Scanning for Gservices \"url:*\" rules");
        }
        Map<String, String> urlRules = Gservices.getStringsByPrefix(resolver, "url:");
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Map.Entry<String, String> e : urlRules.entrySet()) {
            try {
                String name = e.getKey().substring(4);
                String value = e.getValue();
                if (value == null || value.length() == 0) continue;
                if (Log.isLoggable((String)TAG, (int)2)) {
                    Log.v((String)TAG, (String)("  Rule " + name + ": " + value));
                }
                rules.add(new Rule(name, value));
            }
            catch (RuleFormatException exc) {
                Log.e((String)TAG, (String)"Invalid rule from Gservices", (Throwable)exc);
            }
        }
        sCachedRules = new UrlRules(rules.toArray(new Rule[rules.size()]));
        sCachedVersionToken = versionToken;
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("New rules stored, versionToken: " + versionToken));
        }
        return sCachedRules;
    }

    public static class Rule
    implements Comparable {
        public final String mName;
        public final String mPrefix;
        public final String mRewrite;
        public final boolean mBlock;
        public static final Rule DEFAULT = new Rule();

        public Rule(String name, String rule) throws RuleFormatException {
            this.mName = name;
            String[] words = PATTERN_SPACE_PLUS.split(rule);
            if (words.length == 0) {
                throw new RuleFormatException("Empty rule");
            }
            this.mPrefix = words[0];
            String rewrite = null;
            boolean block = false;
            int pos = 1;
            while (pos < words.length) {
                String word = words[pos].toLowerCase();
                if (word.equals("rewrite") && pos + 1 < words.length) {
                    rewrite = words[pos + 1];
                    pos += 2;
                    continue;
                }
                if (word.equals("block")) {
                    block = true;
                    ++pos;
                    continue;
                }
                throw new RuleFormatException("Illegal rule: " + rule);
            }
            this.mRewrite = rewrite;
            this.mBlock = block;
        }

        private Rule() {
            this.mName = "DEFAULT";
            this.mPrefix = "";
            this.mRewrite = null;
            this.mBlock = false;
        }

        public String apply(String url) {
            if (this.mBlock) {
                return null;
            }
            if (this.mRewrite != null) {
                return this.mRewrite + url.substring(this.mPrefix.length());
            }
            return url;
        }

        public int compareTo(Object o) {
            return ((Rule)o).mPrefix.compareTo(this.mPrefix);
        }
    }

    public static class RuleFormatException
    extends Exception {
        public RuleFormatException(String msg) {
            super(msg);
        }
    }
}

