/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.gdata.calendar.parser.xml;

import com.google.wireless.gdata.calendar.data.CalendarEntry;
import com.google.wireless.gdata.calendar.data.CalendarsFeed;
import com.google.wireless.gdata.data.Entry;
import com.google.wireless.gdata.data.Feed;
import com.google.wireless.gdata.parser.ParseException;
import com.google.wireless.gdata.parser.xml.XmlGDataParser;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XmlCalendarsGDataParser
extends XmlGDataParser {
    public XmlCalendarsGDataParser(InputStream is, XmlPullParser parser) throws ParseException {
        super(is, parser);
    }

    protected Feed createFeed() {
        return new CalendarsFeed();
    }

    protected Entry createEntry() {
        return new CalendarEntry();
    }

    protected void handleExtraElementInEntry(Entry entry) throws XmlPullParserException, IOException {
        XmlPullParser parser = this.getParser();
        if (!(entry instanceof CalendarEntry)) {
            throw new IllegalArgumentException("Expected CalendarEntry!");
        }
        CalendarEntry calendarEntry = (CalendarEntry)entry;
        String name = parser.getName();
        if ("accesslevel".equals(name)) {
            String accesslevelStr = parser.getAttributeValue(null, "value");
            int accesslevel = 1;
            if ("none".equals(accesslevelStr)) {
                accesslevel = 0;
            } else if ("read".equals(accesslevelStr)) {
                accesslevel = 1;
            } else if ("freebusy".equals(accesslevelStr)) {
                accesslevel = 2;
            } else if ("contributor".equals(accesslevelStr)) {
                accesslevel = 3;
            } else if ("editor".equals(accesslevelStr)) {
                accesslevel = 3;
            } else if ("owner".equals(accesslevelStr)) {
                accesslevel = 4;
            } else if ("root".equals(accesslevelStr)) {
                accesslevel = 5;
            }
            calendarEntry.setAccessLevel((byte)accesslevel);
        } else if ("color".equals(name)) {
            String color = parser.getAttributeValue(null, "value");
            calendarEntry.setColor(color);
        } else if ("hidden".equals(name)) {
            String hiddenStr = parser.getAttributeValue(null, "value");
            boolean hidden = false;
            if ("false".equals(hiddenStr)) {
                hidden = false;
            } else if ("true".equals(hiddenStr)) {
                hidden = true;
            }
            calendarEntry.setHidden(hidden);
            if (hidden) {
                calendarEntry.setSelected(false);
            }
        } else if ("selected".equals(name)) {
            String selectedStr = parser.getAttributeValue(null, "value");
            boolean selected = false;
            if ("false".equals(selectedStr)) {
                selected = false;
            } else if ("true".equals(selectedStr)) {
                selected = true;
            }
            calendarEntry.setSelected(selected);
        } else if ("timezone".equals(name)) {
            String timezone = parser.getAttributeValue(null, "value");
            calendarEntry.setTimezone(timezone);
        }
    }

    protected void handleExtraLinkInEntry(String rel, String type, String href, Entry entry) throws XmlPullParserException, IOException {
        if ("alternate".equals(rel) && "application/atom+xml".equals(type)) {
            CalendarEntry calendarEntry = (CalendarEntry)entry;
            calendarEntry.setAlternateLink(href);
        }
    }
}

