/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.gdata.contacts.parser.xml;

import com.google.wireless.gdata.client.GDataParserFactory;
import com.google.wireless.gdata.contacts.data.ContactEntry;
import com.google.wireless.gdata.contacts.data.GroupEntry;
import com.google.wireless.gdata.contacts.parser.xml.XmlContactsGDataParser;
import com.google.wireless.gdata.contacts.parser.xml.XmlGroupEntryGDataParser;
import com.google.wireless.gdata.contacts.serializer.xml.XmlContactEntryGDataSerializer;
import com.google.wireless.gdata.contacts.serializer.xml.XmlGroupEntryGDataSerializer;
import com.google.wireless.gdata.data.Entry;
import com.google.wireless.gdata.data.MediaEntry;
import com.google.wireless.gdata.parser.GDataParser;
import com.google.wireless.gdata.parser.ParseException;
import com.google.wireless.gdata.parser.xml.XmlMediaEntryGDataParser;
import com.google.wireless.gdata.parser.xml.XmlParserFactory;
import com.google.wireless.gdata.serializer.GDataSerializer;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XmlContactsGDataParserFactory
implements GDataParserFactory {
    private final XmlParserFactory xmlFactory;

    public XmlContactsGDataParserFactory(XmlParserFactory xmlFactory) {
        this.xmlFactory = xmlFactory;
    }

    public GDataParser createGroupEntryFeedParser(InputStream is) throws ParseException {
        XmlPullParser xmlParser;
        try {
            xmlParser = this.xmlFactory.createParser();
        }
        catch (XmlPullParserException xppe) {
            throw new ParseException("Could not create XmlPullParser", xppe);
        }
        return new XmlGroupEntryGDataParser(is, xmlParser);
    }

    public GDataParser createMediaEntryFeedParser(InputStream is) throws ParseException {
        XmlPullParser xmlParser;
        try {
            xmlParser = this.xmlFactory.createParser();
        }
        catch (XmlPullParserException xppe) {
            throw new ParseException("Could not create XmlPullParser", xppe);
        }
        return new XmlMediaEntryGDataParser(is, xmlParser);
    }

    public GDataParser createParser(InputStream is) throws ParseException {
        XmlPullParser xmlParser;
        try {
            xmlParser = this.xmlFactory.createParser();
        }
        catch (XmlPullParserException xppe) {
            throw new ParseException("Could not create XmlPullParser", xppe);
        }
        return new XmlContactsGDataParser(is, xmlParser);
    }

    public GDataParser createParser(Class entryClass, InputStream is) throws ParseException {
        if (entryClass == ContactEntry.class) {
            return this.createParser(is);
        }
        if (entryClass == GroupEntry.class) {
            return this.createGroupEntryFeedParser(is);
        }
        if (entryClass == MediaEntry.class) {
            return this.createMediaEntryFeedParser(is);
        }
        throw new IllegalArgumentException("unexpected feed type, " + entryClass.getName());
    }

    public GDataSerializer createSerializer(Entry entry) {
        if (entry instanceof ContactEntry) {
            ContactEntry contactEntry = (ContactEntry)entry;
            return new XmlContactEntryGDataSerializer(this.xmlFactory, contactEntry);
        }
        if (entry instanceof GroupEntry) {
            GroupEntry groupEntry = (GroupEntry)entry;
            return new XmlGroupEntryGDataSerializer(this.xmlFactory, groupEntry);
        }
        throw new IllegalArgumentException("unexpected entry type, " + entry.getClass().toString());
    }
}

