/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.gdata.serializer.xml;

import com.google.wireless.gdata.data.Entry;
import com.google.wireless.gdata.data.StringUtils;
import com.google.wireless.gdata.parser.ParseException;
import com.google.wireless.gdata.parser.xml.XmlParserFactory;
import com.google.wireless.gdata.serializer.GDataSerializer;
import java.io.IOException;
import java.io.OutputStream;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XmlEntryGDataSerializer
implements GDataSerializer {
    private final XmlParserFactory factory;
    private final Entry entry;

    public XmlEntryGDataSerializer(XmlParserFactory factory, Entry entry) {
        this.factory = factory;
        this.entry = entry;
    }

    protected Entry getEntry() {
        return this.entry;
    }

    public String getContentType() {
        return "application/atom+xml";
    }

    public void serialize(OutputStream out, int format) throws IOException, ParseException {
        XmlSerializer serializer = null;
        try {
            serializer = this.factory.createSerializer();
        }
        catch (XmlPullParserException e) {
            throw new ParseException("Unable to create XmlSerializer.", e);
        }
        serializer.setOutput(out, "UTF-8");
        serializer.startDocument("UTF-8", new Boolean(false));
        this.declareEntryNamespaces(serializer);
        serializer.startTag("http://www.w3.org/2005/Atom", "entry");
        this.serializeEntryContents(serializer, format);
        serializer.endTag("http://www.w3.org/2005/Atom", "entry");
        serializer.endDocument();
        serializer.flush();
    }

    private final void declareEntryNamespaces(XmlSerializer serializer) throws IOException {
        serializer.setPrefix("", "http://www.w3.org/2005/Atom");
        serializer.setPrefix("gd", "http://schemas.google.com/g/2005");
        this.declareExtraEntryNamespaces(serializer);
    }

    protected void declareExtraEntryNamespaces(XmlSerializer serializer) throws IOException {
    }

    private final void serializeEntryContents(XmlSerializer serializer, int format) throws ParseException, IOException {
        if (format != 1) {
            XmlEntryGDataSerializer.serializeId(serializer, this.entry.getId());
        }
        XmlEntryGDataSerializer.serializeTitle(serializer, this.entry.getTitle());
        if (format != 1) {
            XmlEntryGDataSerializer.serializeLink(serializer, "edit", this.entry.getEditUri(), null);
            XmlEntryGDataSerializer.serializeLink(serializer, "alternate", this.entry.getHtmlUri(), "text/html");
        }
        XmlEntryGDataSerializer.serializeSummary(serializer, this.entry.getSummary());
        XmlEntryGDataSerializer.serializeContent(serializer, this.entry.getContent());
        XmlEntryGDataSerializer.serializeAuthor(serializer, this.entry.getAuthor(), this.entry.getEmail());
        XmlEntryGDataSerializer.serializeCategory(serializer, this.entry.getCategory(), this.entry.getCategoryScheme());
        if (format == 0) {
            XmlEntryGDataSerializer.serializePublicationDate(serializer, this.entry.getPublicationDate());
        }
        if (format != 1) {
            XmlEntryGDataSerializer.serializeUpdateDate(serializer, this.entry.getUpdateDate());
        }
        this.serializeExtraEntryContents(serializer, format);
    }

    protected void serializeExtraEntryContents(XmlSerializer serializer, int format) throws ParseException, IOException {
    }

    private static void serializeId(XmlSerializer serializer, String id) throws IOException {
        if (StringUtils.isEmpty(id)) {
            return;
        }
        serializer.startTag(null, "id");
        serializer.text(id);
        serializer.endTag(null, "id");
    }

    private static void serializeTitle(XmlSerializer serializer, String title) throws IOException {
        if (StringUtils.isEmpty(title)) {
            return;
        }
        serializer.startTag(null, "title");
        serializer.text(title);
        serializer.endTag(null, "title");
    }

    public static void serializeLink(XmlSerializer serializer, String rel, String href, String type) throws IOException {
        if (StringUtils.isEmpty(href)) {
            return;
        }
        serializer.startTag(null, "link");
        serializer.attribute(null, "rel", rel);
        serializer.attribute(null, "href", href);
        if (!StringUtils.isEmpty(type)) {
            serializer.attribute(null, "type", type);
        }
        serializer.endTag(null, "link");
    }

    private static void serializeSummary(XmlSerializer serializer, String summary) throws IOException {
        if (StringUtils.isEmpty(summary)) {
            return;
        }
        serializer.startTag(null, "summary");
        serializer.text(summary);
        serializer.endTag(null, "summary");
    }

    private static void serializeContent(XmlSerializer serializer, String content) throws IOException {
        if (content == null) {
            return;
        }
        serializer.startTag(null, "content");
        serializer.attribute(null, "type", "text");
        serializer.text(content);
        serializer.endTag(null, "content");
    }

    private static void serializeAuthor(XmlSerializer serializer, String author, String email) throws IOException {
        if (StringUtils.isEmpty(author) || StringUtils.isEmpty(email)) {
            return;
        }
        serializer.startTag(null, "author");
        serializer.startTag(null, "name");
        serializer.text(author);
        serializer.endTag(null, "name");
        serializer.startTag(null, "email");
        serializer.text(email);
        serializer.endTag(null, "email");
        serializer.endTag(null, "author");
    }

    private static void serializeCategory(XmlSerializer serializer, String category, String categoryScheme) throws IOException {
        if (StringUtils.isEmpty(category) && StringUtils.isEmpty(categoryScheme)) {
            return;
        }
        serializer.startTag(null, "category");
        if (!StringUtils.isEmpty(category)) {
            serializer.attribute(null, "term", category);
        }
        if (!StringUtils.isEmpty(categoryScheme)) {
            serializer.attribute(null, "scheme", categoryScheme);
        }
        serializer.endTag(null, "category");
    }

    private static void serializePublicationDate(XmlSerializer serializer, String publicationDate) throws IOException {
        if (StringUtils.isEmpty(publicationDate)) {
            return;
        }
        serializer.startTag(null, "published");
        serializer.text(publicationDate);
        serializer.endTag(null, "published");
    }

    private static void serializeUpdateDate(XmlSerializer serializer, String updateDate) throws IOException {
        if (StringUtils.isEmpty(updateDate)) {
            return;
        }
        serializer.startTag(null, "updated");
        serializer.text(updateDate);
        serializer.endTag(null, "updated");
    }
}

