/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.gdata2.client;

import com.google.wireless.gdata2.ConflictDetectedException;
import com.google.wireless.gdata2.client.AuthenticationException;
import com.google.wireless.gdata2.client.BadRequestException;
import com.google.wireless.gdata2.client.ForbiddenException;
import com.google.wireless.gdata2.client.GDataClient;
import com.google.wireless.gdata2.client.GDataParserFactory;
import com.google.wireless.gdata2.client.HttpException;
import com.google.wireless.gdata2.client.PreconditionFailedException;
import com.google.wireless.gdata2.client.QueryParams;
import com.google.wireless.gdata2.client.ResourceGoneException;
import com.google.wireless.gdata2.client.ResourceNotFoundException;
import com.google.wireless.gdata2.client.ResourceNotModifiedException;
import com.google.wireless.gdata2.data.Entry;
import com.google.wireless.gdata2.data.MediaEntry;
import com.google.wireless.gdata2.data.StringUtils;
import com.google.wireless.gdata2.parser.GDataParser;
import com.google.wireless.gdata2.parser.ParseException;
import com.google.wireless.gdata2.serializer.GDataSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

public abstract class GDataServiceClient {
    protected static String DEFAULT_GDATA_VERSION = "2.0";
    private final GDataClient gDataClient;
    private final GDataParserFactory gDataParserFactory;

    public GDataServiceClient(GDataClient gDataClient, GDataParserFactory gDataParserFactory) {
        this.gDataClient = gDataClient;
        this.gDataParserFactory = gDataParserFactory;
    }

    protected GDataClient getGDataClient() {
        return this.gDataClient;
    }

    public abstract String getProtocolVersion();

    protected GDataParserFactory getGDataParserFactory() {
        return this.gDataParserFactory;
    }

    public abstract String getServiceName();

    public QueryParams createQueryParams() {
        return this.gDataClient.createQueryParams();
    }

    public GDataParser getParserForFeed(Class feedEntryClass, String feedUrl, String authToken, String eTag) throws AuthenticationException, ResourceGoneException, ResourceNotModifiedException, HttpException, ParseException, IOException, ForbiddenException {
        try {
            InputStream is = this.gDataClient.getFeedAsStream(feedUrl, authToken, eTag, this.getProtocolVersion());
            return this.gDataParserFactory.createParser(feedEntryClass, is);
        }
        catch (HttpException e) {
            this.convertHttpExceptionForFeedReads("Could not fetch feed " + feedUrl, e);
            return null;
        }
    }

    public InputStream getMediaEntryAsStream(String mediaEntryUrl, String authToken, String eTag) throws AuthenticationException, ResourceGoneException, ResourceNotModifiedException, ResourceNotFoundException, HttpException, IOException, ForbiddenException {
        try {
            return this.gDataClient.getMediaEntryAsStream(mediaEntryUrl, authToken, eTag, this.getProtocolVersion());
        }
        catch (HttpException e) {
            this.convertHttpExceptionForEntryReads("Could not fetch media entry " + mediaEntryUrl, e);
            return null;
        }
    }

    public Entry createEntry(String feedUrl, String authToken, Entry entry) throws ConflictDetectedException, AuthenticationException, PreconditionFailedException, HttpException, ParseException, IOException, ForbiddenException, BadRequestException {
        GDataSerializer serializer = this.gDataParserFactory.createSerializer(entry);
        try {
            InputStream is = this.gDataClient.createEntry(feedUrl, authToken, this.getProtocolVersion(), serializer);
            return this.parseEntry(entry.getClass(), is);
        }
        catch (HttpException e) {
            try {
                this.convertHttpExceptionForWrites(entry.getClass(), "Could not create entry " + feedUrl, e);
            }
            catch (ResourceNotFoundException e1) {
                throw e;
            }
            return null;
        }
    }

    public Entry getEntry(Class entryClass, String id, String authToken, String eTag) throws AuthenticationException, ResourceNotFoundException, ResourceNotModifiedException, HttpException, ParseException, IOException, ForbiddenException {
        try {
            InputStream is = this.getGDataClient().getFeedAsStream(id, authToken, eTag, this.getProtocolVersion());
            return this.parseEntry(entryClass, is);
        }
        catch (HttpException e) {
            this.convertHttpExceptionForEntryReads("Could not fetch entry " + id, e);
            return null;
        }
    }

    public Entry updateEntry(Entry entry, String authToken) throws AuthenticationException, ConflictDetectedException, PreconditionFailedException, HttpException, ParseException, IOException, ForbiddenException, ResourceNotFoundException, BadRequestException {
        String editUri = entry.getEditUri();
        if (StringUtils.isEmpty(editUri)) {
            throw new ParseException("No edit URI -- cannot update.");
        }
        GDataSerializer serializer = this.gDataParserFactory.createSerializer(entry);
        try {
            InputStream is = this.gDataClient.updateEntry(editUri, authToken, entry.getETag(), this.getProtocolVersion(), serializer);
            return this.parseEntry(entry.getClass(), is);
        }
        catch (HttpException e) {
            this.convertHttpExceptionForWrites(entry.getClass(), "Could not update entry " + editUri, e);
            return null;
        }
    }

    public MediaEntry updateMediaEntry(String editUri, InputStream inputStream, String contentType, String authToken, String eTag) throws AuthenticationException, ConflictDetectedException, PreconditionFailedException, HttpException, ParseException, IOException, ForbiddenException, ResourceNotFoundException, BadRequestException {
        if (StringUtils.isEmpty(editUri)) {
            throw new IllegalArgumentException("No edit URI -- cannot update.");
        }
        try {
            InputStream is = this.gDataClient.updateMediaEntry(editUri, authToken, eTag, this.getProtocolVersion(), inputStream, contentType);
            return (MediaEntry)this.parseEntry(MediaEntry.class, is);
        }
        catch (HttpException e) {
            this.convertHttpExceptionForWrites(MediaEntry.class, "Could not update entry " + editUri, e);
            return null;
        }
    }

    public void deleteEntry(String editUri, String authToken, String eTag) throws AuthenticationException, ConflictDetectedException, PreconditionFailedException, HttpException, ParseException, IOException, ForbiddenException, ResourceNotFoundException, BadRequestException {
        try {
            this.gDataClient.deleteEntry(editUri, authToken, eTag);
        }
        catch (HttpException e) {
            if (e.getStatusCode() == 404) {
                return;
            }
            this.convertHttpExceptionForWrites(null, "Unable to delete " + editUri, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry parseEntry(Class entryClass, InputStream is) throws ParseException, IOException {
        GDataParser parser = null;
        try {
            parser = this.gDataParserFactory.createParser(entryClass, is);
            Entry entry = parser.parseStandaloneEntry();
            return entry;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    public GDataParser submitBatch(Class feedEntryClass, String batchUrl, String authToken, Enumeration entries) throws AuthenticationException, HttpException, ParseException, IOException, ForbiddenException, BadRequestException {
        GDataSerializer serializer = this.gDataParserFactory.createSerializer(entries);
        try {
            InputStream is = this.gDataClient.submitBatch(batchUrl, authToken, this.getProtocolVersion(), serializer);
            return this.gDataParserFactory.createParser(feedEntryClass, is);
        }
        catch (HttpException e) {
            this.convertHttpExceptionsForBatches("Could not submit batch " + batchUrl, e);
            return null;
        }
    }

    protected void convertHttpExceptionForFeedReads(String message, HttpException cause) throws AuthenticationException, ResourceGoneException, ResourceNotModifiedException, HttpException, ForbiddenException {
        switch (cause.getStatusCode()) {
            case 403: {
                throw new ForbiddenException(message, cause);
            }
            case 401: {
                throw new AuthenticationException(message, cause);
            }
            case 410: {
                throw new ResourceGoneException(message, cause);
            }
            case 304: {
                throw new ResourceNotModifiedException(message, cause);
            }
        }
        throw new HttpException(message + ": " + cause.getMessage(), cause.getStatusCode(), cause.getResponseStream());
    }

    protected void convertHttpExceptionForEntryReads(String message, HttpException cause) throws AuthenticationException, HttpException, ResourceNotFoundException, ResourceNotModifiedException, ForbiddenException {
        switch (cause.getStatusCode()) {
            case 403: {
                throw new ForbiddenException(message, cause);
            }
            case 401: {
                throw new AuthenticationException(message, cause);
            }
            case 404: {
                throw new ResourceNotFoundException(message, cause);
            }
            case 304: {
                throw new ResourceNotModifiedException(message, cause);
            }
        }
        throw new HttpException(message + ": " + cause.getMessage(), cause.getStatusCode(), cause.getResponseStream());
    }

    protected void convertHttpExceptionsForBatches(String message, HttpException cause) throws AuthenticationException, ParseException, HttpException, ForbiddenException, BadRequestException {
        switch (cause.getStatusCode()) {
            case 403: {
                throw new ForbiddenException(message, cause);
            }
            case 401: {
                throw new AuthenticationException(message, cause);
            }
            case 400: {
                throw new BadRequestException(message, cause);
            }
        }
        throw new HttpException(message + ": " + cause.getMessage(), cause.getStatusCode(), cause.getResponseStream());
    }

    protected void convertHttpExceptionForWrites(Class entryClass, String message, HttpException cause) throws ConflictDetectedException, AuthenticationException, PreconditionFailedException, ParseException, HttpException, IOException, ForbiddenException, ResourceNotFoundException, BadRequestException {
        switch (cause.getStatusCode()) {
            case 409: {
                InputStream is;
                Entry entry = null;
                if (entryClass != null && (is = cause.getResponseStream()) != null) {
                    entry = this.parseEntry(entryClass, cause.getResponseStream());
                }
                throw new ConflictDetectedException(entry);
            }
            case 400: {
                throw new BadRequestException(message, cause);
            }
            case 403: {
                throw new ForbiddenException(message, cause);
            }
            case 401: {
                throw new AuthenticationException(message, cause);
            }
            case 412: {
                throw new PreconditionFailedException(message, cause);
            }
            case 404: {
                throw new ResourceNotFoundException(message, cause);
            }
        }
        throw new HttpException(message + ": " + cause.getMessage(), cause.getStatusCode(), cause.getResponseStream());
    }
}

