/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.gdata2.contacts.parser.xml;

import com.google.wireless.gdata2.contacts.data.CalendarLink;
import com.google.wireless.gdata2.contacts.data.ContactEntry;
import com.google.wireless.gdata2.contacts.data.ContactsElement;
import com.google.wireless.gdata2.contacts.data.ContactsFeed;
import com.google.wireless.gdata2.contacts.data.EmailAddress;
import com.google.wireless.gdata2.contacts.data.Event;
import com.google.wireless.gdata2.contacts.data.ExternalId;
import com.google.wireless.gdata2.contacts.data.GroupMembershipInfo;
import com.google.wireless.gdata2.contacts.data.ImAddress;
import com.google.wireless.gdata2.contacts.data.Jot;
import com.google.wireless.gdata2.contacts.data.Language;
import com.google.wireless.gdata2.contacts.data.Name;
import com.google.wireless.gdata2.contacts.data.Organization;
import com.google.wireless.gdata2.contacts.data.PhoneNumber;
import com.google.wireless.gdata2.contacts.data.Relation;
import com.google.wireless.gdata2.contacts.data.StructuredPostalAddress;
import com.google.wireless.gdata2.contacts.data.TypedElement;
import com.google.wireless.gdata2.contacts.data.UserDefinedField;
import com.google.wireless.gdata2.contacts.data.WebSite;
import com.google.wireless.gdata2.contacts.parser.xml.XmlNametable;
import com.google.wireless.gdata2.data.Entry;
import com.google.wireless.gdata2.data.ExtendedProperty;
import com.google.wireless.gdata2.data.Feed;
import com.google.wireless.gdata2.data.XmlUtils;
import com.google.wireless.gdata2.parser.ParseException;
import com.google.wireless.gdata2.parser.xml.XmlGDataParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XmlContactsGDataParser
extends XmlGDataParser {
    public static final String NAMESPACE_CONTACTS = "gContact";
    public static final String NAMESPACE_CONTACTS_URI = "http://schemas.google.com/contact/2008";
    public static final String LINK_REL_PHOTO = "http://schemas.google.com/contacts/2008/rel#photo";
    private static final String GD_NAMESPACE = "http://schemas.google.com/g/2005#";
    public static final String TYPESTRING_MOBILE = "http://schemas.google.com/g/2005#mobile";
    public static final String TYPESTRING_HOME = "http://schemas.google.com/g/2005#home";
    public static final String TYPESTRING_WORK = "http://schemas.google.com/g/2005#work";
    public static final String TYPESTRING_HOME_FAX = "http://schemas.google.com/g/2005#home_fax";
    public static final String TYPESTRING_WORK_FAX = "http://schemas.google.com/g/2005#work_fax";
    public static final String TYPESTRING_PAGER = "http://schemas.google.com/g/2005#pager";
    public static final String TYPESTRING_ASSISTANT = "http://schemas.google.com/g/2005#assistant";
    public static final String TYPESTRING_CALLBACK = "http://schemas.google.com/g/2005#callback";
    public static final String TYPESTRING_CAR = "http://schemas.google.com/g/2005#car";
    public static final String TYPESTRING_COMPANY_MAIN = "http://schemas.google.com/g/2005#company_main";
    public static final String TYPESTRING_ISDN = "http://schemas.google.com/g/2005#isdn";
    public static final String TYPESTRING_MAIN = "http://schemas.google.com/g/2005#main";
    public static final String TYPESTRING_OTHER_FAX = "http://schemas.google.com/g/2005#other_fax";
    public static final String TYPESTRING_RADIO = "http://schemas.google.com/g/2005#radio";
    public static final String TYPESTRING_TELEX = "http://schemas.google.com/g/2005#telex";
    public static final String TYPESTRING_TTY_TDD = "http://schemas.google.com/g/2005#tty_tdd";
    public static final String TYPESTRING_WORK_MOBILE = "http://schemas.google.com/g/2005#work_mobile";
    public static final String TYPESTRING_WORK_PAGER = "http://schemas.google.com/g/2005#work_pager";
    public static final String TYPESTRING_OTHER = "http://schemas.google.com/g/2005#other";
    public static final String IM_PROTOCOL_AIM = "http://schemas.google.com/g/2005#AIM";
    public static final String IM_PROTOCOL_MSN = "http://schemas.google.com/g/2005#MSN";
    public static final String IM_PROTOCOL_YAHOO = "http://schemas.google.com/g/2005#YAHOO";
    public static final String IM_PROTOCOL_SKYPE = "http://schemas.google.com/g/2005#SKYPE";
    public static final String IM_PROTOCOL_QQ = "http://schemas.google.com/g/2005#QQ";
    public static final String IM_PROTOCOL_GOOGLE_TALK = "http://schemas.google.com/g/2005#GOOGLE_TALK";
    public static final String IM_PROTOCOL_ICQ = "http://schemas.google.com/g/2005#ICQ";
    public static final String IM_PROTOCOL_JABBER = "http://schemas.google.com/g/2005#JABBER";
    public static final String IM_PROTOCOL_NETMEETING = "http://schemas.google.com/g/2005#netmeeting";
    public static final String TYPESTRING_CALENDARLINK_HOME = "home";
    public static final String TYPESTRING_CALENDARLINK_WORK = "work";
    public static final String TYPESTRING_CALENDARLINK_FREEBUSY = "free-busy";
    public static final String TYPESTRING_EVENT_ANNIVERARY = "anniversary";
    public static final String TYPESTRING_EVENT_OTHER = "other";
    public static final String TYPESTRING_EXTERNALID_ACCOUNT = "account";
    public static final String TYPESTRING_EXTERNALID_CUSTOMER = "customer";
    public static final String TYPESTRING_EXTERNALID_NETWORK = "network";
    public static final String TYPESTRING_EXTERNALID_ORGANIZATION = "organization";
    public static final String TYPESTRING_JOT_HOME = "home";
    public static final String TYPESTRING_JOT_WORK = "work";
    public static final String TYPESTRING_JOT_OTHER = "other";
    public static final String TYPESTRING_JOT_KEYWORDS = "keywords";
    public static final String TYPESTRING_JOT_USER = "user";
    public static final String TYPESTRING_PRIORITY_HIGH = "high";
    public static final String TYPESTRING_PRIORITY_LOW = "low";
    public static final String TYPESTRING_PRIORITY_NORMAL = "normal";
    public static final String TYPESTRING_RELATION_ASSISTANT = "assistant";
    public static final String TYPESTRING_RELATION_BROTHER = "brother";
    public static final String TYPESTRING_RELATION_CHILD = "child";
    public static final String TYPESTRING_RELATION_DOMESTICPARTNER = "domestic-partner";
    public static final String TYPESTRING_RELATION_FATHER = "father";
    public static final String TYPESTRING_RELATION_FRIEND = "friend";
    public static final String TYPESTRING_RELATION_MANAGER = "manager";
    public static final String TYPESTRING_RELATION_MOTHER = "mother";
    public static final String TYPESTRING_RELATION_PARENT = "parent";
    public static final String TYPESTRING_RELATION_PARTNER = "partner";
    public static final String TYPESTRING_RELATION_REFERREDBY = "referred-by";
    public static final String TYPESTRING_RELATION_RELATIVE = "relative";
    public static final String TYPESTRING_RELATION_SISTER = "sister";
    public static final String TYPESTRING_RELATION_SPOUSE = "spouse";
    public static final String TYPESTRING_SENSITIVITY_CONFIDENTIAL = "confidential";
    public static final String TYPESTRING_SENSITIVITY_NORMAL = "normal";
    public static final String TYPESTRING_SENSITIVITY_PERSONAL = "personal";
    public static final String TYPESTRING_SENSITIVITY_PRIVATE = "private";
    public static final String TYPESTRING_WEBSITE_HOMEPAGE = "home-page";
    public static final String TYPESTRING_WEBSITE_BLOG = "blog";
    public static final String TYPESTRING_WEBSITE_PROFILE = "profile";
    public static final String TYPESTRING_WEBSITE_HOME = "home";
    public static final String TYPESTRING_WEBSITE_WORK = "work";
    public static final String TYPESTRING_WEBSITE_OTHER = "other";
    public static final String TYPESTRING_WEBSITE_FTP = "ftp";
    private static final Hashtable REL_TO_TYPE_EMAIL;
    private static final Hashtable REL_TO_TYPE_PHONE;
    private static final Hashtable REL_TO_TYPE_POSTAL;
    private static final Hashtable REL_TO_TYPE_IM;
    private static final Hashtable REL_TO_TYPE_ORGANIZATION;
    private static final Hashtable IM_PROTOCOL_STRING_TO_TYPE_MAP;
    private static final Hashtable REL_TO_TYPE_CALENDARLINK;
    private static final Hashtable REL_TO_TYPE_EVENT;
    private static final Hashtable REL_TO_TYPE_EXTERNALID;
    private static final Hashtable REL_TO_TYPE_JOT;
    private static final Hashtable REL_TO_TYPE_PRIORITY;
    private static final Hashtable REL_TO_TYPE_RELATION;
    private static final Hashtable REL_TO_TYPE_SENSITIVITY;
    private static final Hashtable REL_TO_TYPE_WEBSITE;
    public static final Hashtable TYPE_TO_REL_EMAIL;
    public static final Hashtable TYPE_TO_REL_PHONE;
    public static final Hashtable TYPE_TO_REL_POSTAL;
    public static final Hashtable TYPE_TO_REL_IM;
    public static final Hashtable TYPE_TO_REL_ORGANIZATION;
    public static final Hashtable IM_PROTOCOL_TYPE_TO_STRING_MAP;
    public static final Hashtable TYPE_TO_REL_CALENDARLINK;
    public static final Hashtable TYPE_TO_REL_EVENT;
    public static final Hashtable TYPE_TO_REL_EXTERNALID;
    public static final Hashtable TYPE_TO_REL_JOT;
    public static final Hashtable TYPE_TO_REL_PRIORITY;
    public static final Hashtable TYPE_TO_REL_RELATION;
    public static final Hashtable TYPE_TO_REL_SENSITIVITY;
    public static final Hashtable TYPE_TO_REL_WEBSITE;

    private static Hashtable swapMap(Hashtable originalMap) {
        Hashtable newMap = new Hashtable();
        Enumeration enumeration = originalMap.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            Object value = originalMap.get(key);
            if (newMap.containsKey(value)) {
                throw new IllegalArgumentException("value " + value + " was already encountered");
            }
            newMap.put(value, key);
        }
        return newMap;
    }

    public XmlContactsGDataParser(InputStream is, XmlPullParser parser) throws ParseException {
        super(is, parser);
    }

    protected Feed createFeed() {
        return new ContactsFeed();
    }

    protected Entry createEntry() {
        return new ContactEntry();
    }

    protected void handleExtraElementInEntry(Entry entry) throws XmlPullParserException, IOException {
        XmlPullParser parser = this.getParser();
        if (!(entry instanceof ContactEntry)) {
            throw new IllegalArgumentException("Expected ContactEntry!");
        }
        ContactEntry contactEntry = (ContactEntry)entry;
        String name = parser.getName();
        String ns = parser.getNamespace();
        if ("http://schemas.google.com/g/2005".equals(ns)) {
            if (XmlNametable.GD_EMAIL.equals(name)) {
                EmailAddress emailAddress = new EmailAddress();
                XmlContactsGDataParser.parseContactsElement(emailAddress, parser, REL_TO_TYPE_EMAIL);
                emailAddress.setDisplayName(parser.getAttributeValue(null, XmlNametable.GD_EMAIL_DISPLAYNAME));
                emailAddress.setAddress(parser.getAttributeValue(null, XmlNametable.GD_ADDRESS));
                contactEntry.addEmailAddress(emailAddress);
            } else if (XmlNametable.GD_DELETED.equals(name)) {
                contactEntry.setDeleted(true);
            } else if (XmlNametable.GD_IM.equals(name)) {
                ImAddress imAddress = new ImAddress();
                XmlContactsGDataParser.parseContactsElement(imAddress, parser, REL_TO_TYPE_IM);
                imAddress.setAddress(parser.getAttributeValue(null, XmlNametable.GD_ADDRESS));
                imAddress.setLabel(parser.getAttributeValue(null, XmlNametable.LABEL));
                String protocolString = parser.getAttributeValue(null, XmlNametable.GD_PROTOCOL);
                if (protocolString == null) {
                    imAddress.setProtocolPredefined((byte)11);
                    imAddress.setProtocolCustom(null);
                } else {
                    Byte predefinedProtocol = (Byte)IM_PROTOCOL_STRING_TO_TYPE_MAP.get(protocolString);
                    if (predefinedProtocol == null) {
                        imAddress.setProtocolPredefined((byte)1);
                        imAddress.setProtocolCustom(protocolString);
                    } else {
                        imAddress.setProtocolPredefined(predefinedProtocol);
                        imAddress.setProtocolCustom(null);
                    }
                }
                contactEntry.addImAddress(imAddress);
            } else if (XmlNametable.GD_SPA.equals(name)) {
                StructuredPostalAddress postalAddress = new StructuredPostalAddress();
                XmlContactsGDataParser.parseContactsElement(postalAddress, parser, REL_TO_TYPE_POSTAL);
                XmlContactsGDataParser.handleStructuredPostalAddressSubElement(postalAddress, parser);
                contactEntry.addPostalAddress(postalAddress);
            } else if (XmlNametable.GD_PHONENUMBER.equals(name)) {
                PhoneNumber phoneNumber = new PhoneNumber();
                XmlContactsGDataParser.parseContactsElement(phoneNumber, parser, REL_TO_TYPE_PHONE);
                phoneNumber.setPhoneNumber(XmlUtils.extractChildText(parser));
                contactEntry.addPhoneNumber(phoneNumber);
            } else if (XmlNametable.GD_ORGANIZATION.equals(name)) {
                Organization organization = new Organization();
                XmlContactsGDataParser.parseContactsElement(organization, parser, REL_TO_TYPE_ORGANIZATION);
                XmlContactsGDataParser.handleOrganizationSubElement(organization, parser);
                contactEntry.addOrganization(organization);
            } else if (XmlNametable.GD_EXTENDEDPROPERTY.equals(name)) {
                ExtendedProperty extendedProperty = new ExtendedProperty();
                this.parseExtendedProperty(extendedProperty);
                contactEntry.addExtendedProperty(extendedProperty);
            } else if (XmlNametable.GD_NAME.equals(name)) {
                Name n = new Name();
                XmlContactsGDataParser.handleNameSubElement(n, parser);
                contactEntry.setName(n);
            }
        } else if (NAMESPACE_CONTACTS_URI.equals(ns)) {
            if (XmlNametable.GC_GMI.equals(name)) {
                GroupMembershipInfo group = new GroupMembershipInfo();
                group.setGroup(parser.getAttributeValue(null, XmlNametable.HREF));
                group.setDeleted("true".equals(parser.getAttributeValue(null, XmlNametable.GD_DELETED)));
                contactEntry.addGroup(group);
            } else if (XmlNametable.GC_BIRTHDAY.equals(name)) {
                contactEntry.setBirthday(parser.getAttributeValue(null, XmlNametable.GD_WHEN));
            } else if (XmlNametable.GC_BILLINGINFO.equals(name)) {
                contactEntry.setBillingInformation(XmlUtils.extractChildText(parser));
            } else if (XmlNametable.GC_CALENDARLINK.equals(name)) {
                CalendarLink cl = new CalendarLink();
                XmlContactsGDataParser.parseContactsElement(cl, parser, REL_TO_TYPE_CALENDARLINK);
                cl.setHRef(parser.getAttributeValue(null, XmlNametable.HREF));
                contactEntry.addCalendarLink(cl);
            } else if (XmlNametable.GC_DIRECTORYSERVER.equals(name)) {
                contactEntry.setDirectoryServer(XmlUtils.extractChildText(parser));
            } else if ("event".equals(name)) {
                Event event = new Event();
                XmlContactsGDataParser.parseTypedElement(event, parser, REL_TO_TYPE_EVENT);
                XmlContactsGDataParser.handleEventSubElement(event, parser);
                contactEntry.addEvent(event);
            } else if (XmlNametable.GC_EXTERNALID.equals(name)) {
                ExternalId externalId = new ExternalId();
                XmlContactsGDataParser.parseTypedElement(externalId, parser, REL_TO_TYPE_EXTERNALID);
                externalId.setValue(parser.getAttributeValue(null, XmlNametable.VALUE));
                contactEntry.addExternalId(externalId);
            } else if (XmlNametable.GC_GENDER.equals(name)) {
                contactEntry.setGender(parser.getAttributeValue(null, XmlNametable.VALUE));
            } else if (XmlNametable.GC_HOBBY.equals(name)) {
                contactEntry.addHobby(XmlUtils.extractChildText(parser));
            } else if (XmlNametable.GC_INITIALS.equals(name)) {
                contactEntry.setInitials(XmlUtils.extractChildText(parser));
            } else if (XmlNametable.GC_JOT.equals(name)) {
                Jot jot = new Jot();
                XmlContactsGDataParser.parseTypedElement(jot, parser, REL_TO_TYPE_JOT);
                jot.setLabel(XmlUtils.extractChildText(parser));
                contactEntry.addJot(jot);
            } else if (XmlNametable.GC_LANGUAGE.equals(name)) {
                Language language = new Language();
                language.setCode(parser.getAttributeValue(null, XmlNametable.CODE));
                language.setLabel(parser.getAttributeValue(null, XmlNametable.LABEL));
                contactEntry.addLanguage(language);
            } else if (XmlNametable.GC_MAIDENNAME.equals(name)) {
                contactEntry.setMaidenName(XmlUtils.extractChildText(parser));
            } else if (XmlNametable.GC_MILEAGE.equals(name)) {
                contactEntry.setMileage(XmlUtils.extractChildText(parser));
            } else if (XmlNametable.GC_NICKNAME.equals(name)) {
                contactEntry.setNickname(XmlUtils.extractChildText(parser));
            } else if (XmlNametable.GC_OCCUPATION.equals(name)) {
                contactEntry.setOccupation(XmlUtils.extractChildText(parser));
            } else if (XmlNametable.GC_PRIORITY.equals(name)) {
                contactEntry.setPriority(XmlContactsGDataParser.relToType(parser.getAttributeValue(null, XmlNametable.REL), REL_TO_TYPE_PRIORITY));
            } else if (XmlNametable.GC_RELATION.equals(name)) {
                Relation relation = new Relation();
                XmlContactsGDataParser.parseTypedElement(relation, parser, REL_TO_TYPE_RELATION);
                relation.setText(XmlUtils.extractChildText(parser));
                contactEntry.addRelation(relation);
            } else if (XmlNametable.GC_SENSITIVITY.equals(name)) {
                contactEntry.setSensitivity(XmlContactsGDataParser.relToType(parser.getAttributeValue(null, XmlNametable.REL), REL_TO_TYPE_SENSITIVITY));
            } else if (XmlNametable.GC_SHORTNAME.equals(name)) {
                contactEntry.setShortName(XmlUtils.extractChildText(parser));
            } else if (XmlNametable.GC_SUBJECT.equals(name)) {
                contactEntry.setSubject(XmlUtils.extractChildText(parser));
            } else if (XmlNametable.GC_UDF.equals(name)) {
                UserDefinedField udf = new UserDefinedField();
                udf.setKey(parser.getAttributeValue(null, XmlNametable.KEY));
                udf.setValue(parser.getAttributeValue(null, XmlNametable.VALUE));
                contactEntry.addUserDefinedField(udf);
            } else if (XmlNametable.GC_WEBSITE.equals(name)) {
                WebSite ws = new WebSite();
                XmlContactsGDataParser.parseContactsElement(ws, parser, REL_TO_TYPE_WEBSITE);
                ws.setHRef(parser.getAttributeValue(null, XmlNametable.HREF));
                contactEntry.addWebSite(ws);
            }
        }
    }

    protected void handleExtraLinkInEntry(String rel, String type, String href, Entry entry) throws XmlPullParserException, IOException {
        if (LINK_REL_PHOTO.equals(rel)) {
            ContactEntry contactEntry = (ContactEntry)entry;
            XmlPullParser parser = this.getParser();
            String etag = parser.getAttributeValue("http://schemas.google.com/g/2005", XmlNametable.ETAG);
            contactEntry.setLinkPhoto(href, type, etag);
        }
    }

    private static void parseContactsElement(ContactsElement element, XmlPullParser parser, Hashtable relToTypeMap) throws XmlPullParserException {
        XmlContactsGDataParser.parseTypedElement(element, parser, relToTypeMap);
        element.setIsPrimary("true".equals(parser.getAttributeValue(null, XmlNametable.PRIMARY)));
    }

    private static void parseTypedElement(TypedElement element, XmlPullParser parser, Hashtable relToTypeMap) throws XmlPullParserException {
        String rel = parser.getAttributeValue(null, XmlNametable.REL);
        String label = parser.getAttributeValue(null, XmlNametable.LABEL);
        if (label == null && rel == null || label != null && rel != null) {
            rel = TYPESTRING_OTHER;
        }
        if (rel != null) {
            element.setType(XmlContactsGDataParser.relToType(rel, relToTypeMap));
        }
        element.setLabel(label);
    }

    private static byte relToType(String rel, Hashtable relToTypeMap) throws XmlPullParserException {
        if (rel != null) {
            Object type = relToTypeMap.get(rel.toLowerCase());
            if (type == null) {
                throw new XmlPullParserException("unknown rel, " + rel);
            }
            return (Byte)type;
        }
        return -1;
    }

    private static void handleOrganizationSubElement(Organization element, XmlPullParser parser) throws XmlPullParserException, IOException {
        String tag;
        int depth = parser.getDepth();
        while ((tag = XmlUtils.nextDirectChildTag(parser, depth)) != null) {
            if (XmlNametable.GD_ORG_NAME.equals(tag)) {
                element.setName(XmlUtils.extractChildText(parser));
                continue;
            }
            if (XmlNametable.GD_ORG_TITLE.equals(tag)) {
                element.setTitle(XmlUtils.extractChildText(parser));
                continue;
            }
            if (XmlNametable.GD_ORG_DEPARTMENT.equals(tag)) {
                element.setOrgDepartment(XmlUtils.extractChildText(parser));
                continue;
            }
            if (XmlNametable.GD_ORG_JOBDESC.equals(tag)) {
                element.setOrgJobDescription(XmlUtils.extractChildText(parser));
                continue;
            }
            if (XmlNametable.GD_ORG_SYMBOL.equals(tag)) {
                element.setOrgSymbol(XmlUtils.extractChildText(parser));
                continue;
            }
            if (!XmlNametable.GD_WHERE.equals(tag)) continue;
            String where = parser.getAttributeValue(null, XmlNametable.VALUESTRING);
            element.setWhere(where);
        }
    }

    private static void handleEventSubElement(Event element, XmlPullParser parser) throws XmlPullParserException, IOException {
        String tag;
        int depth = parser.getDepth();
        while ((tag = XmlUtils.nextDirectChildTag(parser, depth)) != null) {
            if (!XmlNametable.GD_WHEN.equals(tag)) continue;
            String startDate = parser.getAttributeValue(null, XmlNametable.STARTTIME);
            element.setStartDate(startDate);
        }
    }

    private static void handleNameSubElement(Name element, XmlPullParser parser) throws XmlPullParserException, IOException {
        String tag;
        int depth = parser.getDepth();
        while ((tag = XmlUtils.nextDirectChildTag(parser, depth)) != null) {
            if (XmlNametable.GD_NAME_GIVENNAME.equals(tag)) {
                element.setGivenNameYomi(parser.getAttributeValue(null, XmlNametable.GD_NAME_YOMI));
                element.setGivenName(XmlUtils.extractChildText(parser));
                continue;
            }
            if (XmlNametable.GD_NAME_ADDITIONALNAME.equals(tag)) {
                element.setAdditionalNameYomi(parser.getAttributeValue(null, XmlNametable.GD_NAME_YOMI));
                element.setAdditionalName(XmlUtils.extractChildText(parser));
                continue;
            }
            if (XmlNametable.GD_NAME_FAMILYNAME.equals(tag)) {
                element.setFamilyNameYomi(parser.getAttributeValue(null, XmlNametable.GD_NAME_YOMI));
                element.setFamilyName(XmlUtils.extractChildText(parser));
                continue;
            }
            if (XmlNametable.GD_NAME_PREFIX.equals(tag)) {
                element.setNamePrefix(XmlUtils.extractChildText(parser));
                continue;
            }
            if (XmlNametable.GD_NAME_SUFFIX.equals(tag)) {
                element.setNameSuffix(XmlUtils.extractChildText(parser));
                continue;
            }
            if (!XmlNametable.GD_NAME_FULLNAME.equals(tag)) continue;
            element.setFullNameYomi(parser.getAttributeValue(null, XmlNametable.GD_NAME_YOMI));
            element.setFullName(XmlUtils.extractChildText(parser));
        }
    }

    private static void handleStructuredPostalAddressSubElement(StructuredPostalAddress element, XmlPullParser parser) throws XmlPullParserException, IOException {
        String tag;
        int depth = parser.getDepth();
        while ((tag = XmlUtils.nextDirectChildTag(parser, depth)) != null) {
            if (XmlNametable.GD_SPA_STREET.equals(tag)) {
                element.setStreet(XmlUtils.extractChildText(parser));
                continue;
            }
            if (XmlNametable.GD_SPA_POBOX.equals(tag)) {
                element.setPobox(XmlUtils.extractChildText(parser));
                continue;
            }
            if (XmlNametable.GD_SPA_NEIGHBORHOOD.equals(tag)) {
                element.setNeighborhood(XmlUtils.extractChildText(parser));
                continue;
            }
            if (XmlNametable.GD_SPA_CITY.equals(tag)) {
                element.setCity(XmlUtils.extractChildText(parser));
                continue;
            }
            if (XmlNametable.GD_SPA_REGION.equals(tag)) {
                element.setRegion(XmlUtils.extractChildText(parser));
                continue;
            }
            if (XmlNametable.GD_SPA_POSTCODE.equals(tag)) {
                element.setPostcode(XmlUtils.extractChildText(parser));
                continue;
            }
            if (XmlNametable.GD_SPA_COUNTRY.equals(tag)) {
                element.setCountry(XmlUtils.extractChildText(parser));
                continue;
            }
            if (!XmlNametable.GD_SPA_FORMATTEDADDRESS.equals(tag)) continue;
            element.setFormattedAddress(XmlUtils.extractChildText(parser));
        }
    }

    private void parseExtendedProperty(ExtendedProperty extendedProperty) throws IOException, XmlPullParserException {
        XmlPullParser parser = this.getParser();
        extendedProperty.setName(parser.getAttributeValue(null, XmlNametable.GD_NAME));
        extendedProperty.setValue(parser.getAttributeValue(null, XmlNametable.VALUE));
        extendedProperty.setXmlBlob(XmlUtils.extractFirstChildTextIgnoreRest(parser));
    }

    static {
        Hashtable<String, Byte> map = new Hashtable<String, Byte>();
        map.put(TYPESTRING_HOME, new Byte(1));
        map.put(TYPESTRING_WORK, new Byte(2));
        map.put(TYPESTRING_OTHER, new Byte(3));
        REL_TO_TYPE_EMAIL = map;
        TYPE_TO_REL_EMAIL = XmlContactsGDataParser.swapMap(map);
        map = new Hashtable();
        map.put(TYPESTRING_HOME, new Byte(2));
        map.put(TYPESTRING_MOBILE, new Byte(1));
        map.put(TYPESTRING_PAGER, new Byte(6));
        map.put(TYPESTRING_WORK, new Byte(3));
        map.put(TYPESTRING_HOME_FAX, new Byte(5));
        map.put(TYPESTRING_WORK_FAX, new Byte(4));
        map.put(TYPESTRING_ASSISTANT, new Byte(7));
        map.put(TYPESTRING_CALLBACK, new Byte(8));
        map.put(TYPESTRING_CAR, new Byte(9));
        map.put(TYPESTRING_COMPANY_MAIN, new Byte(10));
        map.put(TYPESTRING_ISDN, new Byte(11));
        map.put(TYPESTRING_MAIN, new Byte(12));
        map.put(TYPESTRING_OTHER_FAX, new Byte(13));
        map.put(TYPESTRING_RADIO, new Byte(14));
        map.put(TYPESTRING_TELEX, new Byte(15));
        map.put(TYPESTRING_TTY_TDD, new Byte(16));
        map.put(TYPESTRING_WORK_MOBILE, new Byte(17));
        map.put(TYPESTRING_WORK_PAGER, new Byte(18));
        map.put(TYPESTRING_OTHER, new Byte(19));
        REL_TO_TYPE_PHONE = map;
        TYPE_TO_REL_PHONE = XmlContactsGDataParser.swapMap(map);
        map = new Hashtable();
        map.put(TYPESTRING_HOME, new Byte(1));
        map.put(TYPESTRING_WORK, new Byte(2));
        map.put(TYPESTRING_OTHER, new Byte(3));
        REL_TO_TYPE_POSTAL = map;
        TYPE_TO_REL_POSTAL = XmlContactsGDataParser.swapMap(map);
        map = new Hashtable();
        map.put(TYPESTRING_HOME, new Byte(1));
        map.put(TYPESTRING_WORK, new Byte(2));
        map.put(TYPESTRING_OTHER, new Byte(3));
        REL_TO_TYPE_IM = map;
        TYPE_TO_REL_IM = XmlContactsGDataParser.swapMap(map);
        map = new Hashtable();
        map.put(TYPESTRING_WORK, new Byte(1));
        map.put(TYPESTRING_OTHER, new Byte(2));
        REL_TO_TYPE_ORGANIZATION = map;
        TYPE_TO_REL_ORGANIZATION = XmlContactsGDataParser.swapMap(map);
        map = new Hashtable();
        map.put(IM_PROTOCOL_AIM, new Byte(2));
        map.put(IM_PROTOCOL_MSN, new Byte(3));
        map.put(IM_PROTOCOL_YAHOO, new Byte(4));
        map.put(IM_PROTOCOL_SKYPE, new Byte(5));
        map.put(IM_PROTOCOL_QQ, new Byte(6));
        map.put(IM_PROTOCOL_GOOGLE_TALK, new Byte(7));
        map.put(IM_PROTOCOL_ICQ, new Byte(8));
        map.put(IM_PROTOCOL_JABBER, new Byte(9));
        map.put(IM_PROTOCOL_NETMEETING, new Byte(10));
        IM_PROTOCOL_STRING_TO_TYPE_MAP = map;
        IM_PROTOCOL_TYPE_TO_STRING_MAP = XmlContactsGDataParser.swapMap(map);
        map = new Hashtable();
        map.put("home", new Byte(1));
        map.put("work", new Byte(2));
        map.put(TYPESTRING_CALENDARLINK_FREEBUSY, new Byte(3));
        REL_TO_TYPE_CALENDARLINK = map;
        TYPE_TO_REL_CALENDARLINK = XmlContactsGDataParser.swapMap(map);
        map = new Hashtable();
        map.put(TYPESTRING_EVENT_ANNIVERARY, new Byte(1));
        map.put("other", new Byte(2));
        REL_TO_TYPE_EVENT = map;
        TYPE_TO_REL_EVENT = XmlContactsGDataParser.swapMap(map);
        map = new Hashtable();
        map.put(TYPESTRING_EXTERNALID_ACCOUNT, new Byte(1));
        map.put(TYPESTRING_EXTERNALID_CUSTOMER, new Byte(2));
        map.put(TYPESTRING_EXTERNALID_NETWORK, new Byte(3));
        map.put(TYPESTRING_EXTERNALID_ORGANIZATION, new Byte(4));
        REL_TO_TYPE_EXTERNALID = map;
        TYPE_TO_REL_EXTERNALID = XmlContactsGDataParser.swapMap(map);
        map = new Hashtable();
        map.put("home", new Byte(1));
        map.put(TYPESTRING_JOT_KEYWORDS, new Byte(3));
        map.put("other", new Byte(5));
        map.put(TYPESTRING_JOT_USER, new Byte(4));
        map.put("work", new Byte(2));
        REL_TO_TYPE_JOT = map;
        TYPE_TO_REL_JOT = XmlContactsGDataParser.swapMap(map);
        map = new Hashtable();
        map.put(TYPESTRING_PRIORITY_HIGH, new Byte(1));
        map.put("normal", new Byte(2));
        map.put(TYPESTRING_PRIORITY_LOW, new Byte(3));
        REL_TO_TYPE_PRIORITY = map;
        TYPE_TO_REL_PRIORITY = XmlContactsGDataParser.swapMap(map);
        map = new Hashtable();
        map.put(TYPESTRING_RELATION_ASSISTANT, new Byte(1));
        map.put(TYPESTRING_RELATION_BROTHER, new Byte(2));
        map.put(TYPESTRING_RELATION_CHILD, new Byte(3));
        map.put(TYPESTRING_RELATION_DOMESTICPARTNER, new Byte(4));
        map.put(TYPESTRING_RELATION_FATHER, new Byte(5));
        map.put(TYPESTRING_RELATION_FRIEND, new Byte(6));
        map.put(TYPESTRING_RELATION_MANAGER, new Byte(7));
        map.put(TYPESTRING_RELATION_MOTHER, new Byte(8));
        map.put(TYPESTRING_RELATION_PARENT, new Byte(9));
        map.put(TYPESTRING_RELATION_PARTNER, new Byte(10));
        map.put(TYPESTRING_RELATION_REFERREDBY, new Byte(11));
        map.put(TYPESTRING_RELATION_RELATIVE, new Byte(12));
        map.put(TYPESTRING_RELATION_SISTER, new Byte(13));
        map.put(TYPESTRING_RELATION_SPOUSE, new Byte(14));
        REL_TO_TYPE_RELATION = map;
        TYPE_TO_REL_RELATION = XmlContactsGDataParser.swapMap(map);
        map = new Hashtable();
        map.put(TYPESTRING_SENSITIVITY_CONFIDENTIAL, new Byte(1));
        map.put("normal", new Byte(2));
        map.put(TYPESTRING_SENSITIVITY_PERSONAL, new Byte(3));
        map.put(TYPESTRING_SENSITIVITY_PRIVATE, new Byte(4));
        REL_TO_TYPE_SENSITIVITY = map;
        TYPE_TO_REL_SENSITIVITY = XmlContactsGDataParser.swapMap(map);
        map = new Hashtable();
        map.put(TYPESTRING_WEBSITE_BLOG, new Byte(2));
        map.put(TYPESTRING_WEBSITE_HOMEPAGE, new Byte(1));
        map.put(TYPESTRING_WEBSITE_PROFILE, new Byte(3));
        map.put("home", new Byte(4));
        map.put("work", new Byte(5));
        map.put("other", new Byte(6));
        map.put(TYPESTRING_WEBSITE_FTP, new Byte(7));
        REL_TO_TYPE_WEBSITE = map;
        TYPE_TO_REL_WEBSITE = XmlContactsGDataParser.swapMap(map);
    }
}

