/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.gdata2.contacts.serializer.xml;

import com.google.wireless.gdata2.contacts.data.CalendarLink;
import com.google.wireless.gdata2.contacts.data.ContactEntry;
import com.google.wireless.gdata2.contacts.data.ContactsElement;
import com.google.wireless.gdata2.contacts.data.EmailAddress;
import com.google.wireless.gdata2.contacts.data.Event;
import com.google.wireless.gdata2.contacts.data.ExternalId;
import com.google.wireless.gdata2.contacts.data.GroupMembershipInfo;
import com.google.wireless.gdata2.contacts.data.ImAddress;
import com.google.wireless.gdata2.contacts.data.Jot;
import com.google.wireless.gdata2.contacts.data.Language;
import com.google.wireless.gdata2.contacts.data.Name;
import com.google.wireless.gdata2.contacts.data.Organization;
import com.google.wireless.gdata2.contacts.data.PhoneNumber;
import com.google.wireless.gdata2.contacts.data.Relation;
import com.google.wireless.gdata2.contacts.data.StructuredPostalAddress;
import com.google.wireless.gdata2.contacts.data.TypedElement;
import com.google.wireless.gdata2.contacts.data.UserDefinedField;
import com.google.wireless.gdata2.contacts.data.WebSite;
import com.google.wireless.gdata2.contacts.parser.xml.XmlContactsGDataParser;
import com.google.wireless.gdata2.contacts.parser.xml.XmlNametable;
import com.google.wireless.gdata2.data.ExtendedProperty;
import com.google.wireless.gdata2.data.StringUtils;
import com.google.wireless.gdata2.parser.ParseException;
import com.google.wireless.gdata2.parser.xml.XmlParserFactory;
import com.google.wireless.gdata2.serializer.xml.XmlEntryGDataSerializer;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.xmlpull.v1.XmlSerializer;

public class XmlContactEntryGDataSerializer
extends XmlEntryGDataSerializer {
    public XmlContactEntryGDataSerializer(XmlParserFactory factory, ContactEntry entry) {
        super(factory, entry);
    }

    protected void declareExtraEntryNamespaces(XmlSerializer serializer) throws IOException {
        super.declareExtraEntryNamespaces(serializer);
        serializer.setPrefix("gContact", "http://schemas.google.com/contact/2008");
    }

    protected ContactEntry getContactEntry() {
        return (ContactEntry)this.getEntry();
    }

    protected void serializeExtraEntryContents(XmlSerializer serializer, int format) throws ParseException, IOException {
        ContactEntry entry = this.getContactEntry();
        entry.validate();
        XmlContactEntryGDataSerializer.serializeLink(serializer, "http://schemas.google.com/contacts/2008/rel#photo", entry.getLinkPhotoHref(), entry.getLinkPhotoType(), entry.getLinkPhotoETag());
        Enumeration eachEmail = entry.getEmailAddresses().elements();
        while (eachEmail.hasMoreElements()) {
            XmlContactEntryGDataSerializer.serialize(serializer, (EmailAddress)eachEmail.nextElement());
        }
        Enumeration eachIm = entry.getImAddresses().elements();
        while (eachIm.hasMoreElements()) {
            XmlContactEntryGDataSerializer.serialize(serializer, (ImAddress)eachIm.nextElement());
        }
        Enumeration eachPhone = entry.getPhoneNumbers().elements();
        while (eachPhone.hasMoreElements()) {
            XmlContactEntryGDataSerializer.serialize(serializer, (PhoneNumber)eachPhone.nextElement());
        }
        Enumeration eachAddress = entry.getPostalAddresses().elements();
        while (eachAddress.hasMoreElements()) {
            XmlContactEntryGDataSerializer.serialize(serializer, (StructuredPostalAddress)eachAddress.nextElement());
        }
        Enumeration eachOrganization = entry.getOrganizations().elements();
        while (eachOrganization.hasMoreElements()) {
            XmlContactEntryGDataSerializer.serialize(serializer, (Organization)eachOrganization.nextElement());
        }
        Enumeration eachExtendedProperty = entry.getExtendedProperties().elements();
        while (eachExtendedProperty.hasMoreElements()) {
            XmlContactEntryGDataSerializer.serialize(serializer, (ExtendedProperty)eachExtendedProperty.nextElement());
        }
        Enumeration eachGroup = entry.getGroups().elements();
        while (eachGroup.hasMoreElements()) {
            XmlContactEntryGDataSerializer.serialize(serializer, (GroupMembershipInfo)eachGroup.nextElement());
        }
        Enumeration eachCalendar = entry.getCalendarLinks().elements();
        while (eachCalendar.hasMoreElements()) {
            XmlContactEntryGDataSerializer.serialize(serializer, (CalendarLink)eachCalendar.nextElement());
        }
        Enumeration eachEvent = entry.getEvents().elements();
        while (eachEvent.hasMoreElements()) {
            XmlContactEntryGDataSerializer.serialize(serializer, (Event)eachEvent.nextElement());
        }
        Enumeration eachWebsite = entry.getWebSites().elements();
        while (eachWebsite.hasMoreElements()) {
            XmlContactEntryGDataSerializer.serialize(serializer, (WebSite)eachWebsite.nextElement());
        }
        Enumeration eachExternalId = entry.getExternalIds().elements();
        while (eachExternalId.hasMoreElements()) {
            XmlContactEntryGDataSerializer.serialize(serializer, (ExternalId)eachExternalId.nextElement());
        }
        Enumeration eachHobby = entry.getHobbies().elements();
        while (eachHobby.hasMoreElements()) {
            XmlContactEntryGDataSerializer.serializeHobby(serializer, (String)eachHobby.nextElement());
        }
        Enumeration eachJot = entry.getJots().elements();
        while (eachJot.hasMoreElements()) {
            XmlContactEntryGDataSerializer.serialize(serializer, (Jot)eachJot.nextElement());
        }
        Enumeration eachLanguage = entry.getLanguages().elements();
        while (eachLanguage.hasMoreElements()) {
            XmlContactEntryGDataSerializer.serialize(serializer, (Language)eachLanguage.nextElement());
        }
        Enumeration eachRelation = entry.getRelations().elements();
        while (eachRelation.hasMoreElements()) {
            XmlContactEntryGDataSerializer.serialize(serializer, (Relation)eachRelation.nextElement());
        }
        Enumeration eachUDF = entry.getUserDefinedFields().elements();
        while (eachUDF.hasMoreElements()) {
            XmlContactEntryGDataSerializer.serialize(serializer, (UserDefinedField)eachUDF.nextElement());
        }
        XmlContactEntryGDataSerializer.serializeBirthday(serializer, entry.getBirthday());
        XmlContactEntryGDataSerializer.serializeElement(serializer, entry.getDirectoryServer(), XmlNametable.GC_DIRECTORYSERVER);
        XmlContactEntryGDataSerializer.serializeGenderElement(serializer, entry.getGender());
        XmlContactEntryGDataSerializer.serializeElement(serializer, entry.getInitials(), XmlNametable.GC_INITIALS);
        XmlContactEntryGDataSerializer.serializeElement(serializer, entry.getMaidenName(), XmlNametable.GC_MAIDENNAME);
        XmlContactEntryGDataSerializer.serializeElement(serializer, entry.getMileage(), XmlNametable.GC_MILEAGE);
        XmlContactEntryGDataSerializer.serializeElement(serializer, entry.getNickname(), XmlNametable.GC_NICKNAME);
        XmlContactEntryGDataSerializer.serializeElement(serializer, entry.getOccupation(), XmlNametable.GC_OCCUPATION);
        XmlContactEntryGDataSerializer.serializeElement(serializer, entry.getShortName(), XmlNametable.GC_SHORTNAME);
        XmlContactEntryGDataSerializer.serializeElement(serializer, entry.getSubject(), XmlNametable.GC_SUBJECT);
        XmlContactEntryGDataSerializer.serializeElement(serializer, entry.getBillingInformation(), XmlNametable.GC_BILLINGINFO);
        XmlContactEntryGDataSerializer.serializeElement(serializer, entry.getPriority(), XmlNametable.GC_PRIORITY, XmlContactsGDataParser.TYPE_TO_REL_PRIORITY);
        XmlContactEntryGDataSerializer.serializeElement(serializer, entry.getSensitivity(), XmlNametable.GC_SENSITIVITY, XmlContactsGDataParser.TYPE_TO_REL_SENSITIVITY);
        XmlContactEntryGDataSerializer.serializeName(serializer, entry.getName());
    }

    private static void serialize(XmlSerializer serializer, EmailAddress email) throws IOException, ParseException {
        if (StringUtils.isEmptyOrWhitespace(email.getAddress())) {
            return;
        }
        serializer.startTag("http://schemas.google.com/g/2005", XmlNametable.GD_EMAIL);
        XmlContactEntryGDataSerializer.serializeContactsElement(serializer, email, XmlContactsGDataParser.TYPE_TO_REL_EMAIL);
        serializer.attribute(null, XmlNametable.GD_ADDRESS, email.getAddress());
        serializer.endTag("http://schemas.google.com/g/2005", XmlNametable.GD_EMAIL);
    }

    private static void serialize(XmlSerializer serializer, ImAddress im) throws IOException, ParseException {
        if (StringUtils.isEmptyOrWhitespace(im.getAddress())) {
            return;
        }
        serializer.startTag("http://schemas.google.com/g/2005", XmlNametable.GD_IM);
        XmlContactEntryGDataSerializer.serializeContactsElement(serializer, im, XmlContactsGDataParser.TYPE_TO_REL_IM);
        serializer.attribute(null, XmlNametable.GD_ADDRESS, im.getAddress());
        switch (im.getProtocolPredefined()) {
            case 11: {
                break;
            }
            case 1: {
                String protocolString = im.getProtocolCustom();
                if (protocolString == null) {
                    throw new IllegalArgumentException("the protocol is custom, but the custom string is null");
                }
                serializer.attribute(null, XmlNametable.GD_PROTOCOL, protocolString);
                break;
            }
            default: {
                String protocolString = (String)XmlContactsGDataParser.IM_PROTOCOL_TYPE_TO_STRING_MAP.get(new Byte(im.getProtocolPredefined()));
                serializer.attribute(null, XmlNametable.GD_PROTOCOL, protocolString);
            }
        }
        serializer.endTag("http://schemas.google.com/g/2005", XmlNametable.GD_IM);
    }

    private static void serialize(XmlSerializer serializer, PhoneNumber phone) throws IOException, ParseException {
        if (StringUtils.isEmptyOrWhitespace(phone.getPhoneNumber())) {
            return;
        }
        serializer.startTag("http://schemas.google.com/g/2005", XmlNametable.GD_PHONENUMBER);
        XmlContactEntryGDataSerializer.serializeContactsElement(serializer, phone, XmlContactsGDataParser.TYPE_TO_REL_PHONE);
        serializer.text(phone.getPhoneNumber());
        serializer.endTag("http://schemas.google.com/g/2005", XmlNametable.GD_PHONENUMBER);
    }

    private static void serialize(XmlSerializer serializer, Organization organization) throws IOException, ParseException {
        serializer.startTag("http://schemas.google.com/g/2005", XmlNametable.GD_ORGANIZATION);
        XmlContactEntryGDataSerializer.serializeContactsElement(serializer, organization, XmlContactsGDataParser.TYPE_TO_REL_ORGANIZATION);
        XmlContactEntryGDataSerializer.serializeGDSubelement(serializer, organization.getName(), XmlNametable.GD_ORG_NAME);
        XmlContactEntryGDataSerializer.serializeGDSubelement(serializer, organization.getTitle(), XmlNametable.GD_ORG_TITLE);
        XmlContactEntryGDataSerializer.serializeGDSubelement(serializer, organization.getOrgDepartment(), XmlNametable.GD_ORG_DEPARTMENT);
        XmlContactEntryGDataSerializer.serializeGDSubelement(serializer, organization.getOrgJobDescription(), XmlNametable.GD_ORG_JOBDESC);
        XmlContactEntryGDataSerializer.serializeGDSubelement(serializer, organization.getOrgSymbol(), XmlNametable.GD_ORG_SYMBOL);
        String where = organization.getWhere();
        if (!StringUtils.isEmpty(where)) {
            serializer.startTag("http://schemas.google.com/g/2005", XmlNametable.GD_WHERE);
            serializer.attribute(null, XmlNametable.VALUESTRING, where);
            serializer.endTag("http://schemas.google.com/g/2005", XmlNametable.GD_WHERE);
        }
        serializer.endTag("http://schemas.google.com/g/2005", XmlNametable.GD_ORGANIZATION);
    }

    private static void serialize(XmlSerializer serializer, StructuredPostalAddress addr) throws IOException, ParseException {
        serializer.startTag("http://schemas.google.com/g/2005", XmlNametable.GD_SPA);
        XmlContactEntryGDataSerializer.serializeContactsElement(serializer, addr, XmlContactsGDataParser.TYPE_TO_REL_POSTAL);
        XmlContactEntryGDataSerializer.serializeGDSubelement(serializer, addr.getStreet(), XmlNametable.GD_SPA_STREET);
        XmlContactEntryGDataSerializer.serializeGDSubelement(serializer, addr.getPobox(), XmlNametable.GD_SPA_POBOX);
        XmlContactEntryGDataSerializer.serializeGDSubelement(serializer, addr.getNeighborhood(), XmlNametable.GD_SPA_NEIGHBORHOOD);
        XmlContactEntryGDataSerializer.serializeGDSubelement(serializer, addr.getCity(), XmlNametable.GD_SPA_CITY);
        XmlContactEntryGDataSerializer.serializeGDSubelement(serializer, addr.getRegion(), XmlNametable.GD_SPA_REGION);
        XmlContactEntryGDataSerializer.serializeGDSubelement(serializer, addr.getPostcode(), XmlNametable.GD_SPA_POSTCODE);
        XmlContactEntryGDataSerializer.serializeGDSubelement(serializer, addr.getCountry(), XmlNametable.GD_SPA_COUNTRY);
        XmlContactEntryGDataSerializer.serializeGDSubelement(serializer, addr.getFormattedAddress(), XmlNametable.GD_SPA_FORMATTEDADDRESS);
        serializer.endTag("http://schemas.google.com/g/2005", XmlNametable.GD_SPA);
    }

    private static void serializeGDSubelement(XmlSerializer serializer, String value, String elementName) throws IOException {
        if (StringUtils.isEmpty(value)) {
            return;
        }
        serializer.startTag("http://schemas.google.com/g/2005", elementName);
        serializer.text(value);
        serializer.endTag("http://schemas.google.com/g/2005", elementName);
    }

    private static void serializeTypedElement(XmlSerializer serializer, TypedElement element, Hashtable typeToRelMap) throws IOException, ParseException {
        String label = element.getLabel();
        byte type = element.getType();
        boolean hasType = type != -1;
        element.validate();
        if (label != null) {
            serializer.attribute(null, XmlNametable.LABEL, label);
        }
        if (hasType) {
            XmlContactEntryGDataSerializer.serializeRelation(serializer, type, typeToRelMap);
        }
    }

    private static void serializeRelation(XmlSerializer serializer, byte type, Hashtable typeToRelMap) throws IOException {
        serializer.attribute(null, XmlNametable.REL, (String)typeToRelMap.get(new Byte(type)));
    }

    private static void serializeContactsElement(XmlSerializer serializer, ContactsElement element, Hashtable typeToRelMap) throws IOException, ParseException {
        XmlContactEntryGDataSerializer.serializeTypedElement(serializer, element, typeToRelMap);
        if (element.isPrimary()) {
            serializer.attribute(null, XmlNametable.PRIMARY, "true");
        }
    }

    private static void serialize(XmlSerializer serializer, GroupMembershipInfo groupMembershipInfo) throws IOException, ParseException {
        String group = groupMembershipInfo.getGroup();
        boolean isDeleted = groupMembershipInfo.isDeleted();
        if (StringUtils.isEmptyOrWhitespace(group)) {
            throw new ParseException("the group must not be empty");
        }
        serializer.startTag("http://schemas.google.com/contact/2008", XmlNametable.GC_GMI);
        serializer.attribute(null, XmlNametable.HREF, group);
        serializer.attribute(null, XmlNametable.GD_DELETED, isDeleted ? "true" : "false");
        serializer.endTag("http://schemas.google.com/contact/2008", XmlNametable.GC_GMI);
    }

    private static void serialize(XmlSerializer serializer, ExtendedProperty extendedProperty) throws IOException {
        String name = extendedProperty.getName();
        String value = extendedProperty.getValue();
        String xmlBlob = extendedProperty.getXmlBlob();
        serializer.startTag("http://schemas.google.com/g/2005", XmlNametable.GD_EXTENDEDPROPERTY);
        if (!StringUtils.isEmpty(name)) {
            serializer.attribute(null, XmlNametable.GD_NAME, name);
        }
        if (!StringUtils.isEmpty(value)) {
            serializer.attribute(null, XmlNametable.VALUE, value);
        }
        if (!StringUtils.isEmpty(xmlBlob)) {
            XmlContactEntryGDataSerializer.serializeBlob(serializer, xmlBlob);
        }
        serializer.endTag("http://schemas.google.com/g/2005", XmlNametable.GD_EXTENDEDPROPERTY);
    }

    private static void serializeBlob(XmlSerializer serializer, String blob) throws IOException {
        serializer.text(blob);
    }

    private static boolean shouldSerialize(TypedElement element, String value) {
        if (element.getType() != -1) {
            return true;
        }
        if (!StringUtils.isEmptyOrWhitespace(element.getLabel())) {
            return true;
        }
        return !StringUtils.isEmptyOrWhitespace(value);
    }

    private static void serialize(XmlSerializer serializer, CalendarLink calendarLink) throws IOException, ParseException {
        String href = calendarLink.getHRef();
        if (XmlContactEntryGDataSerializer.shouldSerialize(calendarLink, href)) {
            serializer.startTag("http://schemas.google.com/contact/2008", XmlNametable.GC_CALENDARLINK);
            XmlContactEntryGDataSerializer.serializeContactsElement(serializer, calendarLink, XmlContactsGDataParser.TYPE_TO_REL_CALENDARLINK);
            if (!StringUtils.isEmpty(href)) {
                serializer.attribute(null, XmlNametable.HREF, href);
            }
            serializer.endTag("http://schemas.google.com/contact/2008", XmlNametable.GC_CALENDARLINK);
        }
    }

    private static void serialize(XmlSerializer serializer, Event event) throws IOException, ParseException {
        String startDate = event.getStartDate();
        if (XmlContactEntryGDataSerializer.shouldSerialize(event, startDate)) {
            serializer.startTag("http://schemas.google.com/contact/2008", XmlNametable.GC_EVENT);
            XmlContactEntryGDataSerializer.serializeTypedElement(serializer, event, XmlContactsGDataParser.TYPE_TO_REL_EVENT);
            if (!StringUtils.isEmpty(startDate)) {
                serializer.startTag("http://schemas.google.com/g/2005", XmlNametable.GD_WHEN);
                serializer.attribute(null, XmlNametable.STARTTIME, startDate);
                serializer.endTag("http://schemas.google.com/g/2005", XmlNametable.GD_WHEN);
            }
            serializer.endTag("http://schemas.google.com/contact/2008", XmlNametable.GC_EVENT);
        }
    }

    private static void serialize(XmlSerializer serializer, ExternalId externalId) throws IOException, ParseException {
        String value = externalId.getValue();
        if (XmlContactEntryGDataSerializer.shouldSerialize(externalId, value)) {
            serializer.startTag("http://schemas.google.com/contact/2008", XmlNametable.GC_EXTERNALID);
            XmlContactEntryGDataSerializer.serializeTypedElement(serializer, externalId, XmlContactsGDataParser.TYPE_TO_REL_EXTERNALID);
            if (!StringUtils.isEmpty(value)) {
                serializer.attribute(null, XmlNametable.VALUE, value);
            }
            serializer.endTag("http://schemas.google.com/contact/2008", XmlNametable.GC_EXTERNALID);
        }
    }

    private static void serializeHobby(XmlSerializer serializer, String hobby) throws IOException {
        if (StringUtils.isEmptyOrWhitespace(hobby)) {
            return;
        }
        serializer.startTag("http://schemas.google.com/contact/2008", XmlNametable.GC_HOBBY);
        serializer.text(hobby);
        serializer.endTag("http://schemas.google.com/contact/2008", XmlNametable.GC_HOBBY);
    }

    private static void serializeBirthday(XmlSerializer serializer, String birthday) throws IOException {
        if (StringUtils.isEmptyOrWhitespace(birthday)) {
            return;
        }
        serializer.startTag("http://schemas.google.com/contact/2008", XmlNametable.GC_BIRTHDAY);
        serializer.attribute(null, XmlNametable.GD_WHEN, birthday);
        serializer.endTag("http://schemas.google.com/contact/2008", XmlNametable.GC_BIRTHDAY);
    }

    private static void serialize(XmlSerializer serializer, Jot jot) throws IOException {
        String value = jot.getLabel();
        if (!StringUtils.isEmptyOrWhitespace(value)) {
            serializer.startTag("http://schemas.google.com/contact/2008", XmlNametable.GC_JOT);
            XmlContactEntryGDataSerializer.serializeRelation(serializer, jot.getType(), XmlContactsGDataParser.TYPE_TO_REL_JOT);
            serializer.text(value);
            serializer.endTag("http://schemas.google.com/contact/2008", XmlNametable.GC_JOT);
        }
    }

    private static void serialize(XmlSerializer serializer, Language language) throws IOException, ParseException {
        language.validate();
        serializer.startTag("http://schemas.google.com/contact/2008", XmlNametable.GC_LANGUAGE);
        String value = language.getCode();
        if (!StringUtils.isEmptyOrWhitespace(value)) {
            serializer.attribute(null, XmlNametable.CODE, value);
        } else {
            serializer.attribute(null, XmlNametable.LABEL, language.getLabel());
        }
        serializer.endTag("http://schemas.google.com/contact/2008", XmlNametable.GC_LANGUAGE);
    }

    private static void serialize(XmlSerializer serializer, Relation relation) throws IOException, ParseException {
        String value = relation.getText();
        if (XmlContactEntryGDataSerializer.shouldSerialize(relation, value)) {
            serializer.startTag("http://schemas.google.com/contact/2008", XmlNametable.GC_RELATION);
            XmlContactEntryGDataSerializer.serializeTypedElement(serializer, relation, XmlContactsGDataParser.TYPE_TO_REL_RELATION);
            serializer.text(value);
            serializer.endTag("http://schemas.google.com/contact/2008", XmlNametable.GC_RELATION);
        }
    }

    private static void serialize(XmlSerializer serializer, UserDefinedField udf) throws IOException, ParseException {
        udf.validate();
        serializer.startTag("http://schemas.google.com/contact/2008", XmlNametable.GC_UDF);
        serializer.attribute(null, XmlNametable.KEY, udf.getKey());
        serializer.attribute(null, XmlNametable.VALUE, udf.getValue());
        serializer.endTag("http://schemas.google.com/contact/2008", XmlNametable.GC_UDF);
    }

    private static void serialize(XmlSerializer serializer, WebSite webSite) throws IOException, ParseException {
        String href = webSite.getHRef();
        if (XmlContactEntryGDataSerializer.shouldSerialize(webSite, href)) {
            serializer.startTag("http://schemas.google.com/contact/2008", XmlNametable.GC_WEBSITE);
            XmlContactEntryGDataSerializer.serializeContactsElement(serializer, webSite, XmlContactsGDataParser.TYPE_TO_REL_WEBSITE);
            if (!StringUtils.isEmpty(href)) {
                serializer.attribute(null, XmlNametable.HREF, href);
            }
            serializer.endTag("http://schemas.google.com/contact/2008", XmlNametable.GC_WEBSITE);
        }
    }

    private static void serializeElement(XmlSerializer serializer, String value, String elementName) throws IOException {
        if (StringUtils.isEmpty(value)) {
            return;
        }
        serializer.startTag("http://schemas.google.com/contact/2008", elementName);
        serializer.text(value);
        serializer.endTag("http://schemas.google.com/contact/2008", elementName);
    }

    private static void serializeGenderElement(XmlSerializer serializer, String value) throws IOException {
        if (StringUtils.isEmpty(value)) {
            return;
        }
        serializer.startTag("http://schemas.google.com/contact/2008", XmlNametable.GC_GENDER);
        serializer.attribute(null, XmlNametable.VALUE, value);
        serializer.endTag("http://schemas.google.com/contact/2008", XmlNametable.GC_GENDER);
    }

    private static void serializeElement(XmlSerializer serializer, byte value, String elementName, Hashtable typeToRelMap) throws IOException {
        if (value == -1) {
            return;
        }
        serializer.startTag("http://schemas.google.com/contact/2008", elementName);
        XmlContactEntryGDataSerializer.serializeRelation(serializer, value, typeToRelMap);
        serializer.endTag("http://schemas.google.com/contact/2008", elementName);
    }

    private static void serializeName(XmlSerializer serializer, Name name) throws IOException {
        if (name == null) {
            return;
        }
        serializer.startTag("http://schemas.google.com/g/2005", XmlNametable.GD_NAME);
        XmlContactEntryGDataSerializer.serializeNameSubelement(serializer, name.getGivenName(), name.getGivenNameYomi(), XmlNametable.GD_NAME_GIVENNAME);
        XmlContactEntryGDataSerializer.serializeNameSubelement(serializer, name.getAdditionalName(), name.getAdditionalNameYomi(), XmlNametable.GD_NAME_ADDITIONALNAME);
        XmlContactEntryGDataSerializer.serializeNameSubelement(serializer, name.getFamilyName(), name.getFamilyNameYomi(), XmlNametable.GD_NAME_FAMILYNAME);
        XmlContactEntryGDataSerializer.serializeNameSubelement(serializer, name.getNamePrefix(), null, XmlNametable.GD_NAME_PREFIX);
        XmlContactEntryGDataSerializer.serializeNameSubelement(serializer, name.getNameSuffix(), null, XmlNametable.GD_NAME_SUFFIX);
        XmlContactEntryGDataSerializer.serializeNameSubelement(serializer, name.getFullName(), null, XmlNametable.GD_NAME_FULLNAME);
        serializer.endTag("http://schemas.google.com/g/2005", XmlNametable.GD_NAME);
    }

    private static void serializeNameSubelement(XmlSerializer serializer, String value, String yomi, String elementName) throws IOException {
        if (StringUtils.isEmpty(value)) {
            return;
        }
        serializer.startTag("http://schemas.google.com/g/2005", elementName);
        if (!StringUtils.isEmpty(yomi)) {
            serializer.attribute(null, XmlNametable.GD_NAME_YOMI, yomi);
        }
        serializer.text(value);
        serializer.endTag("http://schemas.google.com/g/2005", elementName);
    }
}

