/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.gdata2.serializer.xml;

import com.google.wireless.gdata2.data.Entry;
import com.google.wireless.gdata2.data.StringUtils;
import com.google.wireless.gdata2.data.batch.BatchUtils;
import com.google.wireless.gdata2.parser.ParseException;
import com.google.wireless.gdata2.parser.xml.XmlNametable;
import com.google.wireless.gdata2.parser.xml.XmlParserFactory;
import com.google.wireless.gdata2.serializer.GDataSerializer;
import java.io.IOException;
import java.io.OutputStream;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XmlEntryGDataSerializer
implements GDataSerializer {
    private final XmlParserFactory factory;
    private final Entry entry;
    private final boolean supportsPartial;

    public XmlEntryGDataSerializer(XmlParserFactory factory, Entry entry) {
        this.factory = factory;
        this.entry = entry;
        this.supportsPartial = !StringUtils.isEmptyOrWhitespace(this.entry.getFields());
    }

    protected Entry getEntry() {
        return this.entry;
    }

    public String getContentType() {
        return "application/atom+xml";
    }

    public boolean getSupportsPartial() {
        return this.supportsPartial;
    }

    public void serialize(OutputStream out, int format) throws IOException, ParseException {
        XmlSerializer serializer = null;
        try {
            serializer = this.factory.createSerializer();
        }
        catch (XmlPullParserException e) {
            throw new ParseException("Unable to create XmlSerializer.", e);
        }
        serializer.setOutput(out, XmlNametable.UTF8);
        if (format != 3) {
            serializer.startDocument(XmlNametable.UTF8, Boolean.FALSE);
            this.declareEntryNamespaces(serializer);
        }
        String fields = this.entry.getFields();
        if (this.getSupportsPartial()) {
            serializer.startTag("http://schemas.google.com/g/2005", XmlNametable.PARTIAL);
            serializer.attribute(null, XmlNametable.FIELDS, fields);
        }
        serializer.startTag("http://www.w3.org/2005/Atom", XmlNametable.ENTRY);
        this.serializeEntryContents(serializer, format);
        serializer.endTag("http://www.w3.org/2005/Atom", XmlNametable.ENTRY);
        if (this.getSupportsPartial()) {
            serializer.endTag("http://schemas.google.com/g/2005", XmlNametable.PARTIAL);
        }
        if (format != 3) {
            serializer.endDocument();
        }
        serializer.flush();
    }

    private void declareEntryNamespaces(XmlSerializer serializer) throws IOException {
        serializer.setPrefix("", "http://www.w3.org/2005/Atom");
        serializer.setPrefix("gd", "http://schemas.google.com/g/2005");
        this.declareExtraEntryNamespaces(serializer);
    }

    protected void declareExtraEntryNamespaces(XmlSerializer serializer) throws IOException {
    }

    private void serializeEntryContents(XmlSerializer serializer, int format) throws ParseException, IOException {
        if (format == 3) {
            this.serializeBatchInfo(serializer);
        }
        if (format != 1) {
            XmlEntryGDataSerializer.serializeId(serializer, this.entry.getId());
        }
        XmlEntryGDataSerializer.serializeTitle(serializer, this.entry.getTitle());
        if (format != 1) {
            XmlEntryGDataSerializer.serializeLink(serializer, XmlNametable.EDIT_REL, this.entry.getEditUri(), null, null);
            XmlEntryGDataSerializer.serializeLink(serializer, XmlNametable.ALTERNATE_REL, this.entry.getHtmlUri(), XmlNametable.TEXTHTML, null);
        }
        XmlEntryGDataSerializer.serializeSummary(serializer, this.entry.getSummary());
        XmlEntryGDataSerializer.serializeContent(serializer, this.entry.getContent());
        XmlEntryGDataSerializer.serializeAuthor(serializer, this.entry.getAuthor(), this.entry.getEmail());
        XmlEntryGDataSerializer.serializeCategory(serializer, this.entry.getCategory(), this.entry.getCategoryScheme());
        if (format == 0) {
            XmlEntryGDataSerializer.serializePublicationDate(serializer, this.entry.getPublicationDate());
        }
        if (format != 1) {
            XmlEntryGDataSerializer.serializeUpdateDate(serializer, this.entry.getUpdateDate());
        }
        this.serializeExtraEntryContents(serializer, format);
    }

    protected void serializeExtraEntryContents(XmlSerializer serializer, int format) throws ParseException, IOException {
    }

    private static void serializeId(XmlSerializer serializer, String id) throws IOException {
        if (StringUtils.isEmpty(id)) {
            return;
        }
        serializer.startTag(null, XmlNametable.ID);
        serializer.text(id);
        serializer.endTag(null, XmlNametable.ID);
    }

    private static void serializeTitle(XmlSerializer serializer, String title) throws IOException {
        if (StringUtils.isEmpty(title)) {
            return;
        }
        serializer.startTag(null, XmlNametable.TITLE);
        serializer.text(title);
        serializer.endTag(null, XmlNametable.TITLE);
    }

    protected static void serializeLink(XmlSerializer serializer, String rel, String href, String type, String etag) throws IOException {
        if (StringUtils.isEmpty(href)) {
            return;
        }
        serializer.startTag(null, XmlNametable.LINK);
        serializer.attribute(null, XmlNametable.REL, rel);
        serializer.attribute(null, XmlNametable.HREF, href);
        if (!StringUtils.isEmpty(type)) {
            serializer.attribute(null, XmlNametable.TYPE, type);
        }
        if (!StringUtils.isEmpty(etag)) {
            serializer.attribute(null, XmlNametable.ETAG, etag);
        }
        serializer.endTag(null, XmlNametable.LINK);
    }

    private static void serializeSummary(XmlSerializer serializer, String summary) throws IOException {
        if (StringUtils.isEmpty(summary)) {
            return;
        }
        serializer.startTag(null, XmlNametable.SUMMARY);
        serializer.text(summary);
        serializer.endTag(null, XmlNametable.SUMMARY);
    }

    private static void serializeContent(XmlSerializer serializer, String content) throws IOException {
        if (content == null) {
            return;
        }
        serializer.startTag(null, XmlNametable.CONTENT);
        serializer.attribute(null, XmlNametable.TYPE, XmlNametable.TEXT);
        serializer.text(content);
        serializer.endTag(null, XmlNametable.CONTENT);
    }

    private static void serializeAuthor(XmlSerializer serializer, String author, String email) throws IOException {
        if (StringUtils.isEmpty(author) || StringUtils.isEmpty(email)) {
            return;
        }
        serializer.startTag(null, XmlNametable.AUTHOR);
        serializer.startTag(null, XmlNametable.NAME);
        serializer.text(author);
        serializer.endTag(null, XmlNametable.NAME);
        serializer.startTag(null, XmlNametable.EMAIL);
        serializer.text(email);
        serializer.endTag(null, XmlNametable.EMAIL);
        serializer.endTag(null, XmlNametable.AUTHOR);
    }

    private static void serializeCategory(XmlSerializer serializer, String category, String categoryScheme) throws IOException {
        if (StringUtils.isEmpty(category) && StringUtils.isEmpty(categoryScheme)) {
            return;
        }
        serializer.startTag(null, XmlNametable.CATEGORY);
        if (!StringUtils.isEmpty(category)) {
            serializer.attribute(null, XmlNametable.TERM, category);
        }
        if (!StringUtils.isEmpty(categoryScheme)) {
            serializer.attribute(null, XmlNametable.SCHEME, categoryScheme);
        }
        serializer.endTag(null, XmlNametable.CATEGORY);
    }

    private static void serializePublicationDate(XmlSerializer serializer, String publicationDate) throws IOException {
        if (StringUtils.isEmpty(publicationDate)) {
            return;
        }
        serializer.startTag(null, XmlNametable.PUBLISHED);
        serializer.text(publicationDate);
        serializer.endTag(null, XmlNametable.PUBLISHED);
    }

    private static void serializeUpdateDate(XmlSerializer serializer, String updateDate) throws IOException {
        if (StringUtils.isEmpty(updateDate)) {
            return;
        }
        serializer.startTag(null, XmlNametable.UPDATED);
        serializer.text(updateDate);
        serializer.endTag(null, XmlNametable.UPDATED);
    }

    private void serializeBatchInfo(XmlSerializer serializer) throws IOException {
        if (!StringUtils.isEmpty(this.entry.getETag())) {
            serializer.attribute("http://schemas.google.com/g/2005", XmlNametable.ETAG, this.entry.getETag());
        }
        if (!StringUtils.isEmpty(BatchUtils.getBatchOperation(this.entry))) {
            serializer.startTag("http://schemas.google.com/gdata/batch", XmlNametable.OPERATION);
            serializer.attribute(null, XmlNametable.TYPE, BatchUtils.getBatchOperation(this.entry));
            serializer.endTag("http://schemas.google.com/gdata/batch", XmlNametable.OPERATION);
        }
        if (!StringUtils.isEmpty(BatchUtils.getBatchId(this.entry))) {
            serializer.startTag("http://schemas.google.com/gdata/batch", XmlNametable.ID);
            serializer.text(BatchUtils.getBatchId(this.entry));
            serializer.endTag("http://schemas.google.com/gdata/batch", XmlNametable.ID);
        }
    }
}

