/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.authsub;

import com.google.api.client.auth.RsaSha;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.SecureRandom;

public class AuthSub {
    private static final SecureRandom RANDOM = new SecureRandom();

    public static String getAuthorizationHeaderValue(String token) {
        return AuthSub.getAuthSubTokenPrefix(token).toString();
    }

    public static String getAuthorizationHeaderValue(String token, PrivateKey privateKey, String requestMethod, String requestUrl) throws GeneralSecurityException {
        StringBuilder buf = AuthSub.getAuthSubTokenPrefix(token);
        if (privateKey != null) {
            String algorithm = privateKey.getAlgorithm();
            if (!"RSA".equals(algorithm)) {
                throw new IllegalArgumentException("Only supported algorithm for private key is RSA: " + algorithm);
            }
            long timestamp = System.currentTimeMillis() / 1000L;
            long nonce = Math.abs(RANDOM.nextLong());
            String data = requestMethod + ' ' + requestUrl + ' ' + timestamp + ' ' + nonce;
            String sig = RsaSha.sign(privateKey, data);
            buf.append(" sigalg=\"rsa-sha1\" data=\"").append(data).append("\" sig=\"").append(sig).append('\"');
        }
        return buf.toString();
    }

    private static StringBuilder getAuthSubTokenPrefix(String token) {
        return new StringBuilder("AuthSub token=\"").append(token).append('\"');
    }

    private AuthSub() {
    }
}

