/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gsf;

import android.os.Parcel;
import android.os.Parcelable;

public class LoginData
implements Parcelable {
    public String mUsername = null;
    public String mEncryptedPassword = null;
    public String mPassword = null;
    public String mService = null;
    public String mCaptchaToken = null;
    public byte[] mCaptchaData = null;
    public String mCaptchaMimeType = null;
    public String mCaptchaAnswer = null;
    public int mFlags = 0;
    public Status mStatus = null;
    public String mJsonString = null;
    public String mSid = null;
    public String mAuthtoken = null;
    public String mOAuthAccessToken = null;
    public static final Parcelable.Creator<LoginData> CREATOR = new Parcelable.Creator<LoginData>(){

        public LoginData createFromParcel(Parcel in) {
            return new LoginData(in);
        }

        public LoginData[] newArray(int size) {
            return new LoginData[size];
        }
    };

    public LoginData() {
    }

    public LoginData(LoginData other) {
        this.mUsername = other.mUsername;
        this.mEncryptedPassword = other.mEncryptedPassword;
        this.mPassword = other.mPassword;
        this.mService = other.mService;
        this.mCaptchaToken = other.mCaptchaToken;
        this.mCaptchaData = other.mCaptchaData;
        this.mCaptchaMimeType = other.mCaptchaMimeType;
        this.mCaptchaAnswer = other.mCaptchaAnswer;
        this.mFlags = other.mFlags;
        this.mStatus = other.mStatus;
        this.mJsonString = other.mJsonString;
        this.mSid = other.mSid;
        this.mAuthtoken = other.mAuthtoken;
        this.mOAuthAccessToken = other.mOAuthAccessToken;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mUsername);
        out.writeString(this.mEncryptedPassword);
        out.writeString(this.mPassword);
        out.writeString(this.mService);
        out.writeString(this.mCaptchaToken);
        if (this.mCaptchaData == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.mCaptchaData.length);
            out.writeByteArray(this.mCaptchaData);
        }
        out.writeString(this.mCaptchaMimeType);
        out.writeString(this.mCaptchaAnswer);
        out.writeInt(this.mFlags);
        if (this.mStatus == null) {
            out.writeString(null);
        } else {
            out.writeString(this.mStatus.name());
        }
        out.writeString(this.mJsonString);
        out.writeString(this.mSid);
        out.writeString(this.mAuthtoken);
        out.writeString(this.mOAuthAccessToken);
    }

    private LoginData(Parcel in) {
        this.readFromParcel(in);
    }

    public void readFromParcel(Parcel in) {
        this.mUsername = in.readString();
        this.mEncryptedPassword = in.readString();
        this.mPassword = in.readString();
        this.mService = in.readString();
        this.mCaptchaToken = in.readString();
        int len = in.readInt();
        if (len == -1) {
            this.mCaptchaData = null;
        } else {
            this.mCaptchaData = new byte[len];
            in.readByteArray(this.mCaptchaData);
        }
        this.mCaptchaMimeType = in.readString();
        this.mCaptchaAnswer = in.readString();
        this.mFlags = in.readInt();
        String status = in.readString();
        this.mStatus = status == null ? null : Status.valueOf(status);
        this.mJsonString = in.readString();
        this.mSid = in.readString();
        this.mAuthtoken = in.readString();
        this.mOAuthAccessToken = in.readString();
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        sb.append("         status: ");
        sb.append((Object)this.mStatus);
        sb.append("\n       username: ");
        sb.append(this.mUsername);
        sb.append("\n       password: ");
        sb.append(this.mPassword);
        sb.append("\n   enc password: ");
        sb.append(this.mEncryptedPassword);
        sb.append("\n        service: ");
        sb.append(this.mService);
        sb.append("\n      authtoken: ");
        sb.append(this.mAuthtoken);
        sb.append("\n      oauthAccessToken: ");
        sb.append(this.mOAuthAccessToken);
        sb.append("\n   captchatoken: ");
        sb.append(this.mCaptchaToken);
        sb.append("\n  captchaanswer: ");
        sb.append(this.mCaptchaAnswer);
        sb.append("\n    captchadata: ");
        sb.append(this.mCaptchaData == null ? "null" : Integer.toString(this.mCaptchaData.length) + " bytes");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        SUCCESS,
        ACCOUNT_DISABLED,
        BAD_USERNAME,
        BAD_REQUEST,
        LOGIN_FAIL,
        SERVER_ERROR,
        MISSING_APPS,
        NO_GMAIL,
        NETWORK_ERROR,
        CAPTCHA,
        CANCELLED,
        DELETED_GMAIL,
        OAUTH_MIGRATION_REQUIRED;

    }
}

