/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gsf;

import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import android.widget.TextView;

public class WebLoginView {
    private static final String TAG = "WebLoginView";
    private WebView mWebView;
    private View mProgressView;
    private View mTitleView;
    private TextView mTitleTextView;
    private ProgressBar mProgressBar;
    private View mBackButton;
    private View mCancelButton;
    private View mBottomBar;
    private Callback mCallback;
    private String mStartUrl;
    private String mDomainName;
    private boolean mIsLoading;

    public WebLoginView(WebView webView, View progressView, ProgressBar progressBar, View backButton, View cancelButton, View titleView, TextView titleTextView, View bottomBar, Callback callback) {
        this.mWebView = webView;
        this.mProgressView = progressView;
        this.mProgressBar = progressBar;
        this.mProgressBar.setMax(100);
        this.mCallback = callback;
        this.mBackButton = backButton;
        this.mCancelButton = cancelButton;
        this.mTitleView = titleView;
        this.mTitleTextView = titleTextView;
        this.mBottomBar = bottomBar;
        this.setupOptionsAndCallbacks();
    }

    public void login(String startUrl, String domainName) {
        this.mStartUrl = startUrl;
        this.mDomainName = domainName;
        this.doLogin();
    }

    private void doLogin() {
        this.mTitleView.setVisibility(8);
        this.mWebView.setVisibility(8);
        this.mBackButton.setVisibility(8);
        this.mCancelButton.setVisibility(0);
        this.mProgressBar.setProgress(0);
        this.mProgressView.setVisibility(0);
        this.mWebView.loadUrl(this.mStartUrl);
        this.mIsLoading = true;
    }

    public void stop() {
        if (this.mIsLoading) {
            this.mWebView.stopLoading();
            this.mIsLoading = false;
        }
    }

    private void setupOptionsAndCallbacks() {
        this.mWebView.setWebViewClient((WebViewClient)new MyWebViewClient());
        this.mWebView.setWebChromeClient((WebChromeClient)new MyChromeClient());
        WebSettings s = this.mWebView.getSettings();
        s.setJavaScriptEnabled(true);
        s.setSupportMultipleWindows(false);
        s.setSaveFormData(false);
        s.setSavePassword(false);
        s.setAllowFileAccess(false);
        s.setDatabaseEnabled(false);
        s.setJavaScriptCanOpenWindowsAutomatically(false);
        s.setLoadsImagesAutomatically(true);
        s.setLightTouchEnabled(false);
        s.setNeedInitialFocus(false);
        s.setUseWideViewPort(true);
        this.mWebView.setMapTrackballToArrowKeys(false);
        this.mWebView.setFocusable(true);
        this.mWebView.setFocusableInTouchMode(true);
    }

    private class MyWebViewClient
    extends WebViewClient {
        private boolean mOAuthDone = false;
        private String mOAuthUrl;

        private MyWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            Log.i((String)WebLoginView.TAG, (String)("Web view is loading " + url));
            Uri uri = Uri.parse((String)url);
            if (uri.getScheme().compareTo("oauth") == 0 && uri.getSchemeSpecificPart().startsWith("//gls/callback?")) {
                Log.i((String)WebLoginView.TAG, (String)("We will handle oauth:gls URL " + url));
                this.mOAuthDone = true;
                this.mOAuthUrl = url;
                return this.maybeFinish(view);
            }
            return false;
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            Log.i((String)WebLoginView.TAG, (String)("onPageStarted " + url + (WebLoginView.this.mIsLoading ? " - loading" : " - not loading")));
            if (!WebLoginView.this.mIsLoading) {
                WebLoginView.this.mWebView.stopLoading();
                return;
            }
            if (!this.maybeFinish(view)) {
                super.onPageStarted(view, url, favicon);
            }
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            Log.w((String)WebLoginView.TAG, (String)("onReceivedError " + description));
            WebLoginView.this.mIsLoading = false;
            this.hideWebUI();
            WebLoginView.this.mCallback.onWebLoginError(Error.HttpError, errorCode, description);
            super.onReceivedError(view, errorCode, description, failingUrl);
        }

        public void onTooManyRedirects(WebView view, Message cancelMsg, Message continueMsg) {
            Log.e((String)WebLoginView.TAG, (String)"onTooManyRedirects");
            this.hideWebUI();
            super.onTooManyRedirects(view, cancelMsg, continueMsg);
            WebLoginView.this.mCallback.onWebLoginError(Error.TooManyRedirects, 0, "");
        }

        private void hideWebUI() {
            WebLoginView.this.mWebView.clearView();
            WebLoginView.this.mWebView.setVisibility(8);
            WebLoginView.this.mTitleView.setVisibility(8);
            WebLoginView.this.mBottomBar.setVisibility(0);
        }

        public void onPageFinished(WebView view, String url) {
            if (!WebLoginView.this.mIsLoading) {
                Log.i((String)WebLoginView.TAG, (String)("Web view ingoring loaded url " + url));
                return;
            }
            if (!this.maybeFinish(view)) {
                String pageTitle;
                Log.v((String)WebLoginView.TAG, (String)("Not finished at " + url));
                super.onPageFinished(view, url);
                WebLoginView.this.mProgressView.setVisibility(8);
                WebLoginView.this.mTitleView.setVisibility(0);
                Uri uri = Uri.parse((String)url);
                String titleString = "";
                if ("https".equalsIgnoreCase(uri.getScheme())) {
                    titleString = titleString + "https://";
                }
                titleString = TextUtils.isEmpty((CharSequence)(pageTitle = WebLoginView.this.mWebView.getTitle())) ? titleString + uri.getAuthority() : titleString + uri.getAuthority() + " : " + pageTitle;
                WebLoginView.this.mTitleTextView.setText((CharSequence)titleString);
                WebLoginView.this.mBottomBar.setVisibility(8);
                WebLoginView.this.mCancelButton.setVisibility(8);
                WebLoginView.this.mWebView.setVisibility(0);
                WebLoginView.this.mWebView.requestFocus();
            } else {
                Log.v((String)WebLoginView.TAG, (String)("Finished at " + url));
            }
        }

        private boolean maybeFinish(WebView view) {
            if (!this.mOAuthDone) {
                return false;
            }
            view.stopLoading();
            WebLoginView.this.mIsLoading = false;
            this.hideWebUI();
            WebLoginView.this.mCallback.onWebLoginCompleted(this.mOAuthUrl);
            return true;
        }
    }

    private class MyChromeClient
    extends WebChromeClient {
        private MyChromeClient() {
        }

        public boolean onCreateWindow(WebView view, boolean dialog, boolean userGesture, Message resultMsg) {
            Log.v((String)WebLoginView.TAG, (String)"onCreateWindow");
            resultMsg.obj = WebLoginView.this.mWebView;
            resultMsg.sendToTarget();
            return true;
        }

        public void onProgressChanged(WebView view, int newProgress) {
            WebLoginView.this.mProgressBar.setProgress(newProgress);
        }
    }

    public static interface Callback {
        public void onWebLoginCompleted(String var1);

        public void onWebLoginError(Error var1, int var2, String var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Error {
        HttpError,
        TooManyRedirects;

    }
}

