/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.gdata.parser.xml;

import com.google.wireless.gdata.data.Entry;
import com.google.wireless.gdata.data.Feed;
import com.google.wireless.gdata.data.StringUtils;
import com.google.wireless.gdata.data.XmlUtils;
import com.google.wireless.gdata.parser.GDataParser;
import com.google.wireless.gdata.parser.ParseException;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XmlGDataParser
implements GDataParser {
    public static final String NAMESPACE_ATOM_URI = "http://www.w3.org/2005/Atom";
    public static final String NAMESPACE_OPENSEARCH = "openSearch";
    public static final String NAMESPACE_OPENSEARCH_URI = "http://a9.com/-/spec/opensearchrss/1.0/";
    public static final String NAMESPACE_GD = "gd";
    public static final String NAMESPACE_GD_URI = "http://schemas.google.com/g/2005";
    private final InputStream is;
    private final XmlPullParser parser;
    private boolean isInBadState;

    public XmlGDataParser(InputStream is, XmlPullParser parser) throws ParseException {
        this.is = is;
        this.parser = parser;
        this.isInBadState = false;
        if (this.is != null) {
            try {
                this.parser.setInput(is, null);
            }
            catch (XmlPullParserException e) {
                throw new ParseException("Could not create XmlGDataParser", e);
            }
        }
    }

    public final Feed init() throws ParseException {
        int eventType;
        try {
            eventType = this.parser.getEventType();
        }
        catch (XmlPullParserException e) {
            throw new ParseException("Could not parse GData feed.", e);
        }
        if (eventType != 0) {
            throw new ParseException("Attempting to initialize parsing beyond the start of the document.");
        }
        try {
            eventType = this.parser.next();
        }
        catch (XmlPullParserException xppe) {
            throw new ParseException("Could not read next event.", xppe);
        }
        catch (IOException ioe) {
            throw new ParseException("Could not read next event.", ioe);
        }
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = this.parser.getName();
                    if (!"feed".equals(name)) break;
                    try {
                        return this.parseFeed();
                    }
                    catch (XmlPullParserException xppe) {
                        throw new ParseException("Unable to parse <feed>.", xppe);
                    }
                    catch (IOException ioe) {
                        throw new ParseException("Unable to parse <feed>.", ioe);
                    }
                }
            }
            try {
                eventType = this.parser.next();
            }
            catch (XmlPullParserException xppe) {
                throw new ParseException("Could not read next event.", xppe);
            }
            catch (IOException ioe) {
                throw new ParseException("Could not read next event.", ioe);
            }
        }
        throw new ParseException("No <feed> found in document.");
    }

    protected final XmlPullParser getParser() {
        return this.parser;
    }

    protected Feed createFeed() {
        return new Feed();
    }

    protected Entry createEntry() {
        return new Entry();
    }

    private final Feed parseFeed() throws XmlPullParserException, IOException {
        Feed feed = this.createFeed();
        int eventType = this.parser.next();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = this.parser.getName();
                    if ("totalResults".equals(name)) {
                        feed.setTotalResults(StringUtils.parseInt(XmlUtils.extractChildText(this.parser), 0));
                        break;
                    }
                    if ("startIndex".equals(name)) {
                        feed.setStartIndex(StringUtils.parseInt(XmlUtils.extractChildText(this.parser), 0));
                        break;
                    }
                    if ("itemsPerPage".equals(name)) {
                        feed.setItemsPerPage(StringUtils.parseInt(XmlUtils.extractChildText(this.parser), 0));
                        break;
                    }
                    if ("title".equals(name)) {
                        feed.setTitle(XmlUtils.extractChildText(this.parser));
                        break;
                    }
                    if ("id".equals(name)) {
                        feed.setId(XmlUtils.extractChildText(this.parser));
                        break;
                    }
                    if ("updated".equals(name)) {
                        feed.setLastUpdated(XmlUtils.extractChildText(this.parser));
                        break;
                    }
                    if ("category".equals(name)) {
                        String categoryScheme;
                        String category = this.parser.getAttributeValue(null, "term");
                        if (!StringUtils.isEmpty(category)) {
                            feed.setCategory(category);
                        }
                        if (StringUtils.isEmpty(categoryScheme = this.parser.getAttributeValue(null, "scheme"))) break;
                        feed.setCategoryScheme(categoryScheme);
                        break;
                    }
                    if ("entry".equals(name)) {
                        return feed;
                    }
                    this.handleExtraElementInFeed(feed);
                    break;
                }
            }
            eventType = this.parser.next();
        }
        return feed;
    }

    protected void handleExtraElementInFeed(Feed feed) throws XmlPullParserException, IOException {
    }

    public boolean hasMoreData() {
        if (this.isInBadState) {
            return false;
        }
        try {
            int eventType = this.parser.getEventType();
            return eventType != 1;
        }
        catch (XmlPullParserException xppe) {
            return false;
        }
    }

    public Entry readNextEntry(Entry entry) throws ParseException, IOException {
        int eventType;
        if (!this.hasMoreData()) {
            throw new IllegalStateException("you shouldn't call this if hasMoreData() is false");
        }
        try {
            eventType = this.parser.getEventType();
        }
        catch (XmlPullParserException e) {
            throw new ParseException("Could not parse entry.", e);
        }
        if (eventType != 2) {
            throw new ParseException("Expected event START_TAG: Actual event: " + XmlPullParser.TYPES[eventType]);
        }
        String name = this.parser.getName();
        if (!"entry".equals(name)) {
            throw new ParseException("Expected <entry>: Actual element: <" + name + ">");
        }
        if (entry == null) {
            entry = this.createEntry();
        } else {
            entry.clear();
        }
        try {
            this.parser.next();
            this.handleEntry(entry);
            entry.validate();
        }
        catch (ParseException xppe1) {
            try {
                if (this.hasMoreData()) {
                    this.skipToNextEntry();
                }
            }
            catch (XmlPullParserException xppe2) {
                this.isInBadState = true;
            }
            throw new ParseException("Could not parse <entry>, " + entry, xppe1);
        }
        catch (XmlPullParserException xppe1) {
            try {
                if (this.hasMoreData()) {
                    this.skipToNextEntry();
                }
            }
            catch (XmlPullParserException xppe2) {
                this.isInBadState = true;
            }
            throw new ParseException("Could not parse <entry>, " + entry, xppe1);
        }
        return entry;
    }

    public Entry parseStandaloneEntry() throws ParseException, IOException {
        int eventType;
        Entry entry = this.createEntry();
        try {
            eventType = this.parser.getEventType();
        }
        catch (XmlPullParserException e) {
            throw new ParseException("Could not parse GData entry.", e);
        }
        if (eventType != 0) {
            throw new ParseException("Attempting to initialize parsing beyond the start of the document.");
        }
        try {
            eventType = this.parser.next();
        }
        catch (XmlPullParserException xppe) {
            throw new ParseException("Could not read next event.", xppe);
        }
        catch (IOException ioe) {
            throw new ParseException("Could not read next event.", ioe);
        }
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = this.parser.getName();
                    if (!"entry".equals(name)) break;
                    try {
                        this.parser.next();
                        this.handleEntry(entry);
                        return entry;
                    }
                    catch (XmlPullParserException xppe) {
                        throw new ParseException("Unable to parse <entry>.", xppe);
                    }
                    catch (IOException ioe) {
                        throw new ParseException("Unable to parse <entry>.", ioe);
                    }
                }
            }
            try {
                eventType = this.parser.next();
            }
            catch (XmlPullParserException xppe) {
                throw new ParseException("Could not read next event.", xppe);
            }
        }
        throw new ParseException("No <entry> found in document.");
    }

    protected void skipToNextEntry() throws IOException, XmlPullParserException {
        if (!this.hasMoreData()) {
            throw new IllegalStateException("you shouldn't call this if hasMoreData() is false");
        }
        int eventType = this.parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    if (!"entry".equals(this.parser.getName())) break;
                    return;
                }
            }
            eventType = this.parser.next();
        }
    }

    protected void handleEntry(Entry entry) throws XmlPullParserException, IOException, ParseException {
        int eventType = this.parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = this.parser.getName();
                    if ("entry".equals(name)) {
                        return;
                    }
                    if ("id".equals(name)) {
                        entry.setId(XmlUtils.extractChildText(this.parser));
                        break;
                    }
                    if ("title".equals(name)) {
                        entry.setTitle(XmlUtils.extractChildText(this.parser));
                        break;
                    }
                    if ("link".equals(name)) {
                        String rel = this.parser.getAttributeValue(null, "rel");
                        String type = this.parser.getAttributeValue(null, "type");
                        String href = this.parser.getAttributeValue(null, "href");
                        if ("edit".equals(rel)) {
                            entry.setEditUri(href);
                            break;
                        }
                        if ("alternate".equals(rel) && "text/html".equals(type)) {
                            entry.setHtmlUri(href);
                            break;
                        }
                        this.handleExtraLinkInEntry(rel, type, href, entry);
                        break;
                    }
                    if ("summary".equals(name)) {
                        entry.setSummary(XmlUtils.extractChildText(this.parser));
                        break;
                    }
                    if ("content".equals(name)) {
                        entry.setContent(XmlUtils.extractChildText(this.parser));
                        break;
                    }
                    if ("author".equals(name)) {
                        this.handleAuthor(entry);
                        break;
                    }
                    if ("category".equals(name)) {
                        String categoryScheme;
                        String category = this.parser.getAttributeValue(null, "term");
                        if (category != null && category.length() > 0) {
                            entry.setCategory(category);
                        }
                        if ((categoryScheme = this.parser.getAttributeValue(null, "scheme")) == null || category.length() <= 0) break;
                        entry.setCategoryScheme(categoryScheme);
                        break;
                    }
                    if ("published".equals(name)) {
                        entry.setPublicationDate(XmlUtils.extractChildText(this.parser));
                        break;
                    }
                    if ("updated".equals(name)) {
                        entry.setUpdateDate(XmlUtils.extractChildText(this.parser));
                        break;
                    }
                    if ("deleted".equals(name)) {
                        entry.setDeleted(true);
                        break;
                    }
                    this.handleExtraElementInEntry(entry);
                    break;
                }
            }
            eventType = this.parser.next();
        }
    }

    private void handleAuthor(Entry entry) throws XmlPullParserException, IOException {
        int eventType = this.parser.getEventType();
        String name = this.parser.getName();
        if (eventType != 2 || !"author".equals(this.parser.getName())) {
            throw new IllegalStateException("Expected <author>: Actual element: <" + this.parser.getName() + ">");
        }
        eventType = this.parser.next();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    name = this.parser.getName();
                    if ("name".equals(name)) {
                        String authorName = XmlUtils.extractChildText(this.parser);
                        entry.setAuthor(authorName);
                        break;
                    }
                    if (!"email".equals(name)) break;
                    String email = XmlUtils.extractChildText(this.parser);
                    entry.setEmail(email);
                    break;
                }
                case 3: {
                    name = this.parser.getName();
                    if (!"author".equals(name)) break;
                    return;
                }
            }
            eventType = this.parser.next();
        }
    }

    public void close() {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void handleExtraElementInEntry(Entry entry) throws XmlPullParserException, IOException, ParseException {
    }

    protected void handleExtraLinkInEntry(String rel, String type, String href, Entry entry) throws XmlPullParserException, IOException {
    }
}

