/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.gdata2.calendar.parser.xml;

import com.google.wireless.gdata2.calendar.data.EventEntry;
import com.google.wireless.gdata2.calendar.data.EventsFeed;
import com.google.wireless.gdata2.calendar.data.Reminder;
import com.google.wireless.gdata2.calendar.data.When;
import com.google.wireless.gdata2.calendar.data.Who;
import com.google.wireless.gdata2.data.Entry;
import com.google.wireless.gdata2.data.Feed;
import com.google.wireless.gdata2.data.StringUtils;
import com.google.wireless.gdata2.data.XmlUtils;
import com.google.wireless.gdata2.parser.ParseException;
import com.google.wireless.gdata2.parser.xml.XmlGDataParser;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XmlEventsGDataParser
extends XmlGDataParser {
    private static String GD_NAMESPACE = "http://schemas.google.com/g/2005";
    private static String GCAL_NAMESPACE = "http://schemas.google.com/gCal/2005";
    private boolean hasSeenReminder = false;

    public XmlEventsGDataParser(InputStream is, XmlPullParser parser) throws ParseException {
        super(is, parser);
    }

    protected Feed createFeed() {
        return new EventsFeed();
    }

    protected Entry createEntry() {
        return new EventEntry();
    }

    protected void handleEntry(Entry entry) throws XmlPullParserException, IOException, ParseException {
        this.hasSeenReminder = false;
        super.handleEntry(entry);
    }

    protected void handleExtraElementInFeed(Feed feed) throws XmlPullParserException, IOException {
        String timezone;
        XmlPullParser parser = this.getParser();
        if (!(feed instanceof EventsFeed)) {
            throw new IllegalArgumentException("Expected EventsFeed!");
        }
        EventsFeed eventsFeed = (EventsFeed)feed;
        String name = parser.getName();
        if ("timezone".equals(name) && !StringUtils.isEmpty(timezone = parser.getAttributeValue(null, "value"))) {
            eventsFeed.setTimezone(timezone);
        }
    }

    protected void handleExtraElementInEntry(Entry entry) throws XmlPullParserException, IOException, ParseException {
        XmlPullParser parser = this.getParser();
        if (!(entry instanceof EventEntry)) {
            throw new IllegalArgumentException("Expected EventEntry!");
        }
        EventEntry eventEntry = (EventEntry)entry;
        String name = parser.getName();
        if (XmlUtils.matchNameSpaceUri(parser, GD_NAMESPACE)) {
            if ("eventStatus".equals(name)) {
                String eventStatusStr = parser.getAttributeValue(null, "value");
                byte eventStatus = 0;
                if ("http://schemas.google.com/g/2005#event.canceled".equals(eventStatusStr)) {
                    eventStatus = 2;
                } else if ("http://schemas.google.com/g/2005#event.confirmed".equals(eventStatusStr)) {
                    eventStatus = 1;
                } else if ("http://schemas.google.com/g/2005#event.tentative".equals(eventStatusStr)) {
                    eventStatus = 0;
                }
                eventEntry.setStatus(eventStatus);
            } else if ("recurrence".equals(name)) {
                String recurrence = XmlUtils.extractChildText(parser);
                eventEntry.setRecurrence(recurrence);
            } else if ("transparency".equals(name)) {
                String transparencyStr = parser.getAttributeValue(null, "value");
                byte transparency = 0;
                if ("http://schemas.google.com/g/2005#event.opaque".equals(transparencyStr)) {
                    transparency = 0;
                } else if ("http://schemas.google.com/g/2005#event.transparent".equals(transparencyStr)) {
                    transparency = 1;
                }
                eventEntry.setTransparency(transparency);
            } else if ("visibility".equals(name)) {
                String visibilityStr = parser.getAttributeValue(null, "value");
                int visibility = 0;
                if ("http://schemas.google.com/g/2005#event.confidential".equals(visibilityStr)) {
                    visibility = 1;
                } else if ("http://schemas.google.com/g/2005#event.default".equals(visibilityStr)) {
                    visibility = 0;
                } else if ("http://schemas.google.com/g/2005#event.private".equals(visibilityStr)) {
                    visibility = 2;
                } else if ("http://schemas.google.com/g/2005#event.public".equals(visibilityStr)) {
                    visibility = 3;
                }
                eventEntry.setVisibility((byte)visibility);
            } else if ("who".equals(name)) {
                this.handleWho(eventEntry);
            } else if ("when".equals(name)) {
                this.handleWhen(eventEntry);
            } else if ("reminder".equals(name)) {
                if (!this.hasSeenReminder) {
                    eventEntry.clearReminders();
                    this.hasSeenReminder = true;
                }
                this.handleReminder(eventEntry);
            } else if ("originalEvent".equals(name)) {
                this.handleOriginalEvent(eventEntry);
            } else if ("where".equals(name)) {
                String where = parser.getAttributeValue(null, "valueString");
                String rel = parser.getAttributeValue(null, "rel");
                if (StringUtils.isEmpty(rel) || "http://schemas.google.com/g/2005#event".equals(rel)) {
                    eventEntry.setWhere(where);
                }
            } else if ("feedLink".equals(name)) {
                String commentsUri = parser.getAttributeValue(null, "href");
                eventEntry.setCommentsUri(commentsUri);
            } else if ("extendedProperty".equals(name)) {
                String propertyName = parser.getAttributeValue(null, "name");
                String propertyValue = parser.getAttributeValue(null, "value");
                eventEntry.addExtendedProperty(propertyName, propertyValue);
            }
        } else if (XmlUtils.matchNameSpaceUri(parser, GCAL_NAMESPACE)) {
            if ("sendEventNotifications".equals(name)) {
                String value = parser.getAttributeValue(null, "value");
                eventEntry.setSendEventNotifications("true".equals(value));
            } else if ("guestsCanModify".equals(name)) {
                String value = parser.getAttributeValue(null, "value");
                eventEntry.setGuestsCanModify("true".equals(value));
            } else if ("guestsCanInviteOthers".equals(name)) {
                String value = parser.getAttributeValue(null, "value");
                eventEntry.setGuestsCanInviteOthers("true".equals(value));
            } else if ("guestsCanSeeGuests".equals(name)) {
                String value = parser.getAttributeValue(null, "value");
                eventEntry.setGuestsCanSeeGuests("true".equals(value));
            }
        }
    }

    private void handleWho(EventEntry eventEntry) throws XmlPullParserException, IOException, ParseException {
        XmlPullParser parser = this.getParser();
        int eventType = parser.getEventType();
        String name = parser.getName();
        if (eventType != 2 || !"who".equals(parser.getName())) {
            throw new IllegalStateException("Expected <who>: Actual element: <" + name + ">");
        }
        String email = parser.getAttributeValue(null, "email");
        String relString = parser.getAttributeValue(null, "rel");
        String value = parser.getAttributeValue(null, "valueString");
        Who who = new Who();
        who.setEmail(email);
        who.setValue(value);
        int rel = 0;
        if ("http://schemas.google.com/g/2005#event.attendee".equals(relString)) {
            rel = 1;
        } else if ("http://schemas.google.com/g/2005#event.organizer".equals(relString)) {
            rel = 2;
        } else if ("http://schemas.google.com/g/2005#event.performer".equals(relString)) {
            rel = 3;
        } else if ("http://schemas.google.com/g/2005#event.speaker".equals(relString)) {
            rel = 4;
        } else if (StringUtils.isEmpty(relString)) {
            rel = 1;
        } else {
            throw new ParseException("Unexpected rel: " + relString);
        }
        who.setRelationship((byte)rel);
        eventEntry.addAttendee(who);
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    name = parser.getName();
                    if ("attendeeStatus".equals(name)) {
                        String statusString = parser.getAttributeValue(null, "value");
                        int status = 0;
                        if ("http://schemas.google.com/g/2005#event.accepted".equals(statusString)) {
                            status = 1;
                        } else if ("http://schemas.google.com/g/2005#event.declined".equals(statusString)) {
                            status = 2;
                        } else if ("http://schemas.google.com/g/2005#event.invited".equals(statusString)) {
                            status = 3;
                        } else if ("http://schemas.google.com/g/2005#event.tentative".equals(statusString)) {
                            status = 4;
                        } else if (StringUtils.isEmpty(statusString)) {
                            status = 4;
                        } else {
                            throw new ParseException("Unexpected status: " + statusString);
                        }
                        who.setStatus((byte)status);
                        break;
                    }
                    if (!"attendeeType".equals(name)) break;
                    String typeString = XmlUtils.extractChildText(parser);
                    int type = 0;
                    if ("http://schemas.google.com/g/2005#event.optional".equals(typeString)) {
                        type = 1;
                    } else if ("http://schemas.google.com/g/2005#event.required".equals(typeString)) {
                        type = 2;
                    } else if (StringUtils.isEmpty(typeString)) {
                        type = 2;
                    } else {
                        throw new ParseException("Unexpected type: " + typeString);
                    }
                    who.setType((byte)type);
                    break;
                }
                case 3: {
                    name = parser.getName();
                    if (!"who".equals(name)) break;
                    return;
                }
            }
            eventType = parser.next();
        }
    }

    private void handleWhen(EventEntry eventEntry) throws XmlPullParserException, IOException {
        XmlPullParser parser = this.getParser();
        int eventType = parser.getEventType();
        String name = parser.getName();
        if (eventType != 2 || !"when".equals(parser.getName())) {
            throw new IllegalStateException("Expected <when>: Actual element: <" + name + ">");
        }
        String startTime = parser.getAttributeValue(null, "startTime");
        String endTime = parser.getAttributeValue(null, "endTime");
        When when = new When(startTime, endTime);
        eventEntry.addWhen(when);
        boolean firstWhen = eventEntry.getWhens().size() == 1;
        boolean handleReminders = firstWhen && !this.hasSeenReminder;
        eventType = parser.next();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    name = parser.getName();
                    if (!"reminder".equals(name) || !handleReminders) break;
                    this.handleReminder(eventEntry);
                    break;
                }
                case 3: {
                    name = parser.getName();
                    if (!"when".equals(name)) break;
                    return;
                }
            }
            eventType = parser.next();
        }
    }

    private void handleReminder(EventEntry eventEntry) {
        XmlPullParser parser = this.getParser();
        Reminder reminder = new Reminder();
        eventEntry.addReminder(reminder);
        String methodStr = parser.getAttributeValue(null, "method");
        String minutesStr = parser.getAttributeValue(null, "minutes");
        String hoursStr = parser.getAttributeValue(null, "hours");
        String daysStr = parser.getAttributeValue(null, "days");
        if (!StringUtils.isEmpty(methodStr)) {
            if ("alert".equals(methodStr)) {
                reminder.setMethod((byte)3);
            } else if ("email".equals(methodStr)) {
                reminder.setMethod((byte)1);
            } else if ("sms".equals(methodStr)) {
                reminder.setMethod((byte)2);
            }
        }
        int minutes = -1;
        if (!StringUtils.isEmpty(minutesStr)) {
            minutes = StringUtils.parseInt(minutesStr, minutes);
        } else if (!StringUtils.isEmpty(hoursStr)) {
            minutes = 60 * StringUtils.parseInt(hoursStr, minutes);
        } else if (!StringUtils.isEmpty(daysStr)) {
            minutes = 1440 * StringUtils.parseInt(daysStr, minutes);
        }
        if (minutes < 0) {
            minutes = -1;
        }
        reminder.setMinutes(minutes);
    }

    private void handleOriginalEvent(EventEntry eventEntry) throws XmlPullParserException, IOException {
        XmlPullParser parser = this.getParser();
        int eventType = parser.getEventType();
        String name = parser.getName();
        if (eventType != 2 || !"originalEvent".equals(parser.getName())) {
            throw new IllegalStateException("Expected <originalEvent>: Actual element: <" + name + ">");
        }
        eventEntry.setOriginalEventId(parser.getAttributeValue(null, "href"));
        eventType = parser.next();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    name = parser.getName();
                    if (!"when".equals(name)) break;
                    eventEntry.setOriginalEventStartTime(parser.getAttributeValue(null, "startTime"));
                    break;
                }
                case 3: {
                    name = parser.getName();
                    if (!"originalEvent".equals(name)) break;
                    return;
                }
            }
            eventType = parser.next();
        }
    }
}

