/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.gdata2.client;

import com.google.wireless.gdata2.client.GDataClient;
import com.google.wireless.gdata2.client.QueryParams;
import java.util.Hashtable;
import java.util.Vector;

public class HttpQueryParams
extends QueryParams {
    private GDataClient client;
    private Hashtable params;
    private Vector names;

    public HttpQueryParams(GDataClient client) {
        this.client = client;
        this.names = new Vector(4);
        this.params = new Hashtable(7);
    }

    public String generateQueryUrl(String feedUrl) {
        StringBuffer url = new StringBuffer(feedUrl);
        url.append(feedUrl.indexOf(63) >= 0 ? (char)'&' : '?');
        for (int i = 0; i < this.names.size(); ++i) {
            if (i > 0) {
                url.append('&');
            }
            String name = (String)this.names.elementAt(i);
            url.append(this.client.encodeUri(name)).append('=');
            url.append(this.client.encodeUri(this.getParamValue(name)));
        }
        return url.toString();
    }

    public String getParamValue(String param) {
        return (String)this.params.get(param);
    }

    public void setParamValue(String param, String value) {
        if (value != null) {
            if (!this.params.containsKey(param)) {
                this.names.addElement(param);
            }
            this.params.put(param, value);
        } else if (this.params.remove(param) != null) {
            this.names.removeElement(param);
        }
    }

    public void clear() {
        this.names.removeAllElements();
        this.params.clear();
    }
}

