/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.testing.mocking;

import com.google.android.testing.mocking.AndroidMockGenerator;
import com.google.android.testing.mocking.UsesMocks;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.CtClass;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"com.google.android.testing.mocking.UsesMocks"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_5)
public class UsesMocksProcessor
extends AbstractProcessor {
    private AndroidMockGenerator mockGenerator = new AndroidMockGenerator();
    private OutputStream logFile;
    private static final String BIN_DIR = "bin_dir";

    private void printMessage(Diagnostic.Kind kind, String message) {
        this.processingEnv.getMessager().printMessage(kind, message);
        if (this.logFile != null) {
            try {
                this.logFile.write((SimpleDateFormat.getDateTimeInstance().format(new Date()) + " - " + kind.toString() + " : " + message + "\n").getBytes());
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "IOException logging to file" + e.toString());
            }
        }
    }

    private void printMessage(Diagnostic.Kind kind, Exception e) {
        ByteArrayOutputStream stackTraceByteStream = new ByteArrayOutputStream();
        PrintStream stackTraceStream = new PrintStream(stackTraceByteStream);
        e.printStackTrace(stackTraceStream);
        this.printMessage(kind, stackTraceByteStream.toString());
    }

    FileOutputStream openLogFile(String logFileName) {
        try {
            if (logFileName != null) {
                File log = new File(logFileName);
                if (!log.exists() && log.getParentFile() != null) {
                    log.getParentFile().mkdirs();
                }
                return new FileOutputStream(log, true);
            }
        }
        catch (FileNotFoundException e) {
            this.printMessage(Diagnostic.Kind.WARNING, e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment environment) {
        try {
            this.logFile = this.openLogFile(this.processingEnv.getOptions().get("logfile"));
            this.printMessage(Diagnostic.Kind.NOTE, "Start Processing Annotations");
            ArrayList classesToMock = new ArrayList();
            classesToMock.addAll(this.findClassesToMock(environment.getElementsAnnotatedWith(UsesMocks.class)));
            this.printMessage(Diagnostic.Kind.NOTE, "Found " + classesToMock.size() + " classes to mock");
            Set<CtClass> mockedClassesSet = this.getClassMocks(classesToMock);
            this.printMessage(Diagnostic.Kind.NOTE, "Found " + mockedClassesSet.size() + " mocked classes to save");
            this.writeMocks(mockedClassesSet);
            this.printMessage(Diagnostic.Kind.NOTE, "Finished Processing Mocks");
        }
        catch (Exception e) {
            this.printMessage(Diagnostic.Kind.ERROR, e);
        }
        finally {
            if (this.logFile != null) {
                try {
                    this.logFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    List<Class<?>> findClassesToMock(Set<? extends Element> annotatedElements) {
        this.printMessage(Diagnostic.Kind.NOTE, "Processing " + annotatedElements);
        ArrayList classList = new ArrayList();
        for (Element element : annotatedElements) {
            List<? extends AnnotationMirror> mirrors = element.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : mirrors) {
                if (!annotationMirror.getAnnotationType().toString().equals(UsesMocks.class.getName())) continue;
                for (AnnotationValue annotationValue : annotationMirror.getElementValues().values()) {
                    for (Object classFileName : (Iterable)annotationValue.getValue()) {
                        String className = classFileName.toString();
                        if (className.endsWith(".class")) {
                            className = className.substring(0, className.length() - 6);
                        }
                        this.printMessage(Diagnostic.Kind.NOTE, "Adding Class to Mocking List: " + className);
                        try {
                            classList.add(Class.forName(className, false, this.getClass().getClassLoader()));
                        }
                        catch (ClassNotFoundException e) {
                            this.reportClasspathError(className);
                        }
                    }
                }
            }
        }
        return classList;
    }

    Set<CtClass> getClassMocks(List<Class<?>> classesToMock) {
        HashSet<CtClass> mockedClassesSet = new HashSet<CtClass>();
        for (Class<?> clazz : classesToMock) {
            try {
                this.printMessage(Diagnostic.Kind.NOTE, "Mocking " + clazz);
                mockedClassesSet.addAll(this.getAndroidMockGenerator().createMocksForClass(clazz));
            }
            catch (ClassNotFoundException e) {
                this.reportClasspathError(clazz.getName());
            }
        }
        return mockedClassesSet;
    }

    private void reportClasspathError(String clazz) {
        URL[] allUrls;
        this.printMessage(Diagnostic.Kind.ERROR, "Could not find " + clazz);
        this.printMessage(Diagnostic.Kind.NOTE, "Known Classpath: ");
        for (URL url : allUrls = ((URLClassLoader)this.getClass().getClassLoader()).getURLs()) {
            this.printMessage(Diagnostic.Kind.NOTE, url.toString());
        }
    }

    void writeMocks(Set<CtClass> mockedClassesSet) {
        for (CtClass clazz : mockedClassesSet) {
            byte[] classBytes = null;
            try {
                this.printMessage(Diagnostic.Kind.NOTE, "Saving " + clazz.getName());
                classBytes = clazz.toBytecode();
                JavaFileObject classFile = this.processingEnv.getFiler().createClassFile(clazz.getName(), new Element[0]);
                OutputStream classFileStream = classFile.openOutputStream();
                classFileStream.write(classBytes);
                classFileStream.close();
            }
            catch (IOException e) {
                this.printMessage(Diagnostic.Kind.ERROR, "Internal Error saving mock: " + clazz.getName());
                this.printMessage(Diagnostic.Kind.ERROR, e);
            }
            catch (CannotCompileException e) {
                this.printMessage(Diagnostic.Kind.ERROR, "Internal Error converting mock to .class file: " + clazz.getName());
                this.printMessage(Diagnostic.Kind.ERROR, e);
            }
            catch (UnsupportedOperationException e) {
                this.printMessage(Diagnostic.Kind.NOTE, "Saving via Eclipse " + clazz.getName());
                this.saveMocksEclipse(clazz, classBytes);
            }
        }
    }

    private void saveMocksEclipse(CtClass clazz, byte[] classBytes) {
        File targetFile = null;
        File classFolder = new File(this.processingEnv.getOptions().get(BIN_DIR).toString().trim());
        targetFile = new File(classFolder, this.getFilenameForClass(clazz));
        targetFile.getParentFile().mkdirs();
        try {
            FileOutputStream outputStream = new FileOutputStream(targetFile);
            outputStream.write(classBytes);
            outputStream.close();
        }
        catch (FileNotFoundException e) {
            this.printMessage(Diagnostic.Kind.ERROR, e);
        }
        catch (IOException e) {
            this.printMessage(Diagnostic.Kind.ERROR, e);
        }
    }

    String getFilenameForClass(CtClass clazz) {
        return clazz.getName().replace('.', File.separatorChar) + ".class";
    }

    private AndroidMockGenerator getAndroidMockGenerator() {
        return this.mockGenerator;
    }
}

