/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.testing.mocking;

import com.google.android.testing.mocking.AndroidMock;
import com.google.android.testing.mocking.MockObject;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.NotFoundException;

class AndroidMockGenerator {
    public AndroidMockGenerator() {
        ClassPool.doPruning = false;
        ClassPool.getDefault().insertClassPath(new ClassClassPath(MockObject.class));
    }

    public List<CtClass> createMocksForClass(Class<?> clazz) throws ClassNotFoundException {
        if (!this.classIsSupportedType(clazz)) {
            this.reportReasonForUnsupportedType(clazz);
            return Arrays.asList(new CtClass[0]);
        }
        CtClass newInterface = this.generateInterface(clazz);
        CtClass mockDelegate = this.generateSubClass(clazz, newInterface);
        return Arrays.asList(newInterface, mockDelegate);
    }

    private void reportReasonForUnsupportedType(Class<?> clazz) {
        String reason = null;
        if (!clazz.isInterface()) {
            if (clazz.isEnum()) {
                reason = "Cannot mock an Enum";
            } else if (clazz.isAnnotation()) {
                reason = "Cannot mock an Annotation";
            } else if (clazz.isArray()) {
                reason = "Cannot mock an Array";
            } else if (Modifier.isFinal(clazz.getModifiers())) {
                reason = "Cannot mock a Final class";
            } else if (clazz.isPrimitive()) {
                reason = "Cannot mock primitives";
            } else if (!Object.class.isAssignableFrom(clazz)) {
                reason = "Cannot mock non-classes";
            } else if (!this.containsUsableConstructor(clazz)) {
                reason = "Cannot mock a class with no public constructors";
            }
        }
        if (reason != null) {
            System.err.println(reason + ": " + clazz.getName());
        }
    }

    private boolean containsUsableConstructor(Class<?> clazz) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers()) && !Modifier.isProtected(constructor.getModifiers())) continue;
            return true;
        }
        return false;
    }

    boolean classIsSupportedType(Class<?> clazz) {
        return this.containsUsableConstructor(clazz) && Object.class.isAssignableFrom(clazz) && !clazz.isInterface() && !clazz.isEnum() && !clazz.isAnnotation() && !clazz.isArray() && !Modifier.isFinal(clazz.getModifiers());
    }

    void saveCtClass(CtClass clazz) throws ClassNotFoundException, IOException {
        try {
            clazz.writeFile();
        }
        catch (NotFoundException e) {
            throw new ClassNotFoundException("Error while saving modified class " + clazz.getName(), e);
        }
        catch (CannotCompileException e) {
            throw new RuntimeException("Internal Error: Attempt to save syntactically incorrect code for class " + clazz.getName(), e);
        }
    }

    CtClass generateInterface(Class<?> originalClass) {
        ClassPool classPool = this.getClassPool();
        try {
            return classPool.getCtClass(AndroidMock.getInterfaceNameFor(originalClass));
        }
        catch (NotFoundException e) {
            CtClass newInterface = classPool.makeInterface(AndroidMock.getInterfaceNameFor(originalClass));
            this.addInterfaceMethods(originalClass, newInterface);
            return newInterface;
        }
    }

    String getInterfaceMethodSource(Method method) throws UnsupportedOperationException {
        StringBuilder methodBody = this.getMethodSignature(method);
        methodBody.append(";");
        return methodBody.toString();
    }

    private StringBuilder getMethodSignature(Method method) {
        int modifiers = method.getModifiers();
        if (Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers)) {
            throw new UnsupportedOperationException("Cannot specify final or static methods in an interface");
        }
        StringBuilder methodSignature = new StringBuilder("public ");
        methodSignature.append(this.getClassName(method.getReturnType()));
        methodSignature.append(" ");
        methodSignature.append(method.getName());
        methodSignature.append("(");
        int i = 0;
        for (Class<?> arg : method.getParameterTypes()) {
            methodSignature.append(this.getClassName(arg));
            methodSignature.append(" arg");
            methodSignature.append(i);
            if (i < method.getParameterTypes().length - 1) {
                methodSignature.append(",");
            }
            ++i;
        }
        methodSignature.append(")");
        if (method.getExceptionTypes().length > 0) {
            methodSignature.append(" throws ");
        }
        i = 0;
        for (Class<?> exception : method.getExceptionTypes()) {
            methodSignature.append(this.getClassName(exception));
            if (i < method.getExceptionTypes().length - 1) {
                methodSignature.append(",");
            }
            ++i;
        }
        return methodSignature;
    }

    private String getClassName(Class<?> clazz) {
        return clazz.getCanonicalName();
    }

    ClassPool getClassPool() {
        return ClassPool.getDefault();
    }

    private boolean classExists(String name) {
        try {
            this.getClassPool().get(name);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    CtClass generateSubClass(Class<?> superClass, CtClass newInterface) throws ClassNotFoundException {
        if (this.classExists(AndroidMock.getSubclassNameFor(superClass))) {
            try {
                return this.getClassPool().get(AndroidMock.getSubclassNameFor(superClass));
            }
            catch (NotFoundException e) {
                throw new ClassNotFoundException("This should be impossible, since we just checked for the existence of the class being created", e);
            }
        }
        CtClass newClass = this.generateSkeletalClass(superClass, newInterface);
        if (!newClass.isFrozen()) {
            newClass.addInterface(newInterface);
            try {
                newClass.addInterface(this.getClassPool().get(MockObject.class.getName()));
            }
            catch (NotFoundException e) {
                throw new ClassNotFoundException("Could not find " + MockObject.class.getName(), e);
            }
            this.addMethods(superClass, newClass);
            this.addGetDelegateMethod(newClass);
            this.addSetDelegateMethod(newClass, newInterface);
            this.addConstructors(newClass, superClass);
        }
        return newClass;
    }

    private void addConstructors(CtClass clazz, Class<?> superClass) throws ClassNotFoundException {
        CtConstructor[] constructors;
        CtClass superCtClass = this.getCtClassForClass(superClass);
        for (CtConstructor constructor : constructors = superCtClass.getDeclaredConstructors()) {
            int modifiers = constructor.getModifiers();
            if (!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers)) continue;
            try {
                CtConstructor ctConstructor = CtNewConstructor.make(constructor.getParameterTypes(), constructor.getExceptionTypes(), clazz);
                clazz.addConstructor(ctConstructor);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Internal Error - Could not add constructors.", e);
            }
            catch (NotFoundException e) {
                throw new RuntimeException("Internal Error - Constructor suddenly could not be found", e);
            }
        }
    }

    CtClass getCtClassForClass(Class<?> clazz) throws ClassNotFoundException {
        ClassPool classPool = this.getClassPool();
        try {
            return classPool.get(clazz.getName());
        }
        catch (NotFoundException e) {
            throw new ClassNotFoundException("Class not found when finding the class to be mocked: " + clazz.getName(), e);
        }
    }

    private void addSetDelegateMethod(CtClass clazz, CtClass newInterface) {
        try {
            clazz.addMethod(CtMethod.make(this.getSetDelegateMethodSource(newInterface), clazz));
        }
        catch (CannotCompileException e) {
            throw new RuntimeException("Internal error while creating the setDelegate() method", e);
        }
    }

    String getSetDelegateMethodSource(CtClass newInterface) {
        return "public void setDelegate___AndroidMock(" + newInterface.getName() + " obj) { this." + this.getDelegateFieldName() + " = obj;}";
    }

    private void addGetDelegateMethod(CtClass clazz) {
        try {
            CtMethod newMethod = CtMethod.make(this.getGetDelegateMethodSource(), clazz);
            try {
                CtMethod existingMethod = clazz.getMethod(newMethod.getName(), newMethod.getSignature());
                clazz.removeMethod(existingMethod);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            clazz.addMethod(newMethod);
        }
        catch (CannotCompileException e) {
            throw new RuntimeException("Internal error while creating the getDelegate() method", e);
        }
    }

    private String getGetDelegateMethodSource() {
        return "public Object getDelegate___AndroidMock() { return this." + this.getDelegateFieldName() + "; }";
    }

    String getDelegateFieldName() {
        return "delegateMockObject";
    }

    void addInterfaceMethods(Class<?> originalClass, CtClass newInterface) {
        Method[] methods;
        for (Method method : methods = this.getAllMethods(originalClass)) {
            try {
                if (!this.isMockable(method)) continue;
                CtMethod newMethod = CtMethod.make(this.getInterfaceMethodSource(method), newInterface);
                newInterface.addMethod(newMethod);
            }
            catch (UnsupportedOperationException e) {
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Internal error while creating a new Interface method for class " + originalClass.getName() + ".  Method name: " + method.getName(), e);
            }
        }
    }

    void addMethods(Class<?> superClass, CtClass newClass) {
        Method[] methods;
        for (Method method : methods = this.getAllMethods(superClass)) {
            try {
                if (!this.isMockable(method)) continue;
                CtMethod newMethod = CtMethod.make(this.getDelegateMethodSource(method), newClass);
                newClass.addMethod(newMethod);
            }
            catch (UnsupportedOperationException e) {
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Internal Error while creating subclass methods for " + newClass.getName() + " method: " + method.getName(), e);
            }
        }
    }

    Method[] getAllMethods(Class<?> clazz) {
        Map<String, Method> methodMap = this.getAllMethodsMap(clazz);
        return methodMap.values().toArray(new Method[0]);
    }

    private Map<String, Method> getAllMethodsMap(Class<?> clazz) {
        HashMap<String, Method> methodMap = new HashMap<String, Method>();
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            methodMap.putAll(this.getAllMethodsMap(superClass));
        }
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(clazz.getDeclaredMethods()));
        for (Method method : methods) {
            String key = method.getName();
            for (Class<?> param : method.getParameterTypes()) {
                key = key + param.getCanonicalName();
            }
            methodMap.put(key, method);
        }
        return methodMap;
    }

    boolean isMockable(Method method) {
        if (this.isForbiddenMethod(method)) {
            return false;
        }
        int modifiers = method.getModifiers();
        return !Modifier.isFinal(modifiers) && !Modifier.isStatic(modifiers) && !method.isBridge() && (Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers));
    }

    boolean isForbiddenMethod(Method method) {
        if (method.getName().equals("equals")) {
            return method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(Object.class);
        }
        if (method.getName().equals("toString")) {
            return method.getParameterTypes().length == 0;
        }
        if (method.getName().equals("hashCode")) {
            return method.getParameterTypes().length == 0;
        }
        return false;
    }

    private String getReturnDefault(Method method) {
        Class<?> returnType = method.getReturnType();
        if (!returnType.isPrimitive()) {
            return "null";
        }
        if (returnType == Boolean.TYPE) {
            return "false";
        }
        if (returnType == Void.TYPE) {
            return "";
        }
        return "(" + returnType.getName() + ")0";
    }

    String getDelegateMethodSource(Method method) {
        StringBuilder methodBody = this.getMethodSignature(method);
        methodBody.append("{");
        methodBody.append("if(this.");
        methodBody.append(this.getDelegateFieldName());
        methodBody.append("==null){return ");
        methodBody.append(this.getReturnDefault(method));
        methodBody.append(";}");
        if (!method.getReturnType().equals(Void.TYPE)) {
            methodBody.append("return ");
        }
        methodBody.append("this.");
        methodBody.append(this.getDelegateFieldName());
        methodBody.append(".");
        methodBody.append(method.getName());
        methodBody.append("(");
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            methodBody.append("arg");
            methodBody.append(i);
            if (i >= method.getParameterTypes().length - 1) continue;
            methodBody.append(",");
        }
        methodBody.append(");}");
        return methodBody.toString();
    }

    CtClass generateSkeletalClass(Class<?> superClass, CtClass newInterface) throws ClassNotFoundException {
        ClassPool classPool = this.getClassPool();
        CtClass superCtClass = this.getCtClassForClass(superClass);
        CtClass newClass = classPool.makeClass(AndroidMock.getSubclassNameFor(superClass), superCtClass);
        try {
            newClass.addField(new CtField(newInterface, this.getDelegateFieldName(), newClass));
        }
        catch (CannotCompileException e) {
            throw new RuntimeException("Internal error adding the delegate field to " + newClass.getName(), e);
        }
        return newClass;
    }
}

