/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.accounts;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import com.google.android.accounts.AbstractSyncAdapter;
import com.google.android.accounts.Account;
import com.google.android.accounts.Adapter;
import com.google.android.accounts.ContentSyncer;
import com.google.android.accounts.IntentService;

public abstract class AbstractSyncService
extends IntentService {
    static final String ACTION_REQUEST_SYNC = "android.content.SyncAdapter";
    static final String EXTRA_ACCOUNT_NAME = "com.google.android.webcursors.accounts.intent.extra.ACCOUNT_NAME";
    static final String EXTRA_ACCOUNT_TYPE = "com.google.android.webcursors.accounts.intent.extra.ACCOUNT_TYPE";
    static final String EXTRA_AUTHORITY = "com.google.android.webcursors.accounts.intent.extra.AUTHORITY";
    static final String EXTRA_SUPPORTS_UPLOADING = "com.google.android.webcursors.accounts.intent.extra.SUPPORTS_UPLOADING";
    static final String EXTRA_BUNDLE = "com.google.android.webcursors.accounts.intent.extra.BUNDLE";
    private static final int SDK = Integer.parseInt(Build.VERSION.SDK);
    private static final int ECLAIR = 5;
    private final String mTag;
    private final int mNotificationId;

    protected AbstractSyncService(String name, int priority, int notificationId) {
        super(name, priority);
        this.mTag = name;
        this.mNotificationId = notificationId;
    }

    protected abstract AbstractSyncAdapter createSyncAdapter();

    protected abstract CharSequence createNotificationTitle();

    protected abstract CharSequence createNotificationText();

    protected PendingIntent createNotificationIntent() {
        AbstractSyncService context = this;
        int requestCode = 0;
        Intent intent = new Intent();
        int flags = 0;
        return PendingIntent.getBroadcast((Context)context, (int)requestCode, (Intent)intent, (int)flags);
    }

    private boolean isSyncEnabled() {
        return true;
    }

    protected void onHandleIntent(Intent intent) {
        String action = intent.getAction();
        if (ACTION_REQUEST_SYNC.equals(action)) {
            String accountName = intent.getStringExtra(EXTRA_ACCOUNT_NAME);
            String accountType = intent.getStringExtra(EXTRA_ACCOUNT_TYPE);
            String authority = intent.getStringExtra(EXTRA_AUTHORITY);
            boolean supportsUploading = intent.getBooleanExtra(EXTRA_SUPPORTS_UPLOADING, false);
            Bundle extras = intent.getBundleExtra(EXTRA_BUNDLE);
            this.performSync(accountName, accountType, authority, supportsUploading, extras);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSync(String accountName, String accountType, String authority, boolean supportsUploading, Bundle extras) {
        Account account;
        if (accountName == null || accountType == null) {
            Log.e((String)this.mTag, (String)"not syncing because account was not specified (this should never happen)");
            return;
        }
        if (authority == null) {
            Log.e((String)this.mTag, (String)"not syncing because authority was not specified (this should never happen)");
            return;
        }
        if (!this.isSyncEnabled()) {
            Log.v((String)this.mTag, (String)"not syncing because sync is disabled");
            return;
        }
        Object service = this.getSystemService("connectivity");
        ConnectivityManager cm = (ConnectivityManager)service;
        boolean backgroundDataUsageAllowed = cm.getBackgroundDataSetting();
        if (extras == null) {
            extras = new Bundle();
        }
        boolean uploadOnly = extras.getBoolean("upload", false);
        boolean manualSync = extras.getBoolean("force", false);
        AbstractSyncService context = this;
        ContentSyncer cs = ContentSyncer.get((Context)context);
        int isSyncable = cs.getIsSyncable(account = new Account(accountName, accountType), authority);
        if (isSyncable == 0) {
            Log.v((String)this.mTag, (String)"not syncing because account is not syncable for authority");
            return;
        }
        if (!supportsUploading && uploadOnly) {
            Log.v((String)this.mTag, (String)"not syncing because adapter does not support uploading");
            return;
        }
        boolean syncAutomatically = cs.getSyncAutomatically(account, authority);
        boolean syncAllowed = manualSync || backgroundDataUsageAllowed && syncAutomatically;
        Bundle extrasCopy = extras;
        if (isSyncable < 0) {
            extrasCopy = new Bundle(extras);
            String SYNC_EXTRAS_INITIALIZE = "initialize";
            extrasCopy.putBoolean("initialize", true);
        } else if (!syncAllowed) {
            Log.d((String)this.mTag, (String)("sync of " + account + ", " + authority + " is not allowed, dropping request"));
            return;
        }
        this.setForeground(true);
        try {
            this.showNotification(authority);
            try {
                AbstractSyncAdapter syncAdapter = this.createSyncAdapter();
                syncAdapter.onPerformSync(account, extras, authority);
            }
            finally {
                this.cancelNotification();
            }
        }
        finally {
            this.setForeground(false);
        }
    }

    private void showNotification(String authority) {
        Object service = this.getSystemService("notification");
        NotificationManager notificationManager = (NotificationManager)service;
        int icon = 17301628;
        CharSequence tickerText = null;
        long when = 0L;
        Notification notification = new Notification(icon, tickerText, when);
        AbstractSyncService context = this;
        CharSequence contentTitle = this.createNotificationTitle();
        CharSequence contentText = this.createNotificationText();
        PendingIntent contentIntent = this.createNotificationIntent();
        notification.when = System.currentTimeMillis();
        notification.flags |= 2;
        notification.setLatestEventInfo((Context)context, contentTitle, contentText, contentIntent);
        notificationManager.notify(this.mNotificationId, notification);
    }

    private void cancelNotification() {
        Object service = this.getSystemService("notification");
        NotificationManager nm = (NotificationManager)service;
        nm.cancel(this.mNotificationId);
    }

    public void onDestroy() {
        this.cancelNotification();
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        if (SDK >= 5) {
            AbstractSyncService context = this;
            AbstractSyncAdapter adapter = this.createSyncAdapter();
            return new Adapter((Context)context, adapter).getSyncAdapterBinder();
        }
        return null;
    }
}

