/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.accounts;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import com.google.android.accounts.Account;
import com.google.android.accounts.AccountManagerCallback;
import com.google.android.accounts.AccountManagerFuture;
import com.google.android.accounts.AuthenticatorException;
import com.google.android.accounts.DatabaseAccountManager;
import com.google.android.accounts.OperationCanceledException;
import com.google.android.accounts.StandardAccountManager;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AccountManager {
    private static final int SDK = Integer.parseInt(Build.VERSION.SDK);
    private static final int ECLAIR = 5;
    public static final int ERROR_CODE_REMOTE_EXCEPTION = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 3;
    public static final int ERROR_CODE_CANCELED = 4;
    public static final int ERROR_CODE_INVALID_RESPONSE = 5;
    public static final int ERROR_CODE_UNSUPPORTED_OPERATION = 6;
    public static final int ERROR_CODE_BAD_ARGUMENTS = 7;
    public static final int ERROR_CODE_BAD_REQUEST = 8;
    public static final String KEY_ACCOUNTS = "accounts";
    public static final String KEY_AUTHENTICATOR_TYPES = "authenticator_types";
    public static final String KEY_USERDATA = "userdata";
    public static final String KEY_AUTHTOKEN = "authtoken";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_ACCOUNT_NAME = "authAccount";
    public static final String KEY_ACCOUNT_TYPE = "accountType";
    public static final String KEY_ERROR_CODE = "errorCode";
    public static final String KEY_ERROR_MESSAGE = "errorMessage";
    public static final String KEY_INTENT = "intent";
    public static final String KEY_BOOLEAN_RESULT = "booleanResult";
    public static final String KEY_ACCOUNT_AUTHENTICATOR_RESPONSE = "accountAuthenticatorResponse";
    public static final String KEY_ACCOUNT_MANAGER_RESPONSE = "accountManagerResponse";
    public static final String KEY_AUTH_FAILED_MESSAGE = "authFailedMessage";
    public static final String KEY_AUTH_TOKEN_LABEL = "authTokenLabelKey";
    public static final String ACTION_AUTHENTICATOR_INTENT = "android.accounts.AccountAuthenticator";
    public static final String AUTHENTICATOR_META_DATA_NAME = "android.accounts.AccountAuthenticator";
    public static final String AUTHENTICATOR_ATTRIBUTES_NAME = "account-authenticator";
    public static final String LOGIN_ACCOUNTS_CHANGED_ACTION = "android.accounts.LOGIN_ACCOUNTS_CHANGED";
    private Handler mMainHandler;

    public static AccountManager get(Context context) {
        if (SDK >= 5) {
            return new StandardAccountManager(context);
        }
        return new DatabaseAccountManager(context);
    }

    public AccountManager(Context context) {
        this.mMainHandler = new Handler(context.getMainLooper());
    }

    public abstract Account[] getAccountsByType(String var1);

    public abstract AccountManagerFuture<Account[]> getAccountsByTypeAndFeatures(String var1, String[] var2, AccountManagerCallback<Account[]> var3, Handler var4);

    public abstract AccountManagerFuture<Bundle> addAccount(String var1, String var2, String[] var3, Bundle var4, Void var5, AccountManagerCallback<Bundle> var6, Handler var7);

    public abstract boolean addAccountExplicitly(Account var1, String var2, Bundle var3);

    public abstract AccountManagerFuture<Boolean> removeAccount(Account var1, AccountManagerCallback<Boolean> var2, Handler var3);

    public abstract AccountManagerFuture<Bundle> getAuthToken(Account var1, String var2, boolean var3, AccountManagerCallback<Bundle> var4, Handler var5);

    public abstract void invalidateAuthToken(String var1, String var2);

    public final String blockingGetAuthToken(Account account, String authTokenType, boolean notifyAuthFailure) throws AuthenticatorException, IOException, OperationCanceledException {
        AccountManagerCallback<Bundle> callback = null;
        Handler handler = null;
        Bundle bundle = this.getAuthToken(account, authTokenType, notifyAuthFailure, callback, handler).getResult();
        return bundle.getString(KEY_AUTHTOKEN);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Future2Task<T>
    extends BaseFutureTask<T>
    implements AccountManagerFuture<T> {
        final AccountManagerCallback<T> mCallback;

        public Future2Task(Callable<T> callable, Handler handler, AccountManagerCallback<T> callback) {
            super(callable, handler);
            this.mCallback = callback;
        }

        @Override
        protected void done() {
            if (this.mCallback != null) {
                this.postRunnableToHandler(new Runnable(){

                    public void run() {
                        Future2Task.this.mCallback.run(Future2Task.this);
                    }
                });
            }
        }

        public Future2Task<T> start() {
            this.startTask();
            return this;
        }

        private T internalGetResult(Long timeout, TimeUnit unit) throws OperationCanceledException, IOException, AuthenticatorException {
            try {
                if (timeout == null) {
                    Object v = this.get();
                    return (T)v;
                }
                Object v = this.get(timeout, unit);
                return (T)v;
            }
            catch (InterruptedException e) {
            }
            catch (TimeoutException e) {
            }
            catch (CancellationException e) {
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof UnsupportedOperationException) {
                    throw new AuthenticatorException(cause);
                }
                if (cause instanceof AuthenticatorException) {
                    throw (AuthenticatorException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new IllegalStateException(cause);
            }
            finally {
                boolean mayInterruptIfRunning = true;
                this.cancel(mayInterruptIfRunning);
            }
            throw new OperationCanceledException();
        }

        @Override
        public T getResult() throws OperationCanceledException, IOException, AuthenticatorException {
            return this.internalGetResult(null, null);
        }

        @Override
        public T getResult(long timeout, TimeUnit unit) throws OperationCanceledException, IOException, AuthenticatorException {
            return this.internalGetResult(timeout, unit);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BaseFutureTask<T>
    extends FutureTask<T> {
        final Handler mHandler;

        public BaseFutureTask(Callable<T> callable, Handler handler) {
            super(callable);
            this.mHandler = handler;
        }

        protected void postRunnableToHandler(Runnable runnable) {
            Handler handler = this.mHandler == null ? AccountManager.this.mMainHandler : this.mHandler;
            handler.post(runnable);
        }

        protected void startTask() {
            new TaskExecutor().execute(this);
        }
    }

    private static class TaskExecutor
    implements Executor {
        private TaskExecutor() {
        }

        public void execute(Runnable r) {
            new Thread(r).start();
        }
    }
}

