/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.accounts;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import com.google.android.accounts.Account;
import com.google.android.accounts.AccountManager;
import com.google.android.accounts.AccountManagerCallback;
import com.google.android.accounts.AccountManagerFuture;
import com.google.android.accounts.DatabaseAuthenticator;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DatabaseAccountManager
extends AccountManager {
    private static final String LOG_TAG = "DatabaseAccountManager";
    private static final String KEY_DATABASE_AUTHENTICATOR = "com.google.android.accounts.DatabaseAuthenticator";
    private static final String NAMESPACE = "http://schemas.android.com/apk/res/android";
    private Map<String, DatabaseAuthenticator> mAuthenticators;

    private static final void beginDocument(XmlPullParser parser, String firstElementName) throws XmlPullParserException, IOException {
        int type;
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        if (!parser.getName().equals(firstElementName)) {
            throw new XmlPullParserException("Unexpected start tag: found " + parser.getName() + ", expected " + firstElementName);
        }
    }

    private static DatabaseAuthenticator newDatabaseAuthenticatorInstance(Context context, String packageName, String className) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        if (className.startsWith(".")) {
            className = packageName + className;
        }
        Class<?> authenticatorClass = Class.forName(className);
        Constructor<?> constructor = authenticatorClass.getConstructor(Context.class);
        return (DatabaseAuthenticator)constructor.newInstance(context);
    }

    static Map<String, DatabaseAuthenticator> createDatabaseAuthenticators(Context context) {
        HashMap<String, DatabaseAuthenticator> authenticators = new HashMap<String, DatabaseAuthenticator>();
        String packageName = context.getPackageName();
        PackageManager pm = context.getPackageManager();
        Resources resources = context.getResources();
        Intent intent = new Intent(KEY_DATABASE_AUTHENTICATOR);
        int flags = 128;
        for (ResolveInfo resolveInfo : pm.queryIntentServices(intent, flags)) {
            int resId;
            ServiceInfo serviceInfo = resolveInfo.serviceInfo;
            Bundle metaData = serviceInfo.metaData;
            if (metaData == null || !serviceInfo.packageName.equals(packageName) || (resId = metaData.getInt(KEY_DATABASE_AUTHENTICATOR)) == 0) continue;
            try {
                XmlResourceParser parser = resources.getXml(resId);
                DatabaseAccountManager.beginDocument((XmlPullParser)parser, "account-authenticator");
                String name = parser.getAttributeValue(NAMESPACE, "name");
                String accountType = parser.getAttributeValue(NAMESPACE, "accountType");
                DatabaseAuthenticator authenticator = DatabaseAccountManager.newDatabaseAuthenticatorInstance(context, packageName, name);
                authenticators.put(accountType, authenticator);
            }
            catch (Exception e) {
                Log.w((String)LOG_TAG, (String)"Failed  to create authenticator", (Throwable)e);
            }
        }
        if (authenticators.isEmpty()) {
            Log.w((String)LOG_TAG, (String)"No authenticators found");
        }
        return authenticators;
    }

    private static Bundle authenticatorMissing(String accountType) {
        Bundle result = new Bundle();
        result.putInt("errorCode", 7);
        result.putString("errorMessage", "unknown account type: " + accountType);
        return result;
    }

    public DatabaseAccountManager(Context context) {
        super(context);
        this.mAuthenticators = DatabaseAccountManager.createDatabaseAuthenticators(context);
    }

    private DatabaseAuthenticator getAuthenticator(String type) {
        return this.mAuthenticators.get(type);
    }

    @Override
    public Account[] getAccountsByType(String type) {
        DatabaseAuthenticator authenticator = this.getAuthenticator(type);
        if (authenticator != null) {
            return authenticator.getAccountsByType(type);
        }
        return new Account[0];
    }

    @Override
    public AccountManagerFuture<Account[]> getAccountsByTypeAndFeatures(final String type, final String[] features, AccountManagerCallback<Account[]> callback, Handler handler) {
        return new AccountManager.Future2Task<Account[]>(new Callable<Account[]>(){

            @Override
            public Account[] call() {
                DatabaseAuthenticator authenticator = DatabaseAccountManager.this.getAuthenticator(type);
                if (authenticator != null) {
                    return authenticator.getAccountsByTypeAndFeatures(type, features);
                }
                return new Account[0];
            }
        }, handler, callback).start();
    }

    @Override
    public AccountManagerFuture<Bundle> getAuthToken(final Account account, final String authTokenType, boolean notifyAuthFailure, AccountManagerCallback<Bundle> callback, Handler handler) {
        return new AccountManager.Future2Task<Bundle>(new Callable<Bundle>(){

            @Override
            public Bundle call() {
                DatabaseAuthenticator authenticator = DatabaseAccountManager.this.getAuthenticator(account.type);
                if (authenticator != null) {
                    return authenticator.getAuthToken(account, authTokenType, null);
                }
                return DatabaseAccountManager.authenticatorMissing(account.type);
            }
        }, handler, callback).start();
    }

    @Override
    public AccountManagerFuture<Bundle> addAccount(final String accountType, final String authTokenType, final String[] requiredFeatures, final Bundle addAccountOptions, Void activity, AccountManagerCallback<Bundle> callback, Handler handler) {
        if (activity != null) {
            throw new RuntimeException("Activity parameter is not supported");
        }
        return new AccountManager.Future2Task<Bundle>(new Callable<Bundle>(){

            @Override
            public Bundle call() {
                DatabaseAuthenticator authenticator = DatabaseAccountManager.this.getAuthenticator(accountType);
                if (authenticator != null) {
                    return authenticator.addAccount(accountType, authTokenType, requiredFeatures, addAccountOptions);
                }
                return DatabaseAccountManager.authenticatorMissing(accountType);
            }
        }, handler, callback).start();
    }

    @Override
    public boolean addAccountExplicitly(Account account, String password, Bundle userdata) {
        DatabaseAuthenticator authenticator = this.getAuthenticator(account.type);
        if (authenticator != null) {
            return authenticator.addAccountExplicitly(account, password, userdata);
        }
        return false;
    }

    @Override
    public AccountManagerFuture<Boolean> removeAccount(final Account account, AccountManagerCallback<Boolean> callback, Handler handler) {
        return new AccountManager.Future2Task<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                DatabaseAuthenticator authenticator = DatabaseAccountManager.this.getAuthenticator(account.type);
                if (authenticator != null) {
                    return authenticator.removeAccount(account);
                }
                return false;
            }
        }, handler, callback).start();
    }

    @Override
    public void invalidateAuthToken(String accountType, String authToken) {
        DatabaseAuthenticator authenticator = this.getAuthenticator(accountType);
        if (authenticator != null) {
            authenticator.invalidateAuthToken(accountType, authToken);
        }
    }
}

