/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.accounts;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Bundle;
import android.os.Parcelable;
import com.google.android.accounts.Account;
import com.google.android.accounts.NetworkErrorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseAuthenticator {
    private static final int DATABASE_VERSION = 3;
    private static final String TABLE_ACCOUNTS = "accounts";
    private static final String TABLE_AUTH_TOKENS = "auth_tokens";
    private static final String TABLE_SYNC_AUTOMATICALLY = "sync_automatically";
    private static final String COLUMN_ACCOUNT_NAME = "account_name";
    private static final String COLUMN_ACCOUNT_TYPE = "account_type";
    private static final String COLUMN_PASSWORD = "password";
    private static final String COLUMN_AUTH_TOKEN_TYPE = "auth_token_type";
    private static final String COLUMN_AUTH_TOKEN = "auth_token";
    private static final String COLUMN_AUTHORITY = "authority";
    private static final String COLUMN_SYNC_AUTOMATICALLY = "sync_automatically";
    private final Context mContext;
    private final String mDatabaseName;
    private final Class<? extends Activity> mAuthenticatorActivity;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasAccount(SQLiteDatabase db, Account account) {
        String[] projection = new String[]{};
        String selection = String.format("%s=? AND %s=?", COLUMN_ACCOUNT_NAME, COLUMN_ACCOUNT_TYPE, COLUMN_AUTH_TOKEN_TYPE);
        String[] selectionArgs = new String[]{account.name, account.type};
        String groupBy = null;
        String having = null;
        String orderBy = null;
        Cursor c = db.query(TABLE_ACCOUNTS, projection, selection, selectionArgs, groupBy, having, orderBy);
        try {
            boolean bl = c.getCount() != 0;
            return bl;
        }
        finally {
            c.close();
        }
    }

    private static void addAccount(SQLiteDatabase db, Account account, String password) {
        ContentValues values = new ContentValues();
        values.put(COLUMN_ACCOUNT_NAME, account.name);
        values.put(COLUMN_ACCOUNT_TYPE, account.type);
        if (password != null) {
            values.put(COLUMN_PASSWORD, password);
        }
        db.insert(TABLE_ACCOUNTS, null, values);
    }

    protected DatabaseAuthenticator(Context context, String databaseName, Class<? extends Activity> authenticatorActivity) {
        if (context == null || databaseName == null || authenticatorActivity == null) {
            throw new NullPointerException();
        }
        this.mContext = context;
        this.mDatabaseName = databaseName;
        this.mAuthenticatorActivity = authenticatorActivity;
    }

    public Context getContext() {
        return this.mContext;
    }

    private SQLiteDatabase getReadableDatabase() {
        return new DatabaseHelper().getReadableDatabase();
    }

    private SQLiteDatabase getWritableDatabase() {
        return new DatabaseHelper().getWritableDatabase();
    }

    public Bundle addAccount(String accountType, String authTokenType, String[] requiredFeatures, Bundle options) {
        Bundle result = new Bundle();
        Intent intent = new Intent();
        intent.setClass(this.mContext, this.mAuthenticatorActivity);
        intent.putExtra("accountType", accountType);
        result.putString("accountType", accountType);
        result.putParcelable("intent", (Parcelable)intent);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAccountExplicitly(Account account, String password, Bundle userdata) {
        if (account == null || account.type == null || account.name == null) {
            return false;
        }
        SQLiteDatabase db = this.getWritableDatabase();
        try {
            block9: {
                boolean bl;
                db.beginTransaction();
                try {
                    if (!DatabaseAuthenticator.hasAccount(db, account)) break block9;
                    bl = false;
                }
                catch (Throwable throwable) {
                    db.endTransaction();
                    throw throwable;
                }
                db.endTransaction();
                return bl;
            }
            DatabaseAuthenticator.addAccount(db, account, password);
            db.setTransactionSuccessful();
            boolean bl = true;
            db.endTransaction();
            return bl;
        }
        finally {
            db.close();
        }
    }

    public Bundle confirmCredentials(Account account, Bundle options) {
        Bundle result = new Bundle();
        Intent intent = new Intent();
        intent.setClass(this.mContext, this.mAuthenticatorActivity);
        intent.putExtra("authAccount", account.name);
        intent.putExtra("accountType", account.type);
        result.putString("authAccount", account.name);
        result.putString("accountType", account.type);
        result.putParcelable("intent", (Parcelable)intent);
        return result;
    }

    public Bundle editProperties(String accountType) {
        return Bundle.EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle getAuthToken(Account account, String authTokenType, Bundle loginOptions) {
        String[] selectionArgs;
        String selection;
        String table = TABLE_AUTH_TOKENS;
        String[] projection = new String[]{COLUMN_AUTH_TOKEN};
        if (authTokenType != null) {
            selection = String.format("%s=? AND %s=? AND %s=?", COLUMN_ACCOUNT_NAME, COLUMN_ACCOUNT_TYPE, COLUMN_AUTH_TOKEN_TYPE);
            selectionArgs = new String[]{account.name, account.type, authTokenType};
        } else {
            selection = String.format("%s=? AND %s=? AND %s IS NULL", COLUMN_ACCOUNT_NAME, COLUMN_ACCOUNT_TYPE, COLUMN_AUTH_TOKEN_TYPE);
            selectionArgs = new String[]{account.name, account.type};
        }
        String groupBy = null;
        String having = null;
        String orderBy = null;
        SQLiteDatabase db = this.getReadableDatabase();
        try {
            Bundle bundle;
            Cursor cursor = db.query(table, projection, selection, selectionArgs, groupBy, having, orderBy);
            try {
                Bundle result = new Bundle();
                result.putString("authAccount", account.name);
                result.putString("accountType", account.type);
                if (cursor.moveToFirst()) {
                    int columnIndex = cursor.getColumnIndex(COLUMN_AUTH_TOKEN);
                    String authToken = cursor.getString(columnIndex);
                    result.putString("authtoken", authToken);
                } else {
                    Intent intent = new Intent();
                    intent.setClass(this.mContext, this.mAuthenticatorActivity);
                    intent.putExtra("authAccount", account.name);
                    intent.putExtra("accountType", account.type);
                    result.putParcelable("intent", (Parcelable)intent);
                }
                bundle = result;
            }
            catch (Throwable throwable) {
                cursor.close();
                throw throwable;
            }
            cursor.close();
            return bundle;
        }
        finally {
            db.close();
        }
    }

    public abstract String getAuthTokenLabel(String var1);

    public Bundle hasFeatures(Account account, String[] features) throws NetworkErrorException {
        Bundle bundle = new Bundle();
        boolean featuresEmpty = features == null || features.length == 0;
        bundle.putBoolean("booleanResult", featuresEmpty);
        return bundle;
    }

    public Bundle updateCredentials(Account account, String authTokenType, Bundle loginOptions) {
        Bundle result = new Bundle();
        Intent intent = new Intent();
        intent.setClass(this.mContext, this.mAuthenticatorActivity);
        intent.putExtra("authAccount", account.name);
        intent.putExtra("accountType", account.type);
        result.putString("authAccount", account.name);
        result.putString("accountType", account.type);
        result.putParcelable("intent", (Parcelable)intent);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAuthToken(Account account, String authTokenType, String authToken) {
        String[] whereArgs;
        String whereClause;
        if (account == null || account.type == null || account.name == null || authToken == null) {
            throw new NullPointerException();
        }
        ContentValues values = new ContentValues();
        values.put(COLUMN_ACCOUNT_NAME, account.name);
        values.put(COLUMN_ACCOUNT_TYPE, account.type);
        if (authTokenType != null) {
            values.put(COLUMN_AUTH_TOKEN_TYPE, authTokenType);
            whereClause = String.format("%s=? AND %s=? AND %s=?", COLUMN_ACCOUNT_NAME, COLUMN_ACCOUNT_TYPE, COLUMN_AUTH_TOKEN_TYPE);
            whereArgs = new String[]{account.name, account.type, authTokenType};
        } else {
            whereClause = String.format("%s=? AND %s=? AND %s IS NULL", COLUMN_ACCOUNT_NAME, COLUMN_ACCOUNT_TYPE, COLUMN_AUTH_TOKEN_TYPE);
            whereArgs = new String[]{account.name, account.type};
        }
        values.put(COLUMN_AUTH_TOKEN, authToken);
        SQLiteDatabase db = this.getWritableDatabase();
        try {
            boolean bl;
            db.beginTransaction();
            try {
                db.delete(TABLE_AUTH_TOKENS, whereClause, whereArgs);
                db.insert(TABLE_AUTH_TOKENS, null, values);
                db.setTransactionSuccessful();
                bl = true;
            }
            catch (Throwable throwable) {
                db.endTransaction();
                throw throwable;
            }
            db.endTransaction();
            return bl;
        }
        finally {
            db.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account[] getAccountsByType(String type) {
        if (type == null) {
            throw new NullPointerException();
        }
        String table = TABLE_ACCOUNTS;
        String[] columns = new String[]{COLUMN_ACCOUNT_NAME};
        String selection = String.format("%s=?", COLUMN_ACCOUNT_TYPE);
        String[] selectionArgs = new String[]{type};
        String groupBy = null;
        String having = null;
        String orderBy = null;
        SQLiteDatabase db = this.getReadableDatabase();
        try {
            Account[] accountArray;
            Cursor cursor = db.query(table, columns, selection, selectionArgs, groupBy, having, orderBy);
            try {
                int count = cursor.getCount();
                Account[] accounts = new Account[count];
                int columnIndex = cursor.getColumnIndex(COLUMN_ACCOUNT_NAME);
                for (int pos = 0; pos < count; ++pos) {
                    cursor.moveToPosition(pos);
                    String name = cursor.getString(columnIndex);
                    accounts[pos] = new Account(name, type);
                }
                accountArray = accounts;
            }
            catch (Throwable throwable) {
                cursor.close();
                throw throwable;
            }
            cursor.close();
            return accountArray;
        }
        finally {
            db.close();
        }
    }

    public Account[] getAccountsByTypeAndFeatures(String type, String[] features) {
        return this.getAccountsByType(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAccount(Account account) {
        if (account == null || account.type == null || account.name == null) {
            throw new NullPointerException();
        }
        String whereClause = String.format("%s=? AND %s=?", COLUMN_ACCOUNT_NAME, COLUMN_ACCOUNT_TYPE);
        String[] whereArgs = new String[]{account.name, account.type};
        SQLiteDatabase db = this.getWritableDatabase();
        try {
            boolean bl;
            db.beginTransaction();
            try {
                db.delete(TABLE_AUTH_TOKENS, whereClause, whereArgs);
                db.delete("sync_automatically", whereClause, whereArgs);
                db.setTransactionSuccessful();
                bl = true;
            }
            catch (Throwable throwable) {
                db.endTransaction();
                throw throwable;
            }
            db.endTransaction();
            return bl;
        }
        finally {
            db.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAuthToken(String accountType, String authToken) {
        if (accountType == null || authToken == null) {
            throw new NullPointerException();
        }
        String whereClause = String.format("%s=? AND %s=?", COLUMN_ACCOUNT_TYPE, COLUMN_AUTH_TOKEN);
        String[] whereArgs = new String[]{accountType, authToken};
        SQLiteDatabase db = this.getWritableDatabase();
        try {
            db.beginTransaction();
            try {
                db.delete(TABLE_AUTH_TOKENS, whereClause, whereArgs);
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
        }
        finally {
            db.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSyncAutomatically(Account account, String authority, boolean sync) {
        if (account == null || account.type == null || account.name == null || authority == null) {
            throw new NullPointerException();
        }
        SQLiteDatabase db = this.getWritableDatabase();
        try {
            if (sync && !this.getSyncAutomatically(account, authority)) {
                ContentValues values = new ContentValues();
                values.put(COLUMN_ACCOUNT_NAME, account.name);
                values.put(COLUMN_ACCOUNT_TYPE, account.type);
                values.put(COLUMN_AUTHORITY, authority);
                values.put("sync_automatically", Integer.valueOf(1));
                db.insert("sync_automatically", null, values);
            } else {
                String table = "sync_automatically";
                String whereClause = String.format("%s=? AND %s=? AND %s=?", COLUMN_ACCOUNT_NAME, COLUMN_ACCOUNT_TYPE, COLUMN_AUTHORITY);
                String[] whereArgs = new String[]{account.name, account.type, authority};
                db.delete(table, whereClause, whereArgs);
            }
        }
        finally {
            db.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSyncAutomatically(Account account, String authority) {
        if (account == null || account.type == null || account.name == null || authority == null) {
            throw new NullPointerException();
        }
        String table = "sync_automatically";
        String[] columns = new String[]{};
        String selection = String.format("%s=? AND %s=? AND %s=?", COLUMN_ACCOUNT_NAME, COLUMN_ACCOUNT_TYPE, COLUMN_AUTHORITY);
        String[] selectionArgs = new String[]{account.name, account.type, authority};
        String groupBy = null;
        String having = null;
        String orderBy = null;
        SQLiteDatabase db = this.getReadableDatabase();
        try {
            boolean bl;
            Cursor cursor = db.query(table, columns, selection, selectionArgs, groupBy, having, orderBy);
            try {
                bl = cursor.moveToFirst();
            }
            catch (Throwable throwable) {
                cursor.close();
                throw throwable;
            }
            cursor.close();
            return bl;
        }
        finally {
            db.close();
        }
    }

    public void onLoginAccountsChanged(Account[] accounts) {
        this.deleteAccountsNotIn(accounts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAccountsNotIn(Account[] accounts) {
        String whereClause = null;
        String[] whereArgs = null;
        if (accounts.length != 0) {
            StringBuilder where = new StringBuilder();
            whereArgs = new String[accounts.length * 2];
            where.append("NOT (");
            for (int i = 0; i < accounts.length; ++i) {
                Account account = accounts[i];
                if (i != 0) {
                    where.append(" OR ");
                }
                where.append("(");
                where.append(COLUMN_ACCOUNT_NAME).append('=').append('?');
                where.append(" AND ");
                where.append(COLUMN_ACCOUNT_TYPE).append('=').append('?');
                where.append(")");
                whereArgs[i * 2] = account.name;
                whereArgs[i * 2 + 1] = account.type;
            }
            where.append(")");
            whereClause = where.toString();
        }
        SQLiteDatabase db = this.getWritableDatabase();
        try {
            db.delete("sync_automatically", whereClause, whereArgs);
            db.delete(TABLE_AUTH_TOKENS, whereClause, whereArgs);
            db.delete(TABLE_ACCOUNTS, whereClause, whereArgs);
        }
        finally {
            db.close();
        }
    }

    private class DatabaseHelper
    extends SQLiteOpenHelper {
        DatabaseHelper() {
            super(DatabaseAuthenticator.this.getContext(), DatabaseAuthenticator.this.mDatabaseName, null, 3);
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE accounts (account_name TEXT NOT NULL, account_type TEXT NOT NULL, password TEXT)");
            db.execSQL("CREATE TABLE auth_tokens (account_name TEXT NOT NULL, account_type TEXT NOT NULL, auth_token_type TEXT, auth_token TEXT NOT NULL)");
            db.execSQL("CREATE TABLE sync_automatically (account_name TEXT NOT NULL, account_type TEXT NOT NULL, authority TEXT NOT NULL, sync_automatically INTEGER NOT NULL)");
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            db.execSQL("DROP TABLE IF EXISTS accounts");
            db.execSQL("DROP TABLE IF EXISTS auth_tokens");
            db.execSQL("DROP TABLE IF EXISTS sync_automatically");
            this.onCreate(db);
        }
    }
}

