/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.accounts;

import android.accounts.AbstractAccountAuthenticator;
import android.accounts.AccountAuthenticatorResponse;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import com.google.android.accounts.Account;
import com.google.android.accounts.DatabaseAuthenticator;
import com.google.android.accounts.NetworkErrorException;

public class DatabaseAuthenticatorAdapter
extends AbstractAccountAuthenticator {
    private final DatabaseAuthenticator mAuthenticator;

    private static Account convertAccount(android.accounts.Account account) {
        return new Account(account.name, account.type);
    }

    private static Bundle convertResponse(AccountAuthenticatorResponse response, Bundle bundle) {
        if (bundle != null && bundle.containsKey("intent")) {
            String key = "accountAuthenticatorResponse";
            AccountAuthenticatorResponse value = response;
            Intent intent = (Intent)bundle.getParcelable("intent");
            intent.putExtra(key, (Parcelable)value);
            bundle.putParcelable("intent", (Parcelable)intent);
        }
        return bundle;
    }

    public DatabaseAuthenticatorAdapter(DatabaseAuthenticator authenticator) {
        super(authenticator.getContext());
        this.mAuthenticator = authenticator;
    }

    public Bundle addAccount(AccountAuthenticatorResponse response, String accountType, String authTokenType, String[] requiredFeatures, Bundle options) {
        return DatabaseAuthenticatorAdapter.convertResponse(response, this.mAuthenticator.addAccount(accountType, authTokenType, requiredFeatures, options));
    }

    public Bundle confirmCredentials(AccountAuthenticatorResponse response, android.accounts.Account account, Bundle options) {
        return DatabaseAuthenticatorAdapter.convertResponse(response, this.mAuthenticator.confirmCredentials(DatabaseAuthenticatorAdapter.convertAccount(account), options));
    }

    public Bundle editProperties(AccountAuthenticatorResponse response, String accountType) {
        return DatabaseAuthenticatorAdapter.convertResponse(response, this.mAuthenticator.editProperties(accountType));
    }

    public Bundle getAuthToken(AccountAuthenticatorResponse response, android.accounts.Account account, String authTokenType, Bundle loginOptions) {
        return DatabaseAuthenticatorAdapter.convertResponse(response, this.mAuthenticator.getAuthToken(DatabaseAuthenticatorAdapter.convertAccount(account), authTokenType, loginOptions));
    }

    public String getAuthTokenLabel(String authTokenType) {
        return this.mAuthenticator.getAuthTokenLabel(authTokenType);
    }

    public Bundle hasFeatures(AccountAuthenticatorResponse response, android.accounts.Account account, String[] features) throws android.accounts.NetworkErrorException {
        try {
            return DatabaseAuthenticatorAdapter.convertResponse(response, this.mAuthenticator.hasFeatures(DatabaseAuthenticatorAdapter.convertAccount(account), features));
        }
        catch (NetworkErrorException e) {
            throw new android.accounts.NetworkErrorException((Throwable)e);
        }
    }

    public Bundle updateCredentials(AccountAuthenticatorResponse response, android.accounts.Account account, String authTokenType, Bundle loginOptions) {
        return DatabaseAuthenticatorAdapter.convertResponse(response, this.mAuthenticator.updateCredentials(DatabaseAuthenticatorAdapter.convertAccount(account), authTokenType, loginOptions));
    }
}

