/*
 * Decompiled with CFR 0.152.
 */
package com.whereabout.common;

import android.graphics.Point;
import android.location.Location;
import android.util.Log;
import com.whereabout.common.WifiDataStore;
import com.whereabout.common.WifiHttpClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalWifiDataStore
extends WifiDataStore {
    private static final String TAG = "LocalWifiDataStore";
    private static final String REVERSE_INDEX_FILE = "reverse.index";
    private String rootDirectoryPath;
    private String areaToLoad;
    private WifiHttpClient httpClient = new WifiHttpClient();
    private String locName = "unknown";
    private String areaName = "unknown";
    private String buildingName = "unknown";
    private String floorName = "unknown";
    private String line = "";
    private int x = -1;
    private int y = -1;
    private double lat = 0.0;
    private double lon = 0.0;
    private static final int BUFFER_SIZE = 1024;

    public LocalWifiDataStore(String rootPath) {
        Log.d((String)TAG, (String)("setting root=" + rootPath));
        this.rootDirectoryPath = rootPath;
    }

    private boolean readWifiMaps() {
        File f = new File(this.rootDirectoryPath);
        if (f.exists() && f.isDirectory()) {
            File[] files = f.listFiles();
            boolean i = false;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (this.stopReloading) {
                    return false;
                }
                if (!(file.isDirectory() || file.getName().equals("temp.scan") || file.getName().endsWith("index") || this.areaToLoad != null && !file.getName().matches(this.areaToLoad))) {
                    this.loadFromFile(file);
                }
                ++n2;
            }
        } else {
            Log.e((String)TAG, (String)("Error loading data. Directory does not exist: " + this.rootDirectoryPath));
            return false;
        }
        if (this.isDataClean()) {
            this.buildReverseIndex();
            this.saveReverseIndexToFile(this.wifiMacAddrToLocationMap, String.valueOf(this.rootDirectoryPath) + "/" + REVERSE_INDEX_FILE);
            this.reloaded = true;
            return true;
        }
        return false;
    }

    private boolean readFilteredWifiMaps(HashMap<String, Double> strengthTable) {
        this.reloaded = false;
        this.stopReloading = false;
        this.clearAllCache();
        this.wifiMacAddrToLocationMap = this.loadReverseIndexFromFile(String.valueOf(this.rootDirectoryPath) + "/" + REVERSE_INDEX_FILE);
        if (this.wifiMacAddrToLocationMap == null) {
            Log.e((String)TAG, (String)"Error reading reverse index.");
            return false;
        }
        HashSet preloadLocations = new HashSet();
        for (String macAddr : strengthTable.keySet()) {
            if (!(strengthTable.get(macAddr) > -70.0) || !this.wifiMacAddrToLocationMap.containsKey(macAddr)) continue;
            preloadLocations.addAll((Collection)this.wifiMacAddrToLocationMap.get(macAddr));
        }
        if (preloadLocations.size() == 0) {
            return false;
        }
        for (String fileName : preloadLocations) {
            File f = new File(String.valueOf(this.rootDirectoryPath) + "/" + fileName);
            if (this.stopReloading) {
                return false;
            }
            if (!f.exists() || this.areaToLoad != null && !f.getName().matches(this.areaToLoad)) continue;
            this.loadFromFile(f);
        }
        if (this.isDataClean()) {
            this.reloaded = true;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private void loadFromFile(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void clearAllCache() {
        this.wifiStrengthMaps.clear();
        this.wifiFreqMaps.clear();
        this.wifiStddevMaps.clear();
        this.wifiMacAddrToLocationMap.clear();
        this.locationNames.clear();
        this.fullLocationNames.clear();
        this.areaNames.clear();
        this.locationCoords.clear();
        this.latlonCoords.clear();
        this.allMacAddresses.clear();
    }

    private boolean isDataClean() {
        return this.locationNames.size() == this.areaNames.size() && this.locationNames.size() == this.fullLocationNames.size() && this.locationNames.size() == this.locationCoords.size() && this.locationNames.size() == this.latlonCoords.size() && this.locationNames.size() == this.wifiStrengthMaps.size() && this.locationNames.size() == this.wifiFreqMaps.size() && this.locationNames.size() == this.wifiStddevMaps.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean buildReverseIndex() {
        LocalWifiDataStore localWifiDataStore = this;
        synchronized (localWifiDataStore) {
            block6: {
                if (this.wifiMacAddrToLocationMap == null) {
                    this.wifiMacAddrToLocationMap = new HashMap();
                }
                if (this.wifiStrengthMaps.size() != 0) break block6;
                return false;
            }
            int i = 0;
            while (i < this.wifiStrengthMaps.size()) {
                this.buildReverseIndexFor(i);
                ++i;
            }
        }
        return true;
    }

    private void buildReverseIndexFor(int i) {
        if (i >= this.locationNames.size()) {
            Log.w((String)TAG, (String)("Location with index " + i + " does not exist"));
            return;
        }
        String locationName = (String)this.locationNames.get(i);
        String mapName = (String)this.areaNames.get(i);
        HashMap strengthTable = (HashMap)this.wifiStrengthMaps.get(i);
        HashMap freqTable = (HashMap)this.wifiFreqMaps.get(i);
        for (String addr : strengthTable.keySet()) {
            HashSet<String> locationsForMac = (HashSet<String>)this.wifiMacAddrToLocationMap.get(addr);
            if (locationsForMac == null) {
                locationsForMac = new HashSet<String>();
                this.wifiMacAddrToLocationMap.put(addr, locationsForMac);
            }
            if (!((Double)freqTable.get(addr) > 0.7) || !((Double)strengthTable.get(addr) > -75.0)) continue;
            locationsForMac.add(String.valueOf(mapName) + "_" + locationName);
        }
    }

    private void saveReverseIndexToFile(HashMap<String, Set<String>> reverseIndex, String path) {
        File f = new File(path);
        File parentDir = f.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        try {
            FileWriter wr = new FileWriter(f);
            for (String key : reverseIndex.keySet()) {
                StringBuilder str = new StringBuilder();
                str.append(key);
                for (String loc : reverseIndex.get(key)) {
                    str.append("," + loc);
                }
                if (reverseIndex.size() <= 0) continue;
                wr.write(String.valueOf(str.toString()) + "\n");
            }
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)"Error saving reverse index to file.");
        }
    }

    private HashMap<String, Set<String>> loadReverseIndexFromFile(String path) {
        HashMap<String, Set<String>> reverseIndex = new HashMap<String, Set<String>>();
        File f = new File(path);
        if (!f.exists()) {
            return null;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(f));
            String line = "";
            while ((line = reader.readLine()) != null) {
                String[] toks = line.split(",");
                HashSet<String> locSet = reverseIndex.containsKey(toks[0]) ? reverseIndex.get(toks[0]) : new HashSet<String>();
                int i = 1;
                while (i < toks.length) {
                    locSet.add(toks[i]);
                    ++i;
                }
                reverseIndex.put(toks[0], locSet);
            }
            return reverseIndex;
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)"Error saving reverse index to file.");
            return null;
        }
    }

    private String saveScan(String rootDir, String map, String locationName, int x, int y, double lat, double lon, HashMap<String, Double> wifiStrengthTable, HashMap<String, Double> wifiFreqTable, HashMap<String, Double> wifiStddevTable) {
        if (wifiStrengthTable.size() == 0) {
            return null;
        }
        try {
            if (rootDir == null) {
                rootDir = this.rootDirectoryPath;
            }
            File dir = new File(rootDir);
            File tempFile = new File(dir, "temp.scan");
            if (!dir.exists()) {
                dir.mkdirs();
                if (!tempFile.exists()) {
                    tempFile.createNewFile();
                }
            }
            FileWriter writer = new FileWriter(tempFile);
            for (String key : wifiStrengthTable.keySet()) {
                double avgStrength = wifiStrengthTable.get(key);
                writer.write(String.valueOf(key) + " " + wifiFreqTable.get(key) + " " + wifiStrengthTable.get(key) + " " + wifiStddevTable.get(key) + "\n");
            }
            StringTokenizer st = new StringTokenizer(map, "_");
            writer.write("Area: " + st.nextToken() + "\n");
            writer.write("Building: " + st.nextToken() + "\n");
            writer.write("Floor: " + st.nextToken() + "\n");
            writer.write("Loc: " + locationName + "\n");
            writer.write("Pos: " + x + " " + y + "\n");
            writer.write("LatLon: " + lat + " " + lon + "\n");
            writer.close();
            String locationTitle = String.valueOf(map.replace(' ', '-')) + "_" + locationName.replace(' ', '-');
            File targetFile = new File(dir, locationTitle);
            tempFile.renameTo(targetFile);
            return locationTitle;
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)"Error opening file.");
            return null;
        }
    }

    private void dumpRawScans(String rootDir, String map, String locationName, int x, int y, double lat, double lon, ArrayList<HashMap<String, Double>> wifiAllScans) {
        if (wifiAllScans.size() == 0) {
            return;
        }
        try {
            if (rootDir == null) {
                rootDir = this.rootDirectoryPath;
            }
            String locationTitle = String.valueOf(map.replace(' ', '-')) + "_" + locationName.replace(' ', '-');
            File dir = new File(String.valueOf(rootDir) + "/dump");
            File targetFile = new File(dir, locationTitle);
            if (!dir.exists()) {
                dir.mkdirs();
                if (!targetFile.exists()) {
                    targetFile.createNewFile();
                }
            }
            StringBuilder wifiLocStrBuilder = new StringBuilder();
            FileWriter writer = new FileWriter(targetFile);
            for (HashMap<String, Double> scanMap : wifiAllScans) {
                for (String key : scanMap.keySet()) {
                    wifiLocStrBuilder.append(String.valueOf(key) + " ");
                    wifiLocStrBuilder.append(scanMap.get(key) + " ");
                }
                wifiLocStrBuilder.append("\n");
            }
            StringTokenizer st = new StringTokenizer(map, "_");
            wifiLocStrBuilder.append("Area: " + st.nextToken() + "\n");
            wifiLocStrBuilder.append("Building: " + st.nextToken() + "\n");
            wifiLocStrBuilder.append("Floor: " + st.nextToken() + "\n");
            wifiLocStrBuilder.append("Loc: " + locationName + "\n");
            wifiLocStrBuilder.append("Pos: " + x + " " + y + "\n");
            wifiLocStrBuilder.append("LatLon" + lat + " " + lon + "\n");
            writer.write(wifiLocStrBuilder.toString());
            writer.close();
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)"Error opening file.");
        }
    }

    private void saveCachedScansForMapLocally(String map) {
        if (!this.isDataClean()) {
            return;
        }
        int i = 0;
        for (String mapName : this.areaNames) {
            if (mapName.equals(map)) {
                Point p = (Point)this.locationCoords.get(i);
                Location loc = (Location)this.latlonCoords.get(i);
                this.saveScan(this.rootDirectoryPath, map, (String)this.locationNames.get(i), p.x, p.y, loc.getLatitude(), loc.getLongitude(), (HashMap)this.wifiStrengthMaps.get(i), (HashMap)this.wifiFreqMaps.get(i), (HashMap)this.wifiStddevMaps.get(i));
            }
            ++i;
        }
    }

    @Override
    public boolean reload(String rootPath, String area, HashMap<String, Double> strengthTable) {
        Log.d((String)TAG, (String)("setting root=" + rootPath));
        try {
            this.rootDirectoryPath = rootPath;
            this.areaToLoad = area;
            if (strengthTable == null) {
                return this.readWifiMaps();
            }
            return this.readFilteredWifiMaps(strengthTable);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("problem during reload(): " + e.toString()));
            return false;
        }
    }

    @Override
    public void stopReload() {
        this.stopReloading = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean[] refreshData(String root, String url, String[] maps) {
        LocalWifiDataStore localWifiDataStore = this;
        synchronized (localWifiDataStore) {
            Log.d((String)TAG, (String)("setting root=" + root));
            this.rootDirectoryPath = root;
            this.reloaded = false;
            boolean[] success = new boolean[maps.length];
            this.clearAllCache();
            int i = 0;
            while (i < maps.length) {
                success[i] = this.httpClient.refreshData(url, maps[i], this.wifiStrengthMaps, this.wifiFreqMaps, this.wifiStddevMaps, this.locationNames, this.areaNames, this.locationCoords, this.latlonCoords);
                this.deleteScan(maps[i], "");
                this.saveCachedScansForMapLocally(maps[i]);
                ++i;
            }
            this.buildReverseIndex();
            this.reloaded = true;
            return success;
        }
    }

    @Override
    public String getWifiDataVersion(String url, String map) {
        return this.httpClient.getWifiDataVersion(url, map);
    }

    @Override
    public String[] getAllLocationsByPrefix(String area, String prefix) {
        ArrayList<String> locNames = new ArrayList<String>();
        int i = 0;
        for (String loc : this.locationNames) {
            if ((area == null || ((String)this.areaNames.get(i)).matches(area)) && loc.startsWith(prefix)) {
                locNames.add(String.valueOf((String)this.areaNames.get(i)) + "_" + loc);
            }
            ++i;
        }
        this.allLocations = new String[locNames.size()];
        i = 0;
        for (String loc : locNames) {
            this.allLocations[i++] = loc;
        }
        return this.allLocations;
    }

    @Override
    public String getXYForLocation(String area, String loc) {
        int i = 0;
        for (String locName : this.locationNames) {
            if ((area == null || ((String)this.areaNames.get(i)).matches(area)) && locName.equals(loc)) {
                return String.valueOf(((Point)this.locationCoords.get((int)i)).x) + ":" + ((Point)this.locationCoords.get((int)i)).y;
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getLatLonForLocation(String area, String loc) {
        int i = 0;
        for (String locName : this.locationNames) {
            if ((area == null || area.equalsIgnoreCase((String)this.areaNames.get(i))) && locName.equals(loc)) {
                return String.valueOf(((Location)this.latlonCoords.get(i)).getLatitude()) + ":" + ((Location)this.latlonCoords.get(i)).getLongitude();
            }
            ++i;
        }
        return null;
    }

    @Override
    public String saveScan(String rootDir, String map, String locationName, int x, int y, double lat, double lon, HashMap<String, Double> wifiStrengthTable, HashMap<String, Integer> wifiCountTable, HashMap<String, ArrayList<Double>> wifiAllStrengths, ArrayList<HashMap<String, Double>> wifiAllScans, int numScans) {
        HashMap<String, Double> wifiFreqTable = new HashMap<String, Double>();
        HashMap<String, Double> wifiStddevTable = new HashMap<String, Double>();
        if (wifiStrengthTable.size() == 0) {
            return null;
        }
        Set<String> keys = wifiStrengthTable.keySet();
        for (String key : keys) {
            int count = wifiCountTable.get(key);
            double strength = wifiStrengthTable.get(key);
            ArrayList<Double> rawStrengths = wifiAllStrengths.get(key);
            double avgStrength = strength / (double)count;
            double stddev = 0.0;
            for (double strn : rawStrengths) {
                stddev += (strn - avgStrength) * (strn - avgStrength);
            }
            wifiFreqTable.put(key, (double)count / (double)numScans);
            wifiStddevTable.put(key, Math.sqrt(stddev / (double)rawStrengths.size()));
            wifiStrengthTable.put(key, strength / (double)count);
        }
        String locationTitle = this.saveScan(rootDir, map, locationName, x, y, lat, lon, wifiStrengthTable, wifiFreqTable, wifiStddevTable);
        File targetFile = new File(String.valueOf(rootDir) + "/" + locationTitle);
        this.loadFromFile(targetFile);
        this.buildReverseIndexFor(this.locationNames.size() - 1);
        this.dumpRawScans(rootDir, map, locationName, x, y, lat, lon, wifiAllScans);
        return locationTitle;
    }

    @Override
    public void destroy() {
        this.rootDirectoryPath = null;
        this.areaToLoad = null;
        this.httpClient = null;
        super.destroy();
    }

    public void deleteScan(String map, String location) {
        File dir = new File(this.rootDirectoryPath);
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].getName().startsWith(String.valueOf(map) + "_" + location)) {
                files[i].delete();
            }
            ++i;
        }
    }
}

