/*
 * Decompiled with CFR 0.152.
 */
package com.whereabout.common;

import android.graphics.Point;
import android.location.Location;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WifiDataStore {
    public ArrayList<HashMap<String, Double>> wifiStrengthMaps = new ArrayList();
    public ArrayList<HashMap<String, Double>> wifiFreqMaps = new ArrayList();
    public ArrayList<HashMap<String, Double>> wifiStddevMaps = new ArrayList();
    public HashMap<String, Set<String>> wifiMacAddrToLocationMap = new HashMap();
    public HashMap<String, Set<String>> preloadIndex = new HashMap();
    public ArrayList<String> locationNames = new ArrayList();
    public ArrayList<String> areaNames = null;
    public ArrayList<Point> locationCoords = null;
    public ArrayList<Location> latlonCoords = null;
    public HashSet<String> fullLocationNames = new HashSet();
    public HashSet<String> allMacAddresses = null;
    protected String[] allLocations;
    protected boolean reloaded = false;
    protected boolean stopReloading = false;

    public WifiDataStore() {
        this.areaNames = new ArrayList();
        this.locationCoords = new ArrayList();
        this.latlonCoords = new ArrayList();
        this.allMacAddresses = new HashSet();
    }

    public abstract boolean reload(String var1, String var2, HashMap<String, Double> var3);

    public abstract void stopReload();

    public abstract boolean[] refreshData(String var1, String var2, String[] var3);

    public abstract String getWifiDataVersion(String var1, String var2);

    public abstract String[] getAllLocationsByPrefix(String var1, String var2);

    public abstract String getXYForLocation(String var1, String var2);

    public abstract String getLatLonForLocation(String var1, String var2);

    public abstract String saveScan(String var1, String var2, String var3, int var4, int var5, double var6, double var8, HashMap<String, Double> var10, HashMap<String, Integer> var11, HashMap<String, ArrayList<Double>> var12, ArrayList<HashMap<String, Double>> var13, int var14);

    public boolean doneReloading() {
        return this.reloaded;
    }

    public void destroy() {
        this.wifiStrengthMaps = null;
        this.wifiFreqMaps = null;
        this.wifiStddevMaps = null;
        this.wifiMacAddrToLocationMap = null;
        this.preloadIndex = null;
        this.locationNames = null;
        this.fullLocationNames = null;
        this.areaNames = null;
        this.locationCoords = null;
        this.latlonCoords = null;
        this.allMacAddresses = null;
    }
}

