/*
 * Decompiled with CFR 0.152.
 */
package com.whereabout.common;

import android.graphics.Point;
import android.location.Location;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WifiHttpClient {
    private static final String TAG = "WifiHttpClient";
    private static final int SMALL_BUFFER_SIZE = 128;
    private static final int LARGE_BUFFER_SIZE = 8192;
    private static final boolean TRACE_REQUESTS = true;
    private static final int SECOND_IN_MILLIS = 1000;
    private static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    private static final String ENCODING_GZIP = "gzip";
    private static final String USER_AGENT = "whereabout/0 (gzip)";
    private DefaultHttpClient httpClient;
    private static Pattern sSpace = Pattern.compile(" ");

    public WifiHttpClient() {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)20000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)20000);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)USER_AGENT);
        DefaultHttpClient client = new DefaultHttpClient((HttpParams)params);
        client.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) {
                Log.v((String)WifiHttpClient.TAG, (String)("outgoing request: " + request.getRequestLine()));
            }
        });
        client.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) {
                if (!request.containsHeader(WifiHttpClient.HEADER_ACCEPT_ENCODING)) {
                    request.addHeader(WifiHttpClient.HEADER_ACCEPT_ENCODING, WifiHttpClient.ENCODING_GZIP);
                }
            }
        });
        client.addResponseInterceptor(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext context) {
                HttpEntity entity = response.getEntity();
                Header encoding = entity.getContentEncoding();
                if (encoding != null) {
                    HeaderElement[] headerElementArray = encoding.getElements();
                    int n = headerElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        HeaderElement element = headerElementArray[n2];
                        if (element.getName().equalsIgnoreCase(WifiHttpClient.ENCODING_GZIP)) {
                            response.setEntity((HttpEntity)new InflatingEntity(response.getEntity()));
                            break;
                        }
                        ++n2;
                    }
                }
            }
        });
        this.httpClient = client;
    }

    public boolean refreshData(String url, String map, ArrayList<HashMap<String, Double>> wifiStrengthMaps, ArrayList<HashMap<String, Double>> wifiFreqMaps, ArrayList<HashMap<String, Double>> wifiStddevMaps, ArrayList<String> locationNames, ArrayList<String> areaNames, ArrayList<Point> locationCoords, ArrayList<Location> latlonCoords) {
        BufferedReader reader = null;
        try {
            HttpPost method = new HttpPost(url);
            method.addHeader("Pragma", "no-cache");
            method.addHeader("Content-Type", "application/x-www-form-urlencoded");
            ArrayList<BasicNameValuePair> loginInfo = new ArrayList<BasicNameValuePair>();
            loginInfo.add(new BasicNameValuePair("mapname", map));
            loginInfo.add(new BasicNameValuePair("type", "exact"));
            loginInfo.add(new BasicNameValuePair("locationname", ""));
            loginInfo.add(new BasicNameValuePair("boxlowxorlat", "0"));
            loginInfo.add(new BasicNameValuePair("boxlowyorlong", "0"));
            loginInfo.add(new BasicNameValuePair("boxhighxorlat", "0"));
            loginInfo.add(new BasicNameValuePair("boxhighyorlong", "0"));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(loginInfo, "UTF-8");
            method.setEntity((HttpEntity)entity);
            HttpResponse res = this.httpClient.execute((HttpUriRequest)method);
            reader = new BufferedReader(new InputStreamReader(res.getEntity().getContent()), 8192);
            String line = "";
            String locName = "";
            String mapName = "";
            int x = -1;
            int y = -1;
            double lat = 0.0;
            double lon = 0.0;
            HashMap<String, Double> strengthMap = null;
            HashMap<String, Double> freqMap = null;
            HashMap<String, Double> stddevMap = null;
            while ((line = reader.readLine()) != null) {
                if (line.contains("Location Map = ")) {
                    mapName = line.substring(line.indexOf("=") + 1, line.indexOf("<BR>")).trim();
                    strengthMap = new HashMap<String, Double>();
                    freqMap = new HashMap<String, Double>();
                    stddevMap = new HashMap<String, Double>();
                    continue;
                }
                if (line.contains("Location Created Date = ")) {
                    areaNames.add(mapName);
                    locationNames.add(locName);
                    locationCoords.add(new Point(x, y));
                    Location latlon = new Location("");
                    latlon.setLatitude(lat);
                    latlon.setLongitude(lon);
                    latlonCoords.add(latlon);
                    wifiStrengthMaps.add(strengthMap);
                    wifiFreqMaps.add(freqMap);
                    wifiStddevMaps.add(stddevMap);
                    continue;
                }
                if (line.contains("WIFI Signature = ")) {
                    String input = line.substring(line.indexOf("=") + 1, line.indexOf("<BR>")).trim();
                    String[] tokens = sSpace.split(input);
                    if (tokens.length != 4) continue;
                    strengthMap.put(tokens[0], Double.parseDouble(tokens[2]));
                    freqMap.put(tokens[0], Double.parseDouble(tokens[1]));
                    stddevMap.put(tokens[0], Double.parseDouble(tokens[3]));
                    continue;
                }
                if (line.contains("Location Name = ")) {
                    locName = line.substring(line.indexOf("=") + 1, line.indexOf("<BR>")).trim();
                    continue;
                }
                if (line.contains("Local X")) {
                    x = (int)Double.parseDouble(line.substring(line.indexOf("=") + 1, line.indexOf("<BR>")).trim());
                    continue;
                }
                if (line.contains("Local Y")) {
                    y = (int)Double.parseDouble(line.substring(line.indexOf("=") + 1, line.indexOf("<BR>")).trim());
                    continue;
                }
                if (line.contains("Location Latitude = ")) {
                    lat = Double.parseDouble(line.substring(line.indexOf("=") + 1, line.indexOf("<BR>")).trim());
                    continue;
                }
                if (!line.contains("Location Longitude = ")) continue;
                lon = Double.parseDouble(line.substring(line.indexOf("=") + 1, line.indexOf("<BR>")).trim());
            }
            return true;
        }
        catch (UnsupportedEncodingException uee) {
            Log.e((String)TAG, (String)("Error refreshing data: " + uee.getMessage()));
        }
        catch (ClientProtocolException cpe) {
            Log.e((String)TAG, (String)("Error refreshing data: " + cpe.getMessage()));
        }
        catch (IOException ioe) {
            Log.e((String)TAG, (String)("Error refreshing data: " + ioe.getMessage()));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error refreshing data: " + e.getMessage()));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("Error closing reader: " + e.getMessage()));
                }
            }
        }
        return false;
    }

    public boolean saveScanRemote(String url, String rootDir, String map, String locationName, int x, int y, double lat, double lon, HashMap<String, Double> wifiStrengthTable, HashMap<String, Integer> wifiCountTable, HashMap<String, ArrayList<Double>> wifiAllStrengths, int numScans) {
        String wifiStr = "";
        Set<String> keys = wifiStrengthTable.keySet();
        for (String key : keys) {
            int count = wifiCountTable.get(key);
            double strength = wifiStrengthTable.get(key);
            ArrayList<Double> rawStrengths = wifiAllStrengths.get(key);
            double avgStrength = strength / (double)count;
            double stddev = 0.0;
            for (double strn : rawStrengths) {
                stddev += (strn - avgStrength) * (strn - avgStrength);
            }
            stddev = Math.sqrt(stddev / (double)rawStrengths.size());
            wifiStr = String.valueOf(wifiStr) + key + " " + (double)count / (double)numScans + " " + strength / (double)count + " " + stddev + "\n";
        }
        try {
            HttpPost method = new HttpPost(url);
            method.addHeader("Pragma", "no-cache");
            method.addHeader("Content-Type", "application/x-www-form-urlencoded");
            ArrayList<BasicNameValuePair> loginInfo = new ArrayList<BasicNameValuePair>();
            loginInfo.add(new BasicNameValuePair("mapname", map));
            loginInfo.add(new BasicNameValuePair("name", locationName));
            loginInfo.add(new BasicNameValuePair("update", "no"));
            loginInfo.add(new BasicNameValuePair("lat", String.valueOf(lat)));
            loginInfo.add(new BasicNameValuePair("long", String.valueOf(lon)));
            loginInfo.add(new BasicNameValuePair("x", String.valueOf(x)));
            loginInfo.add(new BasicNameValuePair("y", String.valueOf(y)));
            loginInfo.add(new BasicNameValuePair("wifi", wifiStr));
            loginInfo.add(new BasicNameValuePair("key", "496e646f6f72576966694c6f63616c697a6174696f6e"));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(loginInfo, "UTF-8");
            method.setEntity((HttpEntity)entity);
            HttpResponse res = this.httpClient.execute((HttpUriRequest)method);
            int statusCode = res.getStatusLine().getStatusCode();
            return statusCode >= 200 && statusCode < 300;
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
        }
        catch (ClientProtocolException cpe) {
            cpe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return false;
    }

    public String getWifiDataVersion(String url, String map) {
        BufferedReader reader = null;
        try {
            HttpGet method = new HttpGet(String.valueOf(url) + "?mapName=" + map);
            method.addHeader("Pragma", "no-cache");
            method.addHeader("Content-Type", "application/x-www-form-urlencoded");
            HttpResponse res = this.httpClient.execute((HttpUriRequest)method);
            int statusCode = res.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                return "0";
            }
            reader = new BufferedReader(new InputStreamReader(res.getEntity().getContent()), 128);
            String line = "";
            String locName = "";
            String mapName = "";
            while ((line = reader.readLine()) != null) {
                if (line.equals("")) continue;
                String string2 = line.trim();
                return string2;
            }
            return "0";
        }
        catch (UnsupportedEncodingException uee) {
            Log.e((String)TAG, (String)("Error refreshing data: " + uee.getMessage()));
        }
        catch (ClientProtocolException cpe) {
            Log.e((String)TAG, (String)("Error refreshing data: " + cpe.getMessage()));
        }
        catch (IOException ioe) {
            Log.e((String)TAG, (String)("Error refreshing data: " + ioe.getMessage()));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("Error closing reader: " + e.getMessage()));
                }
            }
        }
        return "0";
    }

    private static class InflatingEntity
    extends HttpEntityWrapper {
        public InflatingEntity(HttpEntity wrapped) {
            super(wrapped);
        }

        public InputStream getContent() throws IOException {
            return new GZIPInputStream(this.wrappedEntity.getContent());
        }

        public long getContentLength() {
            return -1L;
        }
    }
}

