/*
 * Decompiled with CFR 0.152.
 */
package com.whereabout.common;

import android.content.Context;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import android.os.PowerManager;
import android.util.Log;
import com.whereabout.common.WifiDataStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WifiScanner {
    private static final long MAX_TIME = 30000L;
    private static final long FLUSH_TIME = 2000L;
    private static final int SCAN_FREQ = 4;
    private static final int FLUSH_FREQ = 10;
    private Context context = null;
    private WifiManager wifi = null;
    private WifiDataStore dataStore = null;
    private PowerManager.WakeLock wakeLock = null;
    private HashMap<String, ArrayList<Double>> wifiAllStrengths = new HashMap();
    private ArrayList<HashMap<String, Double>> wifiAllScans = new ArrayList();
    private HashMap<String, Double> wifiStrengthTable = new HashMap();
    private HashMap<String, Integer> wifiCountTable = new HashMap();
    private int scanNo = 0;
    private int scanFreq = 4;
    private long maxScanTime = 30000L;
    private boolean isScanning = false;
    private boolean doneFlushing = true;
    private Runnable stepChecker = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (WifiScanner.this.isScanning || !WifiScanner.this.doneFlushing) {
                WifiScanner.this.wifi.startScan();
                try {
                    Thread.sleep(1000 / WifiScanner.this.scanFreq);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                List res = WifiScanner.this.wifi.getScanResults();
                if (res == null) {
                    WifiScanner.this.isScanning = false;
                    return;
                }
                if (res.size() > 0 && WifiScanner.this.isScanning && WifiScanner.this.doneFlushing) {
                    String str = "";
                    WifiScanner wifiScanner = WifiScanner.this;
                    wifiScanner.scanNo = wifiScanner.scanNo + 1;
                    WifiScanner wifiScanner2 = WifiScanner.this;
                    synchronized (wifiScanner2) {
                        HashMap<String, Double> scanMap = new HashMap<String, Double>();
                        for (ScanResult r : res) {
                            if (r.BSSID == null) continue;
                            double strength = r.level;
                            int count = 1;
                            scanMap.put(r.BSSID, Double.valueOf(r.level));
                            if (!WifiScanner.this.wifiAllStrengths.containsKey(r.BSSID)) {
                                WifiScanner.this.wifiAllStrengths.put(r.BSSID, new ArrayList());
                            }
                            ((ArrayList)WifiScanner.this.wifiAllStrengths.get(r.BSSID)).add(strength);
                            if (WifiScanner.this.wifiStrengthTable.containsKey(r.BSSID)) {
                                strength += ((Double)WifiScanner.this.wifiStrengthTable.get(r.BSSID)).doubleValue();
                            }
                            if (WifiScanner.this.wifiCountTable.containsKey(r.BSSID)) {
                                count += ((Integer)WifiScanner.this.wifiCountTable.get(r.BSSID)).intValue();
                            }
                            WifiScanner.this.wifiStrengthTable.put(r.BSSID, strength);
                            WifiScanner.this.wifiCountTable.put(r.BSSID, count);
                            str = String.valueOf(str) + WifiScanner.this.scanNo + " " + count + " " + r.BSSID + " " + r.level + "\n";
                        }
                        WifiScanner.this.wifiAllScans.add(scanMap);
                    }
                    if ((long)(WifiScanner.this.scanNo * (1000 / WifiScanner.this.scanFreq)) >= WifiScanner.this.maxScanTime) {
                        WifiScanner.this.stopScan();
                        return;
                    }
                } else if (!WifiScanner.this.doneFlushing) {
                    WifiScanner wifiScanner = WifiScanner.this;
                    wifiScanner.scanNo = wifiScanner.scanNo + 1;
                }
                if ((long)(WifiScanner.this.scanNo * (1000 / WifiScanner.this.scanFreq)) < 2000L || WifiScanner.this.doneFlushing) continue;
                WifiScanner.this.doneFlushing = true;
                WifiScanner.this.scanNo = 0;
                return;
            }
        }
    };

    public WifiScanner(Context ct, WifiDataStore store) {
        this.context = ct;
        this.dataStore = store;
        this.wifi = (WifiManager)this.context.getSystemService("wifi");
    }

    public HashMap<String, Double> getWifiStrengthTable() {
        return this.wifiStrengthTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Double> getCopyOfWifiStrengthTable() {
        HashMap<String, Double> table = new HashMap<String, Double>();
        WifiScanner wifiScanner = this;
        synchronized (wifiScanner) {
            for (String key : this.wifiStrengthTable.keySet()) {
                table.put(key, this.wifiStrengthTable.get(key) / (double)this.wifiCountTable.get(key).intValue());
            }
        }
        return table;
    }

    public HashMap<String, Integer> getWifiCountTable() {
        return this.wifiCountTable;
    }

    public int getNumScans() {
        return this.scanNo;
    }

    public WifiDataStore getDataStore() {
        return this.dataStore;
    }

    public void waitWhileFlushing() {
        try {
            while (!this.doneFlushing) {
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startScan(int freq) {
        this.waitWhileFlushing();
        this.scanFreq = freq == 0 ? 4 : freq;
        WifiScanner wifiScanner = this;
        synchronized (wifiScanner) {
            this.wifiStrengthTable.clear();
            this.wifiCountTable.clear();
            this.wifiAllStrengths.clear();
            this.wifiAllScans.clear();
        }
        this.scanNo = 0;
        this.isScanning = true;
        if (this.wakeLock != null && !this.wakeLock.isHeld()) {
            this.wakeLock.acquire();
        }
        new Thread(this.stepChecker).start();
    }

    public void stopScan() {
        if (!this.isScanning) {
            return;
        }
        this.isScanning = false;
        Log.d((String)"WifiScanner", (String)"Stopping Wifi scanning...");
        if (this.wakeLock != null && this.wakeLock.isHeld()) {
            this.wakeLock.release();
        }
    }

    public void resetScan() {
        this.isScanning = false;
        this.scanNo = 0;
    }

    public void flushWifiScans() {
        this.doneFlushing = false;
        this.scanFreq = 10;
        new Thread(this.stepChecker).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveScan(String rootDir, String map, String locationName, int x, int y, double lat, double lon) {
        Log.d((String)"WifiScanner", (String)locationName);
        WifiScanner wifiScanner = this;
        synchronized (wifiScanner) {
            block4: {
                if (this.wifiStrengthTable.size() != 0) break block4;
                return null;
            }
            return this.dataStore.saveScan(rootDir, map, locationName, x, y, lat, lon, this.wifiStrengthTable, this.wifiCountTable, this.wifiAllStrengths, this.wifiAllScans, this.scanNo);
        }
    }

    public void setScanTime(long scanTime) {
        this.maxScanTime = scanTime;
    }

    public boolean isScanningWifi() {
        return this.isScanning;
    }

    public boolean isFlushing() {
        return !this.doneFlushing;
    }

    public void destroy() {
        this.wifiAllStrengths = null;
        this.wifiAllScans = null;
        this.wifiStrengthTable = null;
        this.wifiCountTable = null;
    }
}

