/*
 * Decompiled with CFR 0.152.
 */
package com.whereabout.location;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.location.Criteria;
import android.location.GpsStatus;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationProvider;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.os.Environment;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.whereabout.common.LocalWifiDataStore;
import com.whereabout.common.WifiDataStore;
import com.whereabout.common.WifiScanner;
import com.whereabout.wifiservice.IWifiLocationService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationManager {
    private static final String TAG = "LocationManager";
    public static final String INDOOR_WIFI_LOCATION_PROVIDER = "INDOOR_WIFI_LOCATION_PROVIDER";
    public static final String COMMAND_LOAD_FOR = "COMMAND_LOAD_FOR";
    public static final String COMMAND_REFRESH_DATA = "COMMAND_REFRESH_DATA";
    public static final int STATUS_INVALID_ROOT = 0;
    public static final String MATCH_MAPS = "MATCH_MAPS";
    public static final String MATCH_SCORES = "MATCH_SCORES";
    public static final String MATCH_LOCATIONS = "MATCH_LOCATIONS";
    public static final String MATCH_XCOORDS = "MATCH_XCOORDS";
    public static final String MATCH_YCOORDS = "MATCH_YCOORDS";
    public static final String MATCH_LATITUDES = "MATCH_LATITUDES";
    public static final String MATCH_LONGITUDES = "MATCH_LONGITUDES";
    public static final String FINAL_LOCATION_NAME = "FINAL_LOCATION_NAME";
    public static final String FINAL_X = "FINAL_X";
    public static final String FINAL_Y = "FINAL_Y";
    public static final String FINAL_LAT = "FINAL_LAT";
    public static final String FINAL_LON = "FINAL_LON";
    public static final String ROOT_DIR_NAME = "ROOT_DIR_NAME";
    public static final String LOAD_FOR_AREA = "LOAD_FOR_AREA";
    public static final String REFRESH_URL = "REFRESH_URL";
    public static final String REFRESH_MAPS = "REFRESH_MAPS";
    public static final String REFRESH_ASYNC = "REFRESH_ASYNC";
    private Context parent;
    private android.location.LocationManager platformLocationManager;
    private final ComponentName mWifiService;
    private IWifiLocationService wifiService = null;
    private ServiceConnection mServiceConnection = null;
    private String mRootDirPath;
    private String loadForArea = null;
    private Thread wifiScanningLoopThread = null;
    private Thread saveLocationThread = null;
    private ArrayList<LocationListener> wifiLocationListeners = null;
    private final Lock serviceStartLock = new ReentrantLock();
    private final Condition serviceStarted = this.serviceStartLock.newCondition();
    private WifiDataStore dataStore = null;
    private WifiScanner wifiScanner = null;
    private boolean quitSave = false;
    private boolean runWifiScanningLoop = false;
    private Runnable wifiScanningLoop = new Runnable(){

        public void run() {
            try {
                while (LocationManager.this.runWifiScanningLoop) {
                    Bundle extras;
                    Thread.sleep(50L);
                    if (LocationManager.this.wifiService == null || !LocationManager.this.wifiService.isLocationUpdated() || !LocationManager.this.wifiService.isReady() || LocationManager.this.wifiService.isRefreshingData() || (extras = LocationManager.this.buildLocationResultBundle()).getStringArray(LocationManager.MATCH_LOCATIONS).length <= 0) continue;
                    Location loc = new Location(LocationManager.INDOOR_WIFI_LOCATION_PROVIDER);
                    loc.setAccuracy(0.5f);
                    loc.setLatitude(extras.getDoubleArray(LocationManager.MATCH_LATITUDES)[0]);
                    loc.setLongitude(extras.getDoubleArray(LocationManager.MATCH_LONGITUDES)[0]);
                    loc.setExtras(extras);
                    LocationManager.this.dispatchLocationUpdates(loc);
                }
            }
            catch (RemoteException e) {
                Log.e((String)LocationManager.TAG, (String)("Error detecting Wifi location: " + e.getMessage()));
            }
            catch (InterruptedException e) {
                Log.e((String)LocationManager.TAG, (String)("Wifi localization interrupted: " + e.getMessage()));
            }
        }
    };
    boolean wifiServiceBusy = false;

    public LocationManager(Context context) {
        this(context, null, Environment.getExternalStorageDirectory() + "/wifiscans");
    }

    public LocationManager(Context context, ComponentName wifiService, String rootDirPath) {
        this.parent = context;
        this.platformLocationManager = (android.location.LocationManager)this.parent.getSystemService("location");
        this.wifiLocationListeners = new ArrayList();
        this.mWifiService = wifiService;
        this.mRootDirPath = rootDirPath;
        this.dataStore = new LocalWifiDataStore(rootDirPath);
        this.wifiScanner = new WifiScanner(context, this.dataStore);
    }

    public boolean addGpsStatusListener(GpsStatus.Listener listener) {
        return this.platformLocationManager.addGpsStatusListener(listener);
    }

    public void addProximityAlert(double latitude, double longitude, float radius, long expiration, PendingIntent intent) {
        this.platformLocationManager.addProximityAlert(latitude, longitude, radius, expiration, intent);
    }

    public void addTestProvider(String name, boolean requiresNetwork, boolean requiresSatellite, boolean requiresCell, boolean hasMonetaryCost, boolean supportsAltitude, boolean supportsSpeed, boolean supportsBearing, int powerRequirement, int accuracy) {
        this.platformLocationManager.addTestProvider(name, requiresNetwork, requiresSatellite, requiresCell, hasMonetaryCost, supportsAltitude, supportsSpeed, supportsBearing, powerRequirement, accuracy);
    }

    public void clearTestProviderEnabled(String provider) {
        this.platformLocationManager.clearTestProviderEnabled(provider);
    }

    public void clearTestProviderLocation(String provider) {
        this.platformLocationManager.clearTestProviderLocation(provider);
    }

    public void clearTestProviderStatus(String provider) {
        this.platformLocationManager.clearTestProviderStatus(provider);
    }

    public List<String> getAllProviders() {
        List providers = this.platformLocationManager.getAllProviders();
        providers.add(INDOOR_WIFI_LOCATION_PROVIDER);
        return providers;
    }

    public String getBestProvider(Criteria criteria, boolean enabledOnly) {
        return this.platformLocationManager.getBestProvider(criteria, enabledOnly);
    }

    public GpsStatus getGpsStatus(GpsStatus status) {
        return this.platformLocationManager.getGpsStatus(status);
    }

    public Location getLastKnownLocation(String provider) {
        return this.platformLocationManager.getLastKnownLocation(provider);
    }

    public LocationProvider getProvider(String name) {
        return this.platformLocationManager.getProvider(name);
    }

    public List<String> getProviders(Criteria criteria, boolean enabledOnly) {
        return this.platformLocationManager.getProviders(criteria, enabledOnly);
    }

    public List<String> getProviders(boolean enabledOnly) {
        List providers = this.platformLocationManager.getAllProviders();
        providers.add(INDOOR_WIFI_LOCATION_PROVIDER);
        return providers;
    }

    public boolean isProviderEnabled(String provider) {
        if (provider.equals(INDOOR_WIFI_LOCATION_PROVIDER)) {
            return ((WifiManager)this.parent.getSystemService("wifi")).isWifiEnabled();
        }
        return this.platformLocationManager.isProviderEnabled(provider);
    }

    public void removeGpsStatusListener(GpsStatus.Listener listener) {
        this.platformLocationManager.removeGpsStatusListener(listener);
    }

    public void removeProximityAlert(PendingIntent intent) {
        this.platformLocationManager.removeProximityAlert(intent);
    }

    public void removeTestProvider(String provider) {
        this.platformLocationManager.removeTestProvider(provider);
    }

    public void removeUpdates(LocationListener listener) {
        if (this.wifiLocationListeners.contains(listener)) {
            this.wifiLocationListeners.remove(listener);
            if (this.wifiLocationListeners.size() == 0) {
                this.runWifiScanningLoop = false;
                if (this.wifiService != null) {
                    try {
                        this.wifiService.stopContinuousPositioning();
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.platformLocationManager.removeUpdates(listener);
    }

    public void removeUpdates(PendingIntent intent) {
        this.platformLocationManager.removeUpdates(intent);
    }

    public void requestLocationUpdates(String provider, long minTime, float minDistance, PendingIntent intent) {
        this.platformLocationManager.requestLocationUpdates(provider, minTime, minDistance, intent);
    }

    public void requestLocationUpdates(String provider, long minTime, float minDistance, LocationListener listener) {
        if (provider.equals(INDOOR_WIFI_LOCATION_PROVIDER)) {
            if (!this.wifiLocationListeners.contains(listener)) {
                this.wifiLocationListeners.add(listener);
            }
            if (!this.runWifiScanningLoop) {
                this.resetWifiScanner();
            }
        } else {
            this.platformLocationManager.requestLocationUpdates(provider, minTime, minDistance, listener);
        }
    }

    public void requestLocationUpdates(String provider, long minTime, float minDistance, LocationListener listener, Looper looper) {
        this.platformLocationManager.requestLocationUpdates(provider, minTime, minDistance, listener, looper);
    }

    public boolean sendExtraCommand(String provider, String command, Bundle extras) {
        if (provider.equals(INDOOR_WIFI_LOCATION_PROVIDER)) {
            if (command.equals(COMMAND_LOAD_FOR)) {
                this.loadDataFor(extras.getString(ROOT_DIR_NAME), extras.getString(LOAD_FOR_AREA));
                return true;
            }
            if (command.equals(COMMAND_REFRESH_DATA)) {
                this.refreshData(extras.getString(REFRESH_URL), extras.getStringArray(REFRESH_MAPS), extras.getString(ROOT_DIR_NAME), extras.getBoolean(REFRESH_ASYNC, true));
                return true;
            }
            return false;
        }
        return this.platformLocationManager.sendExtraCommand(provider, command, extras);
    }

    public void setTestProviderEnabled(String provider, boolean enabled) {
        this.platformLocationManager.setTestProviderEnabled(provider, enabled);
    }

    public void setTestProviderLocation(String provider, Location loc) {
        this.platformLocationManager.setTestProviderLocation(provider, loc);
    }

    public void setTestProviderStatus(String provider, int status, Bundle extras, long updateTime) {
        this.platformLocationManager.setTestProviderStatus(provider, status, extras, updateTime);
    }

    private void loadDataFor(String root, String area) {
        Log.d((String)TAG, (String)("loadDataFor() root=" + this.mRootDirPath));
        this.mRootDirPath = root;
        this.loadForArea = area;
        try {
            if (this.wifiService != null && !this.wifiService.setRoot(this.mRootDirPath, this.loadForArea)) {
                this.dispatchStatusUpdate(0, null);
            }
        }
        catch (RemoteException re) {
            Log.e((String)TAG, (String)("Error loading data from " + this.mRootDirPath + ", for " + this.loadForArea));
        }
    }

    private void refreshData(final String url, final String[] maps, final String root, final boolean async) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    LocationManager.this.serviceStartLock.lock();
                    if (LocationManager.this.serviceStarted.await(5L, TimeUnit.SECONDS)) {
                        LocationManager.this.wifiService.refreshData(url, maps, root, async);
                    } else {
                        Log.w((String)LocationManager.TAG, (String)"unable to acquire service reference");
                    }
                    LocationManager.this.serviceStartLock.unlock();
                }
                catch (InterruptedException ie) {
                    Log.e((String)LocationManager.TAG, (String)("Error refreshing data from " + url));
                }
                catch (RemoteException re) {
                    Log.e((String)LocationManager.TAG, (String)("Error refreshing data from " + url));
                }
            }
        }).start();
    }

    private void resetWifiScanner() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    while (LocationManager.this.wifiService == null) {
                        Thread.sleep(100L);
                    }
                    LocationManager.this.wifiService.startContinuousPositioning(4, 1000L);
                }
                catch (InterruptedException ie) {
                    Log.e((String)LocationManager.TAG, (String)"Error starting continuous positioning.");
                }
                catch (RemoteException re) {
                    Log.e((String)LocationManager.TAG, (String)"Error starting continuous positioning.");
                }
            }
        }).start();
        this.runWifiScanningLoop = true;
        this.wifiScanningLoopThread = new Thread(this.wifiScanningLoop);
        this.wifiScanningLoopThread.start();
    }

    private void dispatchLocationUpdates(Location loc) {
        int i = 0;
        while (i < this.wifiLocationListeners.size()) {
            this.wifiLocationListeners.get(i).onLocationChanged(loc);
            ++i;
        }
    }

    private void dispatchStatusUpdate(int status, Bundle extras) {
        int i = 0;
        while (i < this.wifiLocationListeners.size()) {
            this.wifiLocationListeners.get(i).onStatusChanged(INDOOR_WIFI_LOCATION_PROVIDER, status, extras);
            ++i;
        }
    }

    private Bundle buildLocationResultBundle() throws RemoteException {
        String[] locations = this.wifiService.getLocations();
        double[] proximities = this.wifiService.getProximities();
        int[] xCoords = this.wifiService.getXCoordinates();
        int[] yCoords = this.wifiService.getYCoordinates();
        double[] latitudes = this.wifiService.getLatitudes();
        double[] longitudes = this.wifiService.getLongitudes();
        if (locations.length > 0) {
            Bundle extrasBundle = new Bundle();
            extrasBundle.putDoubleArray(MATCH_SCORES, proximities);
            extrasBundle.putStringArray(MATCH_LOCATIONS, locations);
            extrasBundle.putIntArray(MATCH_XCOORDS, xCoords);
            extrasBundle.putIntArray(MATCH_YCOORDS, yCoords);
            extrasBundle.putDoubleArray(MATCH_LATITUDES, latitudes);
            extrasBundle.putDoubleArray(MATCH_LONGITUDES, longitudes);
            extrasBundle.putInt(FINAL_X, this.wifiService.getX());
            extrasBundle.putInt(FINAL_Y, this.wifiService.getY());
            extrasBundle.putDouble(FINAL_LAT, this.wifiService.getLatitude());
            extrasBundle.putDouble(FINAL_LON, this.wifiService.getLongitude());
            return extrasBundle;
        }
        return null;
    }

    public void startWifiService() {
        if (this.wifiService == null) {
            this.mServiceConnection = new ServiceConnection(){

                public void onServiceConnected(ComponentName name, IBinder service) {
                    LocationManager.this.wifiService = IWifiLocationService.Stub.asInterface(service);
                    try {
                        LocationManager.this.serviceStartLock.lock();
                        LocationManager.this.serviceStarted.signal();
                        LocationManager.this.serviceStartLock.unlock();
                        LocationManager.this.wifiService.setRoot(LocationManager.this.mRootDirPath, LocationManager.this.loadForArea);
                    }
                    catch (RemoteException re) {
                        Log.e((String)LocationManager.TAG, (String)("Error loading data from " + LocationManager.this.mRootDirPath + ", for " + LocationManager.this.loadForArea));
                    }
                }

                public void onServiceDisconnected(ComponentName name) {
                    LocationManager.this.wifiService = null;
                    Log.d((String)LocationManager.TAG, (String)"Service disconnected...");
                }
            };
            Intent serviceIntent = new Intent("android.intent.action.USE_WIFI_SERVICE");
            serviceIntent.addCategory("android.intent.category.WIFI_SERVICE");
            if (this.mWifiService != null) {
                serviceIntent.setComponent(this.mWifiService);
            }
            this.parent.bindService(serviceIntent, this.mServiceConnection, 1);
        }
    }

    public void shutdown() {
        this.runWifiScanningLoop = false;
        this.wifiServiceBusy = true;
        this.quitSave = true;
        this.wifiScanner.stopScan();
        try {
            if (this.wifiScanningLoopThread != null) {
                this.wifiScanningLoopThread.join();
            }
            if (this.saveLocationThread != null) {
                this.saveLocationThread.join();
            }
            if (this.wifiService != null) {
                this.wifiService.stopContinuousPositioning();
            }
            this.parent.unbindService(this.mServiceConnection);
            this.wifiScanner.destroy();
            this.dataStore.destroy();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("Error shutting down Wifi location service: " + e.getMessage()));
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public String[] getAllWifiScanLocations() {
        try {
            return this.wifiService.getAllLocationsByPrefix(null, "");
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("Error getting scan locations: " + e.getMessage()));
            return new String[0];
        }
    }

    public String[] getWifiScanLocationsIn(String map, String prefix) {
        try {
            return this.wifiService.getAllLocationsByPrefix(map, prefix);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("Error getting scan locations: " + e.getMessage()));
            return new String[0];
        }
    }

    public boolean isReady() {
        try {
            return this.wifiService != null && !this.wifiService.isRefreshingData() && this.wifiService.isReady();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("Error getting scan locations: " + e.getMessage()));
            return false;
        }
    }

    public void saveScan(final String dir, final String area, final String building, final String floor, final String location, final int x, final int y, final double lat, final double lon, final int scanFreq, final long duration, final WifiLocationTaggingListener doneListener) {
        this.saveLocationThread = new Thread(new Runnable(){

            public void run() {
                LocationManager.this.wifiScanner.flushWifiScans();
                while (LocationManager.this.wifiScanner.isFlushing()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                LocationManager.this.wifiScanner.setScanTime(duration);
                LocationManager.this.wifiScanner.startScan(scanFreq);
                while (LocationManager.this.wifiScanner.isScanningWifi()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (LocationManager.this.quitSave) {
                    return;
                }
                LocationManager.this.wifiScanner.saveScan(dir, String.valueOf(area) + "_" + building + "_" + floor, location, x, y, lat, lon);
                if (doneListener != null) {
                    doneListener.onDoneSave(true, String.valueOf(dir) + "_" + area + "_" + floor + "_" + location);
                }
            }
        });
        this.saveLocationThread.start();
    }

    public boolean localizeWithWifi(final long scanDuration, final WifiLocalizationListener callback) {
        if (this.wifiServiceBusy) {
            return false;
        }
        this.wifiServiceBusy = true;
        Runnable OnDemandWifiLocalizer = new Runnable(){

            public void run() {
                try {
                    while (LocationManager.this.wifiService == null || !LocationManager.this.wifiService.isReady() || LocationManager.this.wifiService.isRefreshingData()) {
                        Thread.sleep(100L);
                    }
                    LocationManager.this.wifiService.flushWifiScans();
                    while (LocationManager.this.wifiService.isFlushing()) {
                        Thread.sleep(50L);
                    }
                    LocationManager.this.wifiService.startScanningForLocation(10, true, 0);
                    Thread.sleep(scanDuration);
                    LocationManager.this.wifiService.stopScanningForLocation("");
                    Bundle extras = LocationManager.this.buildLocationResultBundle();
                    Location result = new Location(LocationManager.INDOOR_WIFI_LOCATION_PROVIDER);
                    result.setAccuracy(0.5f);
                    result.setLatitude(extras.getDoubleArray(LocationManager.MATCH_LATITUDES)[0]);
                    result.setLongitude(extras.getDoubleArray(LocationManager.MATCH_LONGITUDES)[0]);
                    result.setExtras(extras);
                    callback.onWifiLocalizationResult(0, result);
                    LocationManager.this.wifiServiceBusy = false;
                }
                catch (RemoteException e) {
                    Log.e((String)LocationManager.TAG, (String)("Error detecting Wifi location: " + e.getMessage()));
                }
                catch (InterruptedException e) {
                    Log.e((String)LocationManager.TAG, (String)("Error detecting Wifi location: " + e.getMessage()));
                }
            }
        };
        new Thread(OnDemandWifiLocalizer).start();
        return true;
    }

    public String runAccuracyTest(String dir, String file) {
        try {
            return this.wifiService.testAccuracy(dir, file);
        }
        catch (RemoteException re) {
            Log.e((String)TAG, (String)("Error running accuracy tests: " + re.getMessage()));
            return "";
        }
    }

    public static interface WifiLocalizationListener {
        public void onWifiLocalizationResult(int var1, Location var2);
    }

    public static interface WifiLocationTaggingListener {
        public void onDoneSave(boolean var1, String var2);
    }
}

